import store from './store';

export default {
  data() {
    return {
      store,
      empty_service: {
        name: '',
        cost: null,
        payments: [{
          payment_date: new Date().toJSON().slice(0, 10),
          amount: '',
          payment_method: '',
          notes: ''
        }]
      }
    }
  },
  computed: {
    formData() {
      return this.store.state;
    },
    me() {
      return this.$deepModel(this.formData);
    }
  },
  methods: {
    deepget: function(obj, path, defaultValue) {
      const props = path.split ? path.split('.') : path;
      let lastReference = obj;

      for (var i = 0, len = props.length; i < len; i++) {
        if (lastReference !== null && lastReference[props[i]] !== undefined) {
          lastReference = lastReference[props[i]];
        } else {
          return defaultValue || undefined;
        }
      }

      return lastReference;
    },
    has: function(prop, def) {
      return this.deepget(this.me, prop, def);
    },
    deleteProp(prop, callback = false) {
      this._updateValue(prop, '');
      if (callback && typeof callback === "function") {
        callback();
      }
    },
    _updateValue(prop, value) {
      return this.$vueSet(this.me, prop, value);
    },
    addPayment: function(i) {
      let payments = this.has(`services.${i}.payments`, [])
      if (payments.length != 0) {
        payments.push({});
      } else {
        this._updateValue(`services.${i}.payments`, [{}])
      }
    },
    deletePayment: function(i, p) {
      if (confirm('Are you sure you want to delete payment?')) {
        let payments = this.has(`services.${i}.payments`, [])

        payments.splice(p, 1);
      }
    },
    addService: function() {
      this.store.addService(this.empty_service);
    },
    deleteService: function(i) {
      if (confirm('Are you sure you want to remove service?')) {
        this.store.deleteService(i);
      }
    }
  },
};
