<?php

class invoiceExport
{
    protected function getInvoice($invoice_no)
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $invoices	              =   $supp_obj -> prefix_table("invoices");
        $invoice_services	      =   $supp_obj -> prefix_table("invoice_services");
        $invoice_payments	      =   $supp_obj -> prefix_table("invoice_payments");

        $sql = "SELECT * FROM $invoices WHERE id = '$invoice_no'";
        $row = $supp_obj->get_a_line($sql);
        $invoice = array();
        if ($row) {
            $invoice['invoice_no'] = $row['id'];
            $invoice['company'] = $row['company'];
            $invoice['due_date'] = $row['due_date'];
            $invoice['status'] = $row['status'];

            $sql = "SELECT * FROM $invoice_services WHERE invoice_id = '$invoice_no'";
            $servicesRow = $supp_obj->get_rsltset($sql);

            foreach ($servicesRow as $index => $service) {
                $service_id = $service['id'];
                $invoice['services'][$index]['id'] = $service['id'];
                $invoice['services'][$index]['name'] = $service['service'];
                $invoice['services'][$index]['cost'] = $service['cost'];

                $sql = "SELECT * FROM $invoice_payments WHERE service_id = '$service_id'";
                $paymentsRow = $supp_obj->get_rsltset($sql);
                $total_paid = 0;
                foreach ($paymentsRow as $key => $payment) {
                    $total_paid += $payment['amount'];
                    $invoice['services'][$index]['payments'][$key]['id'] = $payment['id'];
                    $invoice['services'][$index]['payments'][$key]['amount'] = $payment['amount'];
                    $invoice['services'][$index]['payments'][$key]['payment_date'] = $payment['payment_date'];
                    $invoice['services'][$index]['payments'][$key]['payment_method'] = $payment['payment_method'];
                    $invoice['services'][$index]['payments'][$key]['notes'] = $payment['notes'];
                }

                $invoice['services'][$index]['total_paid'] = $total_paid;
                $invoice['services'][$index]['balance'] = $service['cost'] - $total_paid;
            }

            return $invoice;
        }
    }

    public function export()
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $get = $a_predefined['get'];

        $invoice_no = $get['invoice_no'];
        $invoice = $this->getInvoice($invoice_no);

        $template = "../plugins/invoice/templates/report.tpl";
        $content = $supp_obj->return_file_content($template);

        $report = '';
        if ($invoice) {
            $replace['company_name'] = $invoice['company'];
            $replace['invoice_no'] = $invoice['company'];
            $services = $invoice['services'];

            $formatter = new NumberFormatter('en_US', NumberFormatter::CURRENCY);

            foreach ($services as $index => $service) {
                if ($index != 0) {
                    $report .= "<tr>
                                  <td colspan=\"8\">&nbsp;</td>
                                </tr>";
                }

                $payments = $service['payments'];
                if (count($payments) == 0) {
                    $service_no = $index + 1;
                    $service_name = $service['name'];
                    $service_cost = $formatter->formatCurrency($service['cost'], 'USD');
                    $balance = $formatter->formatCurrency($service['balance'], 'USD');
                    $report .= "<tr>
                                  <td>$service_no</td>
                                  <td>$service_name</td>
                                  <td>$service_cost</td>
                                  <td></td>
                                  <td></td>
                                  <td></td>
                                  <td></td>
                                  <td>$balance</td>
                                </tr>";
                } else {
                    foreach ($payments as $key => $payment) {
                        $service_no = $index + 1;
                        $service_name = $service['name'];
                        $service_cost = $formatter->formatCurrency($service['cost'], 'USD');
                        $amount_paid = $formatter->formatCurrency($payment['amount'], 'USD');
                        $payment_date = date('m-d-Y', strtotime($payment['payment_date']));
                        $payment_method = $payment['payment_method'];
                        $payment_notes = $payment['notes'];
                        $balance = $formatter->formatCurrency($service['balance'], 'USD');

                        if ($key !== 0) {
                            $service_cost = $balance = $service_no = $service_name = $cost = '';
                        }

                        $report .= "<tr>
                                      <td>$service_no</td>
                                      <td>$service_name</td>
                                      <td>$service_cost</td>
                                      <td>$payment_date</td>
                                      <td>$amount_paid</td>
                                      <td>$payment_method</td>
                                      <td>$payment_notes</td>
                                      <td>$balance</td>
                                    </tr>";
                    }
                }
            }

            $replace['report_data'] = $report;

            $replace_array = array_merge($generic_msg, $replace);

            $content = $supp_obj->direct_replace($content, $replace_array);

            echo $content;
        }
    }

    public function excel_export()
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $get = $a_predefined['get'];

        if (isset($get['reportoptn']) && $get['reportoptn'] == "xls") {
            $date = date("m-d-y");
            $name = "invoice_$date";
            header("Pragma: public");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-Type: application/force-download");
            header("Content-Type: application/octet-stream");
            header("Content-Type: application/download");
            header("Content-Disposition: attachment;filename=$name.xls ");
            header("Content-Transfer-Encoding: binary ");
        }
    }
}


$invoice = $task = null;

if ($supp_obj->is_plugin_active('invoice')) {
    $task = $a_predefined['get']['task'];
    $export = new invoiceExport();
}
switch ($task) {
  case 'export':
    $export->excel_export();
    $invoice = $export->export();
    break;
}
