jQuery(function() {
	var hideDelay = 500;
	var ticketID;
	var hideTimer = null;
	// One instance that's reused to show info for the current person
	var container = jQuery('<div id="personPopupContainer">'
      + '<table width="" border="0" cellspacing="0" cellpadding="0" align="center" class="personPopupPopup">'
      + '<tr>'
      + '   <td class="corner topLeft"></td>'
      + '   <td class="top"></td>'
      + '   <td class="corner topRight"></td>'
      + '</tr>'
      + '<tr>'
      + '   <td class="left">&nbsp;</td>'
      + '   <td><div id="personPopupContent"></div></td>'
      + '   <td class="right">&nbsp;</td>'
      + '</tr>'
      + '<tr>'
      + '   <td class="corner bottomLeft">&nbsp;</td>'
      + '   <td class="bottom">&nbsp;</td>'
      + '   <td class="corner bottomRight"></td>'
      + '</tr>'
      + '</table>'
      + '</div>');
	jQuery('body').append(container);
	jQuery('.personPopupTrigger').live('mouseover',
	function() {
		// format of 'rel' tag: pageid,personguid
		ticketID = jQuery(this).attr('rel')
		// If no guid in url rel tag, don't popup blank
		if (ticketID == '') return;
		if (hideTimer) clearTimeout(hideTimer);
		var pos = jQuery(this).offset();
		var width = jQuery(this).width();
		container.css({
			left: (pos.left + width) + 'px',
			top: pos.top - 5 + 'px'
		});
		jQuery('#personPopupContent').html('&nbsp;');
		jQuery.ajax({
			type: 'POST',
			url: '../admin/get_ticket_details.php',
			data: 'ticket_id=' + ticketID,
			success: function(data) {
				//var text = jQuery(data).find('.personPopupResult').html();
				jQuery('#personPopupContent').html(data);
			}
		});
		container.css('display', 'block');
	});
	jQuery('.personPopupTrigger').live('mouseout',
	function() {
		if (hideTimer) clearTimeout(hideTimer);
		hideTimer = setTimeout(function() {
			container.css('display', 'none');
		},
		hideDelay);
	});
	// Allow mouse over of details without hiding details
	jQuery('#personPopupContainer').mouseover(function() {
		if (hideTimer) clearTimeout(hideTimer);
	});
	// Hide after mouseout
	jQuery('#personPopupContainer').mouseout(function() {
		if (hideTimer) clearTimeout(hideTimer);
		hideTimer = setTimeout(function() {
			container.css('display', 'none');
		},
		hideDelay);
	});
});