Ajax.InPlaceAutoCompleteEditor = Class.create();
Object.extend(Ajax.InPlaceAutoCompleteEditor.prototype, Ajax.InPlaceEditor.prototype);
Object.extend(Ajax.InPlaceAutoCompleteEditor.prototype, {
  initialize: function(element, url, options) {
    this.url = url;
    this.element = $(element);

    this.options = Object.extend({
      okButton: true,
      okText: "ok",
      cancelLink: true,
      cancelText: "cancel",
      savingText: "Saving...",
      clickToEditText: "Double click to edit",
      okText: "ok",
      rows: 1,
      onComplete: function(transport, element) {
        new Effect.Highlight(element, {startcolor: this.options.highlightcolor});
      },
      onFailure: function(transport) {
        alert("Error communicating with the server: " + transport.responseText.stripTags());
      },
      callback: function(form) {
        return Form.serialize(form);
      },
      handleLineBreaks: true,
      loadingText: 'Loading...',
      savingClassName: 'inplaceeditor-saving',
      loadingClassName: 'inplaceeditor-loading',
      formClassName: 'inplaceeditor-form',
      highlightcolor: Ajax.InPlaceEditor.defaultHighlightColor,
      highlightendcolor: "#FFFFFF",
      externalControl: null,
      submitOnBlur: false,
      ajaxOptions: {},
      evalScripts: false,
      dateField: false,
      onEnterField: this.enterHover.bind(this),
      onLeaveField: this.leaveHover.bind(this),
      highlightOnLeave: true
    }, options || {});

    if(!this.options.formId && this.element.id) {
      this.options.formId = this.element.id + "-inplaceeditor";
      if ($(this.options.formId)) {
        // there's already a form with that name, don't specify an id
        this.options.formId = null;
      }
    }
    
    if (this.options.externalControl) {
      this.options.externalControl = $(this.options.externalControl);
    }
    
    this.originalBackground = Element.getStyle(this.element, 'background-color');
    if (!this.originalBackground) {
      this.originalBackground = "transparent";
    }
    
    this.element.title = this.options.clickToEditText;
    
    this.ondblclickListener = this.enterEditMode.bindAsEventListener(this);
    this.mouseoverListener = this.enterHover.bindAsEventListener(this);
    this.mouseoutListener = this.leaveHover.bindAsEventListener(this);
    this.onkeypress = this.onKeyPress.bindAsEventListener(this);
    
    

    Event.observe(this.element, 'dblclick', this.ondblclickListener);
    Event.observe(this.element, 'mouseover', this.options.onEnterField);
    Event.observe(this.element, 'mouseout',  this.options.onLeaveField);

    if (this.options.externalControl) {
      Event.observe(this.options.externalControl, 'dblclick', this.ondblclickListener);
      Event.observe(this.options.externalControl, 'mouseover', this.options.onEnterField);
      Event.observe(this.options.externalControl, 'mouseout', this.options.onLeaveField);
    }

  },
  onKeyPress: function(evt) {
    if (evt.keyCode == Event.KEY_ESC) {
      this.onclickCancel();
    }
  },
  onclickCancel: function() {
    this.onComplete();
    this.leaveEditMode();
    if(this.options.post_cancel) {
      this.options.post_cancel();
    }
    return false;
  },
  // re-defined this function so we can add a date picker if we want
  enterEditMode: function(evt) {
    if (this.saving) return;
    if (this.editing) return;
    this.editing = true;
    this.onEnterEditMode();
    if (this.options.externalControl) {
      Element.hide(this.options.externalControl);
    }
    Element.hide(this.element);
    this.createForm();
    this.element.parentNode.insertBefore(this.form, this.element);
    if (this.options.dateField) {
      calendar_popup.setup(this.editField.id, this.editField.id);
    }
    Field.scrollFreeActivate(this.editField);
    // stop the event to avoid a page refresh in Safari
    if (evt) {
      Event.stop(evt);
    }
    return false;
  },
  
  createEditField: function() {
    var text;
    if(this.options.loadTextURL) {
      text = this.options.loadingText;
    } else {
      text = this.getText();
    }
    
    if (text == this.options.clickToEditText) text = '';

    var obj = this;

    var textField = document.createElement("input");
    textField.obj = this;
    textField.type = "text";
    textField.name = "value";
    textField.id = this.element.id + "_text";
    textField.value = text;
    textField.style.backgroundColor = this.options.highlightcolor;
    textField.className = 'editor_field text';
    var size = this.options.size || this.options.cols || 0;
    if (size != 0) textField.size = size;
    var maxlength = this.options.maxlength || 0;
    if (maxlength != 0) textField.maxLength = maxlength;
    if (this.options.submitOnBlur)
      textField.onblur = this.onSubmit.bind(this);
    this.editField = textField;
    
    if (!this.options.cancelLink && !this.options.cancelButton) {
      Event.observe(this.editField, "keypress", this.onkeypress);
    }
    
    if(this.options.loadTextURL) {
      this.loadExternalText();
    }
    this.form.appendChild(this.editField);
    this.form.style.margin = "0";
    this.form.style.padding = "0";
    
    var div = document.createElement("div");
    div.id = this.element.id + "_result";
    div.className = "auto_complete";
    this.div = div;
    this.form.appendChild(this.div);
    new Autocompleter.Local(this.editField, this.div, this.options.collection || []);
    if(this.options.post_blur) {
      this.onblur = this.options.post_blur.bindAsEventListener(this);
      Event.observe(this.editField, 'blur', this.onblur);
      Event.observe(this.form, 'submit', this.onblur);
    }
  }
});

Ajax.SpicyInPlaceEditor = Class.create();
Object.extend(Object.extend(Ajax.SpicyInPlaceEditor.prototype, Ajax.InPlaceEditor.prototype), {
  initialize: function(element, url, options) {
    this.url = url;
    this.element = $(element);

    this.options = Object.extend({
      paramName: "value",
      okButton: false,
      okButtonSource:null,
      okText: "ok",
      cancelLink: false,
      cancelText: "cancel",
      savingText: "Saving...",
      clickToEditText: "Click to edit",
      okText: "ok",
      rows: 1,
      onComplete: function(transport, element) {
        new Effect.Highlight(element, {startcolor: this.options.highlightcolor});
      },
      onFailure: function(transport) {
        alert("Error communicating with the server: " + transport.responseText.stripTags());
      },
      callback: function(form) {
        return Form.serialize(form);
      },
      handleLineBreaks: true,
      loadingText: 'Loading...',
      savingClassName: 'inplaceeditor-saving',
      loadingClassName: 'inplaceeditor-loading',
      formClassName: 'inplaceeditor-form',
      highlightcolor: Ajax.InPlaceEditor.defaultHighlightColor,
      highlightendcolor: "#FFFFFF",
      externalControl: null,
      submitOnBlur: true,
      ajaxOptions: {},
      evalScripts: false,
      onDoubleClick: false,
      onEnterField: this.enterHover.bind(this),
      onLeaveField: this.leaveHover.bind(this),
      highlightOnLeave: true
    }, options || {});

    if(!this.options.formId && this.element.id) {
      this.options.formId = this.element.id + "-inplaceeditor";
      if ($(this.options.formId)) {
        // there's already a form with that name, don't specify an id
        this.options.formId = null;
      }
    }
    
    if (this.options.externalControl) {
      this.options.externalControl = $(this.options.externalControl);
    }
    
    this.originalBackground = Element.getStyle(this.element, 'background-color');
    if (!this.originalBackground) {
      this.originalBackground = "transparent";
    }
    
    if (this.options.onDoubleClick) this.options.clickToEditText = 'double-click to edit';
    this.element.title = this.options.clickToEditText;
    
    this.onclickListener = this.enterEditMode.bindAsEventListener(this);
    this.mouseoverListener = this.enterHover.bindAsEventListener(this);
    this.mouseoutListener = this.leaveHover.bindAsEventListener(this);

    Event.observe(this.element, this.options.onDoubleClick ? 'dblclick' : 'click', this.onclickListener);
    Event.observe(this.element, 'mouseover', this.options.onEnterField);
    Event.observe(this.element, 'mouseout',  this.options.onLeaveField);


    if (this.options.externalControl) {
      Event.observe(this.options.externalControl, this.options.onDoubleClick ? 'dblclick' : 'click', this.onclickListener);
      Event.observe(this.options.externalControl, 'mouseover', this.mouseoverListener);
      Event.observe(this.options.externalControl, 'mouseout', this.mouseoutListener);
    }
  },
  getText: function() {
    if (this.element.id.toLowerCase().indexOf('password') > -1)
      return '';
    else
      return this.element.innerHTML;
  },
  createEditField: function() {
    var text;
    if(this.options.loadTextURL) {
      text = this.options.loadingText;
    } else if (this.options.textToEdit) {
      text = this.options.textToEdit;
    } else {
      text = this.getText();
    }

    var obj = this;
    
    if (this.options.rows == 1 && !this.hasHTMLLineBreaks(text)) {
      this.options.textarea = false;
      var textField = document.createElement("input");
      textField.obj = this;
      textField.type = "text";
      textField.name = this.options.paramName;
      textField.value = text;
      textField.style.backgroundColor = this.options.highlightcolor;
      textField.className = 'editor_field';
      var size = this.options.size || this.options.cols || 0;
      if (size != 0) textField.size = size;
      if (this.options.submitOnBlur)
        textField.onblur = this.onSubmit.bind(this);
      this.editField = textField;
    } else {
      this.options.textarea = true;
      var textArea = document.createElement("textarea");
      textArea.obj = this;
      textArea.name = this.options.paramName;
      textArea.value = this.convertHTMLLineBreaks(text);
      textArea.rows = this.options.rows;
      textArea.cols = this.options.cols || 40;
      textArea.className = 'editor_field';      
      if (this.options.submitOnBlur)
        textArea.onblur = this.onSubmit.bind(this);
      this.editField = textArea;
    }
    
    Event.observe(this.editField, 'keypress', this.onKeyPress.bindAsEventListener(this));
    
    if(this.options.loadTextURL) {
      this.loadExternalText();
    }
    this.form.appendChild(this.editField);
  },
  createForm: function() {
    this.form = document.createElement("form");
    this.form.id = this.options.formId;
    Element.addClassName(this.form, this.options.formClassName)
    this.form.onsubmit = this.onSubmit.bind(this);

    this.createEditField();

    if (this.options.textarea) {
      var br = document.createElement("br");
      this.form.appendChild(br);
    }
    
    if (this.options.textBeforeControls)
      this.form.appendChild(document.createTextNode(this.options.textBeforeControls));

    if (this.options.okButton) {
      var okButton = document.createElement("input");
      if (this.options.okButtonSource){
        okButton.type = "image";
        okButton.src = this.options.okButtonSource;
        okButton.className = 'image_button editor_ok_button';
        okButton.onclick = this.onSubmit.bind(this);
      } else {
        okButton.type = "submit";
        okButton.className = 'editor_ok_button';
      }
      okButton.value = this.options.okText;
      this.form.appendChild(okButton);
    }
    
    if (this.options.okLink) {
      var okLink = document.createElement("a");
      okLink.href = "#";
      okLink.appendChild(document.createTextNode(this.options.okText));
      okLink.onclick = this.onSubmit.bind(this);
      okLink.className = 'editor_ok_link';
      this.form.appendChild(okLink);
    }
    
    if (this.options.textBetweenControls && 
      (this.options.okLink || this.options.okButton) && 
      (this.options.cancelLink || this.options.cancelButton))
      this.form.appendChild(document.createTextNode(this.options.textBetweenControls));
      
      
    if (this.options.cancelButton) {
      if (!this.options.cancelButtonSource) {
        var cancelButton = document.createElement("input");
        cancelButton.type = "submit";
        cancelButton.value = this.options.cancelText;
        cancelButton.onclick = this.onclickCancel.bind(this);
        cancelButton.className = 'editor_cancel_button';
        this.form.appendChild(cancelButton);
      } else {
        var cancelButton = document.createElement('input');
        Object.extend(cancelButton, {
          type: 'image',
          src:  this.options.cancelButtonSource,
          onclick: this.onclickCancel.bind(this),
          className: 'editor_cancel_button'
        });
        this.form.appendChild(cancelButton);
      }
    }

    if (this.options.cancelLink) {
      var cancelLink = document.createElement("a");
      cancelLink.href = "#";
      cancelLink.appendChild(document.createTextNode(this.options.cancelText));
      cancelLink.onclick = this.onclickCancel.bind(this);
      cancelLink.className = 'editor_cancel editor_cancel_link';      
      this.form.appendChild(cancelLink);
    }
    
    if (this.options.textAfterControls)
      this.form.appendChild(document.createTextNode(this.options.textAfterControls));
  },
  leaveHover: function() {
    if (this.options.backgroundColor) {
      this.element.style.backgroundColor = this.oldBackground;
    }
    Element.removeClassName(this.element, this.options.hoverClassName)
    if (this.saving) return;
    if (this.options.highlightOnLeave) {
      this.effect = new Effect.Highlight(this.element, {
        startcolor: this.options.highlightcolor,
        endcolor: this.options.highlightendcolor,
        restorecolor: this.originalBackground
      });
    }
  },
  onKeyPress: function(event) {
    if (event.keyCode == Event.KEY_ESC) { this.onclickCancel(); }
  },
  onclickCancel: function() {
    this.onComplete();
    this.leaveEditMode();
    return false;
  }
});
  
  
Element.addMethods({
  /* helper functions for script.aculo.us */
  blindDown:    function(element, options) { new Effect.BlindDown(element, options); },
  blindUp:      function(element, options) { new Effect.BlindUp(element, options); },
  fade:         function(element, options) { new Effect.Fade(element, options); },
  appear:       function(element, options) { new Effect.Appear(element, options); },
  highlight:    function(element, options) { new Effect.Highlight(element, options); },
  pulsate:      function(element, options) { new Effect.Pulsate(element, options); },
  
  scrollTo: function(element, container, options){
    options = Object.extend({
      offsetX:0
    }, options || {});
    if (container){
      element = $(element);
      container = $(container);
      container.scrollTop = (element.offsetTop - element.offsetHeight) + options.offsetX;
    } else {
      element = $(element);
      var pos = Position.cumulativeOffset(element);
      window.scrollTo(pos[0], pos[1]);
    }
    return element;
  },
  morphIntoEdit: function(element){
    element.morph('height:100px', { duration: 0.5, afterFinish: function(morpher){ morpher.element.addClassName('active'); } });
  },
  morphOutOfEdit: function(element){
    element.morph('height:28px', { duration: 0.5, afterFinish: function(morpher){ morpher.element.removeClassName('active'); } });
  },
    
  // these helpers are custom to our app...
  getFirstInputValue: function(element){
    element = $(element);
    var my_inputs = element.getElementsByTagName('input');
    var input_value = 'error';
    if (my_inputs && my_inputs.length > 0){
      input_value = my_inputs[0].value;
    }
    return input_value;
  },
  text: function(element){
    element = $(element);
    /* 
    Return a node's inner text only, not the HTML. 
    IE uses one method (innerText) and all other browsers use a different one (textContent)
    Also checks for a node or empty node, since it *is* possible to have an empty node 
    */
    return (element ? (element.innerText ? element.innerText : element.textContent) : '');
  }
});

// some form helpers
Object.extend(Form, {
  // this implementation is specific to Spiceworks, since every form submit button has a class of "image_button"
  getFormButtons: function(form){
    return form.getElementsByClassName('image_button');
  }
});
