<?php
class database {
	// Public variable, holds the value of the database handle.
	private $db_handle;
	
	/* Database constructor that connects to the mysql server */
	function init($DB_HOST,$DB_NAME,$DB_USER,$DB_PASS) {
		// Redirect the user to install.php if the database connection is unsuccessful
		$cwd = getcwd();
		if(preg_match("/admin/i", $cwd) and file_exists("../install.php")) {	// if the current working directory ends in admin
			$dest = "../install.php";
		} else {
			$dest = "install.php";
		}	
	
		$dbh = mysqli_connect($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
		$cwd = getcwd();

		if(mysqli_connect_errno()) {
				$errno = 1004;
				$error = mysqli_connect_error();
				header("Location:$dest");exit;
		}

		$this->db_handle = $dbh;
		
		/*if(!mysqli_query($this->db_handle, "SET NAMES 'utf8'")) {
			$errno = mysqli_errno($this->db_handle);
			$error = mysqli_error($this->db_handle);
			echo "error: $error , $errno";
			exit;
		}*/
		
		return $dbh;
	}

	/* This function handles any sql query and executes it. Can be used safetly for any DDL and DML statements. In case of INSERTS, returns the auto_increment id	*/
	function execute_query($qry) {
		if(!mysqli_query($this->db_handle, $qry)) {
			$errno = mysqli_errno($this->db_handle);
			$error = mysqli_error($this->db_handle);
			echo "error: $qry $error , $errno";
			exit;
		}
		return mysqli_insert_id($this->db_handle);
	}

	/* Gets a record from the database table*/
	function get_a_line($qry) {
		$row = array();
		//echo '<pre>';print_r($this->db_handle);exit;
		if(!($res = mysqli_query($this->db_handle, $qry))) {
				echo "Error GAL: $qry. ".mysqli_error($this->db_handle) . " " . mysqli_errno();
				exit;
		} else {
			$row = mysqli_fetch_array($res);
			$row = $this->convert_html_entities($row);
			$this->free_result($res);
			return $row;
		}	
	}	

	/* Gets a record set from the database table */
	function get_rsltset($qry) {
		$j=0;
		$cur=mysqli_query($this->db_handle, $qry);
		$row=array();
		while($res=mysqli_fetch_array($cur)) {
			$res=$this->convert_html_entities($res);
			$row[$j]=$res;
			$j++;
		}
		$this->free_result($cur);
		return $row;
	}

	/* Gets associative array from database table */
	function get_associative_data($qry) {
		$j=0;
		$cur=mysqli_query($this->db_handle, $qry);
		$row=array();
		while($res=mysqli_fetch_array($cur))
		{
			$res=$this->convert_html_entities($res);
			$row[$res[0]]=$res[1];
			$j++;
		}
		$this->free_result($cur);
		return $row;	
	}

	function return_db_handle($qry) {
		if(!($res=mysqli_query($this->db_handle, $qry))) {
			$errno = mysqli_errno($this->db_handle);
			$error = mysqli_error($this->db_handle);
			echo "error $qry $error , $errno";
			exit;
		}
		return $res;		
	}

	function return_num_rows($cur) {
		return mysqli_num_rows($cur);
	}

	function free_result($cur) {
		if ($cur != "")
			mysqli_free_result($cur);
	}

	function escape_string($string) {
			return mysqli_real_escape_string($this->db_handle, $string);
	}
	
	function return_next_row($res) {
		$row=array();
		$row=mysqli_fetch_array($res);
		$row=$this->convert_html_entities($row);	
		return $row;
	}

	/* Gets a single column from a database table */
	function get_single_column($qry) {
		$j=0;
		//echo $qry;
		$cur=mysqli_query($this->db_handle, $qry);
		$row=array();
		while($res=mysqli_fetch_array($cur)) {
			$res=$this->convert_html_entities($res);
			$row[$j]=$res[0];
			$j++;
		}
		$this->free_result($cur);
		return $row;
	}

	function free_result_set($cur) {
		mysqli_free_result($cur);
	}
	
	function convert_html_entities($row) {
		$row=str_replace("$","&#36;",$row);
		return $row;
	}

	/* This function handles all the work as far as template system is concerned.
	Given a sql query, and a html file name with proper tag attributes , this would do the query,
	get the records from the table and populate the html file with the actual content and return
	the content to the user so that he can display it.The only constraint here is that , the 
	user should have matching tag attributes for the query and the template .
	* $loop_sql is an associative array having all the sql statments ex : $loop_sql['clients_']
	* $template is the raw html template
	* $eval_code , if any functionality is needed while printing the recordset , pass it as a
	* php code here.
	* $sel_arr , comes in handy while displaying pulldowns and checkboxes .. can use this to make a pulldown selected 
	*/
	function replace_loop($loop_sql, $template, $eval_code = '', $sel_arr = '', $start_tag = '<{', $end_tag = '}>', $adt = '') {
		if (!is_array($loop_sql)) {
			die('Sorry! Invalid parameter to <i><b>mysql_replace_loop</b></i> function.<br>SQL statements should be <u>an array</u>');
		}
		
		foreach($loop_sql as $loop_index => $sql) {
			$temp_start	= $start_tag.$loop_index.'loopstart'.$end_tag;
			$temp_end	= $start_tag.$loop_index.'loopend'.$end_tag;
			
			if(isset($eval_code[$loop_index])) {
				$tmp_eval	= $eval_code[$loop_index];
			}
			
			if(isset($sel_arr[$loop_index])) {
				$tmpsel_arr	= $sel_arr[$loop_index];
			}
			
			$loop_index_next = $loop_index."next";

			if(isset($eval_code[$loop_index_next])) {
				$tmp_eval_next	= $eval_code[$loop_index_next];
			}
			
			if (!is_string($loop_index)) {
				die('Sorry! Invalid loop index to <i><b>mysql_replace_loop</b></i> function.');
			}
			
			$result	= mysqli_query($this->db_handle, $sql);
			if ($result) {
				$num_rows	= mysqli_num_rows($result);
				if ($num_rows > 0) {
					preg_match("/$temp_start(.*?)$temp_end/s", $template, $mat);
					$mat	= @$mat[1];
					$temp_str	= '';
					$rowno=0;
					while ($row = mysqli_fetch_assoc($result)) {
						if(isset($row["subject"]))
							$row["subject"] = str_replace("\\","\\\\",$row["subject"]);
						if(isset($row["message"]))
							$row["message"] = str_replace("\\","\\\\",$row["message"]);
							
						$row = $this->convert_html_entities($row);
						$selected	= '';
						$checked	= '';
						$rowno++;
						while (list($tmp_name, $tmp_val) = each($row)) {
							$$tmp_name	= $tmp_val;
							if (isset($tmpsel_arr[$tmp_name]) and is_array($tmpsel_arr[$tmp_name])) {
								if (in_array($tmp_val, $tmpsel_arr[$tmp_name])) {
									$selected	= 'selected';
									$checked	= 'checked';
								}
							}
						}
						if(isset($tmp_eval) && !empty($tmp_eval)) {
							eval($tmp_eval);
						}
						//$temp_str	.= preg_replace("/$start_tag(.*?)$end_tag/e","$$1",$mat);
						preg_match_all("/$start_tag(.*?)$end_tag/", $mat, $matches);
						$tmp_array = array();
						foreach ($matches[0] as $_index => $var_name) {
							$tmp_var_name = $matches[1][$_index];
							if (isset($$tmp_var_name)) {
							    $tmp_array[$tmp_var_name] = $$tmp_var_name;
							} else {
								$tmp_array[$tmp_var_name] = '';
							}
						}
						
						$temp_str .= preg_replace_callback("/$start_tag(.*?)$end_tag/",
											 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
											 $mat);
						if(isset($tmp_eval_next) && !empty($tmp_eval_next)) {
							eval($tmp_eval_next);
						}
					}
					$template	= preg_replace("/$temp_start(.*?)$temp_end/s", $temp_str, $template);
					$this->free_result($result);
				} else {
					$template	= preg_replace("/$temp_start(.*?)$temp_end/s", '', $template);
				}
				$repl_status[$loop_index]	= $num_rows;
			} else {
				die("Error in query! $sql Function <i><b>mysql_replace_loop</b></i><br><b>MySQL Said:</b> ".mysqli_error($this->db_handle));
			}
		}
		return array($template,$repl_status);
	}
	
	//	Function mysql_replace_loop ends
	function date_add_sql($field,$offset,$format) {
		$sql=" $field + INTERVAL $offset $format ";
		return $sql;
	}	

	function return_sql_date($date) {
		$sql= " $date ";
		return $sql;
	}	
	
	function return_columns($tablename) {
		$sql=" desc $tablename ";
		$fields=$this->get_single_column($sql);
		return $fields;
	}

	function add_offsetNformat($field,$offset,$format,$return='') {
		$sql=$this->date_add_sql($field,$offset,$format);
		if($return!="") {
			$sql.=" as $return ";
		} else {
			$sql.=" as $field ";
		}	
		return $sql;
	}

	function alter_table($tablename,$mode,$old_name,$new_name,$datatype) {
		switch($mode) {
			case "ALTER":
			$sql="alter table $tablename change $old_name $new_name $datatype ";
			$this->execute_query($sql);
			break;
		}	
	}	

	function search_tickets($subject_string) {
		//$sql=" and MATCH(subject,message) AGAINST ('$subject_string') ";
		//return $sql;	
	}	
	
	function date_diff($date1,$date2) {	
		$sql= " ( to_days('$date1') - to_days($date2) ) ";
		return $sql;		
	}

	function return_table_desc($table_name)	 {
		$sql="desc $table_name ";
		$cur=$this->return_db_handle($sql);
		$rst=array(); 
		while($row=$this->return_next_row($cur)) {
			$rst[$row['Field']]=$row['Type'];
		}	
		return $rst;
	}
}

	function init_connect($dbhost,$dbuser,$dbpass) {
		$dbh=mysql_connect($dbhost,$dbuser,$dbpass);
		return $dbh;
	}
	
	function close_connect($dbh) {
		mysqli_close($dbh);
	}
	
	function return_error($dbh) {
		return mysqli_error($dbh);	
	}

	function create_database($dbname,$db_handle) {
		$sql="CREATE DATABASE $dbname  $string ";
		if(!mysqli_query($db_handle, $sql)) {
			$error=mysqli_error($db_handle);
			$status_array['flag']=false;
			$status_array['message']=$error;
			return $status_array;
		} else {
			$status_array['flag']=true;	
			return $status_array;
		}	
	}

	function select_db($dbname,$db_handle)
	{
		if(!mysqli_select_db($db_handle, $dbname))
		{
			$error=mysqli_error($db_handle);
			$status_array['flag']=false;
			$status_array['message']=$error;
			return $status_array;
		}
		else
		{
			$status_array['flag']=true;	
			return $status_array;
		}	
	}	
//--------------------------------------------------------------------------------------------
	function create_tables($tbl_prefix,$dbh)
	{

		$table=$tbl_prefix."_clients";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `client_id` int(11) unsigned NOT NULL auto_increment,
  `client_name` varchar(255)  NULL,
  `email` varchar(255)  NULL,
  `phone` varchar(255)  NULL,
  `registered_on` datetime  NULL,
  `default_lang` varchar(255)  NULL ,
  `preferred_zone` int(11) NULL ,
  `pass_word` varchar(255)  null,
client_status varchar(255) null, 
  PRIMARY KEY  (`client_id`),
  FULLTEXT KEY `client_name` (`client_name`,`email`)
) TYPE=MyISAM;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	
	// Create the activity log table
	$table=$tbl_prefix."_activity_log";
$createcode=<<<EOD
	create table `$table` ( 
	`activity_id` int(11) not null auto_increment primary key,
	`action_on` datetime,
	`action_by` int(11) , 
	`action_who` enum('STAFF','CLIENT','SYSTEM') ,
	`ticket_id` varchar(10) ,
	`action_name` varchar(10) , 
	`action_detail` varchar(255),
	 adept_id int,
	 areply_id int,
	astatus varchar(5) 
 );
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

		// Create the cannedreplies table
	$table=$tbl_prefix."_cannedreplies";
$createcode=<<<EOD
	create table `$table` ( 
	`canned_id` int(11) not null auto_increment primary key,
	`canned_subject` varchar(255),
	`canned_message` text,
	`canned_type` varchar(50),
	`staff_id` int(11),
	`canned_date` datetime,
	`depttype` varchar(25)
	);
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


		// Create the canneddept table
	$table=$tbl_prefix."_canneddept";
$createcode=<<<EOD
	create table `$table` ( 
	`cd_id` int(11) not null auto_increment primary key,
	`dept_id` int(11),
	`canned_id` int(11)	
	);
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}
		



	// Create the configuration table		
	$table=$tbl_prefix."_configuration";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `config_id` int(11) unsigned NOT NULL auto_increment,
  `logo` varchar(255)  NULL,
  `admin_email` varchar(255)  NULL,
  `ticket_subject` varchar(255)  NULL,
  `ticket_message` text,
  `attachment` int(11)  NULL ,
  `attachment_size` int(11)  NULL,
  `delete_mail` int(11)  NULL,
  `reply_subject` varchar(255)  NULL,
  `ticket_pattern` varchar(255)  NULL,
  `records_per_page` int(11) NOT NULL default '0',
  `send_reply` int(11) NOT NULL default '0',
  `reply_message` text  NULL,
  `send_mail` int(11) NOT NULL default '0',
  `send_tktconfirmation` int(11) NOT NULL default '0',
  `send_tktreply` int(11) NOT NULL default '0',
  `http_url` varchar(255)  NULL,
  `tktnotify_subject` varchar(255) NOT NULL default '',
  `tktnotify_message` text,
  `tktnotify_action` int(11) NOT NULL default '0',
  `forgotpass_subject` varchar(255) NOT NULL default '',
  `forgotpass_message` text NOT NULL,
   `forgottkt_subject` varchar(255) NOT NULL default '',
  `forgottkt_message` text NOT NULL,
  `newstaff_subject` varchar(255) NOT NULL default '',
  `newstaff_message` text NOT NULL,
  `newstaff_action` int(11) NOT NULL default '1',
  `cron_option` int(11) not null default '0',
  `cron_time` int(11) not null default '0',
  `last_checked` int(11) not null default '0',
  `approvestaff_subject` varchar(255) NOT NULL default '',
  `approvestaff_message` text NOT NULL,
  `approvestaff_action` int(11) NOT NULL default '1',
 `auto_close` int(11) not null default '7',
 `escalate` int(11) not null default '2',
  `version_no` varchar(20) NOT NULL ,
   `version_info` varchar(20) NOT NULL ,
   	assignstaff_subject varchar(255) not null,
	assignstaff_message text not null,
	assignstaff_action int(11) not null default '1',
	print_activitylog int(11) not null default '1',
	admlogo varchar(255)  null,
	staff_replies int(11) not null default '1',
	closeticket_subject varchar(255),
	closeticket_message text,
	closeticket_action int(11) not null default '1',
	time_zone int(11) not null default '0',
	newclient_subject varchar(255) not null,
	newclient_message text not null,
	newclient_action int(11) not null default '1',
	default_lang varchar(255) null , 
	hide_closed int(11) null,
	attachment_subject varchar(255) NOT NULL default '',
	attachment_message text NOT NULL,
	attachment_action int(11) not null default '1',
	ticket_summary text,
	ticket_replies text,
	ticket_summary_flag int(11) not null,
	ticket_replies_flag int(11) not null,
	ticket_reply_subject varchar(255),
	ticket_summary_subject varchar(255),
	ticket_field varchar(255), 
	password_flag int, 	
	smtp_mail int,
	smtp_host varchar(255),
	smtp_port varchar(255),
	smtp_username varchar(255),
	smtp_password varchar(255),
	allow_routing varchar(255) NULL,  
	allow_staff_stats varchar(255) NULL,
	privatealert_action int NULL,
	privatealert_subject varchar(255) NULL,
	privatealert_message text NULL   ,
	registered_only varchar(255) , 
 	signuprequired_subject varchar(255),
	signuprequired_message text,
	signuprequired_action varchar(255),
	newuser_subject varchar(255),
	newuser_message text,
	newuser_action varchar(255),
	approveduser_subject varchar(255),
	approveduser_message text,
	approveduser_action varchar(255),  	 
	cron_running char(1),
	last_cron_time datetime,	
  PRIMARY KEY  (`config_id`)
) TYPE=MyISAM  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the departments table
	$table=$tbl_prefix."_departments";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `dept_id` int(11) unsigned NOT NULL auto_increment,
  `dept_name` varchar(255)  NULL,
  `ticket_prefix` char(2)  NULL,
  `dept_description` text,
show_time_spent int,
skip_checking varchar(255) NULL, 
group_number int NULL,
private_dept int NULL ,   
  PRIMARY KEY  (`dept_id`)
) TYPE=MyISAM ;
EOD;
		
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the department servers table
	$table=$tbl_prefix."_dept_servers";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `dept_serv_id` int(11) unsigned NOT NULL auto_increment,
  `server_id` int(11)  NULL,
  `dept_id` int(11)  NULL,
  `default_server` int(11)  NULL default '1',
  PRIMARY KEY  (`dept_serv_id`)
) TYPE=MyISAM;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

		// Create the emails table
	$table=$tbl_prefix."_emails";
$createcode=<<<EOD
CREATE TABLE `$table` (
email_id int(11) not null auto_increment primary key,
email varchar(255),
ticket_id varchar(255),
staff_id int(11),
email_as varchar(3),
reply_id int(11)
) TYPE=MyISAM;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	

	// Create the ignored words table
	$table=$tbl_prefix."_ignored_words";
$createcode=<<<EOD
CREATE TABLE `$table` (
 `word` varchar(20)  NULL
) TYPE=MyISAM;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the language table				
	$table=$tbl_prefix."_fields";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `field_id` int(11) NOT NULL auto_increment primary key,
	field_name varchar(255),
field_level int,
parent_id int,
display_order int,
table_field varchar(255),
orient_id int,
fill_close int
  ) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	// Create the language table				
	$table=$tbl_prefix."_field_option";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `field_option_id` int(11) NOT NULL auto_increment primary key,
	field_option_name varchar(255)  ) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


	// create field_answers table
	$table = $tbl_prefix . "_field_answers";
	$createcode  = "create table $table (id int (11) not null auto_increment, answer_id int (11) not null, " ;
	$createcode .= "field_id int(11) not null, field_answer varchar(100), ";
	$createcode .= "depends_on_answer_id int (11) not null, field_type_id int(11) not null, ";
	$createcode .= "field_display_id int (11) not null, compulsory int(2) not null, submitform int(2) not null, ";
	$createcode .= " primary key(id))";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}



	// create client custom values table
	$table = $tbl_prefix . "_client_custom_values";
	$createcode = "create table $table (client_id int(11)) ";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}


	// create client custom ids table
	$table = $tbl_prefix . "_client_custom_ids";
	$createcode = "create table $table (client_id int(11)) ";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}



	// create ticket custom values table
	$table = $tbl_prefix . "_ticket_custom_values";
	$createcode = "create table $table (ticket_id varchar(10))";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}

	// create ticket custom ids table
	$table = $tbl_prefix . "_ticket_custom_ids";
	$createcode = "create table $table (ticket_id varchar(10))";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}




















// Create the field_dept table				
	$table=$tbl_prefix."_field_dept";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `fd_id` int(11) NOT NULL auto_increment primary key,
	field_id int,
	dept_id int
	  ) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


// Create the language table				
	$table=$tbl_prefix."_field_orientation";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `orient_id` int(11) NOT NULL auto_increment primary key,
	orient_name varchar(255)  ) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	
	
		$table=$tbl_prefix."_field_type";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `fieldtype_id` int(11) NOT NULL auto_increment primary key,
	field_type_name varchar(255)  ) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	$table=$tbl_prefix."_plugins";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `plugin_id` int(11) NOT NULL auto_increment primary key,
	plugin_name varchar(255),
	plugin_status int,
	plugin_version varchar(255) 

  ) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	




	// Create the language table				
	$table=$tbl_prefix."_language";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `lang_id` int(11) NOT NULL auto_increment,
  `langname_en` varchar(255)  NULL,
  `lang_folder` varchar(255)  NULL,
  langname_de varchar(255)  NULL,
  langname_fr varchar(255) NULL,
 langname_nl varchar(255) NULL,
langname_ru varchar(255) NULL,
langname_es varchar(255) NULL, 
  PRIMARY KEY  (`lang_id`)
) TYPE=MyISAM ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the mail servers table	
	$table=$tbl_prefix."_mail_servers";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `server_id` int(11) unsigned NOT NULL auto_increment,
  `pop3_host` varchar(255)  NULL,
  `pop3_username` varchar(255)  NULL,
  `pop3_password` varchar(255)  NULL,
  `pop3_email` varchar(255)  NULL,
  `signature` text,
  `last_checked` datetime  null,
  PRIMARY KEY  (`server_id`)
) TYPE=MyISAM ;
EOD;
		
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the news table	
	$table=$tbl_prefix."_news";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `news_id` int(11) NOT NULL auto_increment,
  `news_hdline` varchar(255)  NULL,
  `news_body` text,
  `announcement` int(11)  NULL ,
  `ndept_id` int(11)  NULL,
  `nstaff_id` int(11)  NULL ,
  `last_activity` datetime  NULL ,
  PRIMARY KEY  (`news_id`)
) TYPE=MyISAM;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
		
	// Create the spam message table
	$table=$tbl_prefix."_spam_message";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `spm_id` int(11) NOT NULL auto_increment,
  `sp_word` text,
  `sp_addresses` text,
  `spamaction` varchar(255)  NULL,
  PRIMARY KEY  (`spm_id`)
) TYPE=MyISAM ;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the staff table
	$table=$tbl_prefix."_staff";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `staff_id` int(11) unsigned NOT NULL auto_increment,
  `staff_name` varchar(255)  NULL,
  `staff_password` varchar(255)  NULL,
  `staff_username` varchar(255)  NULL,
  `staff_email` varchar(255)  NULL,
  `staff_status` char(1) default 'i',
  `is_admin` int(11) default '0',
  `default_lang` varchar(255) NOT NULL default 'eng',
  `preferred_zone` int(11) NOT NULL default '0',
  `notify_ticket` int(11) NOT NULL default '0',
  `notify_reply` int(11) NOT NULL default '0',
  `all_dept` int(11)  null,
  `hash` varchar(255)  NULL ,
  notify_assign int(11) NOT NULL default '1',	
  `notify_closeticket` int(11) not null default '0',
staff_signature text, 	
 ticket_access int,
allow_canned varchar(255) NULL,
allow_staff varchar(255) NULL, 	
act_on_closed varchar(255) NULL, 
notify_spam int not null default '0',  
 PRIMARY KEY  (`staff_id`)
) TYPE=MyISAM  ;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the staff departments table	
	$table=$tbl_prefix."_staff_departments";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `staff_dept_id` int(11) unsigned NOT NULL auto_increment,
  `staff_id` int(11) unsigned NOT NULL default '0',
  `dept_id` int(11) unsigned NOT NULL default '0',
readonlyaccess int NOT NULL default '0', 	
  PRIMARY KEY  (`staff_dept_id`)
) TYPE=MyISAM ;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the ticket attachments table	
	$table=$tbl_prefix."_ticket_attachments";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `att_id` int(11) NOT NULL auto_increment,
  `ticket_id` varchar(10) NOT NULL default '',
  `attachment_name` varchar(255)  NULL,
  `file_name` varchar(255) NOT NULL default '',
  `reply_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`att_id`)
) TYPE=MyISAM ;
EOD;
			
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the ticket priorities table
	$table=$tbl_prefix."_ticket_priorities";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `priority_id` int(11) unsigned NOT NULL auto_increment,
  `priorityname` varchar(255)  NULL,
  PRIMARY KEY  (`priority_id`)
) TYPE=MyISAM ;
EOD;
			
$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the ticekt replies table		
	$table=$tbl_prefix."_ticket_replies";
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `reply_id` int(11) unsigned NOT NULL auto_increment,
  `reporter_id` int(11) unsigned NOT NULL default '0',
  `ticket_id` varchar(10) NOT NULL default '',
  `replied_on` datetime  NULL,
  `reminder_on` datetime  NULL,
  `reply` text,
  `reporter` enum('STAFF','CLIENT') NOT NULL default 'STAFF',
  `subject` varchar(255)  NULL,
  `last_update` datetime  NULL,
  `last_updatedby` int(11)  NULL,
  `last_reporter` varchar(255)  NULL,
  `change_status` varchar(255) NOT NULL default 'N',
   `private` int(11)  NULL default '0' ,
`readflag` char(1) NOT NULL default 'U',
  `draft` text,
  `internal_message` text,
	reply_minutes  int(11) ,
	responded_from int not null default '0',  
	resolution_item int not null default '0', 
  PRIMARY KEY  (`reply_id`)
) TYPE=MyISAM  ;
EOD;
			
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

$createcode=<<<EOD
	alter table $table add index ind_ticket_replies(ticket_id) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

		
		// Create the ticket status table
	$table=$tbl_prefix."_ticket_status";	
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `status_id` int(11) unsigned NOT NULL auto_increment,
  `statusname` varchar(255)  NULL,
  `status_key` char(1) NOT NULL default '',
  PRIMARY KEY  (`status_id`)
) TYPE=MyISAM ;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
		// Create the tickets table
	$table=$tbl_prefix."_tickets";	
$createcode=<<<EOD
	CREATE TABLE `$table` (
  `ticket_id` varchar(10) NOT NULL default '',
  `staff_id` int(11) unsigned NOT NULL default '0',
  `priority_id` int(11) unsigned NOT NULL default '0',
  `status` char(1) NOT NULL default '0',
  `cat_id` int(11) unsigned NOT NULL default '0',
  `client_id` int(11) unsigned NOT NULL default '0',
  `subject` varchar(255)  NULL,
  `message` text,
  `client_last_activity` datetime  NULL,
  `flag` char(1)  NULL,
  `dept_id` int(11)  NULL,
  `server_id` int(11)  NULL,
  `ticket_created` datetime  NULL,
  `sent_date` datetime  NULL,
  `timezone` int(11)  NULL,
  `assign_reason` text,
  `updater_id` int(11) NOT NULL default '0',
  `updater` varchar(255) NOT NULL default '',
  `staff_last_activity` datetime  NULL,
    `assigned_to` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ticket_id`),
  FULLTEXT KEY `subject` (`subject`,`message`)
  
) TYPE=MyISAM;
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

$table=$tbl_prefix."_staffsession";	

$createcode=<<<EOD
create table if not exists $table  (
session_id int(11) primary key auto_increment,
staff_id int(11),
staff_hash varchar(255),
lastloggedin int(11) )

EOD;
	
		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

$table=$tbl_prefix."_groups";	

$createcode=<<<EOD
create table if not exists $table  (
group_id int(11) primary key auto_increment,
group_name varchar(255)  
 )

EOD;
	
		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}



$table=$tbl_prefix."_deptgroups";	

$createcode=<<<EOD
create table if not exists $table  (
dg_id int(11) primary key auto_increment,
gdept_id int,
ggroup_id int  
 )

EOD;
	
		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


$table=$tbl_prefix."_statssettings";	

$createcode=<<<EOD
create table if not exists $table  (
stats_id int primary key ,
exclude_weekends int,
 time_zone int  
 )

EOD;
	
		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


$table=$tbl_prefix."_tickets";		

	$createcode=<<<EOD
	alter table $table add index ind_dept_id(dept_id) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	alter table $table add index ind_status(status) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	alter table $table add index ind_assigned_to(assigned_to) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	$createcode=<<<EOD
	alter table $table add index ind_ticket_created(ticket_created) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	
	$createcode=<<<EOD
	alter table $table add index ind_staff_last_activity(staff_last_activity) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	$createcode=<<<EOD
	alter table $table add index ind_client_last_activity(client_last_activity) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

$table=$tbl_prefix."_activity_log";	

	$createcode=<<<EOD
	alter table $table add index ind_action_on(action_on) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	alter table $table add index ind_action_detail(action_detail) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	
	$createcode=<<<EOD
	alter table $table add index ind_action_ticket_id(ticket_id) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	alter table $table add index ind_adept_id(adept_id) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	$createcode=<<<EOD
	alter table $table add index ind_action_by(action_by) ;
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


		$return_message['flag']=true;
	return $return_message;		
		
	}	

function execute_sql($query,$dbh)
{
	if(!mysqli_query($dbh, $query))
	{
		$error=mysqli_error($dbh);
		$status_array['flag']=false;
		$status_array['message']=$error;
		if($id=mysqli_insert_id())
		{
			$status_array['identity']=$id;
		}	
		return $status_array;
	}
	else
	{
		$status_array['flag']=true;
		if($id=mysqli_insert_id())
		{
			$status_array['identity']=$id;
		}	

		return $status_array;
	}	
}	
	

?>
