<?php

class database
{

	var $db_handle;



//-------------------------------------------------------------------------------------
/* Database constructor that connects to the mysql server */
	function database($DB_HOST,$DB_NAME,$DB_USER,$DB_PASS)
		{
			$cwd=getcwd();

			if(ereg("admin$",$cwd) and file_exists("../install.php"))	// if the current working directory ends in admin
			{
				$dest="../install.php";
			}
			else
			{
				$dest="install.php";
			}		
			if(!function_exists('mssql_pconnect')) // Oops, mysql won't work now.Problem for me
			{
					header("Location:$dest");
					exit;	
			}
			$dbh=@mssql_pconnect($DB_HOST,$DB_USER,$DB_PASS);
			$cwd=getcwd();
			if(!$dbh)
			{
					header("Location:$dest");
					exit;
			}

			if(!mssql_select_db($DB_NAME))
			{

					header("Location:$dest");
					exit;
			}

			$this->db_handle=&$dbh;

			return $dbh;
		}
//---------------------------------------------------------------------
//---------------------------------------------------------------------



/* This function handles any sql query and executes it*/
	function execute_query($qry)
		{
			
			$qry=str_replace("\'","''",$qry);
			$qry=str_replace('\"','"',$qry);
	
			if(!mssql_query($qry,$this->db_handle))
				{
					$error=mssql_get_last_message();
					echo "error: $qry $error ";												     exit;
				}
			//echo $qry;
			if( preg_match('#^INSERT #i', trim($qry)) )
			{
				$result_id=@mssql_query('select @@identity as id',$this->db_handle);
				if($result_id)
				{
					if($row=mssql_fetch_array($result_id))
					{
						return $row['id'];	
					}
				}
			}


		}
//---------------------------------------------------------------------
/* Gets a record from the database table*/
	function get_a_line($qry)
		{
		$row=array();
		if(!($res=$this->return_db_handle($qry)))
				{
					$error=mssql_get_last_message();
					echo "error $qry $error ";
					exit;
				}
				else
			{
				$row=mssql_fetch_array($res);
				$row=$this->convert_html_entities($row);
				return $row;
			}	
		}	
//---------------------------------------------------------------------
/* Gets a record set from the database table */
	function get_rsltset($qry)		
	{
			$j=0;
			$cur=$this->return_db_handle($qry);
			$row=array();
			while($res=mssql_fetch_array($cur))
			{
				$res=$this->convert_html_entities($res);
				$row[$j]=$res;
				$j++;
			}
			return $row;
	}
//----------------------------------------------------------------------
/* Gets associative array from database table */
	function get_associative_data($qry)
	{
			$j=0;
			$cur=$this->return_db_handle($qry);
			$row=array();
			while($res=mssql_fetch_array($cur))
			{
				$res=$this->convert_html_entities($res);
				$row[$res[0]]=$res[1];

				
				$j++;
			}
			return $row;	
	}
//-------------------------------------------------------------------------------------------

		function free_result($cur)
	{
		mssql_free_result($cur);
	}


	function return_db_handle($qry)
	{
	
			$qry=str_replace("\'","''",$qry);
			$qry=str_replace('\"','"',$qry);

	

		$query=$qry;
		if( preg_match('/^select(.*?)limit(.*?)$/s', $qry, $limits) )
		//if( preg_match('/^select(.*?)(limit ([0-9]+)[, ]*([0-9]+)*)?$/s', $qry, $limits) )
		{
			$qry = $limits[1];
			list($e,$li)=preg_split("/limit/is",$query);
			list($row_offset,$num_rows)=split(",",trim($li));
			//print_R($list);
			if( !empty( $qry))
			{
				//$row_offset = ( $limits[4] ) ? $limits[3] : "";
				//$num_rows = ( $limits[4] ) ? $limits[4] : $limits[3];
				if(eregi("distinct",$qry))
				{
					$qry=str_replace("distinct","",$qry);
					$distinct=" distinct ";
				}
				else
				{
					$distinct=" ";	
				}	

				$qry = $distinct. ' TOP ' . ( $row_offset + $num_rows ) . $qry;
			}
			//echo "select $qry <hr/>";
			$res = @mssql_query("select $qry", $this->db_handle); 

			if( $res )
			{
				//	$this->limit_offset[$this->result] = ( !empty($row_offset) ) ? $row_offset : 0;
				if( $row_offset > 0 )
				{
						@mssql_data_seek($res, $row_offset);
				}
			}
			else
			{
				$error=mssql_get_last_message();
				echo "error select $qry $error ";
				exit;
			}	
		}
		elseif(preg_match('/^desc(.*?)$/s', $qry, $limits))
		{
			$qry=$limits[1];
			$qry=" sp_columns @table_name='$qry' ";
			$res=mssql_query($qry,$this->db_handle);

		
		}	
		elseif(!($res=mssql_query($qry,$this->db_handle)))
		{

			$error=mssql_get_last_message();
			echo "error $qry $error ";
			exit;
		}
		return $res;		
	}
//-------------------------------------------------------------------------------------------
	function return_next_row($res)
	{
	
		$row=array();
		$row=mssql_fetch_array($res);
		$row=$this->convert_html_entities($row);
		return $row;
		
	}
//-----------------------------------------------------------------------------------	

/* Gets a single column from a database table */
	function get_single_column($qry)
	{
			$j=0;
			$cur=$this->return_db_handle($qry);
			$row=array();
			while($res=mssql_fetch_array($cur))
			{
				$res=$this->convert_html_entities($res);
				$row[$j]=$res[0];
				$j++;
			}
			return $row;
	}
//---------------------------------------------------------------------------------------
	function return_num_rows($cur)
	{
		return mssql_num_rows($cur);
	}

//---------------------------------------------------------------------------------------------
function free_result_set($cur)
{
	mssql_free_result($cur);
		
}
//--------------------------------------------------------------------------------------------

function convert_html_entities($row)
{
		$row=str_replace("$","&#36;",$row);
		

		return $row;
}

//--------------------------------------------------------------------------------------------



/* This function handles all the work as far as template system is concerned.
Given a sql query, and a html file name with proper tag attributes , this would do the query,
get the records from the table and populate the html file with the actual content and return
the content to the user so that he can display it.The only constraint here is that , the 
user should have matching tag attributes for the query and the template .
* $loop_sql is an associative array having all the sql statments ex : $loop_sql['clients_']
* $template is the raw html template
* $eval_code , if any functionality is needed while printing the recordset , pass it as a
* php code here.
* $sel_arr , comes in handy while displaying pulldowns and checkboxes .. can use this to make a pulldown selected 
*/
function replace_loop($loop_sql,$template,$eval_code='',$sel_arr='',$start_tag='<{',$end_tag='}>',$adt='')
	{
		if (!is_array($loop_sql))
		{
			die('Sorry! Invalid parameter to <i><b>mysql_replace_loop</b></i> function.<br>SQL statements should be <u>an array</u>');
		}
		while (list($loop_index,$sql) = @each($loop_sql))
		{
			$temp_start	= $start_tag.$loop_index.'loopstart'.$end_tag;
			$temp_end	= $start_tag.$loop_index.'loopend'.$end_tag;
			$tmp_eval	= $eval_code[$loop_index];
			$tmpsel_arr	= $sel_arr[$loop_index];
			$loop_index_next=$loop_index."next";
			$tmp_eval_next	= $eval_code[$loop_index_next];
			//print_R($tmpsel_arr);
			if (!is_string($loop_index))
			{
				die('Sorry! Invalid loop index to <i><b>mysql_replace_loop</b></i> function.');
			}
			$result	= $this->return_db_handle($sql);
			if ($result)
			{
				$num_rows	= mssql_num_rows($result);
				if ($num_rows > 0)
				{
					preg_match("/$temp_start(.*?)$temp_end/s",$template,$mat);
//print_r($mat);
					$mat	= $mat[1];
//echo $mat;					
					$temp_str	= '';
					$rowno=0;
					while ($row = mssql_fetch_assoc($result))
					{
						$row["subject"]=str_replace("\\","\\\\",$row["subject"]);
						$row["message"]=str_replace("\\","\\\\",$row["message"]);
					
						$row=$this->convert_html_entities($row);
						$selected	= '';
						$checked	= '';
						$rowno++;
						while (list($tmp_name,$tmp_val) = @each($row))
						{
							$$tmp_name	= $tmp_val;
							//echo $tmp_name;
							
							
							if (is_array($tmpsel_arr[$tmp_name]))
							{
						
								if (in_array($tmp_val,$tmpsel_arr[$tmp_name]))
								{
									$selected	= 'selected';
									$checked	= 'checked';
								}
							}
						}
						eval($tmp_eval);
						$temp_str	.= preg_replace("/$start_tag(.*?)$end_tag/e","$$1",$mat);
						eval($tmp_eval_next);
					}
					$template	= preg_replace("/$temp_start(.*?)$temp_end/s",$temp_str,$template);
				}
				else
				{
					$template	= preg_replace("/$temp_start(.*?)$temp_end/s",'',$template);
				}
				$repl_status[$loop_index]	= $num_rows;
			}
			else
			{
				die("Error in query! $sql Function <i><b>mssql_replace_loop</b></i><br><b>MsSQL Said:</b> ".mysql_error());
			}
		}
		return array($template,$repl_status);
		
	}	//	Function mysql_replace_loop ends
//------------------------------------------------------------------------------

	function date_add_sql($field,$offset,$format)
	{
		$sql=" DATEADD($format,$offset,$field)  ";
		return $sql;
	}	
//-----------------------------------------------------------------------------------

	function return_sql_date($date)
	{
		
	$sql=" CAST(DATEPART(YYYY,$date) AS CHAR(4)) + '-'
            + RIGHT(CAST(100+DATEPART(MM,$date) AS CHAR(3)),2) + '-'
            + RIGHT(CAST(100+DATEPART(DD,$date) AS CHAR(3)),2) + ' '
            + RIGHT(CAST(100+DATEPART(hh,$date) AS CHAR(3)),2) + ':'
            + RIGHT(CAST(100+DATEPART(mi,$date) AS CHAR(3)),2) + ':'
           + RIGHT(CAST(100+DATEPART(ss,$date) AS CHAR(3)),2) + ''
              AS $date ";
		return $sql;
	}	

//-------------------------------------------------------------------------------------------------

	function return_columns($tablename)
	{
		$sql=" select column_name from information_schema.columns where table_name='$tablename' ";
		$fields=$this->get_single_column($sql);
		return $fields;	
		
		
	}	
//----------------------------------------------------------------------------------------------------------

	function escape_string($string)
	{
		 
	$replaced_string = str_replace("'","''",$string);
	return $replaced_string; 

	}
	
//------------------------------------------------------------------------------------------------------------
	function return_table_desc($table_name)	
	{
		$sql="select column_name,data_type from information_schema.columns where table_name='$table_name' ";
			$cur=$this->return_db_handle($sql);
		$rst=array(); 
		while($row=$this->return_next_row($cur))
		{
		
			$rst[$row['column_name']]=$row['data_type'];
		
		}	
		
		return $rst;
	}

//----------------------------------------------------------------------------------------------------------
	
	function add_offsetNformat($field,$offset,$format,$return='')
	{


		if($return=="")
		{
			$return=$field;
		}	

		$sql=" CAST(DATEPART(YYYY,".$this->date_add_sql($field,$offset,$format).") AS CHAR(4)) + '-'
            + RIGHT(CAST(100+DATEPART(MM,".$this->date_add_sql($field,$offset,$format).") AS CHAR(3)),2) + '-'
            + RIGHT(CAST(100+DATEPART(DD,".$this->date_add_sql($field,$offset,$format).") AS CHAR(3)),2) + ' '
            + RIGHT(CAST(100+DATEPART(hh,".$this->date_add_sql($field,$offset,$format).") AS CHAR(3)),2) + ':'
            + RIGHT(CAST(100+DATEPART(mi,".$this->date_add_sql($field,$offset,$format).") AS CHAR(3)),2) + ':'
           + RIGHT(CAST(100+DATEPART(ss,".$this->date_add_sql($field,$offset,$format).") AS CHAR(3)),2) + ''
              AS $return ";
		return $sql;
	
	}

//--------------------------------------------------------------------------------------------------------------------------------
	function alter_table($tablename,$mode,$old_name,$new_name,$datatype)
	{
		
		switch($mode)
		{
			case "ALTER":
			if($old_name!=$new_name)
			{	
				$sql="EXEC sp_rename '$tablename.$old_name', '$new_name','COLUMN'";
				$this->execute_query($sql);
			}	
			break;
		}	
	
	}	

//---------------------------------------------------------------------------------------------------------------------------------

	function search_tickets($subject_string)
	{

		$sql="";
		$subject_array=preg_split("/[ ]+/is",$subject_string,-1,PREG_SPLIT_NO_EMPTY);
		if(count($subject_array)>0)
		{
			$sql.=" and ( ";
			for($i=0;$i<count($subject_array);$i++)
			{
				$subject=$subject_array[$i];
				$sql.=" subject like '%$subject%' or message like '%$subject%' or";  	
			
			}
			$sql=substr($sql,0,-2);
			$sql.=" ) ";	
		}
		//echo "sql=$sql";
		return $sql;
	}	

//------------------------------------------------------------------------------------------------------------------

	function date_diff($date1,$date2)
	{
		
		$sql=" datediff(day,$date2,'$date1') ";
		return $sql;
		
	}	
//------------------------------------------------------------------------------------------------------------------------------	

	
}

function init_connect($dbhost,$dbuser,$dbpass)
{
	$dbh=@mssql_connect($dbhost,$dbuser,$dbpass);
	return $dbh;
}	

function close_connect($dbh)
{
	mssql_close($dbh);
}	


function create_database($dbname,$db_handle)
	{
		$sql="CREATE DATABASE $dbname ";
		if(!@mssql_query($sql,$db_handle))
		{
			$error=mssql_get_last_message();
			$status_array['flag']=false;
			$status_array['message']=$error;
			return $status_array;
		}
		else
		{
			$status_array['flag']=true;	
			return $status_array;
		}	
		
	}

//---------------------------------------------------------------------	
	function select_db($dbname,$db_handle)
	{
		if(!@mssql_select_db($dbname,$db_handle))
		{
			$error=mssql_get_last_message();
			$status_array['flag']=false;
			$status_array['message']=$error;
			return $status_array;
		}
		else
		{
			$status_array['flag']=true;	
			return $status_array;
		}	
	}
//------------------------------------------------------------------------------------------

	function return_error($dbh)
	{
		$error=mssql_get_last_message();
		return $error;
	}

	function create_tables($tbl_prefix,$dbh)
	{

		$table=$tbl_prefix."_clients";
$createcode=<<<EOD
	CREATE TABLE $table (
  client_id int  NOT NULL identity(1,1),
  client_name varchar(255)  NULL,
  email varchar(255)  NULL,
  phone varchar(255)  NULL,
  registered_on datetime  NULL,
  default_lang varchar(255)  NULL ,
  preferred_zone int NULL ,
  pass_word varchar(255)  null,
  client_status varchar(255) null, 	
  PRIMARY KEY  (client_id)
  
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	
	// Create the activity log table
	$table=$tbl_prefix."_activity_log";
$createcode=<<<EOD
	create table $table ( 
	activity_id int not null identity(1,1) primary key,
	action_on datetime,
	action_by int , 
	action_who varchar(20) null ,
	ticket_id varchar(10) ,
	action_name varchar(10) , 
	action_detail varchar(255),
	adept_id int ,
	areply_id int,
	astatus varchar(5)	

 );
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


		// Create the activity log table
	$table=$tbl_prefix."_cannedreplies";
$createcode=<<<EOD
	create table $table ( 
	canned_id int not null identity(1,1) primary key,
	canned_subject varchar(255),
	canned_message text,
	canned_type varchar(50),
	staff_id int,
	canned_date datetime,
	depttype varchar(25)
	 );
EOD;


	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}



	// Create the activity log table
	$table=$tbl_prefix."_canneddept";
$createcode=<<<EOD
	create table $table ( 
cd_id int not null identity(1,1) primary key,
dept_id int,
canned_id int	
);
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	
	

	// Create the configuration table		
	$table=$tbl_prefix."_configuration";
$createcode=<<<EOD
	CREATE TABLE $table (
  config_id int NOT NULL identity(1,1) primary key,
  logo varchar(255)  NULL,
  admin_email varchar(255)  NULL,
  ticket_subject varchar(255)  NULL,
  ticket_message text,
  attachment int  NULL ,
  attachment_size int  NULL,
  delete_mail int  NULL,
  reply_subject varchar(255)  NULL,
  ticket_pattern varchar(255)  NULL,
  records_per_page int NOT NULL default '0',
  send_reply int NOT NULL default '0',
  reply_message text  NULL,
  send_mail int NOT NULL default '0',
  send_tktconfirmation int NOT NULL default '0',
  send_tktreply int NOT NULL default '0',
  http_url varchar(255)  NULL,
  tktnotify_subject varchar(255) NOT NULL default '',
  tktnotify_message text,
  tktnotify_action int NOT NULL default '0',
  forgotpass_subject varchar(255) NOT NULL default '',
  forgotpass_message text NOT NULL,
   forgottkt_subject varchar(255) NOT NULL default '',
  forgottkt_message text NOT NULL,
  newstaff_subject varchar(255) NOT NULL default '',
  newstaff_message text NOT NULL,
  newstaff_action int NOT NULL default '1',
  cron_option int not null default '0',
  cron_time int not null default '0',
  last_checked int not null default '0',
  approvestaff_subject varchar(255) NOT NULL default '',
  approvestaff_message text NOT NULL,
  approvestaff_action int NOT NULL default '1',
 auto_close int not null default '7',
 escalate int not null default '2',
  version_no varchar(20) NOT NULL ,
   version_info varchar(20) NOT NULL ,
assignstaff_subject varchar(255) not null,
assignstaff_message text not null,
assignstaff_action int not null default '1',		
print_activitylog int not null default '1',
 admlogo varchar(255)  null,
staff_replies int not null default '1',
closeticket_subject varchar(255),
closeticket_message text,
closeticket_action int not null default '1',
time_zone int not null default '0',
 newclient_subject varchar(255) NOT NULL default '',
  newclient_message text NOT NULL,
  newclient_action int NOT NULL default '1',
default_lang varchar(255),
hide_closed int NULL,
  attachment_subject varchar(255),
attachment_message text,
attachment_action int not null default '1',
ticket_summary text,
ticket_replies text,
ticket_summary_flag int not null default '1',
ticket_replies_flag int not null default '1',
ticket_reply_subject varchar(255),
ticket_summary_subject varchar(255),
ticket_field varchar(255),
password_flag int,
smtp_mail int,
	smtp_host varchar(255),
	smtp_port varchar(255),
	smtp_username varchar(255),
	smtp_password varchar(255) ,
allow_routing varchar(255) NULL,
allow_staff_stats varchar(255) NULL,
privatealert_action int NULL,
privatealert_subject varchar(255) NULL,
privatealert_message text NULL,
registered_only varchar(255),
signuprequired_subject varchar(255),
signuprequired_message text,
signuprequired_action varchar(255),
newuser_subject varchar(255),
newuser_message text,
newuser_action varchar(255) ,
approveduser_subject varchar(255),
approveduser_message text,
approveduser_action varchar(255),
cron_running varchar(1),
last_cron_time datetime 
) 
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the departments table
	$table=$tbl_prefix."_departments";
$createcode=<<<EOD
	CREATE TABLE $table (
  dept_id int NOT NULL identity primary key,
  dept_name varchar(255)  NULL,
  ticket_prefix char(2)  NULL,
  dept_description text,
show_time_spent int,
skip_checking varchar(255) NULL ,
group_number int NULL ,
private_dept int NULL  
) 
EOD;
		
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the department servers table
	$table=$tbl_prefix."_dept_servers";
$createcode=<<<EOD
	CREATE TABLE $table (
  dept_serv_id int NOT NULL identity(1,1) primary key,
  server_id int  NULL,
  dept_id int  NULL,
  default_server int  NULL default '1'
  ) 
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	// Create the emails table
	$table=$tbl_prefix."_emails";
$createcode=<<<EOD
	CREATE TABLE $table (
  email_id int NOT NULL identity(1,1) primary key,
email varchar(255),
ticket_id varchar(255),
staff_id int NULL,
email_as varchar(3),
reply_id int NULL 	  
    ) 
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the ignored words table
	$table=$tbl_prefix."_ignored_words";
$createcode=<<<EOD
CREATE TABLE $table (
 word varchar(20)  NULL
)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the language table				
	$table=$tbl_prefix."_language";
$createcode=<<<EOD
	CREATE TABLE $table (
  lang_id int NOT NULL identity(1,1) primary key,
  langname_en varchar(255)  NULL,
  lang_folder varchar(255)  NULL,
  langname_de varchar(255)  NULL,
langname_fr varchar(255) NULL,
 langname_nl varchar(255) NULL,
langname_ru varchar(255) NULL,
langname_es varchar(255) NULL
	
) 
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	

// Create the language table				
	$table=$tbl_prefix."_fields";
$createcode=<<<EOD
	CREATE TABLE $table (
  field_id int NOT NULL identity(1,1)  primary key,
	field_name varchar(255),
field_level int,
parent_id int, 
display_order int NULL,
table_field varchar(255),
orient_id int,
fill_close int
  )  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	// Create the language table				
	$table=$tbl_prefix."_field_option";
$createcode=<<<EOD
	CREATE TABLE $table (
  field_option_id int NOT NULL identity(1,1) primary key,
	field_option_name varchar(255)  )  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	// create field_answers table
	$table = $tbl_prefix . "_field_answers";
	$createcode  = "create table $table (id int  not null identity(1,1), answer_id int not null, " ;
	$createcode .= "field_id int not null, field_answer varchar(100), ";
	$createcode .= "depends_on_answer_id int  not null, field_type_id int not null, ";
	$createcode .= "field_display_id int  not null, compulsory int not null, submitform int not null, ";
	$createcode .= " primary key(id))";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}
	// create client custom values table
	$table = $tbl_prefix . "_client_custom_values";
	$createcode = "create table $table (client_id int) ";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}


	// create client custom ids table
	$table = $tbl_prefix . "_client_custom_ids";
	$createcode = "create table $table (client_id int) ";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}
	// create ticket custom values table
	$table = $tbl_prefix . "_ticket_custom_values";
	$createcode = "create table $table (ticket_id varchar (10))";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}
	// create ticket custom ids table
	$table = $tbl_prefix . "_ticket_custom_ids";
	$createcode = "create table $table (ticket_id varchar (10))";
	$return_message = execute_sql ($createcode, $dbh);

	if(!$return_message['flag'])
	{
		return $return_message;
	}
		$table=$tbl_prefix."_field_type";
$createcode=<<<EOD
	CREATE TABLE $table (
  fieldtype_id int NOT NULL identity(0,1) primary key,
	field_type_name varchar(255)  )  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


$table=$tbl_prefix."_field_orientation";
$createcode=<<<EOD
	CREATE TABLE $table (
  orient_id int NOT NULL identity(1,1) primary key,
   orient_name varchar(255)  )  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


$table=$tbl_prefix."_field_dept";
$createcode=<<<EOD
	CREATE TABLE $table (
    fd_id int NOT NULL identity(1,1) primary key,
	field_id int,
	dept_id int   
  )  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	




	$table=$tbl_prefix."_plugins";
$createcode=<<<EOD
	CREATE TABLE $table (
  plugin_id int NOT NULL identity(1,1) primary key,
	plugin_name varchar(255),
	plugin_status int,
	plugin_version varchar(255) 

  )  ;
EOD;
	
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	



	

	// Create the mail servers table	
	$table=$tbl_prefix."_mail_servers";
$createcode=<<<EOD
	CREATE TABLE $table (
  server_id int NOT NULL identity(1,1) primary key,
  pop3_host varchar(255)  NULL,
  pop3_username varchar(255)  NULL,
  pop3_password varchar(255)  NULL,
  pop3_email varchar(255)  NULL,
  signature text,
  last_checked datetime  null
) 
EOD;
		
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
	

	// Create the news table	
	$table=$tbl_prefix."_news";
$createcode=<<<EOD
	CREATE TABLE $table (
	  news_id int NOT NULL identity(1,1) primary key,
  news_hdline varchar(255)  NULL,
  news_body text,
  announcement int NULL ,
  ndept_id int  NULL,
  nstaff_id int  NULL ,
  last_activity datetime NOT NULL default '0000-00-00 00:00:00'
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
		
	// Create the spam message table
	$table=$tbl_prefix."_spam_message";
$createcode=<<<EOD
	CREATE TABLE $table (
  spm_id int NOT NULL identity(1,1) primary key,
  sp_word text,
  sp_addresses text,
  spamaction varchar(255)  NULL
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the staff table
	$table=$tbl_prefix."_staff";
$createcode=<<<EOD
	CREATE TABLE $table (
  staff_id int  NOT NULL identity(1,1) primary key,
  staff_name varchar(255)  NULL,
  staff_password varchar(255)  NULL,
  staff_username varchar(255)  NULL,
  staff_email varchar(255)  NULL,
  staff_status char(1) default 'i',
  is_admin int default '0',
  default_lang varchar(255) NOT NULL default 'eng',
  preferred_zone int NOT NULL default '0',
  notify_ticket int NOT NULL default '0',
  notify_reply int NOT NULL default '0',
  all_dept int  null,
  hash varchar(255)  NULL,
 notify_assign int not null default '1' ,
 notify_closeticket int not null default '0',
staff_signature text,
ticket_access int,
allow_canned varchar(255) NULL,
allow_staff varchar(255) NULL   ,
act_on_closed varchar(255) NULL,
notify_spam int not null default '0'  
 
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the staff departments table	
	$table=$tbl_prefix."_staff_departments";
$createcode=<<<EOD
	CREATE TABLE $table (
  staff_dept_id int  NOT NULL identity(1,1) primary key,
  staff_id int NOT NULL default '0',
  dept_id int  NOT NULL default '0',
readonlyaccess int NOT NULL default '0' 	
  
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the ticket attachments table	
	$table=$tbl_prefix."_ticket_attachments";
$createcode=<<<EOD
	CREATE TABLE $table (
  att_id int NOT NULL identity(1,1) primary key,
  ticket_id varchar(10) NOT NULL default '',
  attachment_name varchar(255)  NULL,
  file_name varchar(255) NOT NULL default '',
  reply_id int NOT NULL default '0'
) 
EOD;
			
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the ticket priorities table
	$table=$tbl_prefix."_ticket_priorities";
$createcode=<<<EOD
  CREATE TABLE $table (
  priority_id int NOT NULL identity(1,1) primary key,
  priorityname varchar(255)  NULL
) 
EOD;
			
$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
	// Create the ticekt replies table		
	$table=$tbl_prefix."_ticket_replies";
$createcode=<<<EOD
	CREATE TABLE $table (
  reply_id int NOT NULL identity(1,1) primary key,
  reporter_id int  NOT NULL default '0',
  ticket_id varchar(10) NOT NULL default '',
  replied_on datetime  NULL,
  reminder_on datetime  NULL,
  reply text,
  reporter varchar(10) NOT NULL default 'STAFF',
  subject varchar(255)  NULL,
  last_update datetime  NULL,
  last_updatedby int  NULL,
  last_reporter varchar(255)  NULL,
  change_status varchar(255) NOT NULL default 'N',
   private int  NULL default '0' ,
readflag char(1) NOT NULL default 'U',
  draft text,
  internal_message text,
reply_minutes int,
  responded_from int not null default '0',
 resolution_item int not null default '0'
) 
EOD;
			
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

$createcode=<<<EOD
CREATE INDEX ind_ticket_replies
    ON $table (ticket_id)
EOD;

$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}
	


		
		// Create the ticket status table
	$table=$tbl_prefix."_ticket_status";	
$createcode=<<<EOD
	CREATE TABLE $table (
  status_id int NOT NULL identity(1,1) primary key,
  statusname varchar(255)  NULL,
  status_key char(1) NOT NULL default ''
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	
		
		// Create the tickets table
	$table=$tbl_prefix."_tickets";	
$createcode=<<<EOD
	CREATE TABLE $table (
  ticket_id varchar(10) NOT NULL primary key,
  staff_id int  NOT NULL default '0',
  priority_id int  NOT NULL default '0',
  status char(1) NOT NULL default '0',
  cat_id int  NOT NULL default '0',
  client_id int NOT NULL default '0',
  subject varchar(255)  NULL,
  message text,
  client_last_activity datetime  NULL,
  flag char(1)  NULL,
  dept_id int  NULL,
  server_id int  NULL,
  ticket_created datetime  NULL,
  sent_date datetime  NULL,
  timezone int  NULL,
  assign_reason text,
  updater_id int NOT NULL default '0',
  updater varchar(255) NOT NULL default '',
  staff_last_activity datetime  NULL,
  assigned_to int NOT NULL default '0'

  
) 
EOD;
	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	$table=$tbl_prefix."_staffsession";	
$createcode=<<<EOD
create table $table  (
session_id int not null identity(1,1) ,
staff_id int,
staff_hash varchar(255),
lastloggedin int,
primary key(session_id)

 )

EOD;
	

		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

	$table=$tbl_prefix."_groups";	
$createcode=<<<EOD
create table $table  (
group_id int not null identity(1,1) ,
group_name varchar(255),
primary key(group_id)

 )

EOD;
	

		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


//-----------------------------------------------------------

	$table=$tbl_prefix."_deptgroups";	
$createcode=<<<EOD
create table $table  (
dg_id int not null identity(1,1) ,
gdept_id int,
ggroup_id int,  
primary key(dg_id)

 )

EOD;
	

		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}


$table=$tbl_prefix."_statssettings";	

$createcode=<<<EOD
create table  $table  (
stats_id int primary key ,
exclude_weekends int,
 time_zone int  
 )

EOD;
	
		$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}

$table=$tbl_prefix."_tickets";

	$createcode=<<<EOD
	create index ind_dept_id on $table(dept_id)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	$createcode=<<<EOD
	create index ind_status on $table(status)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	$createcode=<<<EOD
	create index ind_assigned_to on $table(assigned_to)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	$createcode=<<<EOD
	create index ind_ticket_created on $table(ticket_created)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	create index ind_staff_last_activity on $table(staff_last_activity)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	create index ind_client_last_activity on $table(client_last_activity)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

$table=$tbl_prefix."_activity_log";

	$createcode=<<<EOD
	create index ind_action_on on $table(action_on)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	create index ind_action_detail on $table(action_detail)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	


	$createcode=<<<EOD
	create index ind_action_ticket_id on $table(ticket_id)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	create index ind_adept_id on $table(adept_id)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	$createcode=<<<EOD
	create index ind_action_by on $table(action_by)
EOD;

	$return_message=execute_sql($createcode,$dbh);
	if(!$return_message['flag'])
	{
		return $return_message;
	}	

	

	$return_message['flag']=true;
	return $return_message;	
		
	}	

function execute_sql($query,$dbh)
{
	if(!@mssql_query($query,$dbh))
	{
		$error=mssql_get_last_message();
		$status_array['flag']=false;
		$status_array['message']=$error;
			if( preg_match('#^INSERT #i', $query) )
			{
				$result_id=@mssql_query('select @@identity as id',$dbh);
				if($result_id)
				{
					if($row=mssql_fetch_array($result_id))
					{
						$status_array['identity']=$row['id'];
					}
				}
			}
		
		return $status_array;
	}
	else
	{
		$status_array['flag']=true;
					if( preg_match('#^INSERT #i', $query) )
			{
				$result_id=@mssql_query('select @@identity as id',$dbh);
				if($result_id)
				{
					if($row=mssql_fetch_array($result_id))
					{
						$status_array['identity']=$row['id'];
					}
				}
			}

		return $status_array;
	}	
}	
	

?>
