<?php
include_once("../includes/configure.php");
// Check whether Imap functions are enabled on the server


	
if (!function_exists('imap_open'))  {
	// This should actually redirect to some other page
	die("Imap functions are not enabled on this server");
}

if ($db_server == "mysqli")
	$date_func = "now";
else if ($db_server == "mssql")
	$date_func = "getdate";
	
$tbl_config = $supp_obj -> prefix_table ("configuration"); 
$sql = "select cron_running, $date_func() - last_cron_time as diff from $tbl_config";
$res = $supp_obj -> get_rsltset ($sql);

$is_cron_running = $res [0]['cron_running'];
$diff = $res [0]['diff'];

$allow_upto = 1800;

if ($is_cron_running == "y" && $diff < $allow_upto) {
	echo "Cron Job is running";exit;
}


if ($is_cron_running == "y" && $diff > $allow_upto) {
	$sql = "update $tbl_config set cron_running='y', last_cron_time=$date_func()";
	$supp_obj -> execute_query ($sql);
	echo "Cron Job is running";
}


error_reporting(E_ALL ^ E_NOTICE);
class Download
{
	var $ml_handle;
	var $host;
	var $user;
	var $pass;
	var $server_id;
	var $ademail;
	var $signature;
	var $dept_name;
	var $convertible;
	var $ticket_prefix;
	var $dept_id;
	
//---------------------------------------------------------------------------------
/* Download class constructor that connects to the pop3 mail server */	
	function __construct($pop3host,$pop3user,$pop3pass,$server_id,$pop3_email,$sig,$name,$ticket_prefix,$dept_id)
	{
		$this->host=$pop3host;
		$this->user=$pop3user;
		$this->pass=$pop3pass;
		$this->server_id=$server_id;
		$this->ademail=$pop3_email;
		$this->signature=$sig;
		$this->dept_name=$name;
		$this->ticket_prefix=$ticket_prefix;
		$this->dept_id=$dept_id;

		$mail_box1="{".$pop3host.":110/pop3/notls}INBOX";
		$mail_box1="{".$pop3host.":995/pop3/ssl/novalidate-cert}INBOX";//it08exch.it-tc.com:995/pop3/ssl/novalidate-cert
		$mail_box2="{".$pop3host."/pop3/notls}INBOX";


		if(preg_match("/pop.gmail/",$pop3host)) {
			$mail_box1="{pop.gmail.com:995/pop3/ssl/novalidate-cert}";
		}	
		
		// Connect to the mail server .
		$ml_handle = imap_open($mail_box1, $pop3user, $pop3pass);
		if (!$ml_handle) {
			$ml_handle = imap_open($mail_box2, $pop3user, $pop3pass);
    	}
		
		$this->ml_handle=$ml_handle;
	
	}
//--------------------------------------------------------------------------------------
/* This functions opens the mail box , checks for a new mail and populates the sp database */
	function get_mails($supp_obj)
	{
		//Check whether the connection was successful
		if(!$this->ml_handle)	// if the mail box handle is not valid . Then probably .. the account is invalid
		{
			$pop3host=$this->host;
			$pop3user=$this->user;
			$pop3pass=$this->pass;
			$server_id=$this->server_id;
			echo 'probably .. the account is invalid<br>';
			// Alert Administrator
			alert_admin($supp_obj,$pop3host,$pop3user,$pop3pass,$server_id);
			//skip reading the inbox and move on to other pop3 accounts
			return;
		}
		// Prefix and prepare tables
		$tickets=$supp_obj->prefix_table("tickets");
		$clients=$supp_obj->prefix_table("clients");
		$dept_servers=$supp_obj->prefix_table("dept_servers");
		$spam_message=$supp_obj->prefix_table("spam_message");
		$ticket_replies=$supp_obj->prefix_table("ticket_replies");
		$staff=$supp_obj->prefix_table("staff");
		$staff_departments=$supp_obj->prefix_table("staff_departments");
		// Get the banned words from the database
		$sql="select sp_word,spamaction from $spam_message ";
		$a_sql=$supp_obj->get_a_line($sql);
		$sp_word=$a_sql['sp_word'];
		$spamaction=$a_sql['spamaction'];
		$subject_filter=preg_split("/[\r\n]+/is",$sp_word,-1,PREG_SPLIT_NO_EMPTY);
		// find out which department this mail should go out to
		$server_id=$this->server_id;
		$dept_id=$this->dept_id;
		//Find out the ticket prefix
		$departments=$supp_obj->prefix_table("departments");
		$ticket_prefix=$this->ticket_prefix;
		$dept_name=$this->dept_name;
		// These two arrays play a role in determining the type and the encoding used in every mail			
		$type = array("text", "multipart", "message", "application","audio", "image", "video", "other");
		$encoding = array("7bit", "8bit", "binary","base64", "quoted-printable", "other"); 
		// Find out the total number of messages in the mailbox
		$total_msgs=imap_num_msg($this->ml_handle);
		//find out configuration information
		$config=$supp_obj->prefix_table("configuration");
		$sql="select * from $config ";
		$a_config=$supp_obj->get_a_line($sql);
		$max_attach_size=$a_config['attachment_size'];
		$default_lang=$a_config['default_lang'];
		$this->convertible="UTF-8";
		$priority="Medium";
		
		@include("../lang/$default_lang/admin_generic.php");		

		//Loop over for all messages		
		for($message_id=1;$message_id<=$total_msgs;$message_id++)	// scroll for all mails
		{
			$delete_mail=$a_config['delete_mail'];	
			$send_mail=$a_config['send_mail'];
			$send_tktconfirmation=$a_config['send_tktconfirmation'];
			$ticket_subject=$a_config['ticket_subject'];
			$ticket_message=$a_config['ticket_message'];
			$http_url=$a_config['http_url'];
			// get details to send mail to staff
			$tktnotify_subject=$a_config['tktnotify_subject'];
			$tktnotify_message=$a_config['tktnotify_message'];
			$tktnotify_action=$a_config['tktnotify_action'];
			$admin_email=$a_config['admin_email'];
			$newclient_subject=$a_config['newclient_subject'];
			$newclient_message=$a_config['newclient_message'];
			$newclient_action=$a_config['newclient_action'];
			$attachment_subject=$a_config['attachment_subject'];
			$attachment_message=$a_config['attachment_message'];
			$attachment_action=$a_config['attachment_action'];
			$struct=imap_fetchstructure($this->ml_handle,$message_id);					
				if(!$struct)	
				{
					continue;
				}
				//Get Header information for the message				
				$header_info = imap_header($this->ml_handle, $message_id, 800, 800);
		
				$other_recipients=$supp_obj->get_other_recipients($this->ml_handle,$message_id,$header_info,$this->ademail);

				$subject = $header_info->Subject;
				
				if(!($header_info->Unseen=='U' || $header_info->Recent=='N'))// check for newness of message	
				{
					//continue;
				}
				//echo "<br>SUbject=$subject message_flag=".$header_info->Recent."Unseen=".$header_info->Unseen;
				if($subject=="") 	// If No subject , set it to None
				{
					$subject="None";
				}
				// Get the from name and email address of the sender
				// Note this detail would be having data like name<email@domain.com>
				//So you would need to extract the data properly		
				$from = $header_info->reply_toaddress;
				$data = $this->get_mail_content($message_id, "text/html");
			
				$html_charset=$data[1];
				$mail_format="text/html";
				$character_encoding=$html_charset;		
				
				if($data[0] == "") {
					$data = $this->get_mail_content($message_id, "text/plain");
					$plain_charset = $data[1];
					$mail_format = "text/plain";
					$character_encoding = $plain_charset;
				}

				if($data[1] != 'X-UNKNOWN') {
					$content = $this->convert_lang($data[0], $data[1]);
				} else {
					$content = $data[0];
				}
				
				if(function_exists('iconv_mime_decode')) {	
					$subject = iconv_mime_decode($subject, 0, $this->convertible);
				}
				
				$hdr = imap_fetchheader($this->ml_handle, $message_id, FT_INTERNAL);
				//echo "hdr=".$hdr;
				$headers = imap_rfc822_parse_headers($hdr);
				//	$from=$headers->fromaddress;
				
				if (preg_match('/charset=[\"\']?([-a-z0-9\._]+)?/', $hdr, $regs)) {
						$charset = trim($regs[1]);
				} else {	
					$charset = false;
				}
				
				if (!$charset) $charset = ($plain_charset)? $plain_charset :  $html_charset;
				
				$from = $supp_obj->decode_text($from,$charset);
				preg_match("/\<(.*?)\>/is",$from,$out);
				$email = $out[1];
				$client_name = trim(str_replace($out[0],"",$from));
				// There is a chance of the "name" not being there in the replybox .. IN that case , what to do ? 
				$email = $email == ""? $client_name:$email;

				$email = addslashes($email);
				
				if($email=="") {
					continue;
				}
				
				$client_name=str_replace('"',"",$client_name);	
				$client_name=addslashes($client_name);
				if(preg_match("/@/",$client_name)) {
					$client_name = substr($client_name,0,strpos($client_name,'@'));
				}
				//echo "client_name=$client_name";
				$date = $header_info->Date;
				// find out mail sent date and the timezone 
				//echo "date=$date <br/>";
				$timezone = substr(strrchr($date, " "), 1);
				//$timezone=str_replace("-","",$timezone);
				// Convert the mail header date to proper date format
				if(preg_match("/,/",$date))
				{
					list($wkday,$date_string)=explode(",",$date);
				}
				else
				{
					$date_string=$date;
				}
				$date_string=trim($date_string);
			//	echo "date_string=$date_string";
				list($sday,$smon,$syear,$stime)=preg_split("/[ ]+/is",$date_string,-1,PREG_SPLIT_NO_EMPTY);
				list($shr,$smi,$ss)=explode(":",$stime);
				$mon_array=array("01"=>"Jan","02"=>"Feb","03"=>"Mar","04"=>"Apr","05"=>"May","06"=>"Jun","07"=>"Jul","08"=>"Aug","09"=>"Sep","10"=>"Oct","11"=>"Nov","12"=>"Dec");
				$smon=array_search($smon,$mon_array);	
			//	echo " sentdate=$syear $smon $sday $shr $smi $ss timezone=$timezone ";
				$sendtime=gmmktime($shr,$smi,$ss,$smon,$sday,$syear);
				//$sendtime=$header_info->udate;
				//echo "timezone=$timezone";	
				if(strlen($timezone)==4)	// client's timezone not in GMT
				{
					$timezone="+".$timezone;
				}	
				if(strlen($timezone)==5)	// client's timezone not in GMT
				{
					$timezone_array=preg_split("//is",$timezone,-1,PREG_SPLIT_NO_EMPTY);
					$hh=$timezone_array[1].$timezone_array[2];
					$mm=$timezone_array[3].$timezone_array[4];
					$secs=(($hh*60)+$mm)*60;
					//echo "secs=$secs  hour=$hh min=$mm";
					if($timezone_array[0]=="+")		// Clients timezone is ahead .. so you would need to subtract
						{
							$sent_date=gmdate('Y-m-d H:i:s',$sendtime-$secs);								
						}
					else
						{
							$sent_date=gmdate('Y-m-d H:i:s',$sendtime+$secs);	
						}
						$tz = $timezone_array[0].$secs;
				}
				else
				{	
					$sent_date=gmdate('Y-m-d H:i:s');
					$tz = 0;			
				}
				if(!is_numeric($timezone))
				{
					$timezone=0;
				}
				//echo "timezone=$timezone";
				//echo "<br/>sent_date=$sent_date <br/>";	
				$new_ticket=0;				
				//Check whether the mail is a reply or a new ticket
				preg_match("/[A-Z]{2}[0-9]{8}/is",$subject,$out);
				$tkt_id=$out[0];		// Some string that has first two letters as characters and next eight as integers
				if(strlen($tkt_id)==10) // The string happens to be of 10 digit also ... 					
				{
					$sql="select ticket_id from $tickets where ticket_id='$tkt_id' ";
					$a_tk=$supp_obj->get_a_line($sql);
					if($a_tk['ticket_id']!="")	// This ticket id is in the database but am still not sure whether the same client is replying .. So let me check the email address also
					{
						//$sql="select $clients.client_id from $clients,$tickets where $clients.client_id=$tickets.client_id and  $clients.email='$email' and $tickets.ticket_id='$tkt_id' ";
						 $sql="select $clients.client_id from $clients,$tickets
						 where $clients.client_id=$tickets.client_id
						 and $tickets.ticket_id='$tkt_id' ";
						$a_sql=$supp_obj->get_a_line($sql);
						if($a_sql[0]!="") // Perfect .. The client is replying to the ticket now .. 						 	
						{
							$new_ticket=1;
						}
					}
				}
				if($new_ticket!=1)				
					{
					$ticket_id=$supp_obj->generate_unique_no($ticket_prefix);				
					}
				else
					{
					$ticket_id=$tkt_id;
					$sql="select max(reply_id) from $ticket_replies ";
					$a_sql=$supp_obj->get_a_line($sql);
					$next_id=$a_sql[0]+1;
					}
					$return_text="";
				//	echo "max_attach_size = $max_attach_size ";
			$return_text=$this->retrieve_attachments($supp_obj,$message_id,$ticket_id,$next_id,$max_attach_size,0); 
			$content=html_entity_decode($content);		
			$content=addslashes($content);	
			$subject=addslashes($subject);	
			$message=$content;		
			$dept_mail=$this->dept_name." <".$this->ademail.">";
			if($return_text==false)
			{
			$content.="\n ".$generic_msg['cAttachment_truncated'];
			$mail_array=array("client_name"=>$client_name,"pop3_email"=>$this->ademail,
			"attachment_size"=>$max_attach_size,"dept_signature"=>$this->signature,"http_url"=>$http_url,"dept_name"=>$this->dept_name,
			"ticket_id"=>$ticket_id, "subject"=>$subject, "message"=>$content, "priority"=>$priority,"phone"=>"");
			$attachment_message=$supp_obj->direct_replace($attachment_message,$mail_array);
				if($send_mail==1 and $attachment_action==1 )	// send mail only if overall mail is enabled and attachment mail is enabled
				{		
					$supp_obj->send_mail($email,$attachment_subject,$attachment_message,$dept_mail);
				}
			}
			//check for spam
			$ticket_status="N";
			if($supp_obj->mail_spam($subject_filter,$subject,$content) or $supp_obj->is_address_spammed($email))
			{
				if($spamaction=="move")
				{
					// have to mark the message as spam and move it to the spam folder
					if($new_ticket!=1)	// new ticket .. job madde easy .. mark the ticket as SPAM 
					{
						$ticket_status="S";	
					}
				}
				else
				{
					if($new_ticket!=1)		// do this for new tickets alone
					{
						//delete the mail from the server
						
						//i did that comment below
						imap_delete($this->ml_handle,$message_id);
						
						
						
						// now delete the attachments also
						$pattern='/'.$ticket_id."_/";
						if ($handle = @opendir('../attachments')) 	// if an attachments directory exists and can be opened for reading
							{
							    while (false !== ($file = @readdir($handle))) 		// loop thro the attachments directory
								{ 
						        	if ($file != "." && $file != "..") 				// skip . and .. files
									{ 
									         if(preg_match($pattern,$file))				// if the filename matches with the ticket name
										 {
											$f_path="../attachments/".$file;
											@unlink($f_path);					// delete the file
										 }
						  			} 
							    }
						    closedir($handle); 
							}
						continue;
					}
				}
				
			}
			// spam check ended 
			//start populating database with this mail content
			$sql="select client_id,client_name, phone  from $clients where email='$email' and client_status='a'  ";
				$a_client=$supp_obj->get_a_line($sql);
				if(empty($a_client['client_id']))	//new client
				{
					// Check if only registered customers can submit ticket.
					if($a_config['registered_only']=="y")
					{
						$mail_details=array("client_name"=>$client_name,"email"=>$email,"dept_signature"=>$this->signature,
						"http_url"=> $http_url, "dept_name"=> $dept_name, "subject" => $subject, "message" => $content );
						// Send registration required email
						$this->send_registration_required_email($supp_obj,$mail_details,$dept_mail,$a_config);
						// mark this mail for deletion
						
						//i did that comment below
						imap_delete($this->ml_handle,$message_id);
						
						
						// continue with the next mail
						continue;
					}
					$registered_on=$supp_obj->get_current_date();	
					$insert_array=array("client_name"=>$client_name,"email"=>$email,"registered_on"=>$registered_on);
					if ($tz==0)
					{
						$insert_array['preferred_zone']=$a_config['time_zone'];
					}
					else
					{
						$insert_array['preferred_zone'] = $tz;
					}
				
					$pass_word=$supp_obj->generate_password();	
		
					$insert_array['pass_word']=md5($pass_word);
					$insert_array['client_status']='a';	
					$avoid_array=array("client_id");	
					$sql=$supp_obj->construct_query($clients,"INSERT",$insert_array,$avoid_array);
					$client_id=$supp_obj->execute_query($sql);
					//echo "client_id=$client_id ";

				$replace_array=array("http_url"=>$http_url,"dept_name"=>$dept_name,
				"ticket_id"=>$ticket_id,"client_name"=>$client_name,"dept_signature"=>$this->signature,
				"email"=>$email,"pass_word"=>$pass_word,"subject"=>$subject,"message"=>$content,"priority"=>$priority,"phone"=>"");
				$newclient_message=$supp_obj->direct_replace($newclient_message,$replace_array);
				$newclient_subject=$supp_obj->direct_replace($newclient_subject,$replace_array);
				if($send_mail==1 and $newclient_action==1 )	// send mail only if overall mail is enabled and creation mail is enabled
				{		
					$supp_obj->send_mail($email,$newclient_subject,$newclient_message,$dept_mail);
				}
		
				}
				else
				{
					$phone="";
					$client_id=$a_client['client_id'];
					$phone=$a_client['phone'];
				}
			$activity_array['ticket_id']=$ticket_id;				
			if($new_ticket!=1)	// Seems to be a new ticket
			{
			$ticket_created=$supp_obj->get_current_date();
			$last_activity=$ticket_created;	
			$insert_array=array("ticket_id"=>$ticket_id,"status"=>"$ticket_status",
			"client_id"=>$client_id,"subject"=>$subject,
			"message"=>$content,"dept_id"=>$dept_id,"server_id"=>$server_id,
			"timezone"=>$timezone,"sent_date"=>$sent_date,
			"priority_id"=>"2","client_last_activity"=>$sent_date,
			"ticket_created"=>$ticket_created,"updater_id"=>$client_id,
			"updater"=>"CLIENT","staff_last_activity"=>$sent_date,"staff_id"=>0,"cat_id"=>0,"assigned_to"=>0,
	"mail_format"=>$mail_format,"character_encoding"=>$character_encoding,'other_recipients'=>$other_recipients);
			
			$sql=$supp_obj->construct_query($tickets,"INSERT",$insert_array);
			//echo "sql=$sql<br>";
			$supp_obj->execute_query($sql);
			
			$supp_obj->log_activity($activity_array,$client_id,'CLIENT','Y');
			}
			else	// Reply .. so cool down
			{
				$ticket_replies=$supp_obj->prefix_table("ticket_replies");
				$insert_array=array("reporter_id"=>$client_id,
				"reporter"=>"CLIENT","ticket_id"=>$ticket_id,
				"replied_on"=>$sent_date,"reply"=>$content,
				"subject"=>$subject,"change_status"=>$ticket_status,"mail_format"=>$mail_format,
				"character_encoding"=>$character_encoding,'reply_recipients'=>$other_recipients);
				$avoid_array=array("reply_id","reminder_on","last_update","last_updatedby","last_reporter","private");	
				$sql=$supp_obj->construct_query($ticket_replies,"INSERT",$insert_array,$avoid_array);
				//echo $sql;
				$reply_id=$supp_obj->execute_query($sql);
				$activity_array['reply_id']=$reply_id;
				$supp_obj->log_activity($activity_array,$client_id,'CLIENT','Y');
				$sql="select status from $tickets where ticket_id='$ticket_id'";
				$a_sql=$supp_obj->get_a_line($sql);
				if($a_sql['status']=="C")	// this ticket is closed and now the client is again replying for this ticket
				{
					$sql=" update $tickets set status='O' , updater_id='$client_id' , updater='CLIENT'
					where ticket_id='$ticket_id' ";
					$supp_obj->execute_query($sql);		
				}
				$last_activity=$supp_obj->get_current_date();
				$sql="update $tickets set updater_id='$client_id' , updater='CLIENT', 
				client_last_activity='$last_activity' where ticket_id='$ticket_id' ";
				$supp_obj->execute_query($sql);		
			}
							
			$replace_array=array("http_url"=>$http_url,"dept_name"=>$dept_name,
			"ticket_id"=>$ticket_id,"client_name"=>$client_name,"reply"=>$reply,"message"=>$content,
			"dept_signature"=>$this->signature,"subject"=>$subject,"priority"=>"Medium","phone"=>$phone);
			$ticket_message=$supp_obj->direct_replace($ticket_message,$replace_array);
			$ticket_subject=$supp_obj->direct_replace($ticket_subject,$replace_array);
			
			// send mail only if overall mail is enabled and confirmation mail is enabled
			if($send_mail==1 and $send_tktconfirmation==1 and $new_ticket!=1 and $ticket_status != "S")	
			{		
				$supp_obj->send_mail($email,$ticket_subject,$ticket_message,$dept_mail);
			}
				
			//echo "comes here";	
			// should I send mail to staff ?
			$staffclause='';
			if($ticket_status=="S")
			{
				/**
					Should spam mail notification go to staff?
				*/
				$staffclause=" and $staff.notify_spam ='1' ";
			}

			if($send_mail==1 and $tktnotify_action=="1")
			{
					if($new_ticket!=1)	// this is a new ticket
					{
						// send mail to all staff in the department who have opted to receive email notifications
						$sql="select distinct(staff_email), staff_name from $staff,$staff_departments 
						where $staff.staff_id=$staff_departments.staff_id and 
						$staff_departments.dept_id='$dept_id' and $staff.notify_ticket='1' $staffclause   ";
						//echo "sql=$sql";
						$a_staff=$supp_obj->get_rsltset($sql);
												$message=$content;
						for($s=0;$s<count($a_staff);$s++) // send notification to all selected staffs 		
						{
							$tsub=$tktnotify_subject;
							$tmess=$tktnotify_message;

							$staff_name=$a_staff[$s]['staff_name'];
							$staff_email=$a_staff[$s]['staff_email'];
							//$tsub=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tsub);
							preg_match_all("/\{\{(.*?)\}\}/", $tsub, $matches);
							$tmp_array = array();
							foreach ($matches[0] as $index => $var_name) {
								$tmp_var_name = $matches[1][$index];
								if (isset($$tmp_var_name)) {
									$tmp_array[$tmp_var_name] = $$tmp_var_name;
								} else {
									$tmp_array[$tmp_var_name] = '';
								}
							}
							
							$tsub = preg_replace_callback("/\{\{(.*?)\}\}/",
												 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
												 $tsub);
												 
							//$tmess=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tmess);
							preg_match_all("/\{\{(.*?)\}\}/", $tmess, $matches);
							$tmp_array = array();
							foreach ($matches[0] as $index => $var_name) {
								$tmp_var_name = $matches[1][$index];
								if (isset($$tmp_var_name)) {
									$tmp_array[$tmp_var_name] = $$tmp_var_name;
								} else {
									$tmp_array[$tmp_var_name] = '';
								}
							}
							
							$tmess = preg_replace_callback("/\{\{(.*?)\}\}/",
												 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
												 $tmess);
							
							
							
							//echo "comes here , $staff_email <br/> $ticket_id ";
							$supp_obj->send_mail($staff_email,$tsub,$tmess,$admin_email);
						}
						//echo "comes here too";	
					}
					else
					{
						// seems to be a new reply from the client .. mail the staff who had posted in that thread
						$sql="select message from $tickets where ticket_id='$ticket_id' ";
						$a_mess=$supp_obj->get_a_line($sql);
						$message=$a_mess['message'];
						$reply=$content;
						$sql="select distinct(staff_email), staff_name from $staff , 
						$ticket_replies where $staff.staff_id=$ticket_replies.reporter_id
						and $ticket_replies.ticket_id='$ticket_id' and 
						$ticket_replies.reporter='STAFF' and $staff.notify_reply='1' $staffclause ";
						$a_staff=$supp_obj->get_rsltset($sql);
					
						for($s=0;$s<count($a_staff);$s++) // send notification to all selected staffs 		
						{
							$tsub=$tktnotify_subject;
						$tmess=$tktnotify_message;
							$staff_name=$a_staff[$s]['staff_name'];
							$staff_email=$a_staff[$s]['staff_email'];
							
							//$tsub=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tsub);
							preg_match_all("/\{\{(.*?)\}\}/", $tsub, $matches);
							$tmp_array = array();
							foreach ($matches[0] as $index => $var_name) {
								$tmp_var_name = $matches[1][$index];
								if (isset($$tmp_var_name)) {
									$tmp_array[$tmp_var_name] = $$tmp_var_name;
								} else {
									$tmp_array[$tmp_var_name] = '';
								}
							}
							
							$tsub = preg_replace_callback("/\{\{(.*?)\}\}/",
												 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
												 $tsub);
												 
							//$tmess=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tmess);
							preg_match_all("/\{\{(.*?)\}\}/", $tmess, $matches);
							$tmp_array = array();
							foreach ($matches[0] as $index => $var_name) {
								$tmp_var_name = $matches[1][$index];
								if (isset($$tmp_var_name)) {
									$tmp_array[$tmp_var_name] = $$tmp_var_name;
								} else {
									$tmp_array[$tmp_var_name] = '';
								}
							}
							
							$tmess = preg_replace_callback("/\{\{(.*?)\}\}/",
												 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
												 $tmess);	
							
							$supp_obj->send_mail($staff_email,$tsub,$tmess,$admin_email);
						}
					}
			}
			//if($delete_mail==1)		// mark message for deletion
			{
				//i did that comment below
				imap_delete($this->ml_handle,$message_id);
			}
			//echo "message_id=$message_id";
	//echo 	imap_setflag_full($this->ml_handle, imap_uid($this->ml_handle, $message_id), "\\Seen \\Flagged", ST_UID);	
	//		print_r( imap_headerinfo($this->ml_handle, $message_id) );
		}
	
	//if($delete_mail==1)	
		{
			imap_expunge($this->ml_handle);		
		}
		imap_close($this->ml_handle);
		//echo "fine";
	}	
	//----------------------------------------------------------------------------
	function getmimetype ($mime) 
	{
		$mimestring="";
    		switch ($mime) 
		{
   			 case "6":
		 		$mimestring="video";		 
				 break;
    			 case "5":
		 		$mimestring="image";		 
				 break;
    			 case "4":
		 		$mimestring="audio";		 
				 break;
    			 case "3":
			 	$mimestring="application";		 
				 break;
    			case "2":
				$mimestring="message";		 
				break;
    			case "0":
    			default:
				$mimestring="text";		 
				break;
    		}

		return $mimestring;
	}
	//----------------------------------------------------------------------------------------------------------
	
	function mime_type (&$structure, $delim)
	{
		$full_type = $this->getmimetype($structure->type);
    		if ($structure->ifsubtype)
		{
			$full_type .= $delim . strtolower($structure->subtype);
		}	
    		return $full_type;
	}

	//-------------------------------------------------------------------------------------------------
	function get_mail_content ($message_id, $mime_type, $structure = false, $part_number = false) {
			
		$encoding = array("7bit", "8bit", "binary","base64", "quoted-printable", "other"); 
	
		// Fetch the mail structure
		if (!$structure) $structure = imap_fetchstructure($this->ml_handle, $message_id); 
		
		// If structure exists
    		if ($structure) 
		{
			// Get the mime type
			$data_type = $this->mime_type($structure, "/");
			
			if ($mime_type==$data_type) 
			{
				
	    			if (!$part_number)
			       	{	
					// default part number
					$part_number = "1";
				}	
	    			if ($structure->ifdisposition && strtoupper ($structure->disposition) == "ATTACHMENT")
				{
					return false; // do not proceed if the mail part is of attachment type. Can check on that later.
				}

					$text = imap_fetchbody($this->ml_handle, $message_id, $part_number); 
	    				if ($structure->encoding == 3)		// Base 64 
						$text = imap_base64($text); 
	    				else if ($structure->encoding == 4)	// Quoted Printable
						$text = imap_qprint($text);
	    				if ($structure->parameters[0]->attribute == "CHARSET" && $structure->parameters[0]->value != "US-ASCII") 
					{
						$charset = $structure->parameters[0]->value;
	    				} 
					else $charset = false;
					$contentarray[0]=$text;
					$contentarray[1]=$charset;
					return $contentarray;
	    		} 
			if($structure->type == 1)	// MULTIPART 
			{ 
	    			while (list($index, $sub_structure) = each($structure->parts)) 
				{ 
					if ($part_number) $prefix = $part_number . '.';
					$data = $this->get_mail_content($message_id, $mime_type, $sub_structure, $prefix . ($index + 1));
					if ($data) return $data;
	    			}
			} 
    	} 
		return false; 
	}

	//---------------------------------------------------------------------------------------------------------------------------------
	function convert_lang($text, $charset) {
		if ($charset and function_exists("iconv"))  {
			$char = $this->convertible."//IGNORE";
			
			$text = iconv($charset, $char, $text);
			if ($text) return ($text);
    	}
		return ($text);
	}
//-------------------------------------------------------------------------------------------------------------------------------------
	function extract_header($value, $charset) 
	{
    		$text = "";
		if ($value) 
		{
			$rawvalue = imap_mime_header_decode($value);
			for ($i=0; $i<count($rawvalue); $i++) 
			{
	    			if ($rawvalue[$i]->charset != 'default')
				{
					$text .= $this->convert_lang($rawvalue[$i]->text, $rawvalue[$i]->charset);
				}	
	    			else
			       	{	
					$text .= $this->convert_lang($rawvalue[$i]->text, $charset);
				}	
			}
    		}
		return ($text);
	}
	//-----------------------------------------------------------------------------------------------------------------------------------
	function decodestring($rcode) 
	{
    		$base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    		if (preg_match ("/^begin ([0-7]{3}) ([^\n]+)\n(.*)end$/", trim($rcode), $out)) 
		{
			$rcode = preg_replace("/^./m","",$out[3]);
			$rcode = preg_replace("/[\n\r]{1,2}/m","",$rcode);
			for ($i = 0; $i < strlen($rcode); $i++)
			{
	   			 if ($rcode[$i] == '`') 
				 {
				 	$rcode[$i] = ' ';
				 }	
	    			$rcode[$i] = $base64chars[ord($rcode[$i])-32];
			}
			while (strlen($rcode) % 4) 
			{
				$rcode .= "=";
			}	
			return base64_decode($rcode);
    		}
    	return $rcode;
	}
	//---------------------------------------------------------------------------------------------------------------------------------
	
	function retrieve_attachments($supp_obj,$message_id,$ticket_id,$reply_id, $max_attach_size,$x, $structure = false, $part_number = false) 
	{
    		if (!$structure) $structure = imap_fetchstructure($this->ml_handle, $message_id);
		// If structure exists
		if ($structure) 
		{

			$mime_type = $this->mime_type($structure, "/");
		
			if ($structure->type != 1)		// MULTIPART 
			{
	
			
	    			if ($structure->ifdisposition && strtoupper ($structure->disposition) == "ATTACHMENT") 
				{
					if ($structure->ifdparameters) 
					{
		    				while (list ($AtName, $AtDisposition) = each ($structure->dparameters)) 
						{
							if (strtoupper ($AtDisposition->attribute) == "FILENAME") 
							{
								$name = $this->extract_header($AtDisposition->value, false);
			    					break;
							}
		    			}
					}
					
					if (empty($name) && $structure->ifparameters) 
					{
						while (list ($AtName, $AtDisposition) = each ($structure->parameters)) 
						{
							if (strtoupper ($AtDisposition->attribute) == "NAME") 
							{
								$name = $this->extract_header($AtDisposition->value, false);
			    					break;
							}
		    			}
					}
					if (!$part_number) $part_number = 1;
	    		}
	
			if ($structure->type != 0 or $name!="") 
			{

				if(empty($name) && $structure->disposition=="INLINE")
				{
					$nparam=$structure->dparameters;
					$nparam=$nparam[0];
					$name=$nparam->value;
				}
					if (empty($name) && $structure->ifparameters) 
					{
						while (list ($AtName, $AtDisposition) = each ($structure->parameters)) 
						{
							if (strtoupper ($AtDisposition->attribute) == "NAME") 
							{
								$name = $this->extract_header($AtDisposition->value, false);
			    					break;
							}
		    			}
					}
	
				if (empty($name) || ($name == "UNKNOWN_PARAMETER_VALUE")) 
				{
					$name = $this->mime_type($structure, "-")."($part_number)";
					if ($mime_type == "message/rfc822")
					{
				       		$name .= ".msg";
					}
					if ($mime_type == "message/delivery-status")
					{
				       		$mime_type = "text/plain";
					}	
		    			if ($mime_type == "text/plain")
					{
				       		$name .= ".txt";
					}
		    		
				}
	
					$bytes=$structure->bytes;
				$inKB=$bytes/1024;
			//echo " inKB = $inKB, max attach size =$max_attach_size ";
			
				if($max_attach_size < $inKB )
				{
					return false;
				}

							

				$attach = imap_fetchbody($this->ml_handle, $message_id, $part_number);
			//	print_r($structure);
				switch($structure->encoding)
				{
					case 3:		// BASE 64
						$file=imap_base64($attach);
						break;
					case 4:		// QUOTED PRINTABLE
						$file=imap_qprint($attach);
						break;
					case 5:		// OTHER
						$file=$this->decodestring($attach);	
					default:
						$file=$attach;		
				}	
				$att_path=$name;
			//	echo "name=$name ";

				$att_file_name=$name;
				$att_name_arr=explode("\.",$name);
				$ext=$att_name_arr[count($att_name_arr)-1];
				$ext=addslashes($ext);
				$att_file_name=addslashes($att_file_name);
				$att_path="../attachments/".$ticket_id."_$x".'.'.$ext;			
				$att_name=$ticket_id."_$x".".".$ext;

				//echo "att_name=$att_name";
			
				if($reply_id!="")
				{
					$att_name=$ticket_id."_$reply_id"."_$x".".".$ext;	
					$att_path="../attachments/".$ticket_id."_$reply_id"."_$x".'.'.$ext;			
				}
				
				//echo $att_path;
				//exit;
				
				$supp_obj->write_to_file($att_path,$file,"wb");

				$avoid_array=array("att_id");
				$insert_array=array("ticket_id"=>$ticket_id,"attachment_name"=>$att_name,"file_name"=>$att_file_name);
				if($reply_id!="")
				{
					$insert_array['reply_id']=$reply_id;
				}
				else
				{
					$insert_array['reply_id']=0;
				}
				$ticket_attachments=$supp_obj->prefix_table("ticket_attachments");
				$sql=$supp_obj->construct_query($ticket_attachments,"INSERT",$insert_array,$avoid_array);
				$supp_obj->execute_query($sql);
				
			
	    		}
	} 
	else 
	{
		
		
	    while (list ($index, $sub_structure) = each ($structure->parts)) 
	    {
		if ($part_number) $prefix = $part_number . '.';
			$x=$x+1;
			$string=$this->retrieve_attachments($supp_obj,$message_id,$ticket_id,$reply_id,$max_attach_size,$x, $sub_structure, $prefix . ($index + 1));
			if($string == false)
			{
				return $string;
			}
	    }
	}
    }

    return true;
}
//----------------------------------------------------------------------------------------------------------------------------------

function send_registration_required_email($supp_obj,$mail_details,$dept_mail,$a_config)
{
	if($a_config['send_mail']=="1" and $a_config['signuprequired_action']=="y")
	{
		$signuprequired_subject=$a_config['signuprequired_subject'];
		$signuprequired_message=$a_config['signuprequired_message'];
		$signuprequired_subject=$supp_obj->direct_replace($signuprequired_subject,$mail_details);
		$signuprequired_message=$supp_obj->direct_replace($signuprequired_message,$mail_details);
		$supp_obj->send_mail($mail_details['email'],$signuprequired_subject,$signuprequired_message,$dept_mail);							
	}	
}	
//--------------------------------------------------------------------------------------------
}
	// Update last checked time. 
	function alert_admin($supp_obj,$pop3host,$pop3user,$pop3pass,$server_id)
	{
		// Get Last checked time for this account from the database
		$mail_servers=$supp_obj->prefix_table("mail_servers");
		$sql=$supp_obj->return_sql_date("last_checked");
		
		$sql="select $sql from $mail_servers where server_id='$server_id'";
		$a_server=$supp_obj->get_a_line($sql);
		list($date1,$time)=@preg_split("/[ ]+/is",$a_server['last_checked'],-1,PREG_SPLIT_NO_EMPTY);
		
		// Get current date
		$date=date("Y-m-d");
		// If Last checked date is not equal to current date , then check again
		if($date1!=$date)						
		{
			// Get the default administrator's email address
			$staff=$supp_obj->prefix_table("staff");
			$sql="select staff_email from $staff where is_admin='1' ";
			$a_admin=$supp_obj->get_a_line($sql);
			$to=$a_admin['staff_email'];
			// Get the from email address from the configuration settings
			$config=$supp_obj->prefix_table("configuration");
			$sql="select admin_email from $config ";
			$a_config=$supp_obj->get_a_line($sql);
			$from=$a_config['admin_email'];
			$subject="HelpDeskb:Account Validation Failed";
			$message="Dear Admin,\n The cron job was unable to open the mailbox for the $pop3user@$pop3host.
					Please make sure whether you gave the correct details in the department settings.
					Mail checking would be skipped for this account.
					Regards,
					HelpDesk";
			//		echo "message=$message";
			// Send a mail to the administrator about the failure

			$supp_obj->send_mail($to,$subject,$message,$from);
			// update last checked time for this account
			$sql="update $mail_servers set last_checked='$date' where server_id='$server_id' ";
			$supp_obj->execute_query($sql);
		}
	}	
	$current_time=time();
	$config=$supp_obj->prefix_table("configuration");
	$sql="select default_lang,smtp_mail,smtp_port, smtp_host,smtp_username,smtp_password  from $config ";
	$a_config=$supp_obj->get_a_line($sql);

	if($a_config['smtp_mail']=="1")
{
	@include_once("../includes/class.phpmailer.php");	
	@include_once("../includes/class.smtp.php");
	$phpMail=new PHPMailer();
	$supp_obj->phpMail=&$phpMail;
	$supp_obj->gen_smtp_mail=$a_config['smtp_mail'];
	$supp_obj->gen_smtp_host=$a_config['smtp_host'];
	$supp_obj->gen_smtp_port=$a_config['smtp_port'];
	$supp_obj->gen_smtp_username=$a_config['smtp_username'];
	$supp_obj->gen_smtp_password=$a_config['smtp_password'];
}

$sql="update $config set last_checked='$current_time' ";
$supp_obj->execute_query($sql);
// select all mail server information from the database 
$mail_servers=$supp_obj->prefix_table("mail_servers");	
$dept_servers=$supp_obj->prefix_table("dept_servers");
$departments=$supp_obj->prefix_table("departments");

$sql="select pop3_host , pop3_username , pop3_password,$mail_servers.server_id,pop3_email,signature, dept_name, ticket_prefix,
$departments.dept_id 
 from $mail_servers, $dept_servers, $departments
where $mail_servers.server_id=$dept_servers.server_id and $dept_servers.dept_id=$departments.dept_id

and skip_checking <> 'y' ";	
$a_server=$supp_obj->get_rsltset($sql);

for($i=0;$i<count($a_server);$i++) {
	$pop3host=$a_server[$i]['pop3_host'];
	$pop3user=$a_server[$i]['pop3_username'];
	$pop3pass=$a_server[$i]['pop3_password'];
	$server_id=$a_server[$i]['server_id'];
	$pop3_email=$a_server[$i]['pop3_email'];
	$signature=$a_server[$i]['signature'];
	$dept_name=$a_server[$i]['dept_name'];
	$tkprefix=$a_server[$i]['ticket_prefix'];
	$dptid=$a_server[$i]['dept_id'];

	// connect to host over port 110 with a 5 second timeout
	if(preg_match("/pop.gmail/",$pop3host)) {
		$port="995";
	} else {
		$port="110";
	}
	
	$fp = fsockopen ($pop3host, $port, $errno, $errstr, 5); 
	if (!$fp) {
		echo $errstr;
		alert_admin($supp_obj,$pop3host,$pop3user,$pop3pass,$server_id);
		continue;		
	} else { 
		fclose ($fp); 
	} 
	
	// download mails from the pop3 , NNTP , IMAP SERVER
	$mail=new Download($pop3host,$pop3user,$pop3pass,$server_id,$pop3_email,$signature,$dept_name,$tkprefix,$dptid);
	$mail->get_mails($supp_obj);
	$tbl_config = $supp_obj -> prefix_table ("configuration"); 
	$sql = "update $tbl_config set cron_running='n', last_cron_time=$date_func()";
	$supp_obj -> execute_query ($sql);
}