<?php
include_once("session.php");
include_once("header.php");
include_once("nav.php");

class weeklyTicketTemplate {
	function viewform($supp_obj, $a_predefined, $generic_msg, $status_msg) {
		$client_custom_values = $supp_obj->prefix_table("client_custom_values");
		$schedule_tickets = $supp_obj->prefix_table("schedule_tickets");
		$schedule_clients = $supp_obj->prefix_table("schedule_clients");
		$customers = $supp_obj->prefix_table("clients");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		
		$template = "../templates/admin/manage_daily_tickets.tpl";
		$content = $supp_obj->return_file_content($template);
		
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		//subject line
		$sql = "SELECT * FROM $customers, $client_custom_values, $schedule_clients WHERE $customers.client_id = $client_custom_values.client_id AND $schedule_clients.client_id = $customers.client_id AND $schedule_clients.type = '2'";
		$loop_sql['customer_'] = $sql;
$evale=<<<EOD
if(\$rowno%2 == 0) {
	\$class="tabledata";
} else {
	\$class="tabledataalt";
}	
EOD;
		$evalcode['customer_'] = $evale;
		$a_content = $supp_obj->replace_loop($loop_sql,$content,$evalcode);
		$content = $a_content[0];
		
		$replace_array['status_msg'] = $a_predefined['status_msg'];
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		echo $content;
	}
	
	function addClient($supp_obj, $a_predefined, $generic_msg) {
		$schedule_clients = $supp_obj->prefix_table("schedule_clients");
		$clients = $supp_obj->prefix_table("clients");
		
		//searchcust
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		
		if($post_vars['searchcust'] != "") {
			$client_email = $post_vars['searchcust'];
			$client_email = trim($client_email);
			$pos = strpos ($client_email, "[");
			$client_email = substr ($client_email, $pos + 1);
			$pos = strpos ($client_email, "]");
			$client_email = substr ($client_email, 0, $pos);
			$post_vars['searchcust'] = $client_email;
			
			$sql = "SELECT client_id FROM $clients WHERE email = '".$client_email."'";
			$row = $supp_obj->get_a_line($sql);
			
			if($row['client_id'] != '') {
				$sql = "SELECT * FROM $schedule_clients WHERE client_id = '".$row['client_id']."' AND type = '2'";
				$res = $supp_obj->return_db_handle($sql);
				$num = $supp_obj->return_num_rows($res);
				if($num == 0) {
					$sql = "INSERT INTO $schedule_clients (type, client_id, created) VALUES ('2', '".$row['client_id']."', NOW())";
					$supp_obj->execute_query($sql);
				}
			}
		}
		return $generic_msg['cClientAddedSuccessfully'];	
	}
	function deleteClient($supp_obj, $a_predefined, $generic_msg) {
		$schedule_clients = $supp_obj->prefix_table("schedule_clients");
		
		//searchcust
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		
		for($i = 0; $i < count($chk_ticket); $i++) {
			$client_id = $chk_ticket[$i];
			$sql = "DELETE FROM $schedule_clients WHERE client_id = '".$client_id."' AND type = '2'";
			$supp_obj->execute_query($sql);
		}
		return $generic_msg['cClientDeletedSuccessfully'];
	}
}

$cr = new weeklyTicketTemplate;
$act = $post_vars['act'];
switch($act) {
	case NULL:
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
	case 'addnew':
		$a_predefined['status_msg'] = $cr->addClient($supp_obj, $a_predefined, $generic_msg);
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
	case 'deleteCl':
		$a_predefined['status_msg'] = $cr->deleteClient($supp_obj, $a_predefined, $generic_msg);
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
}

include_once("footer.php");
?>