<?php
include_once("session.php");

class Travel {
	//SHOW ADDED COMPANIES
	function Show_companies($supp_obj, $return_array='', $a_predefined) {
		$companies=$supp_obj->prefix_table("companies");
	
		// filter administrator related tasks
		$is_admin = $supp_obj->is_administrator($a_predefined);
		
		$sql="SELECT * FROM $companies ORDER BY companyname";
		
		$template.="../templates/admin/manage_travel.tpl";
		$content=$supp_obj->return_file_content($template);
		$replace_content=array();
		$loop_sql['company_']=$sql;
		
		if($is_admin) {
			$content=preg_replace("/\<\{adminonly_(.*?)\}\>/is","",$content);
		} else {
			$content=preg_replace("/\<\{adminonly_start\}\>(.*?)\<\{adminonly_end\}\>/is","",$content);
		}
	
		$evalcode['company_']='';
		$a_content=$supp_obj->replace_loop($loop_sql,$content,$evalcode);
		$content=$a_content[0];

		if($return_array!="") {
			$status_msg=$return_array['status_msg'];
			$post_vars['status_msg']=$status_msg;
		}	
		if($return_array['status_msg'] != "") {
			$content=preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		} else {
			$content=preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);
		}
		
		//$content=preg_replace("/<{errormsg_start}>(.*?)<{errormsg_end}>/is","",$content);
		$content=$supp_obj->direct_replace($content, $post_vars);
		echo $content;
	}
	
	//SHOW ADD FROM
	function Show_company_add_form($supp_obj, $return_array='') {
		$get_vars=$a_predefined['get'];
		$post_vars=$a_predefined['post'];
		
		$fields=$supp_obj->prefix_table("fields");
		$field_dept=$supp_obj->prefix_table("field_dept");
		$field_answers = $supp_obj -> prefix_table ("field_answers");
		
		$template.="../templates/admin/manage_travel_add.tpl";
		$content=$supp_obj->return_file_content($template);
		$replace_content=array();
		
		
		
		if($return_array!="") {
			$status_msg=$return_array['status_msg'];
			$post_vars['status_msg']=$status_msg;
		}
		
		if($return_array['status_msg'] != "") {
			$content=preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		} else {
			$content=preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);
		}
		
		$sql="SELECT fa.* FROM $field_answers fa, $fields f WHERE f.field_id = fa.field_id AND f.field_name = 'Company' ORDER BY fa.field_answer ASC";
		$loop_sql['company_'] = $sql;
		
		$sel_arr['company_']['field_answer'] = array();
		$a_content = $supp_obj->replace_loop($loop_sql, $content, '', $sel_arr); // populate tpl file
		$content = $a_content[0];
		
		$content=$supp_obj->direct_replace($content, $post_vars);
		echo $content;
	}
	
	//SHOW EDIT FROM
	function Show_company_edit_form($supp_obj, $a_predefined, $return_array='') {
		$get_vars=$a_predefined['get'];
		$post_vars=$a_predefined['post'];
		
		$companies=$supp_obj->prefix_table("companies");
		
		$template.="../templates/admin/manage_travel_edit.tpl";
		$content=$supp_obj->return_file_content($template);
		$replace_content=array();
	
		if($return_array!="")
		{
			$status_msg=$return_array['status_msg'];
			$post_vars['status_msg']=$status_msg;
		}
		
		$id = $get_vars['id'];
		$sql = "SELECT * FROM $companies WHERE id = '$id'";
		$res = $supp_obj->get_a_line($sql);
		
		$replace_cont['companyname'] = addslashes($res['companyname']);
		$replace_cont['address'] = addslashes($res['address']);
		$replace_cont['phone'] = addslashes($res['phone']);
		$replace_cont['id'] = $id;
		
		if($return_array['status_msg'] != "") {
			$content=preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		} else {
			$content=preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);
		}
		
		$content=$supp_obj->direct_replace($content, $replace_cont);
		echo $content;
	}
	
	//Add COMPANY function
	function Add_company($supp_obj, $a_predefined, $generic_msg) {
		//Prefix and prepare tables	
		$companies=$supp_obj->prefix_table("companies");
		$travel_distance=$supp_obj->prefix_table("travel_distance");
		
		$post_vars=$a_predefined['post'];
		$get_vars=$a_predefined['get'];
		@extract($post_vars);
		$return_array=array();
		
		$sql = "SELECT id FROM $companies WHERE companyname = '$companyname'";
		$res = $supp_obj->get_single_column($sql);
		if(!$res) {
			$sql = "SELECT companyname FROM $companies";
			$pre_res = $supp_obj->get_single_column($sql);
			//Add message
			$avoid_array=array("id");
			$insert_array=array("companyname"=>addslashes($companyname), "phone"=>addslashes($phone), "address"=>addslashes($address));
			
			$sql=$supp_obj->construct_query($companies,"INSERT",$insert_array,$avoid_array);
			$result = $supp_obj->execute_query($sql);
			
			for($i = 0; $i<count($pre_res); $i++) {
				$avoid_array=array("id");
				$insert_array=array("fromid"=>addslashes($companyname), "toid"=>addslashes($pre_res[$i]), "distance"=>"0");
	
				$sql=$supp_obj->construct_query($travel_distance,"INSERT",$insert_array,$avoid_array);
				$result = $supp_obj->execute_query($sql);
			}
		} else  {
			$return_array['status'] = false;
			$return_array['status_msg'] = $generic_msg['cCompany_name_exist'];
			return $return_array;		
		}
		if($result)		
		{
			$return_array['status'] = false;
			$return_array['status_msg'] = $generic_msg['cCompany_name_added'];
			return $return_array;	
		}
	}
	
	//EDIT COMPANY function
	function Edit_company($supp_obj, $a_predefined, $generic_msg) {
		//Prefix and prepare tables	
		$companies=$supp_obj->prefix_table("companies");
		$travel_distance=$supp_obj->prefix_table("travel_distance");
		
		$post_vars=$a_predefined['post'];
		$get_vars=$a_predefined['get'];
		@extract($post_vars);
		$return_array=array();
		
		$sql = "SELECT companyname FROM $companies";
		$pre_res = $supp_obj->get_single_column($sql);
		
		$id = $post_vars['id'];
		
		$sql = "UPDATE $companies SET address = '$address',  phone = '$phone' WHERE id = '$id'";
		$result = $supp_obj->execute_query($sql);

		if($result)		
		{
			$return_array['status'] = false;
			$return_array['status_msg'] = $generic_msg['cAddress_updated'];
			return $return_array;	
		}
	}
		
	//EDIT DISTANCE UPDATE FUNCTION
	function Edit_distance($supp_obj, $a_predefined, $generic_msg) {
		$travel_distance=$supp_obj->prefix_table("travel_distance");
		$post_vars=$a_predefined['post'];
		$get_vars=$a_predefined['get'];
		@extract($get_vars);
		@extract($post_vars);
		$count = count($distance);

		for($i = 0; $i<$count; $i++) {
			$sql = "UPDATE $travel_distance SET distance = '$distance[$i]' WHERE id = '$id[$i]'";
			$supp_obj->execute_query($sql);
		}
		$template.="../templates/admin/manage_travel_distance.tpl";
		$content=$supp_obj->return_file_content($template);
		$replace_content=array();
	
		if($return_array!="")
		{
			$status_msg=$return_array['status_msg'];
			$post_vars['status_msg']=$status_msg;
		}	
		if($return_array['status_msg'] != "") {
			$content=preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		} else {
			$content=preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);
		}
		$content=$supp_obj->direct_replace($content, $post_vars);
		$replace_content=array();
		
		if(isset($get_vars['exclude'])) {
			$sql = "SELECT * FROM $travel_distance WHERE distance = 0 ORDER BY fromid";
		} else {
			$sql = "SELECT * FROM $travel_distance ORDER BY fromid";
		}

		$loop_sql['company_'] = $sql;
	
		$evalcode['company_']='';
		$a_content=$supp_obj->replace_loop($loop_sql,$content,$evalcode);
		$content=$a_content[0];
		
		echo $content;
	}
	function Delete_travel($supp_obj, $a_predefined, $generic_msg) {
		$post_vars=$a_predefined['post'];
		$get_vars=$a_predefined['get'];
		@extract($get_vars);

		$companies=$supp_obj->prefix_table("companies");
		$travel_distance=$supp_obj->prefix_table("travel_distance");
		$return_array=array();
		
		$sql = "SELECT companyname FROM $companies WHERE id = '$ffc_id'";
		$row = $supp_obj->get_a_line($sql);

		if(count($row) > 1) {
			$sql = "DELETE FROM $companies WHERE id = '$ffc_id'";
			$result = $supp_obj->execute_query($sql);
			
			$sql = "DELETE FROM $travel_distance WHERE fromid = '".addslashes($row['companyname'])."' or toid = '".addslashes($row['companyname'])."'";
			$result = $supp_obj->execute_query($sql);
		}
		$return_array['status'] = false;
		$return_array['status_msg'] = $generic_msg['cCompany_name_delete'];
		return $return_array;	
	}
}

// filter administrator related tasks
$is_admin = $supp_obj->is_administrator($a_predefined);

$traveling=new Travel;
	switch($act)
	{	
	
	case NULL:
		include_once("header.php");
		include_once("nav.php");
		if($is_admin) {
			$traveling->Show_company_add_form($supp_obj, $return_array);
		}
		$traveling->Show_companies($supp_obj, $return_array, $a_predefined);
		break;
		
	case "edit":
		include_once("header.php");
		include_once("nav.php");
		$traveling->Edit_company($supp_obj, $a_predefined, $generic_msg);
		if($is_admin) {
			$traveling->Show_company_add_form($supp_obj, $return_array);
		}
		$traveling->Show_companies($supp_obj, $return_array, $a_predefined);
		break;
		
	case "addname":
		include_once("header.php");
		include_once("nav.php");
		$return_array = $traveling->Add_company($supp_obj, $a_predefined, $generic_msg);	
		if($is_admin) {
			$traveling->Show_company_add_form($supp_obj, $return_array);
		}
		$traveling->Show_companies($supp_obj, $return_array, $a_predefined);
		break;
	case "editform":
		include_once("header.php");
		include_once("nav.php");
		//$return_array = $traveling->Add_chnned($supp_obj, $a_predefined, $generic_msg);	
		$traveling->Show_company_edit_form($supp_obj, $a_predefined, $return_array);
		//$traveling->Show_companies($supp_obj, $return_array);
		break;
	case "delete":
		include_once("header.php");
		include_once("nav.php");
		$return_array = $traveling->Delete_travel($supp_obj, $a_predefined, $generic_msg);	
		if($is_admin) {
			$traveling->Show_company_add_form($supp_obj, $return_array);
		}
		$traveling->Show_companies($supp_obj, $return_array, $a_predefined);
		break;
	case "editdistance":
		include_once("header.php");
		include_once("nav.php");
		$traveling->Edit_distance($supp_obj, $a_predefined, $generic_msg);
		break;
	}
include_once("footer.php");
?>