<?php
class fileUploader {
	private $pathStorage;
	private $sizeLimit;
	private $extensions;
	private $fileIn;
	public $result;
	public $error;
	public $tof;
	public $file_extension;
	public $system_name;
	public $file_size;
	
	function __construct($path, $size, $extension, $file) {
		$this->pathStorage = $path;
		$this->sizeLimit = $size;
		$this->extensions = $extension;
		$this->fileIn = $file;
		$this->upload();
	}
	
	private function verifyExtension($extensions, $fileExt) {
		$this->tof = false;
		foreach($extensions as $k => $v) {
				if ($v == $fileExt) {
					$this->tof = true;
				}
		}
		return $this->tof;
	}
	
	private function verifySize($size, $fileSize) {
		$this->tof = false;
		if ($fileSize <= $size) {
			$this->tof = true;
		}
		return $this->tof;
	}
	
	private function get_file_extension($file_name) {
	  return substr(strrchr($file_name,'.'),1);
	}

	private function upload() {
		if ($this->fileIn['name'] == "") {
			$this->error = "Please select a file";
		} else {
			// Verify extensions admitted
			if ($this->verifyExtension($this->extensions, $this->get_file_extension($this->fileIn['name']))) {
				// Verify file size
				if ($this->verifySize($this->sizeLimit, $this->fileIn['size'])) {
					$this->file_extension = $this->get_file_extension($this->fileIn['name']);
					$this->system_name = md5(time().$this->fileIn['name']).'.'.$this->file_extension;
					$this->file_size = $this->fileIn['size'];
					if (@copy($this->fileIn['tmp_name'], $this->pathStorage.$this->system_name)) {
						$this->result = "File uploaded successfully";
					} else {
							$this->error = "File upload error please try again.";
					}
				} else {
						$this->error = "File size is larger than system can accept";
				}
			} else {
					$this->error = "Invlid file type.";
			}
		}
				
	}	
}
?>