<?php
$page = "groups";
$extra = "";
include "report_include.php"; 
echo "<div class=\"main_each\">\n";
?>
<style type="text/css">
#report_header {
	height:120px;
	width:100%;
}
.clearleft {
	clear:left;
}
h3, h2, h4, h5 {
	font-family:Arial, Helvetica, sans-serif;
}
h2 {
	height:10px;
	font-size:18px;
	color:#003399;
}
h3 {
	height:15px;
	font-size:14;
	color:#000000
}
h4 {
	height:15px;
	font-size:11px;
	color:#333333;
}
h5 {
	height:15px;
	font-size:10px;
	color:#000000;
}
#report_header #logo {
	float:right;
	margin:5px;
}

#inventory_report td
{
  border-bottom:1px solid #ccc;
  color:#000000;
  padding:6px 8px;
  white-space:nowrap;
}

#inventory_report
{
  font-family:"Lucida Sans Unicode", "Lucida Grande", Sans-Serif;
  font-size:12px;
  background:#fff;
  border-collapse:collapse;
  text-align:left;
}

#inventory_report th
{
  font-size:14px;
  font-weight:500;
  color:#000000;
  border-bottom:2px solid #6678b1;
  border-top:2px solid #6678b1;
  padding:10px 8px;
  white-space:nowrap;
}

#inventory_report tbody tr:hover td
{
  color:#6678b1;
}
</style>
<?php
//report class
class inventory {
	function get_single_column($qry)
	{
		$j=0;
		//echo $qry;
		while($res=mysqli_fetch_array($qry))
		{
			$res1 = explode("mac-",$res[0]);
			if($res1[1] != "") {
				$res=$this->convert_html_entities($res1[1]);
				$res1 = str_replace("_",".",$res1[1]);
				$row[$j]=$res1;
				$j++;
			}
		}
		return $row;
	}
	
	function convert_html_entities($row)
	{
		$row=str_replace("$","&#36;",$row);
		return $row;
	}
	
	//get result set
	function get_result_set($qry) {
		$j=0;
		$cur=mysqli_query($qry);
		$row=array();
		while($res=@mysqli_fetch_array($cur))
		{
			$res=$this->convert_html_entities($res);
			$row[$j]=$res;
			$j++;
		}
		return $row;	
	}
	
	//array sorting
	function sort_array($array, $id) {
		$temp_array = array();
		while(count($array)>0) {
			$lowest_id = 0;
			$index=0;
			foreach ($array as $item) {
				if (isset($item[$id]) && $array[$lowest_id][$id]) {
					if ($item[$id]<$array[$lowest_id][$id]) {
						$lowest_id = $index;
					}
				}
			$index++;
			}
			$temp_array[] = $array[$lowest_id];
			$array = array_merge(array_slice($array, 0,$lowest_id), array_slice($array, $lowest_id+1));
		}
		return $temp_array;
    }
	//my implode
	function my_implode($char,$array)
	{
		$lem = array_keys($array);
		$char = htmlentities($char);
		for($i=0;$i<sizeof($lem);$i++) {
			$str .= ($i == sizeof($lem)-1) ? $array[$lem[$i]] : $array[$lem[$i]].$char;
		}
		return $str;
	}
	
	//get the uuid's of all listed pcs in a group
	function get_group_uuids($group_id = 0) {
		$gid = $group_id;
		if($gid != 0) {
			$sql = "SELECT group_uuid FROM group_members where group_names_id = '$gid'";
			$result = mysqli_query($db, $sql);
			$num = mysqli_num_rows($result);
			if($num > 0) {
				$row = $this->get_single_column($result);
				$returnset = $this->my_implode("','", $row);
				return $returnset;
			} else {
				return false;
			}
		} else {
			$sql = "SELECT group_uuid FROM group_members ORDER BY group_names_id";
			$result = mysqli_query($db, $sql);
			$num = mysqli_num_rows($result);
			if($num > 0) {
				$row = $this->get_single_column($result);
				$returnset = $this->my_implode("','", $row);
				return $returnset;
			} else {
				return false;
			}
		}
	}
	
	//get all listed systems of the group
	function get_systems($uuids) {
		$sql = "SELECT * FROM system WHERE system_uuid IN ('$uuids')";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get memory detail of listed systesm of the group
	function get_memory($uuids) {
		$sql = "SELECT memory_uuid, SUM(memory_capacity) as memory_capacity, MAX(memory_speed) as memory_speed FROM memory WHERE memory_uuid IN ('$uuids') GROUP BY memory_uuid";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get processor detail of listed systesm of the group
	function get_processor($uuids) {
		$sql = "SELECT processor_uuid, processor_name, processor_current_clock_speed FROM processor WHERE processor_uuid IN ('$uuids') GROUP BY processor_uuid";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get harddrive detail of listed systesm of the group
	function get_harddrive($uuids) {
		$sql = "SELECT hard_drive_uuid, hard_drive_model, hard_drive_caption, SUM(hard_drive_size)/1024 as hard_drive_size FROM hard_drive WHERE hard_drive_uuid IN ('$uuids') GROUP BY hard_drive_uuid";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get system USB data listed systesm of the group
	function get_system_usb($uuids) {
		$sql = "SELECT * FROM usb WHERE usb_uuid = '$uuids'";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get system printers data listed systesm of the group
	function get_system_other($uuids) {
		$sql = "SELECT * FROM other WHERE other_linked_pc = '$uuids' AND other_type = 'printer'";
		$row = $this->get_result_set($sql);
		return $row;
	}
	//get system monitor data listed systesm of the group
	function get_system_monitor($uuids) {
		$sql = "SELECT * FROM monitor WHERE monitor_uuid = '$uuids'";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get system keys detail of listed systesm of the group
	function get_keys($uuids) {
		$sql = "SELECT ms_keys_uuid, ms_keys_cd_key, ms_keys_name FROM ms_keys WHERE ms_keys_uuid = '$uuids'";
		//echo $sql."<br>";
		$result = mysqli_query($db, $sql);
		$i = 0;
		while($row = mysqli_fetch_array($result)) {
			$data[0] .= $row['ms_keys_cd_key']."<br>";
			$data[1] .= $row['ms_keys_name']."<br>";
			$i++;
		}
		//$row = $this->get_result_set($sql);
		return $data;
	}
	
	//get system printers data listed systesm of the group
	function get_system_printer($uuids) {
		$sql = "SELECT * FROM other WHERE other_linked_pc = '$uuids' AND other_type = 'printer'";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get system nic detail of listed systesm of the group
	function get_network_cards($uuids) {
		$sql = "SELECT net_uuid, net_mac_address, net_adapter_type, net_ip_address FROM network_card WHERE net_uuid IN ('$uuids')";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get system manual data listed systesm of the group
	function get_system_manual($uuids) {
		$sql = "SELECT * FROM system_man WHERE system_man_uuid IN ('$uuids')";
		$row = $this->get_result_set($sql);
		return $row;
	}
	
	//get group name & company detail
	function get_group_name($gid = 0) {
		if($gid != 0) {
			$sql = "SELECT * FROM group_names WHERE group_id = '$gid'";
			$row = $this->get_result_set($sql);
			return $row;
		} else {
			$row['group_name'] = "All Groups";
			$row['companyname'] = "All Companies";
			$row['email'] = "N/A";
			$row['website'] = "N/A";
			return $row;
		}
	}
	
	function report_data($groupid = 0, $farray) {
		$gid 		= $groupid;
		$row 		= array();
		$auuids		= $this->get_group_uuids($gid);
		$system 	= $this->get_systems($auuids);
		$processor 	= $this->get_processor($auuids);
		$harddrive 	= $this->get_harddrive($auuids);
		
		$network 	= $this->get_network_cards($auuids);
		$manual = array();
		$manual 	= $this->get_system_manual($auuids);
		//$row = array();
		$j = 0;
		$uuid = explode("','",$auuids);
		for($i = 0; $i < count(explode(",",$auuids)); $i++) {
			$fields1 = $farray[$i];
			//system info
			if(in_array("1", $farray))
				$row[$j][] = $system[$i]['net_ip_address'];
			if(in_array("2", $farray))
				$row[$j][] = $system[$i]['net_domain'];
			if(in_array("3", $farray))
				$row[$j][] = $system[$i]['net_user_name'];
			if(in_array("4", $farray))
				$row[$j][] = $system[$i]['system_model'];
			if(in_array("5", $farray))
				$row[$j][] = $system[$i]['system_id_number'];
			if(in_array("6", $farray))
				$row[$j][] = $system[$i]['system_vendor'];
			if(in_array("7", $farray))
				$row[$j][] = $system[$i]['system_os_name'];
			if(in_array("8", $farray))
				$row[$j][] = $system[$i]['system_service_pack'];
			if(in_array("9", $farray))
				$row[$j][] = $system[$i]['virus_manufacturer'];
			//processor
			if(in_array("10", $farray))
				$row[$j][] = $processor[$i]['processor_name'];
			if(in_array("11", $farray))
				$row[$j][] = ceil($processor[$i]['processor_current_clock_speed'])." Mhz";
				//harddrive
			if(in_array("12", $farray))
				$row[$j][] = $harddrive[$i]['hard_drive_caption'];
			if(in_array("13", $farray))
				$row[$j][] = $harddrive[$i]['hard_drive_model'];
			if(in_array("14", $farray))
				$row[$j][] = ceil($harddrive[$i]['hard_drive_size'])." GB";
			//memory
			$memory 	= $this->get_memory($system[$i]['system_uuid']);
			if(in_array("15", $farray))
				$row[$j][] = round($system[$i]['system_memory']/1024, 1).' GB';
			if(in_array("16", $farray))
				$row[$j][] = ceil($memory[0]['memory_speed']).' Mhz';
			//keys
			$keys 	   = $this->get_keys($uuid[$j]);
			if(in_array("17", $farray))
				$row[$j][] = $keys[1];
			if(in_array("18", $farray))
				$row[$j][] = $keys[0];
				//network
			if(in_array("19", $farray))
				$row[$j][] = $network[$i]['net_mac_address'];
			if(in_array("20", $farray))
				$row[$j][] = $network[$i]['net_adaper_type'];
			if(in_array("21", $farray))
				$row[$j][] = $network[$i]['net_ip_address'];
				//system_man
			if(in_array("22", $farray))
				$row[$j][] = $manual[$i]['system_man_value'];
			if(in_array("23", $farray))
				$row[$j][] = $manual[$i]['system_man_email1'];
			if(in_array("24", $farray))
				$row[$j][] = $manual[$i]['system_man_email1_password'];
			if(in_array("25", $farray))
				$row[$j][] = $manual[$i]['system_man_pca_username'];
			if(in_array("26", $farray))
				$row[$j][] = $manual[$i]['system_man_password'];
			if(in_array("27", $farray))
				$row[$j][] = $manual[$i]['system_man_port'];
			if(in_array("28", $farray))
				$row[$j][] = $manual[$i]['system_man_network_username'];
			if(in_array("29", $farray))
				$row[$j][] = $manual[$i]['system_man_network_password'];
			if(in_array("30", $farray))
				$row[$j][] = $manual[$i]['system_man_location'];
			
			if(in_array("39", $farray))
				$row[$j][] = ($manual[$i]['system_man_date_of_purchase'] != '' && $manual[$i]['system_man_date_of_purchase'] != '0000-00-00')? date("n/j/Y", strtotime($manual[$i]['system_man_date_of_purchase'])) : "";
			if(in_array("40", $farray))
				$row[$j][] = $manual[$i]['system_man_expiration_date'];
			
			if(in_array("31", $farray))
				$row[$j][] = $manual[$i]['system_man_description'];
			$usb = array();
			$usb 	= $this->get_system_usb($system[$i]['system_uuid']);
			if(in_array("32", $farray))
				$row[$j][] = $usb[0]['usb_caption'];
			if(in_array("33", $farray))
				$row[$j][] = $usb[0]['usb_manufacturer'];
			$printer = array();
			$printer 	= $this->get_system_printer($system[$i]['system_uuid']);
			if(in_array("34", $farray))
				$row[$j][] = $printer[0]['other_network_name'];
			if(in_array("35", $farray))
				$row[$j][] = $printer[0]['other_description'];
			$monitor = array();
			$monitor 	= $this->get_system_monitor($system[$i]['system_uuid']);
			if(in_array("36", $farray))
				$row[$j][] = $monitor[0]['monitor_model'];
			if(in_array("37", $farray))
				$row[$j][] = $monitor[0]['monitor_serial'];
			if(in_array("38", $farray))
				$row[$j][] = $monitor[0]['monitor_manufacturer'];
			
			$j++;
		}
		return $row;
	}
	
	function sort2d ($array, $index, $order='asc', $natsort=FALSE, $case_sensitive=FALSE) 
    {
        if(is_array($array) && count($array)>0) 
        {
           foreach(array_keys($array) as $key) 
               $temp[$key]=$array[$key][$index];
               if(!$natsort) 
                   ($order=='asc')? asort($temp) : arsort($temp);
              else 
              {
                 ($case_sensitive)? natsort($temp) : natcasesort($temp);
                 if($order!='asc') 
                     $temp=array_reverse($temp,TRUE);
           }
           foreach(array_keys($temp) as $key) 
               (is_numeric($key))? $sorted[]=$array[$key] : $sorted[$key]=$array[$key];
           return $sorted;
      }
      return $array;
    }  
}

function generate_report() {
	$Obj = new inventory;
	$rrow = $Obj->report_data($_SESSION['gid'], $_SESSION['listopt']);
	$rrow = $Obj->sort2d($rrow, $_SESSION['sortopt']);
	$group = $Obj->get_group_name($_SESSION['gid']);
	echo "<div id=\"report_header\">
		<div id=\"logo\"><img src=\"../../images/logo.png\" alt=\"ITTC LOGO\" border=\"0\"></div>
		<div class=\"clearleft\" id=\"reporttitle\"><h2>Inventory Report</h2></div>
		<div class=\"group\"><h3>".$group[0][1]."</h3><h4>".$group[0][2]."</h4><h5>".date("m/d/Y H:i")."</h5></div>
	</div>";
	$farray = $_SESSION['listopt'];
	echo "<table id=\"inventory_report\">";
	echo "<tr>";
		echo "<th>#</th>";
	if(in_array("1", $farray))
		echo "<th>IP Address</th>";
	if(in_array("2", $farray))
		echo "<th>Domain Name</th>";
	if(in_array("3", $farray))
		echo "<th>User Name</th>";
	if(in_array("4", $farray))
		echo "<th>Model</th>";
	if(in_array("5", $farray))
		echo "<th>Serial Number</th>";
	if(in_array("6", $farray))
		echo "<th>Vendor Information</th>";
	if(in_array("7", $farray))
		echo "<th>Operating System</th>";
	if(in_array("8", $farray))
		echo "<th>Service Pack</th>";
	if(in_array("9", $farray))
		echo "<th>Anti Virus</th>";
	if(in_array("10", $farray))
		echo "<th>Processor</th>";
	if(in_array("11", $farray))
		echo "<th>Processor Speed</th>";
	if(in_array("12", $farray))
		echo "<th>Hard Drive</th>";
	if(in_array("13", $farray))
		echo "<th>Hard Drive Model</th>";
	if(in_array("14", $farray))
		echo "<th>Hard Drive Size</th>";
	if(in_array("15", $farray))
		echo "<th>Memory Size</th>";
	if(in_array("16", $farray))
		echo "<th>Memory Speed</th>";
	if(in_array("17", $farray))
		echo "<th>CD Key Type</th>";
	if(in_array("18", $farray))
		echo "<th>CD Key</th>";
	if(in_array("19", $farray))
		echo "<th>Mac Address</th>";
	if(in_array("20", $farray))
		echo "<th>NIC Type</th>";
	if(in_array("21", $farray))
		echo "<th>IP Address</th>";
	if(in_array("22", $farray))
		echo "<th>System Value</th>";
	if(in_array("23", $farray))
		echo "<th>Email Address</th>";
	if(in_array("24", $farray))
		echo "<th>Email Password</th>";
	if(in_array("25", $farray))
		echo "<th>PCA Username</th>";
	if(in_array("26", $farray))
		echo "<th>PCA Password</th>";
	if(in_array("27", $farray))
		echo "<th>PCA Port</th>";
	if(in_array("28", $farray))
		echo "<th>Network Username</th>";
	if(in_array("29", $farray))
		echo "<th>Network Password</th>";
	if(in_array("30", $farray))
		echo "<th>System Location</th>";
	
	if(in_array("39", $farray))
		echo "<th>Purchase Date</th>";
	if(in_array("40", $farray))
		echo "<th>Expire Date</th>";
	
	if(in_array("31", $farray))
		echo "<th>Notes</th>";
	if(in_array("32", $farray))
		echo "<th>USB Caption</th>";
	if(in_array("33", $farray))
		echo "<th>Manufacturer</th>";	
	if(in_array("34", $farray))
		echo "<th>Network Name</th>";
	if(in_array("35", $farray))
		echo "<th>Description</th>";	
	if(in_array("36", $farray))
		echo "<th>Model</th>";	
	if(in_array("37", $farray))
		echo "<th>Serial</th>";
	if(in_array("38", $farray))
		echo "<th>Manufacturer</th>";
	
	echo "</tr>";
	for($i = 0; $i < count($rrow); $i++) {
		echo "<tr>";
		for($j = 0; $j < count($rrow[$i]); $j++) {
			if($j == 0) {
				echo "<td align=\"left\" valign=\"top\" style=\"width:100px;\">".($i+1)."</td>";		
			}
			echo "<td align=\"left\" valign=\"top\" style=\"width:100px;\">".$rrow[$i][$j]."</td>";
		}
		echo "</tr>";
	}
	echo "</table>";
}

	if($_POST['generate_report'] == "now") {
		//$html_contents = $new_report->generate_new_report($supp_obj,$a_predefined,$generic_msg,$manager,$timezones_array);
		$html_contents = generate_report();
		require_once("inc/pdf/dompdf_config.inc.php");
		
		if ( get_magic_quotes_gpc() )
		$html_contents = stripslashes($html_contents);
		
		$dompdf = new DOMPDF();
		$dompdf->load_html($html_contents);
		$dompdf->set_paper($_POST['paper'], $_POST['orientation']);
		$dompdf->render();
		//$company_name = $_SESSION['company_name'];
		$file_name = "inventory".date("m-d-Y").".pdf";
		$dompdf->stream($file_name);
		exit(0);
	} else {
		echo '<form name="paperselection" method="post"><p>Paper size and orientaion:
				<select name="paper">
				<option value="4a0">4a0</option>
				<option value="2a0">2a0</option>
				<option value="a0">a0</option>
				<option value="a1">a1</option>
				<option value="a2">a2</option>
				<option value="a3">a3</option>
				<option selected="selected" value="a4">a4</option>
				<option value="a5">a5</option>
				<option value="a6">a6</option>
				<option value="a7">a7</option>
				<option value="a8">a8</option>
				<option value="a9">a9</option>
				<option value="a10">a10</option>
				<option value="b0">b0</option>
				<option value="b1">b1</option>
				<option value="b2">b2</option>
				<option value="b3">b3</option>
				<option value="b4">b4</option>
				<option value="b5">b5</option>
				<option value="b6">b6</option>
				<option value="b7">b7</option>
				<option value="b8">b8</option>
				<option value="b9">b9</option>
				<option value="b10">b10</option>
				<option value="c0">c0</option>
				<option value="c1">c1</option>
				<option value="c2">c2</option>
				<option value="c3">c3</option>
				<option value="c4">c4</option>
				<option value="c5">c5</option>
				<option value="c6">c6</option>
				<option value="c7">c7</option>
				<option value="c8">c8</option>
				<option value="c9">c9</option>
				<option value="c10">c10</option>
				<option value="ra0">ra0</option>
				<option value="ra1">ra1</option>
				<option value="ra2">ra2</option>
				<option value="ra3">ra3</option>
				<option value="ra4">ra4</option>
				<option value="sra0">sra0</option>
				<option value="sra1">sra1</option>
				<option value="sra2">sra2</option>
				<option value="sra3">sra3</option>
				<option value="sra4">sra4</option>
				<option value="letter">letter</option>
				<option value="legal">legal</option>
				<option value="ledger">ledger</option>
				<option value="tabloid">tabloid</option>
				<option value="executive">executive</option>
				<option value="folio">folio</option>
				<option value="commerical #10 envelope">commerical #10 envelope</option>
				<option value="catalog #10 1/2 envelope">catalog #10 1/2 envelope</option>
				<option value="8.5x11">8.5x11</option>
				<option value="8.5x14">8.5x14</option>
				<option value="11x17">11x17</option>
				</select>
				<select name="orientation">
				  <option value="portrait">portrait</option>
				  <option selected="selected" value="landscape">landscape</option>
				</select>
				<input type="submit" name="sumbit" value="Download" /><input type="hidden" name="generate_report" value="now" /></p></form><hr />';
		$html_contents = generate_report();
		echo $html_contents;
	}


/////////////////////
echo "</div>\n";
echo "</body>\n";
echo "</html>\n";
?>
