<?php
$workshift = $records[0];
$assignedEmployees = $records[1];
$availableEmployees = $records[2];

$disabled = ($records['rights']['edit']) ? '' : 'disabled="disabled"';
?>
<script type="text/javascript" src="../../scripts/archive.js"></script>
<script type="text/javascript" src="../../scripts/octopus.js"></script>
<script type="text/javascript">
//<![CDATA[
var baseUrl = '?timecode=Time&action=';

function goBack() {
	location.href = "./CentralController.php?timecode=Time&action=View_Work_Shifts";
}

function upateShift() {
	err=false;
	msg='<?php echo $lang_Error_PleaseCorrectTheFollowing; ?>\n\n';

	if ($('txtShiftName').value.trim() == '') {
		err=true;
		msg+="\t- <?php echo $lang_Time_Error_SpecifyWorkShiftName; ?>\n";
	}

	var hoursPerDay = $('txtHoursPerDay').value.trim();
	if ( hoursPerDay == '') {
		err=true;
		msg+="\t- <?php echo $lang_Time_Error_SpecifyHoursPerDay; ?>\n";
	} else if (isNaN(hoursPerDay)) {
		err=true;
		msg+="\t- <?php echo $lang_Time_Error_HoursPerDayShouldBeANumericValue; ?>\n";
	} else if (0 >= hoursPerDay) {
		err=true;
		msg+="\t- <?php echo $lang_Time_Error_HoursPerDayShouldBePositiveNumber; ?>\n";
	} else if (hoursPerDay > 24) {
		err=true;
		msg+="\t- <?php echo $lang_Time_Error_HoursPerDayShouldBeLessThan24; ?>\n";
	}

	if (err) {
		alert(msg);

		return false;
	}

	selectAllOptions($('cmbAssignedEmployees'));
	$('frmEditWorkShift').action=baseUrl+'Edit_Work_Shift';
	$('frmEditWorkShift').submit();
}

function assignEmployee() {
	moveSelectOptions($('cmbAvailableEmployees'), $('cmbAssignedEmployees'), '<?php echo $lang_Time_Error_NoEmployeeSelected; ?>');
}

function removeEmployee() {
	moveSelectOptions($('cmbAssignedEmployees'), $('cmbAvailableEmployees'), '<?php echo $lang_Time_Error_NoEmployeeSelected; ?>');
}


    
//]]>
</script>

<div class="formpage">
  <div class="navigation">
    <input type="button" class="backbutton"
				onclick="goBack();" 
				value="<?php echo $lang_Common_Back;?>" />
  </div>
  <div class="outerbox">
    <div class="mainHeading">
      <h2><?php echo $lang_Time_AssignEmployeesTitle;?></h2>
    </div>
    <?php
            if (isset($_GET['message']) && !empty($_GET['message'])) {            
                $message  = $_GET['message'];
                $messageType = CommonFunctions::getCssClassForMessage($message);
                $message = "lang_Time_Errors_" . $message;
        ?>
    <div class="messagebar"> <span class="<?php echo $messageType; ?>"><?php echo (isset($$message)) ? $$message: CommonFunctions::escapeHtml($_GET['message']); ?></span> </div>
    <?php } ?>
    <form name="frmEditWorkShift" id="frmEditWorkShift" method="post" action="?timecode=Time&action=">
      <label for="txtShiftName"><?php echo $lang_Time_ShiftName; ?><span class="required">*</span></label>
      <input type="text" id="txtShiftName" name="txtShiftName" tabindex="1" value="<?php echo $workshift->getName(); ?>"
                class="formInputText"/>
      <br class="clear"/>
      <label for="txtHoursPerDay"><?php echo $lang_Time_HoursPerDay; ?><span class="required">*</span></label>
      <input type="text" id="txtHoursPerDay" name="txtHoursPerDay" tabindex="2" size="3" value="<?php echo $workshift->getHoursPerDay(); ?>"
                class="formInputText" style="width:30px;"/>
      <input type="hidden" id="txtShiftId" name="txtShiftId" value="<?php echo $workshift->getWorkshiftId(); ?>"/>
      <br class="clear"/>
      <div class="formbuttons">
        <input type="button" class="savebutton" <?php echo $disabled; ?>
                    onclick="upateShift();"                          
                    value="<?php echo $lang_Common_Save;?>" />
      </div>
      <br class="clear"/>
      <table border="0">
        <tr>
          <th width="100" style="align:center;"><?php echo $lang_Time_AvailableEmployees; ?></th>
          <th width="100"/>
          <th width="125" style="align:center;"><?php echo $lang_Time_AssignedEmployees; ?></th>
        </tr>
        <tr>
          <td width="100" ><select size="10" id="cmbAvailableEmployees" name="cmbAvailableEmployees[]" <?php echo $disabled; ?>
				style="width:125px;" multiple="multiple">
              <?php
       				foreach($availableEmployees as $employee) {
       					$empNum = $employee['emp_number'];
       					$name = $employee['emp_firstname'] . " " . $employee['emp_lastname'];
           				echo "<option value='{$empNum}'>{$name}</option>";
       				}
				?>
            </select></td>
          <td align="center" width="100"><input type="button" <?php echo $disabled; ?> name="btnAssignEmployee" id="btnAssignEmployee" class="plainbtn"
					onclick="assignEmployee();" value=" <?php echo $lang_compstruct_add; ?> >" style="width:80%" />
            <br />
            <br />
            <input type="button" <?php echo $disabled; ?> name="btnRemoveEmployee" id="btnRemoveEmployee" class="plainbtn"
					onclick="removeEmployee();" value="< <?php echo $lang_Leave_Common_Remove; ?>" style="width:80%" />
          </td>
          <td><select size="10" name="cmbAssignedEmployees[]" id="cmbAssignedEmployees" <?php echo $disabled; ?>
				style="width:125px;" multiple="multiple">
              <?php
       				foreach($assignedEmployees as $employee) {
       					$empNum = $employee['emp_number'];
       					$name = $employee['emp_firstname'] . " " . $employee['emp_lastname'];
           				echo "<option value='{$empNum}'>{$name}</option>";
       				}
				?>
            </select></td>
        </tr>
      </table>
    </form>
  </div>
  <script type="text/javascript">
//<![CDATA[
    if (document.getElementById && document.createElement) {
        roundBorder('outerbox');                
    }
//]]>
</script>
</div>
