<?php
/**
 * Class containing details of time spent on an activity
 */
 class ProjectActivityTime {

	/**
	 * Class Attributes
	 */
	protected $activityId;
	protected $activityName;
	protected $projectId;

	/** Time spent on activity, in seconds */
	protected $activityTime;

	public function setActivityId($activityId) {
		$this->activityId = $activityId;
	}

	public function getActivityId() {
		return $this->activityId;
	}

	public function setActivityName($activityName) {
		$this->activityName = $activityName;
	}

	public function getActivityName() {
		return $this->activityName;
	}

	public function setActivityTime($activityTime) {
		$this->activityTime = $activityTime;
	}

	public function getActivityTime() {
		return $this->activityTime;
	}

	public function setProjectId($projectId) {
		$this->projectId = $projectId;
	}

	public function getProjectId() {
		return $this->projectId;
	}

	/**
	 * Constructor
	 *
	 * @param int    $activityId Activity ID
	 * @param string $activityName Activity Name
	 * @param int    $activityTime The time spent on the activity (in seconds)
	 * @param int    $projectId The project to which this activity belongs
	 */
	public function __construct($activityId, $activityName, $activityTime, $projectId) {
		$this->activityId = $activityId;
		$this->activityName = $activityName;
		$this->activityTime = $activityTime;
		$this->projectId = $projectId;
	}

 }

?>
