<?php
require_once ROOT_PATH . '/lib/models/report/ReportModuleObject.php';

class ReportField extends ReportModuleObject {
    const SINGLE_VALUE = 'single-value';
    const COMPOSITE_VALUE = 'composite-value';
    const DIRECT_QUERY = 'direct-query';
    const SINGLE_REFERENCE = 'single-reference';
    const MULTIPLE_REFERENCE = 'multi-reference';

    const COMPOSITE_SEPARATOR = ', ';
    const GROUP_SEPARATOR = '[:]';
    const EMPTY_MARKER = '―';
    const LEFT_TABLE = 'hs_hr_employee';

    protected $dataValues = array (
        'type' => null,
        'table' => null,
        'field' => null,
        'pk' => null,
        'fk' => null,
		'ternaryTable' => null,
    );

    public function __construct($field, $type = self :: SINGLE_VALUE, $table = null, $pk = null, $fk = null, $ternaryTable = null) {
        $this->dataValues = array (
            'type' => $type,
            'table' => $table,
            'field' => $field,
            'pk' => $pk,
            'fk' => $fk,
			'ternaryTable' => $ternaryTable,
        );
    }

    public function __toString() {
        return $this->dataValues['field'];
    }
}
