<?php
require_once ROOT_PATH . '/lib/common/CommonFunctions.php';
require_once ROOT_PATH . '/lib/models/hrfunct/AbstractEmpHistory.php';

/**
 * Manages history of employee sub divisions
 */
class SubDivisionHistory extends AbstractEmpHistory {

    protected $tableName = 'hs_hr_emp_subdivision_history';
    protected $externalTable = 'hs_hr_compstructtree';
    protected $externalCodeField = 'id';
    protected $externalNameField = 'title';

    protected $allowMultipleCurrentItems = false;

    /**
     * Validate the code
     *
     * @param mixed $code Code
     * @return boolean true if code valid, false otherwise
     */
    protected function validateCode($code) {
        return CommonFunctions::isValidId($code);
    }

}

?>
