<?php
require_once ROOT_PATH . '/lib/common/CommonFunctions.php';
require_once ROOT_PATH . '/lib/models/hrfunct/AbstractEmpHistory.php';

/**
 * Job title history class, manages history of employee job titles.
 */
class JobTitleHistory extends AbstractEmpHistory {

    protected $tableName = 'hs_hr_emp_jobtitle_history';
    protected $externalTable = 'hs_hr_job_title';
    protected $externalCodeField = 'jobtit_code';
    protected $externalNameField = 'jobtit_name';

    protected $allowMultipleCurrentItems = false;

    /**
     * Validate the code
     *
     * @param mixed $code Code
     * @return boolean true if code valid, false otherwise
     */
    protected function validateCode($code) {
        return CommonFunctions::isValidId($code, 'JOB');
    }

}

?>
