<?php
 require_once 'Auditor.php';
 require_once 'FileLogger.php';

 class AuditorFactory {
 	private static $instance;
 	private $propertyReader;

 	private function __construct($propertyReader) {
 		if(!isset($propertyReader )){
 			return;
 		}
 		$this->propertyReader = $propertyReader;
 	}

 	public static function getInstance($propertyReader=null) {
//		if(!isset($instance)) {
//			$instance = new AuditorFactory($propertyReader);
//		}

		return new AuditorFactory($propertyReader);
 	}

 	public function getAuditor($name) {
		$type = Auditor::getType($name, $this->propertyReader);

		if (isset($type)) {
			switch ($type) {
				case Auditor::TYPE_FILELOGGER :
					return new FileLogger($name, $this->propertyReader);
					break;
				default:
					break;
			}
		}
		return null;
 	}


 }
?>
