<?php
require_once ROOT_PATH . '/lib/models/time/Timesheet.php';
require_once ROOT_PATH . '/lib/models/time/TimesheetSubmissionPeriod.php';
require_once ROOT_PATH . '/lib/common/LocaleUtil.php';

class EXTRACTOR_Timesheet {

	private $parent_Timesheet;

	public function __construct() {
		//nothing to do
	}

	public function parseViewData($postArr) {

		$this->parent_Timesheet = new Timesheet();

		if (isset($postArr['txtStartDate'])) {
			$this->parent_Timesheet->setStartDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtStartDate']));
		}

		if (isset($postArr['txtEndDate'])) {
			$this->parent_Timesheet->setEndDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtEndDate'])." 23:59:59");
		}

		if (isset($postArr['txtTimesheetPeriodId'])) {
			$this->parent_Timesheet->setTimesheetPeriodId($postArr['txtTimesheetPeriodId']);
		}

		if (isset($postArr['txtTimesheetId'])) {
			$this->parent_Timesheet->setTimesheetId($postArr['txtTimesheetId']);
		}

		if (isset($postArr['txtEmployeeId'])) {
			$this->parent_Timesheet->setEmployeeId($postArr['txtEmployeeId']);
		} else if (isset($postArr['txtRepEmpID'])) {
			$this->parent_Timesheet->setEmployeeId($postArr['txtRepEmpID']);
		} else if (isset($_SESSION['empID'])){
			$this->parent_Timesheet->setEmployeeId($_SESSION['empID']);
		}

		return $this->parent_Timesheet;
	}

	public function parseViewDataWithTimezoneDiff($clientStartDate, $clientEndDate, $timesheetPeriodId) {
		$this->parent_Timesheet = new Timesheet();

		$this->parent_Timesheet->setStartDate(LocaleUtil::getInstance()->convertToStandardDateFormat($clientStartDate));

		$this->parent_Timesheet->setEndDate(LocaleUtil::getInstance()->convertToStandardDateFormat($clientEndDate)." 23:59:59");

		$this->parent_Timesheet->setTimesheetPeriodId($timesheetPeriodId);

		$this->parent_Timesheet->setEmployeeId($_SESSION['empID']);

		return $this->parent_Timesheet;
	}

	public function parseChangeStatusData($postArr) {
		$this->parent_Timesheet = new Timesheet();

		$this->parent_Timesheet->setTimesheetId($postArr['txtTimesheetId']);

		if (isset($postArr['txtComment'])) {
			$this->parent_Timesheet->setComment($postArr['txtComment']);
		}

		return $this->parent_Timesheet;
	}

}
?>
