<?php
 require_once ROOT_PATH . '/lib/common/SearchObject.php';

 class EXTRACTOR_ViewList {

	/**
	 * Parse request data and return a SearchObject
	 *
	 * @param Array $postArr Array of POST variables
	 * @param Array $getArr Array of GET variables
	 *
	 * @return SearchObject Search object with parsed data
	 */
	public function parseSearchData($postArr, $getArr) {

		$searchObject = new SearchObject();

        $pageNo = isset ($postArr['pageNO']) ? (int) $postArr['pageNO'] : 1;
        $searchObject->setPageNumber($pageNo);

        if (isset ($postArr['captureState']) && ($postArr['captureState'] == 'SearchMode')) {

            $searchField = $postArr['loc_code'];
            $searchString = trim($postArr['loc_name']);

            $searchObject->setSearchField($searchField);
            $searchObject->setSearchString($searchString);
        }

        if (!isset ($getArr['sortField'])) {
            $getArr['sortField'] = 0;
        }
        $sortOrderField = 'sortOrder' . $getArr['sortField'];

        if (!isset ($getArr[$sortOrderField])) {
            $getArr[$sortOrderField] = 'ASC';
        }

        $sortField = $getArr['sortField'];
        $sortOrder = $getArr[$sortOrderField];

		$searchObject->setSortField($sortField);
		$searchObject->setSortOrder($sortOrder);

		return $searchObject;
	}

}
?>