<?php
require_once ROOT_PATH . '/lib/models/eimadmin/encryption/KeyHandler.php';

class CryptoQuery {

	public static function isEncTable($table) {

		if (strtolower($table) == "hs_hr_employee" || strtolower($table) == "hs_hr_emp_basicsalary") {
		    return true;
		} else {
		    return false;
		}

	}

	public static function prepareDecryptFields($decryptFieldsArray) {
		$encOn = KeyHandler::KeyExists();
		foreach ($decryptFieldsArray as $field) { 
			if ($encOn && self::isEncField($field)) {
				$key = KeyHandler::readKey();
			    $fieldsArray[] = "AES_DECRYPT(`$field`, '$key')";
			} else {
			    $fieldsArray[] = $field;
			}
		}
		return $fieldsArray;
	}
	
	public static function prepareEncryptFields($encryptFieldsArray, $encryptValuesArray) {
		$encOn = KeyHandler::KeyExists();
		
		$valuesArray = array();
		
		$encryptFieldsArrayCount = count($encryptFieldsArray);
		
		for ($i = 0; $i < $encryptFieldsArrayCount; $i++) { 
			if ($encOn && self::isEncField($encryptFieldsArray[$i])) {
				
				$key = KeyHandler::readKey();
				
				if ($encryptValuesArray[$i] == null)
					$valuesArray[$i] = null;
				else
				    $valuesArray[$i] = "AES_ENCRYPT($encryptValuesArray[$i], '$key')";
			    
			} else {
			    $valuesArray[$i] = $encryptValuesArray[$i];
			}
		}
		return $valuesArray;
	}	

	public static function isEncField($field) {
	    if (strtolower($field) == "emp_ssn_num" || strtolower($field) == "ebsal_basic_salary") {
			return true;
	    } else {
			return false;
	    }
	}

}

?>
