<?php

    include_once('../class/include.php');
    $inc = new Includer();
    $inc->auth();
    $inc->template();
    $inc->assign();

    // Check to see if the person is not logged in
    $GLOBALS['auth']->check_logout();

    // Define the three sets of links in the template
    if ($GLOBALS['auth']->admin()) {
        $GLOBALS['template']->links('conf', 'conf');
    } else {
        header('Location: '.$GLOBALS['conf']['url'].'/admin/notes.php');
    }

    $GLOBALS['template']->assign('links_main', array(
        array('title' => $GLOBALS['lang']['view_all'], 'url' => $GLOBALS['conf']['url'].'/admin/assigns.php'),
        array('title' => $GLOBALS['lang']['operators'], 'url' => $GLOBALS['conf']['url'].'/admin/operators.php'),
        array('title' => $GLOBALS['lang']['departments'], 'url' => $GLOBALS['conf']['url'].'/admin/departments.php')
        ));

    if (isset($_POST['edit'])) {
        $GLOBALS['template']->assign('text', $GLOBALS['lang']['assigns_updated']);
        $GLOBALS['assign']->delete_department(addslashes($_POST['id']));
        // Loop through all the posted variables. Ones that have their name and values as numbers
        // are departments being assigned
        foreach ($_POST as $key => $val) {
            if (is_numeric($key) && is_numeric($val) && is_numeric($_POST['poll_'.$key])) {
                $GLOBALS['assign']->insert($key, $val, $_POST['poll_'.$key]);
            }
        }
    } else {
        $GLOBALS['template']->assign('text', '');
    }

    // Grab a list of the assigns already in place
    $GLOBALS['template']->assign('assigns', $GLOBALS['assign']->listall());

    // Assign the page's title and the content template that needs to be used
    $GLOBALS['template']->assign('title', $GLOBALS['lang']['assigns']);
    $GLOBALS['template']->assign('content', 'admin_assigns.tpl');

    // Include the javascript files
    $GLOBALS['template']->assign('javascript', 'misc');

    // Display the output
    $GLOBALS['template']->display('admin.tpl');

    // do events that need to be done at the end of the file
    $inc->finished();
    
?>