import store from './store';
import ComponentMixin from './mixins';

const invoice = {};
const invoiceOptions = {
  companies: [],
  services_list: [],
  invoice_no: '',
  company: '',
  services: [],
};

invoice.install = (Vue, optionsOut) => {
  const options = Object.assign({}, invoiceOptions, optionsOut);

  if (options.invoice_no) {
    store.init('invoice_no', options.invoice_no);
  }
  if (options.company) {
    store.init('company', options.company);
  }
  if (options.services) {
    store.init('services', options.services);
  }
  if (options.companies) {
    store.init('companies', options.companies);
  }
  if (options.services_list) {
    store.init('services_list', options.services_list);
  }
};

export {
  invoice
};
export {
  ComponentMixin
};
