<?php
class template extends database {
    var $cols;
    var $rows;
    //---------------------------------------------------------------------------------    
    function init($db_host, $db_name, $db_user, $db_pass) {
        database::init($db_host, $db_name, $db_user, $db_pass);
        $this->rows = 10;
        $this->cols = 60;
    }
    //----------------------------------------------------------------------------------
    /*This function would read a file and return the contents to the user as a variable string*/
    function return_file_content($file_path) {
        $handle    = @fopen($file_path, "r");
        $file_size = filesize($file_path);
        if ($file_size > 0) {
            $contents = @fread($handle, $file_size);
        } else {
            $contents = "";
        }
        @fclose($handle);
        return $contents;
    }
    //------------------------------------------------------------------------------------
    /*This function would replace the {{}} kind of tag attributes with data from the language files and database*/
    function direct_replace($content, $array = array()) {
        global $generic_msg;
        $object_vars = get_object_vars($this);
        extract($object_vars);
        
        if (count($generic_msg) > 0) {
            foreach ($generic_msg as $key => $value) {
                $$key = stripslashes($value);
            }
        }
        if (count($array) > 0) {
            foreach ($array as $key => $value) {
                $$key = stripslashes($value);
            }
        }

        //$content = preg_replace("/\{\{(.*?)\}\}/", "$$1", $content);
		preg_match_all('/\{\{(.*?)\}\}/', $content, $matches);
		$tmp_array = array();
		foreach ($matches[0] as $index => $var_name) {
			$tmp_var_name = $matches[1][$index];
			if (isset($$tmp_var_name)) {
			   $tmp_array[$tmp_var_name] = $$tmp_var_name;
			} else {
				$tmp_array[$tmp_var_name] = '';
			}
		}
		
		$content = preg_replace_callback("/\{\{(.*?)\}\}/",
							 function($m) use ($tmp_array) { return $tmp_array[$m[1]]; },
							 $content);
		
        return $content;
    }
    //------------------------------------------------------------------------------------
    /* API Library to replace a one dimensional array in tpl files*/
    function replace_oned_array($loop_array, $template, $sel_arr = array(), $eval_code = array(), $start_tag = '<{', $end_tag = '}>') {
        if (!is_array($loop_array)) {
            die('Sorry! Invalid parameter to <i><b>replace_oned_array</b></i> function.<br> first argument should be <u>an array</u>');
        }
        while (list($loop_index, $oned_array) = @each($loop_array)) {
            if (!is_string($loop_index)) {
                die('Sorry! Invalid loop index to <i><b>replace_oned_array</b></i> function.');
            }
            $temp_start = $start_tag . $loop_index . 'loopstart' . $end_tag;
            $temp_end   = $start_tag . $loop_index . 'loopend' . $end_tag;
            $tmp_eval   = $eval_code[$loop_index];
            $tmpsel_arr = $sel_arr[$loop_index];
            $selected   = "";
            if (count($oned_array) > 0) {
                preg_match("/$temp_start(.*?)$temp_end/s", $template, $mat);
                $mat      = $mat[1];
                $temp_str = '';
                $l_array  = array_keys($oned_array);
                for ($i = 0; $i < count($l_array); $i++) {
                    $index          = $l_array[$i];
                    $variable_name  = substr($loop_index, 0, -1);
                    $$variable_name = $oned_array[$index];
                    if (@in_array($index, $tmpsel_arr) or @in_array($$variable_name, $tmpsel_arr)) {
                        $selected = "selected";
                    } else {
                        $selected = "";
                    }
                    if (is_string($tmp_eval)) {
                        eval($tmp_eval);
                    }
                    //$temp_str .= preg_replace("/$start_tag(.*?)$end_tag/e", "$$1", $mat);
					preg_match_all("/$start_tag(.*?)$end_tag/", $mat, $matches);
					$tmp_array = array();
					foreach ($matches[0] as $_index => $var_name) {
						$tmp_var_name = $matches[1][$_index];
						if (isset($$tmp_var_name)) {
						   $tmp_array[$tmp_var_name] = $$tmp_var_name;
						} else {
							$tmp_array[$tmp_var_name] = '';
						}
					}
					
					$temp_str .= preg_replace_callback("/$start_tag(.*?)$end_tag/",
										 function($m) use ($tmp_array) { return $tmp_array[$m[1]]; },
										 $mat);
                }
                $template = preg_replace("/$temp_start(.*?)$temp_end/s", $temp_str, $template);
            } else {
                $template = preg_replace("/$temp_start(.*?)$temp_end/s", '', $template);
            }
        }
        return $template;
    }
    //---------------------------------------------------------------------------------------    
	function timer() {
		static $start;
	
		if (is_null($start)) {
			$start = microtime(true);
		} else {
			$diff = round((microtime(true) - $start), 4);
			$start = null;
			return $diff;
		}
	}
}