<?php
class Manage {
	function __construct() {
			
	}
	
	function set_search_type($a_predefined) {
		$get_vars=$a_predefined['get'];
		if(isset($get_vars['typeofsearch']) and $get_vars['typeofsearch']=="customsearch") {
			$_SESSION['typeofsearch']="customsearch";
		} elseif(isset($get_vars['typeofsearch']) and $get_vars['typeofsearch']=="simplesearch") {
			$_SESSION['typeofsearch']="simplesearch";
		}
	}
	
	function get_hidescript($a_predefined) {
		$this->set_search_type($a_predefined);
		$typeofsearch = $hidedivscript = "";
		if(isset($_SESSION['typeofsearch'])) {	
			$typeofsearch = $_SESSION['typeofsearch'];
		}
		if($typeofsearch=="customsearch") {
			$hidedivscript.=" show_custom_search(); ";
		} else {
			$hidedivscript.=" show_simple_search(); ";
		}
	return $hidedivscript;
	}

	function is_logged_in($supp_obj, $staff_id) {
		$time = time();
		$min = 15*60;
		$staffsession = $supp_obj->prefix_table("staffsession");
		$sql="select staff_id from $staffsession where '$time' - lastloggedin <='$min' and  staff_id ='$staff_id'  ";
		$a_sql = $supp_obj->get_a_line($sql);
		if($a_sql['staff_id'] != "") {
			return true;
		} else {
			return false;
		}
	}

	function for_super_admin($supp_obj, $staff_id, $content) {
		$staff=$supp_obj->prefix_table("staff");
		$sql="select is_admin from $staff where staff_id='$staff_id'";
		$a_sql=$supp_obj->get_a_line($sql);
		if($a_sql['is_admin'] == "1") {
			$content=preg_replace("/\<\{admin_(.*?)\}\>/is","",$content);	
		} else {
			$content = preg_replace("/\<\{admin_start\}\>(.*?)\<\{admin_end\}\>/is","",$content);
		}
		return $content;
	}	
		
	function filter_routing($supp_obj, $content) {
		$config = $supp_obj->prefix_table("configuration");
		$sql = "select allow_routing from $config";
		$a_config = $supp_obj->get_a_line($sql);
		if($a_config['allow_routing'] == "n") {
			$content=preg_replace("/\<\{routing_start\}\>(.*?)\<\{routing_end\}\>/is","",$content);
		} else {
			$content = preg_replace("/\<\{routing_(.*?)\}\>/is","",$content);	
		}
		return $content;
	}

	function filter_restricted_admin($supp_obj, $content) {
		$staff = $supp_obj->prefix_table("staff");
		$sql = "select is_admin,allow_canned,allow_staff,all_dept from $staff where staff_id='".$_SESSION['staff_id']."'";
		$a_config = $supp_obj->get_a_line($sql);
		
		if(isset($a_config['is_admin']) && $a_config['is_admin'] == "1") {
			$content=@preg_replace("/\<\{allowcanned_(.*?)\}\>/is","",$content);
			$content=@preg_replace("/\<\{allowstaff_(.*?)\}\>/is","",$content);	
			$content=@preg_replace("/<{adminscript}>/is","settings",$content);
		} else {
			if(isset($a_config['allow_canned']) && $a_config['allow_canned'] == "y") {
				$content = @preg_replace("/\<\{allowcanned_(.*?)\}\>/is","",$content);
			} else {
				$content = @preg_replace("/\<\{allowcanned_start}>(.*?)<{allowcanned_end\}\>/is","",$content);
			}
			
			if(isset($a_config['allow_staff']) && $a_config['allow_staff'] == "y") {
				$content=@preg_replace("/\<\{allowstaff_(.*?)\}\>/is","",$content);
			} else {
				$content=@preg_replace("/\<\{allowstaff_start}>(.*?)<{allowstaff_end\}\>/is","",$content);
			}
			
			if(isset($a_config['allow_canned']) && $a_config['allow_canned'] != "y" && $a_config['allow_staff'] != "y") {
				$content=@preg_replace("/<{adminscript}>/is","",$content);
			} elseif(isset($a_config['allow_canned']) && $a_config['allow_canned'] == "y" && $a_config['allow_staff'] == "n") {
				$content=@preg_replace("/<{adminscript}>/is","replies",$content);
			} elseif(isset($a_config['allow_canned']) && $a_config['allow_canned'] == "n" && $a_config['allow_staff'] == "y") {	
				$content=@preg_replace("/<{adminscript}>/is","staff",$content);
			} else {
				$content=@preg_replace("/<{adminscript}>/is","staff",$content);
			}
		}
		return $content;
	}

	function filter_assign($status,$content) {
		if($status == "C") {
			$content = @preg_replace("/<{assignneeded_start}>(.*?)<{assignneeded_end}>/is","",$content);
		} else {
			$content = @preg_replace("/<{assignneeded_(.*?)}>/is","",$content);
		}
		return $content;
	}

	/*Return date range for a selected value in preset pulldown*/
	function return_date_range($supp_obj,$a_predefined,$generic_msg) {
	$session_vars = $a_predefined['session'];
	$post_vars = $a_predefined['post'];
	@extract($post_vars);
	
	// find out preferred timezone
	$zone = $session_vars['zone'];
	
	// Correct timestamp according to that
	$timestamp = $supp_obj->get_corrected_timestamp($zone,gmdate("Y"),gmdate("m"),gmdate("d"),gmdate("H"),gmdate("i"),gmdate("s"),2);
	$cwkday = @gmdate("w",$timestamp);	
	$datetime = @gmdate("Y-m-d H:i:s",$timestamp);
	
	list($d_array, $t_array) = preg_split("/[ ]+s/",$datetime,-1,PREG_SPLIT_NO_EMPTY);
	list($cyear, $cmon, $cday) = explode("-", $d_array);
	list($chour, $cmin, $csec) = explode(":", $t_array);
	
	// find out the date range for a selected value of preset range
	switch($preset) {
		case "tw": // this week
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday-$cwkday,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday+6-$cwkday,$cyear));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday-$cwkday,$cyear))."-";	
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday+6-$cwkday,$cyear));
				break;	
		case "lw": // last week
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday-$cwkday-7,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday+6-$cwkday-7,$cyear));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday-$cwkday-7,$cyear))."-";	
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday+6-$cwkday-7,$cyear));
				break;	
		case "lbw": //last business week
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday-$cwkday-6,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday+6-$cwkday-8,$cyear));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday-$cwkday-6,$cyear))."-";	
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday+6-$cwkday-8,$cyear));
				break;	
		case "y": // Yesterday 
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday-1,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday-1,$cyear));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday-1,$cyear));	
				$enddisplay="";
				break;	
		case "td":
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday,$cyear));
				$startdisplay=@gmdate("d F Y ",gmmktime(0,0,0,$cmon,$cday,$cyear));	
				$enddisplay="";
				break;	
		case "p":
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,date("m")-1,1,date("Y")));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon-1,1,$cyear))."-";
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,date("m"),0,date("Y")));
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,0,$cyear));
				break;	
		case "a":
				$tickets=$supp_obj->prefix_table("tickets");
				$sql="select ticket_id, ".$supp_obj->add_offsetNformat("sent_date",$zone,"minute","ticket_created")." from $tickets order by ticket_created asc limit 0 ,1 ";
				$a_sql=$supp_obj->get_a_line($sql);
				
				if($a_sql['ticket_id'] == "") {	// No tickets created till now .. so better show the current date as from date also
					$timestamp=$supp_obj->get_corrected_timestamp($zone,gmdate("Y"),gmdate("m"),gmdate("d"),gmdate("h"),gmdate("i"),gmdate("s"),2);
					$cwkday=@gmdate("w",$timestamp);	
					$a_sql['ticket_created']=@gmdate("Y-m-d H:i:s",$timestamp);
				}
				list($d_array,$t_array)=preg_split("/[ ]+s/",$a_sql['ticket_created'],-1,PREG_SPLIT_NO_EMPTY);
				list($cyear1,$cmon1,$cday1)=explode("-",$d_array);
				list($chour1,$cmin1,$csec1)=explode(":",$t_array);
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon1,$cday1,$cyear1));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday,$cyear));
				$startdisplay=@gmdate("d F Y ",gmmktime(0,0,0,$cmon1,$cday1,$cyear1))." -";	
				$enddisplay=@gmdate("d F Y ",gmmktime(23,59,0,$cmon,$cday,$cyear));	
				break;
		case "m":
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,1,date("Y")));
				$startdisplay=@gmdate("d, F Y",gmmktime(0,0,0,$cmon,1,date("Y")))."-";
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon+1,0,date("Y")));
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon+1,0,date("Y")));
				break;
		case "l30":	// last 30 days
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday-30,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday,$cyear));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday-30,$cyear))."-";	
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday,$cyear));
				break;	
		case "l7":	// last 7 days
		default:
				$start=@gmdate("Y-m-d H:i:s",gmmktime(0,0,0,$cmon,$cday-6,$cyear));	
				$end=@gmdate("Y-m-d H:i:s",gmmktime(23,59,0,$cmon,$cday,$cyear));
				$startdisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday-6,$cyear))."-";	
				$enddisplay=@gmdate("d F Y",gmmktime(0,0,0,$cmon,$cday,$cyear));
				break;	
		}

		$return_array=array();
		$return_array['start']=$start;
		$return_array['startdisplay']=$startdisplay;
		$return_array['end']=$end;
		$return_array['enddisplay']=$enddisplay;
		return $return_array;			
	}

	// Function: Mark a ticket as resolution
	function mark_as_resolution($supp_obj,$ticket_id,$reply_id) {
		$ticket_replies=$supp_obj->prefix_table("ticket_replies");
	 	$sql="update $ticket_replies set resolution_item='1' where ticket_id='$ticket_id' and reply_id='$reply_id'";
		$supp_obj->execute_query($sql);
		$activity_array=array("ticket_id"=>$ticket_id,"resolution"=>$reply_id,"resolutiontype"=>"mark");
		$supp_obj->log_activity($activity_array,$_SESSION['staff_id'],"STAFF");	
		return "cMarked_as_resolution";		
	}

	// Function: UnMark a ticket as resolution
	function unmark_as_resolution($supp_obj,$ticket_id,$reply_id) {
		$ticket_replies=$supp_obj->prefix_table("ticket_replies");
	 	$sql="update $ticket_replies set resolution_item='0' where ticket_id='$ticket_id' and reply_id='$reply_id'";
		$supp_obj->execute_query($sql);
		$activity_array=array("ticket_id"=>$ticket_id,"resolution"=>$reply_id,"resolutiontype"=>"unmark");
		$supp_obj->log_activity($activity_array,$_SESSION['staff_id'],"STAFF");	
		return "cUnmarked_as_resolution";		
	}

	function date_filter_for_ageing_report($supp_obj,$column_name,$timeperiod) {
		$from_date="";
		$to_date="";
		$where_clause="";
		$zone=$_SESSION['zone'];
		$current_date=$supp_obj->get_current_date($zone,'d');
		$from_time=" 00:00:00";
		$to_time=" 23:59:00";
		switch($timeperiod) {
			case "24hours":
				$from_date=$current_date.$from_time;
				$to_date=$current_date.$to_time;
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";				
			break;
			case "1day":
				$date=$supp_obj->get_db_date($zone,-1);	
				$from_date=$date.$from_time;
				$to_date=$date.$to_time;
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";	
			break;
			case "1to2days":
				$date=$supp_obj->get_db_date($zone,-2);	
				$from_date=$date.$from_time;
				$to_date=$date.$to_time;
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";	
			break;	
			case "2to3days":
				$date=$supp_obj->get_db_date($zone,-3);	
				$from_date=$date.$from_time;
				$to_date=$date.$to_time;
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";	
			break;
			case "3to5days":
				$from_date=$supp_obj->get_db_date($zone,-5).$from_time;	
				$to_date=$supp_obj->get_db_date($zone,-4).$to_time;	
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";		
			break;
			case "5to10days":
				$from_date=$supp_obj->get_db_date($zone,-10).$from_time;	
				$to_date=$supp_obj->get_db_date($zone,-6).$to_time;	
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";	
			break;
			case "10to24days":
				$from_date=$supp_obj->get_db_date($zone,-24).$from_time;	
				$to_date=$supp_obj->get_db_date($zone,-11).$to_time;	
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";		
			break;
			case "24to54days":
				$from_date=$supp_obj->get_db_date($zone,-54).$from_time;	
				$to_date=$supp_obj->get_db_date($zone,-25).$to_time;	
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";	
			break;
			default:
				$from_date=$supp_obj->get_db_date($zone,-54).$from_time;
				$to_date=$current_date.$to_time;
				$where_clause.="and ( (".$supp_obj->date_add_sql($column_name,$zone,'minute')." between '$from_date' and '$to_date') ) ";
			break;	
		}

		$return_array['where_clause']=$where_clause;
		$return_array['from_date']=$from_date;
		$return_array['to_date']=$to_date;
		return $return_array;
	}

	function create_group($supp_obj,$a_predefined,$generic_msg) {
		$post_vars=$a_predefined['post'];
		@extract($post_vars);	
		$groups=$supp_obj->prefix_table("groups");
		$deptgroups=$supp_obj->prefix_table("deptgroups");
		$sql="select group_id from $groups where group_name='$group_name' ";
		$a_group=$supp_obj->get_a_line($sql);
		$return_array=array();
		if($a_group['group_id']!="") {
			$return_array['status']=false;
			$return_array['status_msg']='cDup_groupname';
			return $return_array;	
		}		
	
		$sql=" insert into $groups (group_name) values ('$group_name') ";
		$group_id=$supp_obj->execute_query($sql);
		for($i=0; $i < count($dept_ids); $i++) {
			$id=$dept_ids[$i];
			$sql=" insert into $deptgroups (gdept_id, ggroup_id) values ('$id','$group_id') ";
			$supp_obj->execute_query($sql);
		}
		$return_array['status']=true;
		$return_array['status_msg']='cGroup_added';
		return $return_array;	
	}

	function delete_group($supp_obj,$a_predefined,$generic_msg) {
		$post_vars=$a_predefined['post'];
		@extract($post_vars);	
		$get_vars=$a_predefined['get'];
		$groups=$supp_obj->prefix_table("groups");
		$deptgroups=$supp_obj->prefix_table("deptgroups");
		$group_id=$get_vars['group_id'];
		$sql="delete from $groups where group_id='$group_id' ";
		$supp_obj->execute_query($sql);	
		$sql="delete from $deptgroups where ggroup_id='$group_id'";
		$supp_obj->execute_query($sql);
		$return_array['status']=true;
		$return_array['status_msg']='cGroup_deleted';
		return $return_array;	
	}

	function format_time($tsp) {
		$time=0;
		if($tsp < 60)	 {
			$time=round($tsp);
			if($time==1) { $time.= " second"; } else { $time.=" seconds"; }

		} elseif($tsp >= 60 and $tsp < 3600) {
			$time=round($tsp/60);
			if($time==1) { $time.= " minute"; } else { $time.=" minutes"; }
		} elseif($tsp >= 3600 and $tsp < 86400) {
			$time=round($tsp/3600);
			if($time==1) { $time.= " hour"; } else { $time.=" hours"; }
		} else {
			$time=round($tsp/86400);
			if($time==1) { $time.= " day"; } else { $time.=" days"; }
		}
		return $time;
	}

	function submit_stats_settings($supp_obj,$a_predefined,$generic_msg,$timezones_array,$return_array) {
		$post_vars=$a_predefined['post'];
		@extract($post_vars);
		$statssettings=$supp_obj->prefix_table("statssettings");
		$sql="update $statssettings set exclude_weekends='$exclude_weekend', time_zone='$time_zone' ";
		$supp_obj->execute_query($sql);
		$return_array['status']=true;
		$return_array['status_msg']='cStats_saved';
		return $return_array;
	}

	function workday($date, $begindate = TRUE)  {
		$adate = getdate($date);
		$day = 24 * 60 * 60;
		if ($adate['wday'] == 0) // Sunday
			$date += $begindate ? $day : -($day * 2);
		elseif ($adate['wday'] == 6) // Saterday
			$date += $begindate ? $day * 2 : -$day;
		return $date;
	}

	function businessdays($begin, $end) {
		$rbegin = is_string($begin) ? strtotime(strval($begin)) : $begin;
		$rend = is_string($end) ? strtotime(strval($end)) : $end;
		//echo "rbegin=$rbegin ";
		if ($rbegin < 0 || $rend < 0)
			return 0;
	
		$begin = $this->workday($rbegin, TRUE);
		$end = $this->workday($rend, FALSE);
	
		if ($end < $begin) {
			$end = $begin;
			$begin = $end;
		}
	
		$difftime = $end - $begin;
		$diffdays = floor($difftime / (24 * 60 * 60)) ;
	
		if ($diffdays < 7) {
			$abegin = getdate($rbegin);
			$aend = getdate($rend);
			if ($diffdays == 1 && ($abegin['wday'] == 0 || $abegin['wday'] == 6) && ($aend['wday'] == 0 || $aend['wday'] == 6))
				return 0;
			$abegin = getdate($begin);
			$aend = getdate($end);
			$weekends = ($aend['wday'] < $abegin['wday']) ? 1 : 0;
		} else
			$weekends = floor($diffdays / 7);
	
		$days=$diffdays - ($weekends * 2);
		$seconds=$days*24*60*60;
		$st_week_day=gmdate('w',$rbegin);
		$ed_week_day=gmdate('w',$rend);
		
		if($diffdays==0) {	// Solved in less than 24 hours
			$seconds=$end-$begin;
		} else {
			// adjust for hours and minutes
			if($st_week_day!=6 and $st_week_day!=0) {
				list($y,$m,$d,$h,$i,$s)=explode("/",gmdate('Y/m/d/H/i/s',$begin));	
				$beginstart=mktime(0,0,0,$m,$d,$y);
				// Subtract time elapsed from the start of the day till the time the ticket came in
				$seconds = $seconds - ($begin - $beginstart);
			}
			list($y,$m,$d,$h,$i,$s)=explode("/",gmdate('Y/m/d/H/i/s',$end));	
			$endstart=mktime(0,0,0,$m,$d,$y);
			// Add time spent on the ticket at the last day of closing the ticket.
			$seconds= $seconds + ($end - $endstart);
		}
		
		if($ed_week_day == 6 or $ed_week_day==0) {
			list($y,$m,$d,$h,$i,$s)=explode("/",gmdate('Y/m/d/H/i/s',$end));	
			$endstop=mktime(24,0,0,$m,$d,$y);
			$seconds=$seconds + ($endstop-$end);
		}
		return $seconds;
	}

	function sort_group($supp_obj,$a_predefined,$generic_msg) {
		$post_vars=$a_predefined['post'];
		$dept_array=array();
		while(list($key,$value)=@each($post_vars)) {
			if(ereg("^grps",$key)) {
				list($s,$dept_id)=explode("_",$key);
				$dept_array[$dept_id]=$value;
			}
		}
		$departments=$supp_obj->prefix_table("departments");
		$dept_ids=@array_keys($dept_array);
		for($i=0;$i<count($dept_ids);$i++) {
			$dept_id=$dept_ids[$i];
			$group_number=$dept_array[$dept_id];
			$sql="update $departments set group_number='$group_number' where dept_id='$dept_id'";
			$supp_obj->execute_query($sql);
		}
		$return_array['status']=true;
		$return_array['status_msg']='cGroup_updated';	
		return $return_array;
	}
}
?>