<?php
include_once("session.php");
include_once("header.php");
include_once("nav.php");

class warranty {
	function view($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager) {
		$warranty = $supp_obj->prefix_table("warranty");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		
		$template = "../templates/admin/manage_warranty.tpl";
		$content = $supp_obj->return_file_content($template);
		$content = $manager->for_super_admin($supp_obj, $_SESSION['staff_id'], $content);
		
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		//subject line
		$sql = "SELECT *, IF(file != '', CONCAT('<a href=\"license_attachments.php?id=', warranty_id, '\" class=\"btn btn-info btn-sm\" target=\"_blank\">Download</a>'), '') AS download, IF(STR_TO_DATE(end_date, '%m-%d-%Y') <= NOW(), 'danger', '') AS expired_class, DATE_FORMAT(STR_TO_DATE(ship_date, '%m-%d-%Y'), '%M %d, %Y') AS shipdate, DATE_FORMAT(STR_TO_DATE(end_date, '%m-%d-%Y'), '%M %d, %Y') AS enddate FROM $warranty ";
		
		if(isset($get_vars['filter']) && isset($get_vars['months'])) {
			$end = date('Y-m-d 23:59:59', strtotime('+'.($get_vars['months']*30).' days'));
			$start = date('Y-m-d 00:00:00');
			
			$sql .= " WHERE STR_TO_DATE(end_date, '%m-%d-%Y') BETWEEN '".$start."' AND '".$end."'";
		}
		
		$sql .= " ORDER BY end_date ASC";
		$loop_sql['warranty_'] = $sql;
		$evalcode['warranty_'] = '';
		$a_content = $supp_obj->replace_loop($loop_sql,$content,$evalcode);
		$content = $a_content[0];
		
		$replace_array['status_msg'] = $a_predefined['status_msg'];
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		echo $content;
	}
	function viewForm($supp_obj, $a_predefined, $generic_msg) {
		$warranty = $supp_obj->prefix_table("warranty");
		$field_answers = $supp_obj->prefix_table("field_answers");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		
		$template = "../templates/admin/manage_warranty_add.tpl";
		$content = $supp_obj->return_file_content($template);
		
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		//subject line
		$replace_array = array();
		$selected = '';
		$replace_array['cAddEditWarranty'] = $generic_msg['cAddWarranty'];
		if(isset($get_vars['id'])) {
			$sql = "SELECT *, DATE_FORMAT(STR_TO_DATE(ship_date, '%m-%d-%Y'), '%M %d, %Y') AS shipdate, DATE_FORMAT(STR_TO_DATE(end_date, '%m-%d-%Y'), '%M %d, %Y') AS enddate FROM $warranty";
			$id = $get_vars['id'];
			$sql .= " WHERE warranty_id = '".$id."'";
			$replace_array = $supp_obj->get_a_line($sql);
			
			$selected = $replace_array['company'];
			$replace_array['cAddEditWarranty'] = $generic_msg['cEditWarranty'];
		}
		$sql = "SELECT * FROM $field_answers WHERE field_id = 6 ORDER BY field_answer";
		$results = $supp_obj->get_rsltset($sql);
		
		$company_field = "<select name=\"company\" id=\"company\" class=\"form-control required\"><option value=''>Choose Company</option>";
		for($o = 0; $o < count($results); $o++) {
			$sel = '';
			if($results[$o]['field_answer'] == $selected) {$sel = 'selected';}
			$company_field .= '<option value="'.$results[$o]['field_answer'].'"'.$sel.'>'.$results[$o]['field_answer'].'</option>';
		}	
		$company_field .= "</select>";
		
		$replace_array['company_field'] = $company_field;
		$replace_array['cWarrantyDeleteConfirm'] = $generic_msg['cWarrantyDeleteConfirm'];
		$replace_array['status_msg'] = $a_predefined['status_msg'];
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		
		echo $content;
	}
	function processWarranty($supp_obj, $a_predefined, $generic_msg) {
		$warranty = $supp_obj->prefix_table("warranty");
		
		//searchcust
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		$file_vars = $a_predefined['file'];
		$ren_msg = '';
		
		if(isset($post_vars['action']) && $post_vars['action'] == "warranty") {
			$attachment_name = '';
			if(count($file_vars) > 0) {
				$file_name = $file_vars['license']['name'];
				$new_name = md5(time());
				list($n, $ext) = split("\.", $file_name);
				$attachment_name = $new_name.".".$ext;
				$supp_obj->upload_file("license", $file_vars, $new_name, '', '../licenses');
			}
			
			if(isset($post_vars['warranty_id']) && !empty($post_vars['warranty_id'])) {
				$warranty_id = $post_vars['warranty_id'];
				$sql = "UPDATE $warranty SET company = '".$post_vars['company']."', brand = '".$post_vars['brand']."', model = '".$post_vars['model']."', description = '".$post_vars['description']."', service_tag = '".$post_vars['service_tag']."', ship_date = '".$post_vars['ship_date']."', end_date = '".$post_vars['end_date']."'";
				if($attachment_name) {
					$sql .= ", file = '".$attachment_name."'";
				}
				$sql .= " WHERE warranty_id = '".$warranty_id."'";
				$supp_obj->execute_query($sql);
				
				$ren_msg = $generic_msg['cWarrantyUpdatedSuccessfully'];
			} else {
				$sql = "INSERT INTO $warranty (company, brand, model, description, service_tag, ship_date, end_date, file, created) VALUES ('".$post_vars['company']."', '".$post_vars['brand']."', '".$post_vars['model']."', '".$post_vars['description']."', '".$post_vars['service_tag']."', '".$post_vars['ship_date']."', '".$post_vars['end_date']."', '".$attachment_name."', NOW())";
				$supp_obj->execute_query($sql);
				
				$ren_msg = $generic_msg['cWarrantyAddedSuccessfully'];
			}
		}
		
		return $ren_msg;	
	}
	
	function deleteWarranty($supp_obj, $a_predefined, $generic_msg) {
		$warranty = $supp_obj->prefix_table("warranty");
		
		//searchcust
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		
		for($i = 0; $i < count($post_vars['chk_warranty']); $i++) {
			$warranty_id = $post_vars['chk_warranty'][$i];
			$sql = "DELETE FROM $warranty WHERE warranty_id = '".$warranty_id."'";
			$supp_obj->execute_query($sql);
		}
		return $generic_msg['cWarrantyDeletedSuccessfully'];
	}
	
	function download_file($supp_obj, $a_predefined, $generic_msg) {
		$warranty = $supp_obj->prefix_table("warranty");
		
		//searchcust
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		
		if(isset($get_vars['id'])) {
			$sql = "SELECT * FROM $warranty WHERE warranty_id = '".$get_vars['id']."'";
			$row = $supp_obj->get_a_line($sql);
			
			$fileDir = '../licenses';
			$fileName = $row['file'];
			list($n, $ext) = split("\.", $fileName);
			$instance_name = $row['brand'].'_'.$row['service_tag'].'.'.$ext;
			
			$supp_obj->download_file($fileDir, $fileName, $instance_name);
		}
	}
}

$cr = new warranty;
$act = $get_vars['act'];

switch($act) {
	case NULL:
		$cr->view($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager);
	break;
	case 'addnew':
		$cr->viewForm($supp_obj, $a_predefined, $generic_msg);
	break;
	case 'edit':
		$cr->viewForm($supp_obj, $a_predefined, $generic_msg);
	break;
	case 'update':
		$a_predefined['status_msg'] = $cr->processWarranty($supp_obj, $a_predefined, $generic_msg);
		$cr->view($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager);
	break;
	case 'deleteCl':
		$a_predefined['status_msg'] = $cr->deleteWarranty($supp_obj, $a_predefined, $generic_msg);
		$cr->view($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager);
	break;
}

include_once("footer.php");
?>