<?php
include_once("session.php");
class Settings {
    //----------------------------------------------------------------------
    /*Show current configuration*/
    function show_configuration($supp_obj, $a_predefined, $status_msg = '') {
        $template        = "../templates/admin/manage_settings.tpl";
        $content         = $supp_obj->return_file_content($template);
        $config          = $supp_obj->prefix_table("configuration");
        $language        = $supp_obj->prefix_table("language");
        $clients         = $supp_obj->prefix_table("clients");
        $sql             = "select * from $config";
        $a_config        = $supp_obj->get_a_line($sql);
        $ticket_field    = $a_config['ticket_field'];
        $timezones_array = $a_predefined['timezones'];
        $pattern         = "/\<\{timezone_loopstart\}\>(.*?)\<\{timezone_loopend\}\>/is";
        preg_match($pattern, $content, $out);
        $match          = $out[1];
        $array_keys     = array_keys($timezones_array);
        $str            = "";
        // find out preferred timezone
        $preferred_zone = $a_config['time_zone'];
        $selected       = "";
        for ($i = 0; $i < count($array_keys); $i++) {
            $index    = $array_keys[$i];
            $timezone = $timezones_array[$index];
            if ($preferred_zone == (int) $index) {
                $selected = "selected";
            } else {
                $selected = "";
            }
            //$str.=preg_replace("/\<\{(.*?)\}\>/e","$$1",$match);
            preg_match_all("/\<\{(.*?)\}\>/", $match, $matches);
            $tmp_array = array();
            foreach ($matches[0] as $_index => $var_name) {
                $tmp_var_name = $matches[1][$_index];
                if (isset($$tmp_var_name)) {
                    $tmp_array[$tmp_var_name] = $$tmp_var_name;
                } else {
                    $tmp_array[$tmp_var_name] = '';
                }
            }
            $str .= preg_replace_callback("/\<\{(.*?)\}\>/", function($m) use ($tmp_array) {
                return $tmp_array[$m[1]];
            }, $match);
        }
        $content       = preg_replace($pattern, $str, $content);
        $statssettings = $supp_obj->prefix_table("statssettings");
        $sql           = "select * from $statssettings ";
        $a_stats       = $supp_obj->get_a_line($sql);
        $pattern       = "/\<\{timezone1_loopstart\}\>(.*?)\<\{timezone1_loopend\}\>/is";
        preg_match($pattern, $content, $out);
        $match          = $out[1];
        $array_keys     = @array_keys($timezones_array);
        $str            = "";
        // find out preferred timezone
        $preferred_zone = $a_stats['time_zone'];
        $selected       = "";
        for ($i = 0; $i < count($array_keys); $i++) {
            $index    = $array_keys[$i];
            $timezone = $timezones_array[$index];
            if ($preferred_zone == (int) $index) {
                $selected = "selected";
            } else {
                $selected = "";
            }
            //$str.=preg_replace("/\<\{(.*?)\}\>/e","$$1",$match);
            preg_match_all("/\<\{(.*?)\}\>/", $match, $matches);
            $tmp_array = array();
            foreach ($matches[0] as $_index => $var_name) {
                $tmp_var_name = $matches[1][$_index];
                if (isset($$tmp_var_name)) {
                    $tmp_array[$tmp_var_name] = $$tmp_var_name;
                } else {
                    $tmp_array[$tmp_var_name] = '';
                }
            }
            $str .= preg_replace_callback("/\<\{(.*?)\}\>/", function($m) use ($tmp_array) {
                return $tmp_array[$m[1]];
            }, $match);
        }
        $content     = preg_replace($pattern, $str, $content);
        $client_rec  = array();
        $fields      = $supp_obj->prefix_table("fields");
        $sql         = "select field_name,table_field from $fields where orient_id='1' ";
        $client_rec  = $supp_obj->get_rsltset($sql);
        $client_rec1 = array(
            "client_name",
            "email"
        );
        $pattern     = "/<{field_loopstart}>(.*?)<{field_loopend}>/is";
        preg_match($pattern, $content, $out);
        $match = $out[1];
        if ($ticket_field == "") {
            $ticket_field = "client_name";
        }
        $str = "";
        for ($i = 0; $i < count($client_rec1); $i++) {
            $field_name  = $client_rec1[$i];
            $table_field = $field_name;
            if ($ticket_field == $table_field) {
                $selected = "selected";
            } else {
                $selected = "";
            }
            //$str.=preg_replace("/\<\{(.*?)\}\>/e","$$1",$match);
            preg_match_all("/\<\{(.*?)\}\>/", $match, $matches);
            $tmp_array = array();
            foreach ($matches[0] as $_index => $var_name) {
                $tmp_var_name = $matches[1][$_index];
                if (isset($$tmp_var_name)) {
                    $tmp_array[$tmp_var_name] = $$tmp_var_name;
                } else {
                    $tmp_array[$tmp_var_name] = '';
                }
            }
            $str .= preg_replace_callback("/\<\{(.*?)\}\>/", function($m) use ($tmp_array) {
                return $tmp_array[$m[1]];
            }, $match);
        }
        for ($i = 0; $i < count($client_rec); $i++) {
            $field_name  = $client_rec[$i]['field_name'];
            $table_field = $client_rec[$i]['table_field'];
            if ($ticket_field == $table_field) {
                $selected = "selected";
            } else {
                $selected = "";
            }
            //$str.=preg_replace("/\<\{(.*?)\}\>/e","$$1",$match);
            preg_match_all("/\<\{(.*?)\}\>/", $match, $matches);
            $tmp_array = array();
            foreach ($matches[0] as $_index => $var_name) {
                $tmp_var_name = $matches[1][$_index];
                if (isset($$tmp_var_name)) {
                    $tmp_array[$tmp_var_name] = $$tmp_var_name;
                } else {
                    $tmp_array[$tmp_var_name] = '';
                }
            }
            $str .= preg_replace_callback("/\<\{(.*?)\}\>/", function($m) use ($tmp_array) {
                return $tmp_array[$m[1]];
            }, $match);
        }
        $content                              = preg_replace($pattern, $str, $content);
        $supportlang                          = $_SESSION['supportlang'];
        $sql                                  = "select * , langname_$supportlang as lang_name from $language ";
        $loop_sql['lang_']                    = $sql;
        // Make active language selected	
        $select_array['lang_']['lang_folder'] = array(
            $supportlang
        );
        $a_content                            = $supp_obj->replace_loop($loop_sql, $content, '', $select_array);
        $content                              = $a_content[0];
        //$a_config['yesdeletechecked'] = (($a_config['delete_mail']==1)?"checked":"");
        //$a_config['nodeletechecked'] = (($a_config['delete_mail']==1)?"checked":"");
        $a_config['yeschecked']               = (($a_config['send_mail'] == 1) ? "checked" : "");
        $a_config['nochecked']                = (($a_config['send_mail'] == 0) ? "checked" : "");
        $a_config['yesattachmentchecked']     = (($a_config['attachment'] == 1) ? "checked" : "");
        $a_config['noattachmentchecked']      = (($a_config['attachment'] == 0) ? "checked" : "");
        $a_config['yesprintactlog']           = (($a_config['print_activitylog'] == 1) ? "checked" : "");
        $a_config['noprintactlog']            = (($a_config['print_activitylog'] == 0) ? "checked" : "");
        $a_config['yescronchecked']           = (($a_config['cron_option'] == 1) ? "checked" : "");
        $a_config['nocronchecked']            = (($a_config['cron_option'] == 0) ? "checked" : "");
        $a_config['yesstaffreplies']          = (($a_config['staff_replies'] == 1) ? "checked" : "");
        $a_config['nostaffreplies']           = (($a_config['staff_replies'] == 0) ? "checked" : "");
        $a_config['yeshideclosed']            = (($a_config['hide_closed'] == 1) ? "checked" : "");
        $a_config['nohideclosed']             = (($a_config['hide_closed'] == 0) ? "checked" : "");
        if ($a_config['allow_routing'] != "y") {
            $a_config['allow_routing'] = "n";
        }
        if ($a_stats['exclude_weekends'] == "1") {
            $a_config['weekendchecked'] = 'checked';
        }
        $a_config['yesrouting'] = (($a_config['allow_routing'] == "y") ? "checked" : "");
        $a_config['norouting']  = (($a_config['allow_routing'] == "n") ? "checked" : "");
        if ($a_config['allow_staff_stats'] != "y") {
            $a_config['allow_staff_stats'] = "n";
        }
        $a_config['yes_staff_stats']    = (($a_config['allow_staff_stats'] == "y") ? "checked" : "");
        $a_config['no_staff_stats']     = (($a_config['allow_staff_stats'] == "n") ? "checked" : "");
        $a_config['yesdisablepassword'] = (($a_config['password_flag'] == 1) ? "checked" : "");
        $a_config['nodisablepassword']  = (($a_config['password_flag'] == 0) ? "checked" : "");
        if ($a_config['registered_only'] == "") {
            $a_config['registered_only'] = "n";
        }
        $a_config['yes_registered_only'] = (($a_config['registered_only'] == "y") ? "checked" : "");
        $a_config['no_registered_only']  = (($a_config['registered_only'] == "n" or $a_config['registered_only'] == "N") ? "checked" : "");
        $a_config['smtp_mail']           = (($a_config['smtp_mail'] == 1) ? "checked" : "");
        if ($a_config['smtp_port'] == "") {
            $a_config['smtp_port'] = 25;
        }
        $a_config['status_msg'] = $status_msg;
        if ($status_msg != "") {
            $content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
        } else {
            $content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
        }
        $content = $supp_obj->direct_replace($content, $a_config);
        echo $content;
    }
    //--------------------------------------------------------------------------------
    /*Submit new configuration details to the database*/
    function submit_configuration($supp_obj, $a_predefined, $generic_msg) {
        $post_vars    = $a_predefined['post'];
        $file_vars    = $a_predefined['file'];
        $session_vars = $a_predefined['session'];
        @extract($post_vars);
        $adt_clause = " ";
        // Upload logo to the server directory
        if ($file_vars['logo']['tmp_name'] != "" and $file_vars['logo']['tmp_name'] != "none") {
            $file_name  = $supp_obj->upload_file('logo', $file_vars, $file_vars['logo']['name'], "images");
            $adt_clause = " , logo='$file_name' ";
        }
        if ($file_vars['admlogo']['tmp_name'] != "" and $file_vars['admlogo']['tmp_name'] != "none") {
            $file_name = $supp_obj->upload_file('admlogo', $file_vars, $file_vars['admlogo']['name'], "images");
            $adt_clause .= " , admlogo='$file_name' ";
        }
        $records_per_page = ceil($records_per_page);
        if ($records_per_page <= 0) {
            return $generic_msg['cInvalid_records_per_page'];
        }
        // update database with new configuration details
        $_SESSION['supportlang'] = $default_lang;
        $config                  = $supp_obj->prefix_table("configuration");
        $sql                     = "update $config set  attachment='$attachment', 
		
		attachment_size='$attachment_size', 
		
		records_per_page='$records_per_page' , send_mail='$send_mail',
		
		http_url='$http_url' ,  admin_email='$admin_email' ,cron_option='$cron_option' ,

	 time_zone='$time_zone', 

		cron_time='$cron_time', default_lang='$default_lang'  $adt_clause
		
		";
        // End -------------------- //
        $supp_obj->execute_query($sql);
        $staff = $supp_obj->prefix_table("staff");
        $sql   = " update $staff set default_lang='$default_lang' where staff_id='" . $session_vars['staff_id'] . "'";
        $supp_obj->execute_query($sql);
        return 'cConfiguration_updated';
        //echo "sql=$sql"	;
        //	return  $generic_msg['cConfiguration_updated'];
    }
    //--------------------------------------------------------------------------------	
    function submitadvanced_configuration($supp_obj, $a_predefined, $generic_msg) {
        $post_vars    = $a_predefined['post'];
        $session_vars = $a_predefined['session'];
        @extract($post_vars);
        $config = $supp_obj->prefix_table("configuration");
        $sql    = " update $config set password_flag='$password_flag', auto_close='$auto_close', 
	
			ticket_field='$ticket_field',delete_mail='$delete_mail' ,print_activitylog='$print_activitylog', staff_replies='$staff_replies',

			hide_closed='$hide_closed',allow_routing='$allow_routing',allow_staff_stats='$allow_staff_stats',
			registered_only='$registered_only'  ";
        $supp_obj->execute_query($sql);
        return 'cConfiguration_updated';
    }
    //------------------------------------------------------------------------------------------------------------------
    function submitmail_configuration($supp_obj, $a_predefined, $generic_msg) {
        $post_vars    = $a_predefined['post'];
        $session_vars = $a_predefined['session'];
        @extract($post_vars);
        $config = $supp_obj->prefix_table("configuration");
        if ($smtp_mail == "") {
            $smtp_mail = 0;
        }
        $sql = " update $config set smtp_mail='$smtp_mail', smtp_host='$smtp_host', smtp_username='$smtp_username', smtp_password='$smtp_password',smtp_port='$smtp_port'  ";
        $supp_obj->execute_query($sql);
        //	echo $sql;
        return 'cConfiguration_updated';
    }
}
$set                       = new Settings;
$a_predefined['timezones'] = $timezones_array;
switch ($act) {
    case NULL:
        include_once("header.php");
        include_once("nav.php");
        $status_msg = $generic_msg[$get_vars['status_msg']];
        $set->show_configuration($supp_obj, $a_predefined, $status_msg);
        break;
    case "submit":
        $status_msg = $set->submit_configuration($supp_obj, $a_predefined, $generic_msg);
        $script     = <<<EOD
<script language="JavaScript">
	window.location='manage_settings.php?status_msg=cConfiguration_updated';
</script>
EOD;
        echo $script;
        exit;
        include_once("header.php");
        include_once("nav.php");
        $set->show_configuration($supp_obj, $a_predefined, $status_msg);
        break;
    case "submitadvanced":
        $status_msg = $set->submitadvanced_configuration($supp_obj, $a_predefined, $generic_msg);
        $script     = <<<EOD
<script language="JavaScript">
	window.location='manage_settings.php?status_msg=cConfiguration_updated';
</script>
EOD;
        echo $script;
        exit;
        break;
    case "submitmail":
        $status_msg = $set->submitmail_configuration($supp_obj, $a_predefined, $generic_msg);
        $script     = <<<EOD
<script language="JavaScript">
	window.location='manage_settings.php?status_msg=cConfiguration_updated';
</script>
EOD;
        echo $script;
        exit;
        break;
    case "submitstats":
        $manager->submit_stats_settings($supp_obj, $a_predefined, $generic_msg, $timezones_array, $return_array);
        $script = <<<EOD
<script language="JavaScript">
	window.location='manage_settings.php?status_msg=cConfiguration_updated';
</script>
EOD;
        echo $script;
        exit;
        break;
}
include_once("footer.php");