<?php
$page = "";
$extra = "";
$software = "";
$count = 0;
$total_rows = 0;
$latest_version = "09.12.23";

// Check for config, otherwise run setup
if(!file_exists("include_config.php"))exit(header("Location: ../setup.php"));
include "include.php";

$software = GetGETOrDefaultValue("software","");
$sort = GetGETOrDefaultValue("sort","system_name");
?>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-default">
      <div class="panel-body panel-body-table faq">
        <?php
		$title = "";
		if (isset($_GET["show_all"])){ $count_system = '10000'; }
		if (isset($_GET["page_count"])){ $page_count = $_GET["page_count"]; } else { $page_count = 0;}
		$page_prev = $page_count - 1;
		if ($page_prev < 0){ $page_prev = 0; }
		$page_next = $page_count + 1;
		$page_current = $page_count;
		$page_count = $page_count * $count_system;
		
		// ****** Display various sections *****************************************************
		if ($show_system_discovered == "y") 
			DisplaySection('f1',__("Systems Discovered in the last ").$system_detected.__(" Days"),'RecentlyDiscoveredSystems','Systems','rss_new_systems.php');
		if ($show_other_discovered == "y") 
			DisplaySection('f2',__("Other Items Discovered in the last ").$other_detected.__(" Days"),'OtherDiscovered','Other Items','rss_new_other.php');
		if ($show_systems_not_audited == "y") 
			DisplaySection('f3',__("Systems Not Audited in the last ").$days_systems_not_audited.__(" Days"),'SystemsNotAudited','Systems');
		if ($show_partition_usage == "y") 
			DisplaySection('f4',__("Partition free space less than ").$partition_free_space.__(" MB"),'PartitionUsage','Partitions');
		if ($show_software_detected == "y")
			DisplaySection('f5',__("Software detected in the last ").$days_software_detected.__(" Days"),'DetectedSoftware','Packages','rss_new_software.php');
		if ($show_detected_servers == "y") {
		  DisplaySection('f6',__("Web Servers"),'WebServers','Systems');
		  DisplaySection('f7',__("FTP Servers"),'FtpServers','Systems');  
		  DisplaySection('f8',__("Telnet Servers"),'TelnetServers','Systems');  
		  DisplaySection('f9',__("Email Servers"),'EmailServers','Systems');
			DisplaySection('f10',__("VNC Servers"),'VncServers','Systems');
			if ($show_detected_rdp == "y") DisplaySection('f12',__('RDP and Terminal Servers'),'RDPServers','Systems');
			DisplaySection('f13',__('Database Servers'),'DbServers','Systems');
		}
		if ($show_detected_xp_av == "y") 
			DisplaySection('f11',__("XP SP2 without up to date AntiVirus"),'DetectedXpAv','Systems');
			
		if ($show_ldap_changes == 'y') DisplaySection('f15',__("LDAP Directory changes in the last ".$ldap_changes_days." days"),'AdInfo','Accounts','rss_ldap_directory_changes.php');
		
		//******* Display Graph *****************************************************
		function DisplayAuditGraph() {
			global $systems_audited_days;
			
			echo '  <div class="row">
					  <div class="col-md-12">
						<div class="panel panel-default">
						  <div class="panel-heading ui-draggable-handle">
							<h3 class="panel-title">Systems Audited in the last '.$systems_audited_days.' Days</h3><span class="pull-right"></span>
						  </div>
						  <div class="panel-body" id="AuditedSystems">
						  	<img class="npb_auditedsystems_hourglass" alt="Retrieving..." src="images/hourglass-busy.gif" width="24"/>
						  </div>
						</div>
					  </div>
					</div>';
		}
		
		/******* Generic display section function *****************************************************
			$SwitchID			- String	-	Unique element ID to be used by switchUl() function
			$Display			-	String	-	Section description (heading) string to be displayed
			$DivID				-	String	-  Unique element ID used by the HttpRequestor object
			$TotalString		- String	- String used in "total" description
			$RssUrl				- String	- RSS URL string
		**********************************************************************************************/
		function DisplaySection($SwitchID, $Display, $DivID, $TotalString, $RssUrl='') {
		  $i="i".$SwitchID;
			/*echo "<div class='npb_section_shadow'>";
			echo "	<div class='npb_section_content'>";
			echo "		<div class='npb_section_heading'>";*/
			
			// **** Only for sections with RSS feed *******************
			if (strlen($RssUrl)>0){/*echo "<a href='$RssUrl'><img class='npb_rss' src=\"images/feed-icon.png\" alt=\"RSS Feed\" /></a>";*/}
			// ****************************************************
			
			/*echo "			<a href=\"javascript://\" onclick=\"switchUl('$SwitchID');\"></a>";
			echo "			<img class='npb_down' src=\"images/down.png\" alt=\"\" onclick=\"switchUl('$SwitchID');\"/>";
			echo "		</div>";
			echo "		<div class='npb_section_data' id='$DivID'>";
			echo "			<p class='npb_section_summary'>: </p>";
			echo "		</div>";
			echo "	</div>";
			echo "</div>";*/
			
			echo '<div class="faq-item">
					  <div class="faq-title"><span class="fa fa-angle-down"></span>'.$Display.'<span class="pull-right text-muted"><img class="npb_hourglass" alt="Retrieving..." src="images/hourglass-busy.gif" width="24" /></span></div>
					  <div class="faq-text" id="'.$DivID.'" style="overflow:auto;">'.__($TotalString).'</div>
				  </div>';
			
			
		}
		?>
      </div>
    </div>
  </div>
</div>
<?php if ($show_systems_audited_graph == 'y') DisplayAuditGraph();?>
<script type="text/javascript">
function ajaxPopulate(id, data_sub) {
	jQuery.get('index_data.php', {'sub': data_sub}, function(response) {
		jQuery('#'+id).html(response);
		/*if(jQuery('#'+id).parent().children().children('.pull-right').length > 0) {
			jQuery('#'+id).parent().children().children('.pull-right').hide();
		}*/
		if(jQuery('#'+id).children('.npb_section_summary').length > 0) {
			if(jQuery('#'+id).parent().children().children('.pull-right').length > 0) {
				var counter = jQuery('#'+id).children('.npb_section_summary').html();
				jQuery('#'+id).parent().children().children('.pull-right').html(counter);
			}
		} else if(jQuery('#'+id).parent().children().children('.pull-right').length > 0) {
			jQuery('#'+id).parent().children().children('.pull-right').hide();
		}
	});
}
<?php
// Initiate retrieval of data for each section
if ($show_system_discovered == "y") echo "ajaxPopulate(\"RecentlyDiscoveredSystems\", \"f1\");\n";
if ($show_other_discovered == "y") echo "ajaxPopulate(\"OtherDiscovered\", \"f2\");\n";
if ($show_systems_not_audited == "y") echo "ajaxPopulate(\"SystemsNotAudited\", \"f3\");\n"; 
if ($show_partition_usage == "y") echo "ajaxPopulate(\"PartitionUsage\", \"f4\");\n"; 
if ($show_software_detected == "y") echo "ajaxPopulate(\"DetectedSoftware\", \"f5\");\n";
if ($show_detected_servers == "y" ) {	
  echo "ajaxPopulate(\"WebServers\", \"f6\");\n";
  echo "ajaxPopulate(\"FtpServers\", \"f7\");\n";
  echo "ajaxPopulate(\"TelnetServers\", \"f8\");\n";
  echo "ajaxPopulate(\"EmailServers\", \"f9\");\n";
  echo "ajaxPopulate(\"VncServers\", \"f10\");\n";
	if ($show_detected_rdp == "y")   echo "ajaxPopulate(\"RDPServers\", \"f12\");\n";
  echo "ajaxPopulate(\"DbServers\", \"f13\");\n";
}
if ($show_detected_xp_av == "y") echo "ajaxPopulate(\"DetectedXpAv\", \"f11\");\n";
if ($show_ldap_changes == 'y') echo "ajaxPopulate(\"AdInfo\", \"f15\");\n";
if ($show_systems_audited_graph == 'y') echo "ajaxPopulate(\"AuditedSystems\", \"f14\");\n";
?>
</script>
<script type="text/javascript" src="../../theme/js/faq.js"></script>
<?php include "include_right_column.php"; ?>