<?php
require_once ROOT_PATH . '/lib/dao/DMLFunctions.php';
require_once ROOT_PATH . '/lib/dao/SQLQBuilder.php';
require_once ROOT_PATH . '/plugins/Plugin.php';
require_once ROOT_PATH . '/plugins/PlugInFactoryException.php';
class PlugInFactory
{
	private function __construct(){
	}
	
	/**
	 * Get plugin object
	 *
	 * @return new plugin object
	 */
    public static function factory($plugInName){
		//Acces databse and get xmlpath
		$xmlPath = Plugin::fetchPlugin($plugInName);
		if($xmlPath){
			return PlugInFactory::readXMl($xmlPath);
		}else{
			throw new PlugInFactoryException(PlugInFactoryException::PLUGIN_INSTALL_ERROR);		
		}
	}
	
	/**
	 * Read plugins's install xml file
	 *
	 * @return new plugin object
	 */
	
	private static function readXMl($xmlPath){
		
		//Loading xml file through SimpleXML libarey
		if(is_file(ROOT_PATH .  "/" . $xmlPath)){
			$xmlObj = simplexml_load_file(ROOT_PATH .  "/" .  $xmlPath);
			if(is_file(ROOT_PATH . trim($xmlObj->initFile))){
					require_once(ROOT_PATH . trim($xmlObj->initFile));
					$pluginClassName = trim($xmlObj->initClass);
					$pluginClassNameNewObj = new $pluginClassName(); 
					foreach($xmlObj->authorizedRoles ->children() as $user){
			 	 		$authorizedRoles[trim($user)] = true;
			 		}
			 		$pluginClassNameNewObj->setAuthorizedRoles($authorizedRoles);
					foreach($xmlObj->authorizeModules ->children() as $module){							
		 	 			$authorizeModules[trim($module)] = true;
			 		}
			 		$pluginClassNameNewObj->setAuthorizeModules($authorizeModules);
					return  $pluginClassNameNewObj;
			}else{
				throw new PlugInFactoryException(PlugInFactoryException::PLUGIN_INSTALL_ERROR);
			}
		}else{
			return FALSE ;
		}
	}
}
?>