<?php
 abstract class ReportModuleObject {
     protected $dataValues = array();
     
     public function __set($name, $value) {
        if (array_key_exists($name, $this->dataValues)) {
            $this->dataValues[$name] = $value;
        }
        elseif (array_key_exists($name, $this->publicPropertyMapping)) {
            $key = $this->publicPropertyMapping[$name];
            $this->dataValues[$key];
        } else {
            throw new Exception('PropertyNotSet');
        }
    }

    public function __get($name) {
        if (array_key_exists($name, $this->dataValues)) {
            return $this->dataValues[$name];
        } else {
            // TODO: Warn
            return null;
        }
    }

    public function __isset($name) {
        return (array_key_exists($name, $this->dataValues) && isset ($this->dataValues[$name]));
    }
 }