<?php
require_once ROOT_PATH . '/lib/common/CommonFunctions.php';
require_once ROOT_PATH . '/lib/models/hrfunct/AbstractEmpHistory.php';

/**
 * Manages history of employee sub divisions
 */
class LocationHistory extends AbstractEmpHistory {

    protected $tableName = 'hs_hr_emp_location_history';
    protected $externalTable = 'hs_hr_location';
    protected $externalCodeField = 'loc_code';
    protected $externalNameField = 'loc_name';

    /* An employee can have multiple locations assigned */
    protected $allowMultipleCurrentItems = true;

    /**
     * Validate the code
     *
     * @param mixed $code Code
     * @return boolean true if code valid, false otherwise
     */
    protected function validateCode($code) {
        return CommonFunctions::isValidId($code, 'LOC');
    }

}

?>
