<?php
/**
 * Interface to be implemented by CSV import plugins
 */
interface CSVImportPlugin {


	/** Get descriptive name for this plugin */
	public function getName();

	/** Get number of header rows to skip */
	public function getNumHeaderRows();

	/** Get number of csv columns expected */
	public function getNumColumns();

	/**
	 * Import CSV data to the system
	 *
	 * @param array dataRow Array containing one row of CSV data
	 */
	public function importCSVData($dataRow);
}

class CSVImportException extends Exception {
	const IMPORT_DATA_NOT_RECEIVED = 0;
	const COMPULSARY_FIELDS_MISSING_DATA = 1;
	const MISSING_WORKSTATION = 2;
	const UNKNOWN_ERROR = 3;
	const DD_DATA_INCOMPLETE = 4;
	const INVALID_TYPE = 5;
	const DUPLICATE_EMPLOYEE_ID = 6;
	const DUPLICATE_EMPLOYEE_NAME = 7;
	const FIELD_TOO_LONG = 8;

}

?>
