<?php
 require_once 'PropertyReader.php';
 require_once 'Auditor.php';
 require_once 'AuditorFactory.php';


 class Logger {
 	private static $instance;
	private $propertyReader;
	private $auditors;

	const DEFAULT_PROPERTY_FILE = '/logger.properties';

	private function __construct($propertyFilePath = null) {
		if(!isset($propertyFilePath) || $propertyFilePath == '') {
			$propertyFilePath = dirname(__FILE__) . self::DEFAULT_PROPERTY_FILE;
		}
		$this->init($propertyFilePath);
	}

	public static function getInstance($propertyFilePath = null) {
//		if(!isset($this->instance)) {
//			$this->instance = new Logger($propertyFilePath);
//		}

		return new Logger();
	}

	private function init($propertyFilePath) {
		$this->auditors = array();

		$this->propertyReader = new PropertyReader($propertyFilePath);
		$auditorNames = $this->propertyReader->getPropertyArray(Auditor::LOG . '.' . Auditor::LOG_NAME);
		$this->initAuditors($auditorNames);
	}

	private function initAuditors($auditorNames) {
		if(isset($auditorNames) && is_array($auditorNames)) {

			$factory = AuditorFactory::getInstance($this->propertyReader);

			foreach($auditorNames as $name) {
				$auditor = $factory->getAuditor($name);
				if(isset($auditor)) {
					$this->auditors[] = $auditor;
				}
			}
		}
	}

	public function info($obj) {
		if(!isset($this->auditors)) {
			return null;
		}

		foreach($this->auditors as $auditor) {
			$auditor -> info($obj);
		}
	}

	public function debug($obj) {
		if(!isset($this->auditors)) {
			return null;
		}

		foreach($this->auditors as $auditor) {
			$auditor -> debug($obj);
		}
	}

	public function warn($obj) {
		if(!isset($this->auditors)) {
			return null;
		}

		foreach($this->auditors as $auditor) {
			$auditor -> warn($obj);
		}
	}

	public function error($obj) {
		if(!isset($this->auditors)) {
			return null;
		}

		foreach($this->auditors as $auditor) {
			$auditor -> error($obj);
		}
	}
 }
?>
