<?php
require_once ROOT_PATH . '/lib/models/hrfunct/EmpChildren.php';

class EXTRACTOR_EmpChildren {

	private $empId;
	private $empCSeqNo;
	private $empChiName;
	private $empDOB;

	public function __construct() {
		$this->chi = new EmpChildren();
	}

	public function parseData($postArr) {

		$postArr['ChiDOB']=LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['ChiDOB']);

		$this->chi->setEmpId($postArr['txtEmpID']);
		$this->chi->setEmpCSeqNo(trim($postArr['txtCSeqNo']));
		$this->chi->setEmpChiName(trim($postArr['txtChiName']));
		$this->chi->setEmpDOB(self::_handleEmptyDates($postArr['ChiDOB']));

		return $this->chi;

	}

	public function reloadData($postArr) {

		$postArr['ChiDOB']=LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['ChiDOB']);

		$this->txtEmpID		=	$postArr['txtEmpID'];
		$this->txtDSeqNo	=	trim($postArr['txtDSeqNo']);
		$this->txtChiName	=	trim($postArr['txtChiName']);
		$this->DOB			=	self::_handleEmptyDates($postArr['ChiDOB']);

		return $this;

	}

	private static function _handleEmptyDates($date) {

		$date = trim($date);

	    if ($date == "" || $date == "YYYY-mm-DD" || $date == "0000-00-00") {
			return "null";
	    } else {
	        return "'".$date."'";
	    }

	}

}
?>
