<?php
require_once ROOT_PATH . '/lib/models/eimadmin/EmailConfiguration.php';

class EXTRACTOR_EmailConfiguration {

	private $emailConfiguration;

	public function __construct() {
		$this->emailConfiguration = new EmailConfiguration();
	}

	public function parseAddData() {}

	public function parseEditData($postArr) {

			$this->emailConfiguration->setSmtpHost($postArr["txtSmtpHost"]);

			if (isset($postArr["txtSmtpUser"])) {
				$this->emailConfiguration->setSmtpUser($postArr["txtSmtpUser"]);
			}

			if (isset($postArr["txtSmtpPass"])) {
				$this->emailConfiguration->setSmtpPass($postArr["txtSmtpPass"]);
			}

			$this->emailConfiguration->setSmtpPort($postArr["txtSmtpPort"]);
			$this->emailConfiguration->setMailType($postArr["txtMailType"]);
			$this->emailConfiguration->setMailAddress($postArr["txtMailAddress"]);

			if (isset($postArr["chkTestEmail"]) && !empty($postArr["txtTestEmail"])) {
				if ($postArr["txtMailType"] == "smtp") {
					$this->emailConfiguration->setTestEmailType("smtp");
				} elseif ($postArr["txtMailType"] == "sendmail") {
				    $this->emailConfiguration->setTestEmailType("sendmail");
				}
			    $this->emailConfiguration->setTestEmail(trim($postArr["txtTestEmail"]));
			}

			if (isset($postArr["optAuth"])) {
				$this->emailConfiguration->setSmtpAuth($postArr["optAuth"]);
			}

			if (isset($postArr["optSecurity"])) {
				$this->emailConfiguration->setSmtpSecurity($postArr["optSecurity"]);
			}

			if (isset($postArr["txtSendmailPath"])) {
				$this->emailConfiguration->setSendmailPath($postArr["txtSendmailPath"]);
			}

			return $this->emailConfiguration;

	}

	public function parseDeleteData() {}

}
?>
