<?php
require_once ROOT_PATH . '/lib/models/benefits/HspPayPeriod.php';

class EXTRACTOR_HspPayPeriod {

	public function __construct() {
		// nothing to do
	}

	public static function parseAddData($postArr) {
		$payPeriod = new HspPayPeriod();

		$payPeriod->setStartDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodFromDate']));
		$payPeriod->setEndDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodToDate']));
		$payPeriod->setCloseDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodCloseDate']));
		$payPeriod->setTimesheetAprovalDueDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodTimesheetDueDate']));
		$payPeriod->setCheckDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodCheckDate']));

		return $payPeriod;
	}

	public static function parseEditData($postArr) {
		$payPeriod = new HspPayPeriod();

		$payPeriod->setId($postArr['txtPayPeriodId']);
		$payPeriod->setStartDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodFromDate']));
		$payPeriod->setEndDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodToDate']));
		$payPeriod->setCloseDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodCloseDate']));
		$payPeriod->setTimesheetAprovalDueDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodTimesheetDueDate']));
		$payPeriod->setCheckDate(LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtPayPeriodCheckDate']));

		return $payPeriod;
	}

	public static function parseDeleteData($postArr) {
		$payPeriods = array();
		if (is_array($postArr['chkPayPeriodId'])) {
			for ($i=0; $i<count($postArr['chkPayPeriodId']); $i++) {
				$tmpObj = new HspPayPeriod();
				$tmpObj->setId($postArr['chkPayPeriodId'][$i]);

				$payPeriods[] = $tmpObj;
			}
		}

		return $payPeriods;
	}
}
?>
