<?php
require_once ROOT_PATH . '/lib/dao/MySQLClass.php';
require_once ROOT_PATH . '/lib/confs/Conf.php';

class DMLFunctions {

	var $dbObject; // var to connection
	var $conf;

	/**
	 * Constructor for the DMLFunctions Class
	 * which takes the configuration variables
	 * from the conf.php Class and return the
	 * reference of conf object
	 */
	function DMLFunctions() {
		$this-> conf = new Conf();
		$this-> dbObject = new MySQLClass($this->conf);
	}

	/**
	 * Function ExecuteQuery will take in a SQL Query
	 * String as the Input Parameter and execute the
	 * SQLQuery Function
	 */
	function executeQuery($SQL) {

		$SQL = $this->_formatQuery($SQL);

		if ( $this -> dbObject -> dbConnect()) {
			$result = $this->dbObject->sqlQuery($SQL);
			return $result;
		}

		return false;
	}
	
	function _formatQuery($query) {
		
		if (preg_match('/\'AES_[ED][NE]CRYPT\(/', $query)) {
			
			$query = preg_replace(array("/^'AES_ENCRYPT\(/", "/\)'/"), array('AES_ENCRYPT(', ')'), $query);
			
		}
		
		return $query;
		
	}

}
?>
