<?php
require_once ROOT_PATH . '/lib/common/Language.php';
require_once ROOT_PATH . '/lib/common/CommonFunctions.php';

class FormCreator
{
	var $getArr;
	var $postArr;
	var $popArr;
	var $formPath;

	function FormCreator($getArr,$postArr = null) {

        /**
         * Escape any html in GET variables, making them safer
         */
        foreach($getArr as $key=>$val) {
            if (is_string($val)) {
                $getArr[$key] = CommonFunctions::escapeHtml($val);
            }
        }

		$this->getArr = $getArr;
		if($postArr != null)
			$this->postArr = $postArr;

		$this->popArr = array();

	}

	function display() {
		@ob_clean();
		$str = ROOT_PATH . $this->formPath;

		require_once ROOT_PATH . '/lib/common/xajax/xajax.inc.php';
		require_once ROOT_PATH . '/lib/common/xajax/xajaxElementFiller.php';
		require_once ROOT_PATH . '/language/default/lang_default_full.php';

		$lan = new Language();
		require_once($lan->getLangPath("full.php"));
		$fileName = pathinfo($this->formPath, PATHINFO_BASENAME);

		$styleSheet = CommonFunctions::getTheme();

		if (preg_match('/view\.php$/', $fileName) == 1) {
			require_once(ROOT_PATH . '/language/default/lang_default_' .$fileName);
		}

		require_once(ROOT_PATH.$this->formPath);
	}
}
?>