<?php
/**
 * Observer interface listening to event changes.
 */
interface EventObserver {

    /**
     * Register this observer with the given subject
     * 
     * TODO: Instead of EventMediator, use an interface or abstract super class
     *  
     * @param EventMediator 
     */
    public function register($subject);
    
    
    /**
     * Notify of event
     * @param String $event Event name
     * @param Array $data Array containing event specific data
     * @return boolean true if caller should continue UI flow, false if caller should exit 
     *      (typically done when observer handles the UI - eg redirecting the user to a confirmation page) 
     */
    public function notify($event, $data = array());
}