<?php
/*-----------------------------------------------------------------------------------------------------------------------------
*******************************************************************************************************************************
LDAP DEBUGGING SCRIPT
Author: celia@tenmiles.com
*******************************************************************************************************************************
------------------------------------------------------------------------------------------------------------------------------*/
	
	include_once("../config.php");
	error_reporting(E_ALL & ~ E_NOTICE);
	

	// Configuration details
/*---------------------------------------------------------------------------------------------------------------------------*/
	$ip="192.168.0.177";
	$port="389";
	$base_dn="dc=pepl,dc=,dc=pel";
	$user_name="administrator";
	// Variation 
	//$user_name="cn=administrator, $base_dn";
	$pass_word="khuljasimsim";
/*---------------------------------------------------------------------------------------------------------------------------*/


	
	// STEP 1: Connect to the LDAP Server.

	ldap_set_option(NULL, LDAP_OPT_DEBUG_LEVEL, 7);
	ldap_set_option(NULL, LDAP_TRACE_LEVEL, 7);

	$conn=ldap_connect($ip,$port);
	ldap_set_option($conn, LDAP_OPT_PROTOCOL_VERSION, 3);
	ldap_set_option($conn, LDAP_OPT_REFERRALS, 0);
	
	if(!$conn)	
	{
		die("Could not connect to the LDAP Server");
	}

	echo " Connect to LDAP Server succeeded. Trying to Bind to the server ... <br/>";

//------------------------------------------------------------------------------------------------------------------------------------------------

	// STEP 2: Bind the account to the LDAP Server.
	$bind=ldap_bind($conn,$user_name,$pass_word);

	if(!$bind)
	{
		die(ldap_error($conn));
	}

	echo " Authentication successful. Fetching customer email address <br/>";

//-----------------------------------------------------------------------------------------------------------------------------------------------

	// STEP 3: Search for entries based on the base distinguished name

	$filter="(|(sn=$user_name*)(cn=$user_name*)(givenname=$user_name*)(sAMAccountName=$user_name*))";
	$sr=ldap_search($conn,$base_dn,$filter);
	if(!$sr)
	{
		die(" A search could not be done using the entered base distinguished name");
	}
	$info = ldap_get_entries($conn, $sr);
	if(count($info) <=0 )
	{
		die(" No further information found for this particular account ");
	}

	for ($i=0; $i<$info["count"]; $i++) 
	{
       				if(strtolower($info[$i]['sn'][0])==strtolower($user_name) or strtolower($info[$i]['givenname'][0])==strtolower($user_name) or strtolower($info[$i]['cn'][0])==strtolower($user_name))
			{
				$user_info['email']=$info[$i]['mail'][0];
						break;	
			}
      }

//-------------------------------------------------------------------------------------------------------------------------------------------------

	// STEP 4: Print out user's email address. Display of this confirms that LDAP is working perfectly.	
	echo "User's email address: ".$user_info['email'];



/*--------------------------------------------------------------------------------------------------------------------------------------------------*/
?>
