<?php
include_once("session.php");
include_once("header.php");
class Ticketdetail {
    //-------------------------------------------------------------------------
    function view_ticket_details($supp_obj, $a_predefined, $generic_msg, $return_status = array()) {
        
        // Get in all global and session variables
        $get_vars     = $a_predefined['get'];
        $post_vars    = $a_predefined['post'];
        $session_vars = $a_predefined['session'];
        $zone         = $session_vars['zone'];
        $supportlang  = $session_vars['supportlang'];
        @extract($post_vars);
        if ($ticket_id == "") {
            $ticket_id = $get_vars['ticket_id'];
        }
        // Prefix and prepare all tables		
        $tickets           = $supp_obj->prefix_table("tickets");
        $departments       = $supp_obj->prefix_table("departments");
        $ticket_status     = $supp_obj->prefix_table("ticket_status");
        $ticket_priorities = $supp_obj->prefix_table("ticket_priorities");
        $clients           = $supp_obj->prefix_table("clients");
        $staff             = $supp_obj->prefix_table("staff");
        $ticket_replies    = $supp_obj->prefix_table("ticket_replies");
        // Get in ticket_detail tpl file content
        $template          = "templates/ticket_detail.tpl";
        $content           = $supp_obj->return_file_content($template);
        // Get Ticket details
        $sql               = "select *," . $supp_obj->add_offsetNformat('sent_date', $zone, 'minute') . " from $tickets where ticket_id='$ticket_id' ";
        $a_ticket          = $supp_obj->get_a_line($sql);
        list($date, $time) = preg_split("/[ ]+/is", $a_ticket['sent_date'], -1, PREG_SPLIT_NO_EMPTY);
        list($y, $m, $d) = explode("-", $date);
        list($h, $i, $s) = explode(":", $time);
        $a_ticket['ticket_created'] = @gmdate("d M Y H:i:s", @gmmktime($h, $i, $s, $m, $d, $y));
        
        $dept_id       = $a_ticket['dept_id'];
        $content       = $supp_obj->screen_timespent($content, $dept_id);
        $status        = $a_ticket['status'];
        $subject       = $a_ticket['subject'];
        $reply_subject = $supp_obj->clean_textbox_data("Re: " . $subject . " ($ticket_id)");
        $client_id     = $session_vars['client_id'];
        
        switch ($status) {
            case "O":
                $class        = "info";
                $contentclass = "ticket-content-open";
                break;
            case "N":
                $class        = "danger";
                $contentclass = "ticket-content-new";
                break;
            case "H":
                $class        = "warning";
                $contentclass = "ticket-content-hold";
                break;
            case "C":
                $class        = "default";
                $contentclass = "ticket-content-closed";
                break;
            case "S":
                $class        = "primary";
                $contentclass = "ticket-content-spam";
                break;
        }
        
        
        $replace_content['class']        = $class;
        $replace_content['contentclass'] = $contentclass;
        $priority_id                     = $a_ticket['priority_id'];
        $client_id                       = $a_ticket['client_id'];
        // select all ticket replies		
        $sql                             = "select *, replied_on as sort_field ," . $supp_obj->add_offsetNformat('replied_on', $zone, 'minute') . " , " . $supp_obj->add_offsetNformat('last_update', $zone, 'minute') . "from $ticket_replies where ticket_id='$ticket_id' and private <> '1' order by $ticket_replies.reply_id asc   ";
        //echo $sql;
        $a_replies                       = $supp_obj->get_rsltset($sql);
        $pattern                         = "/\<\{replies_loopstart\}\>(.*?)\<\{replies_loopend\}\>/is";
        preg_match($pattern, $content, $out1);
        $outer_match = $out1[1];
        // check whether reply box has to be shown or not
        if (count($a_replies) == 0) {
            $content = preg_replace("/\<\{replybox_start\}\>(.*?)\<\{replybox_end\}\>/is", "", $content);
        } else {
            $content = preg_replace("/\<\{replybox_(.*?)\}\>/is", "", $content);
        }
        
        $str = "";
        
        // loop over ticket replies 
        $ticket_attachments = $supp_obj->prefix_table("ticket_attachments");
        
        $staffclass        = $contentclass;
        $departments       = $supp_obj->prefix_table("departments");
        $staff_departments = $supp_obj->prefix_table("staff_departments");
        
        for ($i = 0; $i < count($a_replies); $i++) {
            $row = $a_replies[$i];
            @extract($row);
            
            if ($reply_minutes == "") {
                $reply_minutes = 0;
            }
            $ticket_minutes += $reply_minutes;
            
            $dept_name = "";
            $readdept  = "";
            
            if ($reporter == "STAFF") {
                $sql        = "select dept_name from $departments, $staff_departments where $departments.dept_id=$staff_departments.dept_id
					  and $staff_departments.staff_id='$reporter_id' and readonlyaccess<>'1' ";
                $a_deptlist = $supp_obj->get_single_column($sql);
                $dept_name  = @implode(", ", $a_deptlist);
                $sql        = "select dept_name from $departments, $staff_departments where $departments.dept_id=$staff_departments.dept_id
					  and $staff_departments.staff_id='$reporter_id' and readonlyaccess='1'";
                $a_deptlist = $supp_obj->get_single_column($sql);
                $readdept   = @implode(", ", $a_deptlist);
                if ($readdept != "") {
                    $readdept = "\n[" . $readdept . "]";
                }
                
            }
            
            list($date, $time) = preg_split("/[ ]+/is", $replied_on, -1, PREG_SPLIT_NO_EMPTY);
            list($y, $m, $d) = explode("-", $date);
            list($h, $ii, $s) = explode(":", $time);
            $sec = @gmmktime($h, $ii, $s, $m, $d, $y);
            list($date, $time) = preg_split("/[ ]+/is", $last_update, -1, PREG_SPLIT_NO_EMPTY);
            list($y, $m, $d) = explode("-", $date);
            list($h, $ii, $s) = explode(":", $time);
            $sec1 = @gmmktime($h, $ii, $s, $m, $d, $y);
            if ($sec1 <= 0) {
                $last_update = @gmdate("d M Y H:i:s", $sec);
            } else {
                $last_update = @gmdate("d M Y H:i:s", $sec1);
            }
            $replied_on = @gmdate("d M Y H:i:s", $sec);
            
            if ((count($a_replies) - 1) == $i) {
                $lastresponse = '<a name=last></a>';
            } else {
                $lastresponse = '';
            }
            
            
            
            // see whether the reply was posted by customer or staff
            
            if ($reporter == "CLIENT") {
                $sql           = "select client_name from $clients where client_id='$client_id' ";
                $a_client      = $supp_obj->get_a_line($sql);
                $reporter_name = $a_client['client_name'];
                //	$reporter_name="<a >".$reporter_name."</a>";	
                
                $contentclass = $class;
            } else {
                $sql           = "select staff_name from $staff where staff_id='$reporter_id' ";
                $a_client      = $supp_obj->get_a_line($sql);
                $reporter_name = $a_client['staff_name'];
                //	$reporter_name="<a title=\"$dept_name $readdept\">".$reporter_name."</a>";	
                $contentclass  = $staffclass;
            }
            $reply = str_replace("\\", "\\\\", $reply);
            
            $replyo = $reply;
            // change all line feed characters to <br> so that the reply wraps properly on the browser
            if (!preg_match("/\<(.*?)\>(.*?)\<\/(.*?)\>/is", $reply)) {
                $reply = nl2br($reply);
            }
            // alternate colors
            $reply = $supp_obj->makeClickableLinks($reply);
            
            
            // will have to replace inner loop now
            $temp_match = $outer_match;
            //echo "client_id=$client_id , reporter_id =$reporter_id <br/> ";
            if ($client_id == $reporter_id and $reporter == "CLIENT") {
                $outer_match = preg_replace("/\<\{actionneeded_(.*?)\}\>/is", "", $outer_match);
            } else {
                $outer_match = preg_replace("/\<\{actionneeded_start\}\>(.*?)\<\{actionneeded_end\}\>/is", "", $outer_match);
            }
            
            // for other recipients
            if ($reply_recipients != "") {
                $outer_match = preg_replace("/<{replyrecipients_(.*?)}>/is", "", $outer_match);
            } else {
                $outer_match = preg_replace("/<{replyrecipients_start}>(.*?)<{replyrecipients_end}>/is", "", $outer_match);
            }
            
            
            
            $innerpattern = "/\<\{replyfiles_loopstart\}\>(.*?)\<\{replyfiles_loopend\}\>/is";
            preg_match($innerpattern, $outer_match, $out2);
            //print_R($out2);
            $inner_match = $out2[1];
            //echo "inner_match = $inner_match ";
            $sql         = "select * from $ticket_attachments where reply_id='$reply_id' ";
            //echo $sql;
            $a_attach    = $supp_obj->get_rsltset($sql);
            //print_R($a_attach);
            $string      = "";
            for ($j = 0; $j < count($a_attach); $j++) {
                $row = $a_attach[$j];
                @extract($row);
                //$string .= preg_replace("/\<\{(.*?)\}\>/e", "$$1", $inner_match);
				preg_match_all("/\<\{(.*?)\}\>/", $inner_match, $matches);
				$tmp_array = array();
				foreach ($matches[0] as $index => $var_name) {
					$tmp_var_name = $matches[1][$index];
					if (isset($$tmp_var_name)) {
						$tmp_array[$tmp_var_name] = $$tmp_var_name;
					} else {
						$tmp_array[$tmp_var_name] = '';
					}
				}
				
				$string .= preg_replace_callback("/\<\{(.*?)\}\>/",
									 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
									 $inner_match);
            }
            //echo "string = $string <br/>";
            $outer_match = preg_replace($innerpattern, $string, $outer_match);
            //echo "outer_match=$outer_match";						
            // inner loop replace end
            //$str .= preg_replace("/\<\{(.*?)\}\>/e", "$$1", $outer_match);
			preg_match_all("/\<\{(.*?)\}\>/", $outer_match, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$str .= preg_replace_callback("/\<\{(.*?)\}\>/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $outer_match);
								 
            $outer_match = $temp_match;
        }
        $content            = preg_replace($pattern, $str, $content);
        $subject_array      = preg_split("/[ ]/", $subject);
        $ticket_attachments = $supp_obj->prefix_table("ticket_attachments");
        $sql                = "select * from $ticket_attachments where ticket_id='$ticket_id' and reply_id='0' ";
        $loop_sql['files_'] = $sql;
        $fields             = $supp_obj->prefix_table("fields");
        $field_dept         = $supp_obj->prefix_table("field_dept");
        
        $sql                      = "select field_name, table_field from $fields,$field_dept where  $fields.field_id=$field_dept.field_id
	and $field_dept.dept_id in ('0','$dept_id') and orient_id='2'"; // and submitform='1' ";
        $loop_sql['customfield_'] = $sql;
        
        $sql_status = "select status from $tickets where ticket_id = '$ticket_id'";
        $sql_status = $supp_obj->get_a_line($sql_status);
        $sql_status = $sql_status[0];
        
        if ($sql_status == "O") {
            $status1        = "info";
            $contentstatus1 = "ticket-content-open";
        } else if ($sql_status == "N") {
            $status1        = "danger";
            $contentstatus1 = "ticket-content-new";
        } else if ($sql_status == "C") {
            $status1        = "default";
            $contentstatus1 = "ticket-content-closed";
        } else if ($sql_status == "S") {
            $status1        = "primary";
            $contentstatus1 = "spam";
        } else if ($sql_status == "H") {
            $status1        = "warning";
            $contentstatus1 = "ticket-content-hold";
        }
        
        $custom_field_data        = "";
        $client_custom_field_data = $this->get_custom_fields($supp_obj, $client_id, "0");
        $names                    = $client_custom_field_data[0];
        $values                   = $client_custom_field_data[1];
        for ($m = 0; $m < count($names); $m++) {
            /*$custom_field_data .= "<tr class='$contentstatus1'>
            <td class='$status1' width='15%' > " . $names [$m] . "
            </td>
            <td class='$contentstatus1' colspan=5>" . $values [$m] . "		
            </td>		
            </tr>";*/
            
            $custom_field_data .= '<a class="list-group-item">' . $names[$m] . ' <span class="badge badge-' . $status1 . '">' . $values[$m] . '</span></a>';
            
        }
        $content = preg_replace("/<{client_custom_field_data}>/is", $custom_field_data, $content);
        
        $custom_field_data        = "";
        $ticket_custom_field_data = $this->get_custom_fields($supp_obj, $ticket_id, "1");
        $names                    = $ticket_custom_field_data[0];
        $values                   = $ticket_custom_field_data[1];
        for ($m = 0; $m < count($names); $m++) {
            /*$custom_field_data .= "<tr class='$contentstatus1'>
            <td class='$status1' width='15%' > " . $names [$m] . "
            </td>
            <td class='$contentstatus1' colspan=5>" . $values [$m] . "		
            </td>		
            </tr>";*/
            $custom_field_data .= '<a class="list-group-item">' . $names[$m] . ' <span class="badge badge-' . $status1 . '">' . $values[$m] . '</span></a>';
        }
        $content = preg_replace("/<{ticket_custom_field_data}>/is", $custom_field_data, $content);
        
        $sql                        = "select field_name, table_field  from $fields where orient_id='1'"; // and submitform='1' ";
        $loop_sql['customerfield_'] = $sql;
        
        
        $a_content = $supp_obj->replace_loop($loop_sql, $content, $eval_code, '', "<{", "}>", $subject_array);
        $content   = $a_content[0];
        //echo "content=$content";
        if ($a_content[1]['files_'] == 0) // No attached files 
            {
            $replace_content['statustxt'] = $generic_msg['cNo_attachment'];
        }
        $sql        = "select dept_name from $departments where dept_id='$dept_id'";
        $a_dept     = $supp_obj->get_a_line($sql);
        //get status name
        $sql        = "select statusname as status_name from $ticket_status where status_key='$status'";
        $a_status   = $supp_obj->get_a_line($sql);
        $sql        = "select priorityname as priority_name from $ticket_priorities where priority_id='$priority_id'";
        $a_priority = $supp_obj->get_a_line($sql);
        //get Client details
        $sql        = "select * from $clients where client_id='$client_id' ";
        $a_client   = $supp_obj->get_a_line($sql);
        
        $a_client1 = $supp_obj->prefix_keys($a_client, "cs");
        $a_ticket1 = $supp_obj->prefix_keys($a_ticket, "tt");
        
        //get Staff details
        $sql     = "select staff_name from $staff where staff_id='$staff_id'";
        //echo $sql;
        $a_staff = $supp_obj->get_a_line($sql);
        
        $replace_content['reply_subject'] = $reply_subject;
        
        $replace_content = @array_merge($replace_content, $a_ticket, $a_dept, $a_status, $a_priority, $a_client, $a_client1, $a_ticket1);
        if (isset($a_staff['staff_name']) && $a_staff['staff_name'] != "") {
            $replace_content = @array_merge($replace_content, $a_staff);
        }
        if (!preg_match("/\<(.*?)\>(.*?)\<\/(.*?)\>/is", $replace_content['message'])) {
            $replace_content['message'] = nl2br($replace_content['message']);
        }
        $replace_content['message'] = $supp_obj->makeClickableLinks($replace_content['message']);
        
        $replace_content['ticket_minutes'] = $ticket_minutes;
        
        //	print_R($return_status);
        if ($return_status['status_msg'] == "") {
            $content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
        } else {
            $content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
        }
        if ($status == "C") // if the ticket status is already closed
            {
            $content = preg_replace("/\<\{closedtkt_start\}\>(.*?)\<\{closedtkt_end\}\>/is", "", $content);
        } else {
            $content = preg_replace("/\<\{closedtkt_(.*?)\}\>/is", "", $content);
        }
        $replace_content['status_msg'] = $generic_msg[$return_status['status_msg']];
        
        if (!preg_match("/^c/", $return_status['status_msg'])) {
            $replace_content['status_msg'] = $return_status['status_msg'];
        }
        
        if (count($a_replies) == 0) {
            $replace_content['lastresponse'] = '<a name="last"></a>';
        }
        
        // Other recipients block
        if ($a_ticket['other_recipients'] != "") {
            $content = preg_replace("/\<\{otherrecipients_(.*?)\}\>/is", "", $content);
        } else {
            $content = preg_replace("/\<\{otherrecipients_start\}\>(.*?)\<\{otherrecipients_end\}\>/is", "", $content);
            
        }
        
        
        $replace_content['reply_data'] = $post_vars['reply_data'];
        $replace_content["subject"]    = str_replace("\\", "\\\\", $replace_content["subject"]);
        $replace_content["message"]    = str_replace("\\", "\\\\", $replace_content["message"]);
        
        $content = $supp_obj->direct_replace($content, $replace_content);
        echo $content;
        // mark all replies posted by staff as read
        $ticket_replies = $supp_obj->prefix_table("ticket_replies");
        $sql            = "update $ticket_replies set readflag='R' where ticket_id='$ticket_id' and reporter='STAFF' ";
        $supp_obj->execute_query($sql);
    }
    //--------------------------------------------------------------------------------------
    function authorize_client($supp_obj, $a_predefined, $generic_msg) {
        $post_vars    = $a_predefined['post'];
        $session_vars = $a_predefined['session'];
        $get_vars     = $a_predefined['get'];
        $ticket_id    = $get_vars['ticket_id'];
        
        @extract($post_vars);
        
        
        $client_id = $session_vars['client_id'];
        
        $tickets  = $supp_obj->prefix_table("tickets");
        $sql      = "select client_id from $tickets where ticket_id='$ticket_id' ";
        $a_ticket = $supp_obj->get_a_line($sql);
        if ($a_ticket['client_id'] != $client_id) {
            $return_array['status']     = false;
            $return_array['status_msg'] = "cAuth_denied";
            return $return_array;
        }
        
        $return_array['status'] = true;
        return $return_array;
        
        
    }
    
    function edit_reply($supp_obj, $a_predefined, $client_id) {
        $post_vars = $a_predefined['post'];
        @extract($post_vars);
        $ticket_replies = $supp_obj->prefix_table("ticket_replies");
        $tickets        = $supp_obj->prefix_table("tickets");
        $replied_on     = $supp_obj->get_current_date();
        $sql            = "update $ticket_replies set last_update='$replied_on' ,
		last_updatedby='$client_id' , last_reporter='CLIENT',reply='$reply' where 
		reply_id='$reply_id' and ticket_id='$ticket_id' ";
        $supp_obj->execute_query($sql);
        $last_activity = $supp_obj->get_current_date();
        $sql           = "update $tickets set 
		client_last_activity='$last_activity'
		 where ticket_id='$ticket_id' ";
        $supp_obj->execute_query($sql);
        
        $activity_array['ticket_id'] = $ticket_id;
        $activity_array['reply_id']  = $reply_id;
        $supp_obj->log_activity($activity_array, $client_id, 'CLIENT');
        $return_array['status_msg'] = "cTicketreply_edited";
        $staff_departments          = $supp_obj->prefix_table("staff_departments");
        $staff                      = $supp_obj->prefix_table("staff");
        $clients                    = $supp_obj->prefix_table("clients");
        $mail_servers               = $supp_obj->prefix_table("mail_servers");
        $dept_servers               = $supp_obj->prefix_table("dept_servers");
        $config                     = $supp_obj->prefix_table("configuration");
        $departments                = $supp_obj->prefix_table("departments");
        $ticket_replies             = $supp_obj->prefix_table("ticket_replies");
        // Get the ticket details
        $sql                        = "select * from $tickets where ticket_id='$ticket_id' ";
        $a_sql                      = $supp_obj->get_a_line($sql);
        $dept_id                    = $a_sql['dept_id'];
        $client_id                  = $a_sql['client_id'];
        $sql                        = "select * from $config ";
        $a_config                   = $supp_obj->get_a_line($sql);
        @extract($a_config);
        $ticket_replies = $supp_obj->prefix_table("ticket_replies");
        
        // Get the reply subject
        if ($subject == "") {
            $subject = $a_config['tktnotify_subject'];
            //$subject = preg_replace("/{{(.*?)}}/e", "$$1", $subject);
			preg_match_all("/{{(.*?)}}/", $subject, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$subject = preg_replace_callback("/{{(.*?)}}/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $subject);
        }
        //Get the mail server's email address
        $sql         = "select pop3_email,signature from $mail_servers ,
		$dept_servers,$departments where 
		$mail_servers.server_id=$dept_servers.server_id and
		$departments.dept_id=$dept_servers.dept_id 
		and $dept_servers.dept_id='$dept_id' ";
        $a_to        = $supp_obj->get_a_line($sql);
        $email       = $a_to['pop3_email'];
        $signature   = $a_to['signature'];
        //Get the customer's email address
        $sql         = "select * from $clients where client_id='$client_id' ";
        $a_client    = $supp_obj->get_a_line($sql);
        $from        = $a_client['email'];
        $client_name = $a_client['client_name'];
        if ($ticket_id != "") {
            $replace_array = array(
                "reply" => $reply,
                "http_url" => $http_url,
                "ticket_id" => $ticket_id,
                "client_name" => $client_name,
                "signature" => $signature
            );
            $reply_message = $supp_obj->direct_replace($tktnotify_message, $replace_array);
            $tsub          = $a_config['tktnotify_subject'];
            $tmess         = $a_config['tktnotify_message'];
            
            if ($send_mail == 1 and $tktnotify_action == 1) {
                // send mail to all staff in the department who have opted to receive email notifications
                $sql     = "select distinct($ticket_replies.reporter_id), staff_name , staff_email from $staff , 
				$ticket_replies where $staff.staff_id=$ticket_replies.reporter_id
				and $ticket_replies.ticket_id='$ticket_id' and 
				$ticket_replies.reporter='STAFF' and $staff.notify_reply='1'
				 ";
                $a_staff = $supp_obj->get_rsltset($sql);
                for ($s = 0; $s < count($a_staff); $s++) // send notification to all selected staffs 		
                    {
                    $staff_name  = $a_staff[$s]['staff_name'];
                    $staff_email = $a_staff[$s]['staff_email'];
					//$tsub=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tsub);
					preg_match_all("/\{\{(.*?)\}\}/", $tsub, $matches);
					$tmp_array = array();
					foreach ($matches[0] as $index => $var_name) {
						$tmp_var_name = $matches[1][$index];
						if (isset($$tmp_var_name)) {
							$tmp_array[$tmp_var_name] = $$tmp_var_name;
						} else {
							$tmp_array[$tmp_var_name] = '';
						}
					}
					
					$tsub = preg_replace_callback("/\{\{(.*?)\}\}/",
										 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
										 $tsub);
					
					//$tmess=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tmess);
					preg_match_all("/\{\{(.*?)\}\}/", $tmess, $matches);
					$tmp_array = array();
					foreach ($matches[0] as $index => $var_name) {
						$tmp_var_name = $matches[1][$index];
						if (isset($$tmp_var_name)) {
							$tmp_array[$tmp_var_name] = $$tmp_var_name;
						} else {
							$tmp_array[$tmp_var_name] = '';
						}
					}
					
					$tmess = preg_replace_callback("/\{\{(.*?)\}\}/",
										 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
										 $tmess);
                    $supp_obj->send_mail($staff_email, $tsub, $tmess, $admin_email);
                }
                
            }
        }
        return $return_array;
    }
    //------------------------------------------------------------------------------------------	
    
    
    
    
    
    
    
    
    function get_client_custom_fields($supp_obj, $fclient_id) {
        
        $client_custom_names = array();
        $client_custom_data  = array();
        $counter             = 0;
        
        $field_answers        = $supp_obj->prefix_table("field_answers");
        $fields               = $supp_obj->prefix_table("fields");
        $client_custom_values = $supp_obj->prefix_table("client_custom_values");
        $client_custom_ids    = $supp_obj->prefix_table("client_custom_ids");
        
        $custom_answer_ids = "select * from $client_custom_ids where client_id = $fclient_id";
        $custom_answer_ids = $supp_obj->get_rsltset($custom_answer_ids);
        
        $sql = "select * from $fields where orient_id='1'  order by display_order";
        
        $a_fields = $supp_obj->get_rsltset($sql);
        
        $div_id = 0;
        $group  = -1;
        
        $depends_on_id = 0;
        for ($f = 0; $f < count($a_fields); $f++) {
            if ($a_fields[$f]['field_level'] == 0) {
                $group++;
            }
            
            $field_name  = $a_fields[$f]['field_name'];
            $table_field = $a_fields[$f]['table_field'];
            
            $field_option_array    = array();
            $field_option_id_array = array();
            
            
            $div_id++;
            $_SESSION['div_id'] = $div_id;
            $current_id         = $f . "_" . $group . "_" . $a_fields[$f]['field_level'];
            
            $field_level     = $a_fields[$f]['field_level'];
            $parent_field_id = $a_fields[$f]['field_id'];
            
            if ($field_level == 0) {
                $depends_on_id = -1;
            } else {
                $tf = $a_fields[$f - 1]['table_field'];
                if ($a_fields[$f - 1]['field_level'] < $a_fields[$f]['field_level']) {
                    $depends_on_id = $custom_answer_ids[0][$tf];
                }
            }
            if ($depends_on_id == "")
                continue;
            $sql = "select field_answer, answer_id, field_type_id, field_display_id, compulsory, 
				submitform from $field_answers where field_id = $parent_field_id and 
				depends_on_answer_id = $depends_on_id";
            
            
            $res = $supp_obj->get_rsltset($sql);
            for ($m = 0; $m < count($res); $m++) {
                $field_option_array[$m]    = $res[$m][0];
                $field_option_id_array[$m] = $res[$m][1];
            }
            
            if ($res[0]['submitform'] == "0")
                continue;
            
            if (!$this->showField($supp_obj, $res[0]['answer_id']))
                continue;
            
            if ($res[0]['compulsory'] == "1") {
                $mandatory = "*";
            } else {
                $mandatory = "";
            }
            if ($res[0]['field_type_id'] == "3") {
                $selected_id = $custom_answer_ids[0][$table_field];
                $draw_field .= "<div class='formrow' id = $f><span class='label'>$field_name :</span>";
                $draw_field .= "<span class='field'>";
                $client_custom_names[$counter] = $field_name;
                
                for ($o = 0; $o < count($field_option_array); $o++) {
                    if ($selected_id == $field_option_id_array[$o]) {
                        $draw_field .= $field_option_array[$o];
                        $client_custom_data[$counter] = $field_option_array[$o];
                    }
                    
                }
                
                $draw_field .= "</span>";
                $draw_field .= "</span></div>";
                $counter++;
                
            } else if ($res[0]['field_type_id'] == "2" || $res[0]['field_type_id'] == "1") {
                if ($fclient_id != "") {
                    $sql = "select $table_field from $client_custom_values where 
						client_id = $fclient_id";
                    $sql = $supp_obj->get_a_line($sql);
                    $sql = $sql[0];
                    
                } else {
                    $sql = "";
                }
                
                $draw_field .= "<div class='formrow' id = $f><span class='label'>$field_name :</span>";
                $draw_field .= "<span class='field'>";
                
                $client_custom_names[$counter] = $field_name;
                $draw_field .= "$sql";
                $client_custom_data[$counter] = $sql;
                if ($res[0]['compulsory'] == "1")
                    $draw_field .= " <span class=\"mandatory-fld\">*</span>";
                $draw_field .= "</span></div>";
                $counter++;
            } else {
                $depends_on_id = -999;
            }
            
            
        }
        $data[0] = $client_custom_names;
        $data[1] = $client_custom_data;
        return $data;
        //return $draw_field;
        
    }
    
    
    function showField($supp_obj, $id) {
        $field_answers = $supp_obj->prefix_table("field_answers");
        $pid           = 0;
        while ($pid != -1) {
            $sql = "select depends_on_answer_id, submitform from $field_answers where answer_id = $id";
            $res = $supp_obj->get_rsltset($sql);
            $pid = $res[0]['depends_on_answer_id'];
            $id  = $pid;
            if ($res[0]['submitform'] == "0")
                return false;
        }
        return true;
    }
    
    
    
    
    
    
    function get_custom_fields($supp_obj, $id, $custom_field_type) {
        
        $field_answers = $supp_obj->prefix_table("field_answers");
        $fields        = $supp_obj->prefix_table("fields");
        
        if ($custom_field_type == "0") {
            $custom_values = $supp_obj->prefix_table("client_custom_values");
            $custom_ids    = $supp_obj->prefix_table("client_custom_ids");
        } else {
            $custom_values = $supp_obj->prefix_table("ticket_custom_values");
            $custom_ids    = $supp_obj->prefix_table("ticket_custom_ids");
        }
        
        
        if ($custom_field_type == "0")
            $custom_answer_ids = "select * from $custom_ids where client_id = '" . "$id'";
        else
            $custom_answer_ids = "select * from $custom_ids where ticket_id = '" . "$id'";
        $custom_answer_ids = $supp_obj->get_rsltset($custom_answer_ids);
        
        
        $sql = "select * from $fields where orient_id='" . ($custom_field_type + 1) . "'  order by display_order";
        
        $a_fields = $supp_obj->get_rsltset($sql);
        
        $group = -1;
        
        $custom_field_names  = array();
        $custom_field_values = array();
        $counter             = 0;
        
        $depends_on_id = 0;
        for ($f = 0; $f < count($a_fields); $f++) {
            if ($a_fields[$f]['field_level'] == 0) {
                $group++;
            }
            
            $field_name  = $a_fields[$f]['field_name'];
            $table_field = $a_fields[$f]['table_field'];
            
            $field_option_array    = array();
            $field_option_id_array = array();
            
            $field_level     = $a_fields[$f]['field_level'];
            $parent_field_id = $a_fields[$f]['field_id'];
            
            if ($field_level == 0) {
                $depends_on_id = -1;
            } else {
                $tf = $a_fields[$f - 1]['table_field'];
                if ($a_fields[$f - 1]['field_level'] < $a_fields[$f]['field_level']) {
                    $depends_on_id = $custom_answer_ids[0][$tf];
                }
            }
            if ($depends_on_id == "")
                continue;
            $sql = "select field_answer, answer_id, field_type_id, field_display_id, compulsory, 
				submitform from $field_answers where field_id = $parent_field_id and 
				depends_on_answer_id = $depends_on_id";
            
            $res = $supp_obj->get_rsltset($sql);
            
            if (count($res) == 0)
                continue;
            
            for ($m = 0; $m < count($res); $m++) {
                $field_option_array[$m]    = $res[$m][0];
                $field_option_id_array[$m] = $res[$m][1];
            }
            
            if ($res[0]['submitform'] == "0")
                continue;
            
            if (!$this->showField($supp_obj, $res[0]['answer_id'])) {
                continue;
            }
            
            if ($res[0]['compulsory'] == "1") {
                $mandatory = "*";
            } else {
                $mandatory = "";
            }
            if ($res[0]['field_type_id'] == "3") {
                $selected_id                  = $custom_answer_ids[0][$table_field];
                $custom_field_names[$counter] = $field_name;
                
                for ($o = 0; $o < count($field_option_array); $o++) {
                    if ($selected_id == $field_option_id_array[$o]) {
                        $custom_field_values[$counter] = $field_option_array[$o];
                        $counter++;
                    }
                }
            } else if ($res[0]['field_type_id'] == "2" || $res[0]['field_type_id'] == "1") {
                if ($id != "") {
                    if ($custom_field_type == "0") {
                        $sql = "select $table_field from $custom_values where 
							client_id = '$id'";
                    } else {
                        $sql = "select $table_field from $custom_values where 
							ticket_id = '$id'";
                    }
                    $sql = $supp_obj->get_a_line($sql);
                    $sql = $sql[0];
                    
                } else {
                    $sql = "";
                }
                
                $custom_field_names[$counter]  = $field_name;
                $custom_field_values[$counter] = $sql;
                $counter++;
                
            } else {
                $depends_on_id = -999;
            }
            
        }
        $data = array();
        
        $data[0] = $custom_field_names;
        $data[1] = $custom_field_values;
        return $data;
        
    }    
}

$tick         = new Ticketdetail();
$return_array = $tick->authorize_client($supp_obj, $a_predefined, $generic_msg);

if ($return_array['status'] == true) {
    switch ($act) {
        case NULL:
            $tick->view_ticket_details($supp_obj, $a_predefined, $generic_msg);
            break;
        case "quickreply":
            $ticket_id = $a_predefined['post']['ticket_id'];
            $tickets   = $supp_obj->prefix_table("tickets");
            $sql       = "select status from $tickets where ticket_id='$ticket_id' ";
            $a_sql     = $supp_obj->get_a_line($sql);
            if ($a_sql['status'] == "C") {
                $a_predefined['post']['tktstatus']   = "O";
                $a_predefined['post']['dotktaction'] = "O";
            }
            $return_array = $supp_obj->submit_client_reply($supp_obj, $a_predefined, $generic_msg);
            $tick->view_ticket_details($supp_obj, $a_predefined, $generic_msg, $return_array);
            break;
        case "deletereply":
            $return_array = $tick->delete_reply($supp_obj, $a_predefined, $staff_id);
            $tick->view_ticket_details($supp_obj, $a_predefined, $generic_msg, $return_array);
            break;
        case "editreply":
            $return_array = $tick->edit_reply($supp_obj, $a_predefined, $_SESSION['client_id']);
            $tick->view_ticket_details($supp_obj, $a_predefined, $generic_msg, $return_array);
            break;
    }
} else {
    echo $generic_msg[$return_array['status_msg']];
}
include_once("footer.php");
