jQuery(function($){        
    /* reportrange */
    if(jQuery("#reportrange").length > 0) {
        jQuery("#reportrange").daterangepicker({               
            ranges: {
               'Today': [moment(), moment()],
               'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
               'Last 7 Days': [moment().subtract(6, 'days'), moment()],
               'Last 30 Days': [moment().subtract(29, 'days'), moment()],
               'This Month': [moment().startOf('month'), moment().endOf('month')],
               'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            opens: 'left',
            buttonClasses: ['btn btn-default'],
            applyClass: 'btn-small btn-primary',
            cancelClass: 'btn-small',
            format: 'MM-DD-YYYY',
            separator: ' to ',
			startDate: jQuery('#startDate').val(),
            endDate: jQuery('#endDate').val(),
			onSelect: function() {jQuery(this).show();}
          },function(start, end) {
              jQuery('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        });
        
        jQuery("#reportrange span").html(moment($("#startDate").val(), 'MM-DD-YYYY').format('MMMM D, YYYY') + ' - ' + moment($("#endDate").val(), 'MM-DD-YYYY').format('MMMM D, YYYY'));
		
		jQuery('#reportrange').on('apply.daterangepicker', function(ev, picker) {
		  jQuery(this).show();
		  jQuery('#fday').val(picker.startDate.format('DD'));
		  jQuery('#fmonth').val(picker.startDate.format('MM'));
		  jQuery('#fyear').val(picker.startDate.format('YYYY'));
		  jQuery('#tday').val(picker.endDate.format('DD'));
		  jQuery('#tmonth').val(picker.endDate.format('MM'));
		  jQuery('#tyear').val(picker.endDate.format('YYYY'));
		  
		  $("#frmDaterange").submit();
		});
    }
	
	
	
    /* end reportrange */
    
    jQuery(".x-navigation-minimize").on("click",function(){
        setTimeout(function(){
            rdc_resize();
        },200);    
    });
    
    
});

