<?php
/**
 * Manage Invoice Class
 */
class invoiceManage
{
    private $locale = array();
    private $status_msg = array();

    public function __construct()
    {
        global $a_predefined, $gengeneric_msg;
        $session_vars = $a_predefined['session'];

        $supportlang = !empty($session_vars['supportlang'])? $session_vars['supportlang'] : 'en';
        $language_dir = "../plugins/invoice/lang/$supportlang/invoice.php";
        if (!file_exists($language_dir)) {
            $language_dir = "../plugins/invoice/lang/en/invoice.php";
        }
        include_once($language_dir);

        $this->locale = $plugin_msg;
    }

    public function debug($data, $exit = false)
    {
        echo '<pre>';
        print_r($data);
        echo '</pre>';

        if ($exit) {
            exit;
        }
    }

    protected function notifications($content, $status_msg = '')
    {
        if (!empty($status_msg)) {
            $content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
            $this->status_msg = (array)$status_msg;
        } else {
            $content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
        }

        return $content;
    }

    protected function invoice_status($content, $invoice)
    {
        if ($invoice) {
            $content = preg_replace("/\<\{notfound_(.*?)\}\>/is", "", $content);
        } else {
            $status_msg = 'Invoice not found';
            $content = $this->notifications($content, $status_msg);
            $content = preg_replace("/\<\{notfound_start\}\>(.*?)\<\{notfound_end\}\>/is", "", $content);
        }

        return $content;
    }

    public function manage($data = array())
    {
        global $supp_obj, $a_predefined, $generic_msg;

        $invoices	              =   $supp_obj -> prefix_table("invoices");
        $invoice_services	      =   $supp_obj -> prefix_table("invoice_services");
        $invoice_payments	      =   $supp_obj -> prefix_table("invoice_payments");

        $template = "../plugins/invoice/templates/manage.tpl";
        $content = $supp_obj->return_file_content($template);

        $status_msg = $data['status_msg'] ?? '';
        $content = $this->notifications($content, $status_msg);

        $loop_sql['invoices_'] = "SELECT *, (SELECT SUM(cost) FROM $invoice_services WHERE $invoice_services.invoice_id = $invoices.id) as total, (SELECT SUM(amount) FROM $invoice_payments WHERE $invoice_payments.invoice_id = $invoices.id) as total_payments FROM $invoices";
        $a_content = $supp_obj->replace_loop($loop_sql, $content);
        $content = $a_content[0];

        $replace_array = array_merge($generic_msg, $this->locale, array('status_msg' => $status_msg));

        $content = $supp_obj->direct_replace($content, $replace_array);

        echo $content;
    }

    public function delete()
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $get = $a_predefined['get'];
        $return = array();
        $invoice_no = $get['invoice_no'] ?? false;
        if ($invoice_no) {
            $invoices = $supp_obj -> prefix_table("invoices");
            $sql = "DELETE FROM $invoices WHERE id = '$invoice_no'";
            $supp_obj->execute_query($sql);

            $return['status_msg'] = 'Invoice deleted successfully.';
        }

        return $return;
    }

    protected function getInvoice($invoice_no)
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $invoices	              =   $supp_obj -> prefix_table("invoices");
        $invoice_services	      =   $supp_obj -> prefix_table("invoice_services");
        $invoice_payments	      =   $supp_obj -> prefix_table("invoice_payments");

        $sql = "SELECT * FROM $invoices WHERE id = '$invoice_no'";
        $row = $supp_obj->get_a_line($sql);
        $invoice = array();
        if ($row) {
            $invoice['invoice_no'] = $row['id'];
            $invoice['company'] = $row['company'];
            $invoice['due_date'] = $row['due_date'];
            $invoice['status'] = $row['status'];

            $sql = "SELECT * FROM $invoice_services WHERE invoice_id = '$invoice_no'";
            $servicesRow = $supp_obj->get_rsltset($sql);

            foreach ($servicesRow as $index => $service) {
                $service_id = $service['id'];
                $invoice['services'][$index]['id'] = $service['id'];
                $invoice['services'][$index]['name'] = $service['service'];
                $invoice['services'][$index]['cost'] = $service['cost'];

                $sql = "SELECT * FROM $invoice_payments WHERE service_id = '$service_id'";
                $paymentsRow = $supp_obj->get_rsltset($sql);
                foreach ($paymentsRow as $key => $payment) {
                    $invoice['services'][$index]['payments'][$key]['id'] = $payment['id'];
                    $invoice['services'][$index]['payments'][$key]['amount'] = $payment['amount'];
                    $invoice['services'][$index]['payments'][$key]['payment_date'] = $payment['payment_date'];
                    $invoice['services'][$index]['payments'][$key]['payment_method'] = $payment['payment_method'];
                    $invoice['services'][$index]['payments'][$key]['notes'] = $payment['notes'];
                }
            }

            return $invoice;
        }
    }

    public function create($data = array())
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $field_answers          =  $supp_obj -> prefix_table("field_answers");
        $invoices	              =   $supp_obj -> prefix_table("invoices");
        $invoice_services	      =   $supp_obj -> prefix_table("invoice_services");
        $invoice_payments	      =   $supp_obj -> prefix_table("invoice_payments");

        $template = "../plugins/invoice/templates/create.tpl";
        $content = $supp_obj->return_file_content($template);

        $sql = "SELECT field_answer FROM $field_answers WHERE field_id = '6' ORDER BY field_answer";
        $companies = $supp_obj->get_single_column($sql);
        $sql = "SELECT field_answer FROM $field_answers WHERE field_id = '12' ORDER BY field_answer";
        $services_list = $supp_obj->get_single_column($sql);

        $services = array();
        $invoice = true;

        if (!empty($data['invoice_no'])) {
            $invoice_no = $data['invoice_no'];
            $data['post'] = $this->getInvoice($invoice_no);
        }

        if ($data['post']) {
            $invoice = $data['post'];
            $services = $invoice['services'] ?? array();
            $replace['invoice_no'] = $invoice['invoice_no'];
            $replace['company'] = $invoice['company'];
            $replace['due_date'] = $invoice['due_date'] ?? 'abbas';
            $replace['status'] = $invoice['status'] ?? 'abbas';
        }

        $content = $this->invoice_status($content, $invoice);
        $status_msg = $data['status_msg'] ?? '';
        $content = $this->notifications($content, $status_msg);

        $replace['invoice_services'] = json_encode($services);
        $replace['companies'] = json_encode($companies);
        $replace['services_list'] = json_encode($services_list);
        $replace_array = array_merge($generic_msg, $this->locale, array('status_msg' => $status_msg), $replace);

        $content = $supp_obj->direct_replace($content, $replace_array);

        echo $content;
    }

    public function updateOrCreate($status_msg = '')
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $post = $a_predefined['post'];

        $invoice_no = $post['invoice_no'];
        $company = $post['company'];
        $services = $post['services'];

        $return = array();
        $return['error'] = true;
        $return['post'] = $post;

        if (empty($company) || count($services) === 0) {
            $return['status_msg'] = empty($company)? $this->locale['pNoCompanyName'] : (count($services) === 0? $this->locale['pNoServices'] : '');
        } else {
            $return['error'] = false;
            if (empty($invoice_no)) {
                $status =  $this->insertInvoice($post);
            } else {
                $status =  $this->updateInvoice($post);
            }

            $return['invoice_no'] = $status['invoice_no'] ?? '';
            $return['status_msg'] = $status['message'] ?? '';
        }

        return $return;
    }

    protected function updateInvoice($post)
    {
        global $supp_obj, $a_predefined, $generic_msg;

        $invoices	              =   $supp_obj->prefix_table("invoices");
        $invoice_services	      =   $supp_obj->prefix_table("invoice_services");
        $invoice_payments	      =   $supp_obj->prefix_table("invoice_payments");

        $invoice_no = $post['invoice_no'];
        $company = $post['company'];
        $services = $post['services'];

        $sql = "SELECT id FROM $invoices WHERE id = '$invoice_no'";
        $check = $supp_obj->get_a_line($sql);
        if (!$check) {
            return 'Invoice not found or might have deleted. Please create new one.';
        }

        $avoid_array = array('id', 'updated_at', 'created_at', 'due_date', 'status');
        $invoiceArray = array();
        $invoiceArray['company'] = $company;
        $sql = $supp_obj->construct_query($invoices, 'UPDATE', $invoiceArray, $avoid_array);
        $sql .= " WHERE id = '$invoice_no'";
        $supp_obj->execute_query($sql);

        $sql = "DELETE FROM $invoice_services WHERE invoice_id = '$invoice_no'";
        $supp_obj->execute_query($sql);

        $avoid_array = array('id', 'updated_at');
        foreach ($services as $index => $service) {
            $payments = $service['payments'] ?? array();
            $serviceArray = array();
            $serviceArray['invoice_id'] =  $invoice_no;
            $serviceArray['service'] =  $service['name'];
            $serviceArray['cost'] =  $service['cost'];
            $serviceArray['created_at'] = date('Y-m-d H:i:s');

            $sql = $supp_obj->construct_query($invoice_services, 'INSERT', $serviceArray, $avoid_array);
            $service_id = $supp_obj->execute_query($sql);

            foreach ($payments as $key => $payment) {
                $paymentArray = array();
                $paymentArray['service_id'] =  $service_id;
                $paymentArray['invoice_id'] =  $invoice_no;
                $paymentArray['amount'] =  $payment['amount'];
                $paymentArray['payment_date'] =  $payment['payment_date'];
                $paymentArray['payment_method'] =  $payment['payment_method'];
                $paymentArray['notes'] =  $payment['notes'];
                $paymentArray['created_at'] = date('Y-m-d H:i:s');

                $sql = $supp_obj->construct_query($invoice_payments, 'INSERT', $paymentArray, $avoid_array);
                $payment_id = $supp_obj->execute_query($sql);
            }
        }

        $return = array();
        $return['invoice_no'] = $invoice_no;
        $return['message'] = 'Invoice updated successfully.';

        return $return;
    }

    protected function insertInvoice($post)
    {
        global $supp_obj, $a_predefined, $generic_msg;

        $invoices	              =   $supp_obj -> prefix_table("invoices");
        $invoice_services	      =   $supp_obj -> prefix_table("invoice_services");
        $invoice_payments	      =   $supp_obj -> prefix_table("invoice_payments");

        $invoice_no = $post['invoice_no'];
        $company = $post['company'];
        $services = $post['services'];

        $avoid_array = array('id', 'updated_at', 'due_date', 'status');
        $invoiceArray = array();
        $invoiceArray['company'] = $company;
        $invoiceArray['created_at'] = date('Y-m-d H:i:s');
        $sql = $supp_obj->construct_query($invoices, 'INSERT', $invoiceArray, $avoid_array);
        $invoice_no = $post['invoice_no'] = $supp_obj->execute_query($sql);

        foreach ($services as $index => $service) {
            $payments = $service['payments'] ?? array();
            $serviceArray = array();
            $serviceArray['invoice_id'] =  $invoice_no;
            $serviceArray['service'] =  $service['name'];
            $serviceArray['cost'] =  $service['cost'];
            $serviceArray['created_at'] = date('Y-m-d H:i:s');

            $sql = $supp_obj->construct_query($invoice_services, 'INSERT', $serviceArray, $avoid_array);
            $service_id = $supp_obj->execute_query($sql);

            foreach ($payments as $key => $payment) {
                $paymentArray = array();
                $paymentArray['service_id'] =  $service_id;
                $paymentArray['invoice_id'] =  $invoice_no;
                $paymentArray['amount'] =  $payment['amount'];
                $paymentArray['payment_date'] =  $payment['payment_date'];
                $paymentArray['payment_method'] =  $payment['payment_method'];
                $paymentArray['notes'] =  $payment['notes'];
                $paymentArray['created_at'] = date('Y-m-d H:i:s');

                $sql = $supp_obj->construct_query($invoice_payments, 'INSERT', $paymentArray, $avoid_array);
                $payment_id = $supp_obj->execute_query($sql);
            }
        }
        $return = array();
        $return['invoice_no'] = $invoice_no;
        $return['message'] = 'Invoice saved successfully.';

        return $return;
    }

    public function export()
    {
        global $supp_obj, $a_predefined, $generic_msg;
        $get = $a_predefined['get'];
        $export_file  = "../plugins/invoice/generate_invoice.php";
        if (file_exists($export_file)) {
            include($export_file);
        }
    }
}

$invoice = $task = null;
if ($supp_obj->is_plugin_active('invoice')) {
    $task = $a_predefined['get']['task'];
    $invoice = new invoiceManage();
}

switch ($task) {
  case 'create':
    $invoice->create();
    break;
  case 'export':
    $invoice->export();
    break;
  case 'manage':
    $invoice->manage();
    break;
  case 'update':
    $data = $invoice->updateOrCreate();
    $invoice->create($data);
    break;
  case 'edit':
    $data['invoice_no'] = $a_predefined['get']['invoice_no'] ?? '';
    $invoice->create($data);
    break;
  case 'delete':
    $data = $invoice->delete();
    $invoice->manage($data);
    break;
}

function view_plugin_properties($supp_obj, $a_predefined, $generic_msg, $status_msg)
{
}
function update_plugin_properties($supp_obj, $a_predefined, $generic_msg, $status_msg)
{
}
