<?php
$plugins = $supp_obj->prefix_table("plugins");
$plugins_invoices = $supp_obj->prefix_table("invoices");
$plugins_invoices_services = $supp_obj->prefix_table("invoice_services");
$plugins_invoices_payments = $supp_obj->prefix_table("invoice_payments");

// Create Plugin tables
$table1 = "CREATE TABLE IF NOT EXISTS `$plugins_invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company` varchar(250) NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;";


$table2 = "CREATE TABLE IF NOT EXISTS `$plugins_invoices_services` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`invoice_id` int(11) NOT NULL,
`service` varchar(250) NOT NULL,
`cost` double(13,2) NOT NULL,
`created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
`updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (`id`),
KEY `invoice_id` (`invoice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;";



$table2_const = "ALTER TABLE `$plugins_invoices_services` ADD CONSTRAINT `ittc_invoice_services_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `ittc_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;";

$table3 = "CREATE TABLE IF NOT EXISTS `$plugins_invoices_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `amount` double(13,2) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_method` varchar(250) DEFAULT NULL,
  `notes` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `service_id` (`service_id`),
  KEY `payment_date` (`payment_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

$table3_const = "ALTER TABLE `$plugins_invoices_payments` ADD CONSTRAINT `ittc_invoice_payments_ibfk_1` FOREIGN KEY (`invoice_id`) REFERENCES `ittc_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE, ADD CONSTRAINT `ittc_invoice_payments_ibfk_2` FOREIGN KEY (`service_id`) REFERENCES `ittc_invoice_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;";

$supp_obj->execute_query($table1);
$supp_obj->execute_query($table2);
$supp_obj->execute_query($table2_const);
$supp_obj->execute_query($table3);
$supp_obj->execute_query($table3_const);

// Create Plugin
$sql = "INSERT INTO $plugins (plugin_name, plugin_status, plugin_version) VALUES ('$plugin_name', '1', '1.0')";
$supp_obj->execute_query($sql);
