<?php
class generic extends template {
	var $tbl_prefix;
	var $gen_smtp_mail;
	var $gen_smtp_host;
	var $gen_smtp_port;
	var $gen_smtp_username;
	var $gen_smtp_password;
	var $phpMail;
	var $date_format;
	
	// Generic class constructor that gets in super class and self's properties
	function __construct($db_host, $db_name, $db_user, $db_pass, $tbl_prefix) {
		template::init($db_host, $db_name, $db_user, $db_pass);
		$this->tbl_prefix = $tbl_prefix;
	}
	
	function strip_html($text, $allowed_tags = '<br><p><ul><li><ol>') {
		mb_regex_encoding('UTF-8');
		$search = array ("'<script[^>]*?>.*?</script>'si",
						 "'<style[^>]*?>.*?</style>'si",
						 "'([\r\n])[\s]+'"              // Strip out white space
						 );                    // evaluate as php
				
		$replace = array ("",
							"",
							"\\1");
		$text = preg_replace($search, $replace, $text);

		/*
		* Remove quotes
		*/
		$search = array('/&lsquo;/u', '/&rsquo;/u', '/&ldquo;/u', '/&rdquo;/u', '/&mdash;/u');
		$replace = array('\'', '\'', '"', '"', '-');
		$text = preg_replace($search, $replace, $text);
		
		//$text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
		
		if(mb_stripos($text, '/*') !== FALSE){
			$text = mb_eregi_replace('#/\*.*?\*/#s', '', $text, 'm');
		}
		
		$text = preg_replace(array('/<([0-9]+)/'), array('< $1'), $text);
		$text = strip_tags($text, $allowed_tags);
		
		$text = preg_replace(array('/^\s\s+/', '/\s\s+$/', '/\s\s+/u'), array('', '', ' '), $text);
		/*
		* Replace tags
		*/
		$search = array('#<(strong|b)[^>]*>(.*?)</(strong|b)>#isu', '#<(em|i)[^>]*>(.*?)</(em|i)>#isu', '#<u[^>]*>(.*?)</u>#isu');
		$replace = array('<b>$2</b>', '<i>$2</i>', '<u>$1</u>');
		$text = preg_replace($search, $replace, $text);
		/*
		* Remove comments from html
		*/
		$num_matches = preg_match_all("/\<!--/u", $text, $matches);
		if($num_matches){
			$text = preg_replace('/\<!--(.)*--\>/isu', '', $text);
		}
		/*
		* Remove multiple br from html
		*/
		//$text = preg_replace('#<br />(\s*<br />)+#', '<br />', $text);
		/*
		* Remove inline style from html
		*/
		$text = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $text);
		/*
		* Remove classes from html
		*/
		$text = preg_replace('/class=".*?"/', '', $text);
		/*
		* Remove double breakes from html
		*/
		//$text = preg_replace('#<br[^>]*>(\s*<br[^>]*>)+#', '<br />', $text);
		/*
		* Remove empty paragraphs from html
		*/
		$text = preg_replace("/<p[^>]*>[\s|&nbsp;]*<\/p>/", '', $text);
		/*
		* Add responsive class if tables are allowed in html
		*/
		$text = preg_replace('#<table[^>]*>(.*?)</table>#isu', '<table class="table table-hover">$1</table>', $text);
		/*
		* Remove last breaks from html
		*/
		$text = preg_replace("/(^)?(<br\s*\/?>\s*)+$/", "", $text);
		return $text;
	} 
	 
	/**
	* Prefix_table function takes a string as its input, prepends it with the tableprefix value given
	* during installation and returns it.  
	* @return $tablename
	*/
	function prefix_table($tablename) {	
		$tablename = $this->tbl_prefix."_".$tablename;
		return $tablename;
	}
	/*
	* convert timestamp to days
	*/
	function secondsToTime($seconds) {
		// extract hours
		$hours = floor($seconds / (60 * 60));
	
		// extract minutes
		$divisor_for_minutes = $seconds % (60 * 60);
		$minutes = floor($divisor_for_minutes / 60);
	
		// extract the remaining seconds
		$divisor_for_seconds = $divisor_for_minutes % 60;
		$seconds = ceil($divisor_for_seconds);
	
		// return the final array
		$obj = array(
			"h" => (int) $hours,
			"m" => (int) $minutes,
			"s" => (int) $seconds,
		);
		return $obj;
	}
	/*
	* function to help ical meeting time
	*/
	function iCalTime($ticket_id) {
		$schedule = $this->prefix_table('schedule');
		$sql = "SELECT * FROM $schedule WHERE ticket_id = '".$ticket_id."'";
		$time_details = $this->get_a_line($sql);
		
		if($time_details['duetime'] != '') {
			$ends = strtotime($time_details['dueon'].' '.$time_details['duetime']);
		} else {
			$ends = strtotime($time_details['dueon'].' '. "10:00:00");
		}
		$start = $ends - 1800;
		$return_str['start_time'] = date("Ymd", $start)."T".date("His", $start);
		$return_str['end_time'] = date("Ymd", $ends)."T".date("His", $ends);
		
		return $return_str;	
	}
	function clean_textbox_data($text) {
		return htmlspecialchars($text);
	}	
	/* 
	* use this function if you need to generate your own insert or update
	* queries .. comes in very handy .. only pass the appropriate arguments
	* mode is either INSERT/UPDATE .. data_arr is a key/value pair that has
	* fieldname/fieldvalue mapping , avoid_array can have those field_names 
	* that u do not want to come up in the qry
	 */
	function construct_query($tablename,$mode,$data_arr,$avoid_array=array()) {
		foreach($data_arr as $key => $value) {
			$$key = $value;
		}
		$sql="";
		$fields = $this->return_columns($tablename);	
		$description = $this->return_table_desc($tablename);	
		
		if(count($avoid_array) > 0) {
			$fields = array_diff($fields,$avoid_array);
		}
		$field_string = implode(",",$fields);
		switch($mode) {
			case "INSERT":
				$sql = " insert into $tablename ($field_string) values ( ";
			break;
			case "UPDATE":
				$sql = " update $tablename set ";
				break;
		}
		$array = array_keys($fields);
		for($i = 0; $i < count($array); $i++) {
			$index=$array[$i];
			$field_name=$fields[$index];
			$field_value=$$field_name;
			$field_type=$description[$field_name];
				
			if(preg_match("/^int/",$field_type)) {
				if(trim($field_value)=="" or !is_numeric(trim($field_value))) {
					$field_value = 0;
				}
			}	
			if($mode == "UPDATE") {
				$sql.= " $field_name='$field_value',";
			} else {
				$sql .= " '$field_value',";	
			}	
		}
		$sql=substr($sql,0,-1);
		if($mode == "INSERT") {
			$sql .= " ) ";
		}	
		return $sql;
	}
	// subroutine that generates a 10 digit number prefixed with the department prefix
	function generate_unique_no($prefix) {
		$tickets = $this->prefix_table("tickets");
		$sql = "select max(RIGHT(ticket_id,8)) as newid from  $tickets where LEFT(ticket_id,2)='$prefix' ";
		$array = $this->get_a_line($sql);		
		if($array['newid'] == "") {
			$newid="00000001";
		} else {
			$newid = ((int)$array['newid'])+1;
			$newid = str_pad($newid, 8, '0', STR_PAD_LEFT);
		}
		$newid = $prefix.$newid;
		return $newid;
	}
	// This function generates a random 8 digit uppercase string
	function generate_password() {
		$array = array();
		for($i = 0; $i < 8; $i++) {
			$array[$i] = chr(rand(65,90));
		}
		$string = implode("",$array);
		return $string;		
	}
	
	//-------------------------------------------------------------------------------------
	function is_address_skip($email) {
		# Feature Block email addresses,
		$spam_message = $this->prefix_table("spam_message");
		$sql = "SELECT * FROM $spam_message";
		$a_skip = $this->get_a_line($sql);
		
		if($a_skip['sp_skip'] == "") {
			return false;
		}
		
		if (preg_match("/".$email."/i", $a_skip['sp_skip'])) {
			return true;
		} else {
			return false;
		}	
	}
	
	//-------------------------------------------------------------------------------------
	function send_smtp_mail($to, $subject, $message, $from, $addresses = array(), $adt = array()) {
		$content_type="text/plain";
		$message = stripslashes($message);
		if(preg_match("/\<(.*?)\>(.*?)\<\/(.*?)\>/is",$message)) {
			$content_type = "text/html";
			$message = nl2br($message);
		}
		$from_array = preg_split("/[\r\n]+/is",trim($from),-1,PREG_SPLIT_NO_EMPTY);
		$from = $from_array[0];
		$pos = strpos($from,"<");
		if($pos > 1) {
			$this->phpMail->FromName=substr($from,0,$pos-1);
			$this->phpMail->From=substr($from,$pos+1,-1);	
			$this->phpMail->Sender=$this->phpMail->From;		
		} else {
			$this->phpMail->From=$from;
			$this->phpMail->Sender=$from;
		}
		$this->phpMail->ReturnPath=$this->phpMail->From;;
		$this->phpMail->CharSet="UTF-8";
		$this->phpMail->ContentType=$content_type;	
		$this->phpMail->Host     = $this->gen_smtp_host;
		$this->phpMail->Mailer   = "smtp";
		$this->phpMail->Subject=$subject;
		$this->phpMail->Body=$message;
		$this->phpMail->Port=$this->gen_smtp_port;	
		$this->phpMail->SMTPAuth=true;
		$this->phpMail->Username=$this->gen_smtp_username;
		$this->phpMail->Password=$this->gen_smtp_password;
		//$this->phpMail->SMTPDebug  = 2;

		//if(@ereg(",",$to)) {
		if (strpos($to, ',') !== false) {
			$to1 = explode(",",$to);
			for($l = 0; $l < count($to1); $l++) {
				if($this->is_address_skip($to1[$l])) {
					return;	
				}
				
				$this->phpMail->AddAddress($to1[$l]);
			}
		} else {
			if($this->is_address_skip($to)) {
				return;	
			}
			
			$this->phpMail->AddAddress($to);
		}
		if(isset($addresses['cc']) and $addresses['cc'] != "") {
			$cc = $addresses['cc'];
			$cc_address = explode(",",$cc);
			for($i = 0; $i < count($cc_address); $i++) {
				$this->phpMail->AddCC($cc_address[$i]);
			}
		} 
		if(isset($addresses['bcc']) and $addresses['bcc'] != "") {
			$bcc = $addresses['bcc'];
			$bcc_address = explode(",",$bcc);
			for($i = 0; $i < count($bcc_address); $i++) {
				$this->phpMail->AddCC($bcc_address[$i]);
			}
		}
		if($adt['file'] != "") {
			$file_vars = $adt['file'];
			$ticket_id = $adt['ticket_id'];
			$reply_id = $adt['reply_id'];
			for($i = 0; $i < (count($file_vars)); $i++) {
				$tmp_name = $file_vars['file_'.$i]['tmp_name'];
				if($tmp_name != "none" and $tmp_name != "") {		// if the user has uploaded an attachment
					$size = $file_vars['file_'.$i]['size'];	
					$new_name = $ticket_id."_".$reply_id."_".$i;
					$attachment_name = $this->upload_file("file_".$i,$file_vars,$new_name,'','../attachments');
				}
				$fileatt_type = $file_vars['file_'.$i]['type'];
				$fileatt_name = $file_vars['file_'.$i]['name'];
				list($n,$ext)=explode("\.",$fileatt_name);
				$this->phpMail->AddAttachment("../attachments/$attachment_name", "$fileatt_name"); 
				unset($file);
				unset($fileatt);
				unset($fileatt_type);
				unset($fileatt_name);
			}
		}
		
		// $mail->AddAttachment("c:/temp/11-10-00.zip", "new_name.zip"); 
		if($this->phpMail->Send()) {
			$bool = true;
			//echo '<pre>';print_r($this);
		} else {
			$bool = false;
		}
		// Clear all addresses and attachments for next loop
		$this->phpMail->ClearAddresses();
		$this->phpMail->ClearAttachments();
		return $bool;
	}
	/*format email as calendar entry*/
	function formatIcal($to, $from, $ical) {
		$gtimes = $this->iCalTime($ical['ticket_id']);
		$body .= "BEGIN:VCALENDAR\r\n";
		$body .= "VERSION:2.0\r\n";
		$body .= "PRODID:-//IT-TC//Help Desk//EN\r\n";
		$body .= "METHOD:REQUEST\r\n";
		$body .= "BEGIN:VEVENT\r\n";
		$body .= "ORGANIZER:MAILTO:".$from."\r\n";
		$body .= "ATTENDEE;CN=\"".$to."\";ROLE=REQ-PARTICIPANT;RSVP=FALSE:MAILTO:".$to."\r\n";
		$body .= "UID:".date('Ymd').'T'.date('His')."-".rand()."@it-tc.com\r\n";
		$body .= "DTSTAMP:".date('Ymd').'T'.date('His')."\r\n";
		$body .= "DTSTART:".$gtimes['start_time']."\r\n";
		$body .= "DTEND:".$gtimes['end_time']."\r\n"; 
		if ($ical['location'] != "") $body .= "LOCATION:".$ical['location']."\r\n";
		$body .= "SUMMARY:".$ical['subject']."\r\n";
		$body .= "BEGIN:VALARM\r\n";
		$body .= "TRIGGER:-PT15M\r\n";
		$body .= "ACTION:DISPLAY\r\n";
		$body .= "DESCRIPTION:".strip_tags($ical['summary'])."\r\n"; 
		$body .= "END:VALARM\r\n";
		$body .= "END:VEVENT\r\n";
		$body .= "END:VCALENDAR\r\n";
		//manually setup headers so phpmailer does not break format and so that icalendar works
		//$headers  = "From: ".$from."\r\n";
		//$headers .= "Reply-To: ".$from."\n";
		//$headers .= "\r\nMIME-version: 1.0\r\nContent-Type: text/calendar; method=REQUEST; charset=\"ISO-8859-1\"";
		//$headers .= "\r\nContent-Transfer-Encoding: 7bit\r\nX-Mailer: Microsoft Office Outlook 12.0"; 
		//$headers .= "Content-class: urn:content-classes:calendarmessage\n";
		
		$headers = "From: $from\r\nReply-To: $from"; 
		$headers .= "\r\nMIME-version: 1.0\r\nContent-Type: text/calendar; method=REQUEST; charset=\"iso-8859-1\"";
		$headers .= "\r\nContent-Transfer-Encoding: 7bit\r\nX-Mailer: Microsoft Office Outlook 12.0"; 
		
		$return_str['message'] = $body;
		$return_str['headers'] = $headers;

		if($this->gen_smtp_mail == "1") {
			$content_type = "text/html";
			$from_array = preg_split("/[\r\n]+/is",trim($from),-1,PREG_SPLIT_NO_EMPTY);
			$from = $from_array[0];
			$pos = strpos($from,"<");
			if($pos > 1) {
				$this->phpMail->FromName = substr($from,0,$pos-1);
				$this->phpMail->From = substr($from,$pos+1,-1);	
				$this->phpMail->Sender = $this->phpMail->From;		
			} else {
				$this->phpMail->From = $from;
				$this->phpMail->Sender = $from;
			}
			$this->phpMail->CharSet = "UTF-8";
			$this->phpMail->ContentType = $content_type;	
			$this->phpMail->Host     = $this->gen_smtp_host;
			$this->phpMail->Mailer   = "smtp";
			$this->phpMail->Subject = $ical['subject'];
			$this->phpMail->Body = nl2br($ical['summary']);
			$this->phpMail->Port = $this->gen_smtp_port;	
			$this->phpMail->SMTPAuth = true;
			$this->phpMail->Username = $this->gen_smtp_username;
			$this->phpMail->Password = $this->gen_smtp_password;
			if(@ereg(",",$to)) {
				$to1 = explode(",",$to);
				for($l = 0; $l < count($to1); $l++) {
					$this->phpMail->AddAddress($to1[$l]);
				}
			} else {
				$this->phpMail->AddAddress($to);
			}
			$this->phpMail->AddStringAttachment($return_str['message'], "meeting.ics", "7bit", "text/calendar; charset=utf-8; method=REQUEST");
						
			if($this->phpMail->Send()) {
				$bool = true;
			} else {
				$bool = false;
			}

			$this->phpMail->ClearAddresses();
		} else {
			$bool = mail($to, $ical['subject'], $return_str['message'], $return_str['headers']);
		}
		
		return $bool;
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function decode_html_entities($text,$nodollar = 0) {
		if($nodollar != 1) {
			$text = str_replace("&#36;","$",$text);
		}
		return $text;
	}
	// Products' simple mail functionality . This subroutine handles only plan text mails	
	function send_mail($to, $subject, $message, $from, $addresses = array()) {
		// check whether the message has got html content
		$subject=$this->decode_html_entities($subject);
		$message=$this->decode_html_entities($message);	
		// Clean the from data
		$from_array=preg_split("/[\r\n]+/is",trim($from),-1,PREG_SPLIT_NO_EMPTY);
		$from=$from_array[0];
		$to_array=preg_split("/[\r\n]+/is",trim($to),-1,PREG_SPLIT_NO_EMPTY);
		$to=$to_array[0];
		$subject_array=preg_split("/[\r\n]+/is",trim($subject),-1,PREG_SPLIT_NO_EMPTY);
		$subject=$subject_array[0];

		if($this->gen_smtp_mail=="1")
		{
			return $this->send_smtp_mail($to,$subject,$message,$from,$addresses);
		}

		if (strtoupper(substr(PHP_OS,0,3)=='WIN')) 
		{ 
			  $eol="\r\n"; 
		} 
		elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) 
		{ 
 			 $eol="\r"; 
		} 
		else 
		{ 
  			$eol="\n"; 
		}
		$cc="";
		$bcc="";

		if(isset($addresses['cc']) and $addresses['cc']!="")
		{
			$cc=$addresses['cc'];
		} 

		if(isset($addresses['bcc']) and $addresses['bcc']!="")
		{
			$bcc=$addresses['bcc'];
		} 
		
		$content_type="text/plain";
		$message=stripslashes($message);
		if(preg_match("/\<(.*?)\>(.*?)\<\/(.*?)\>/is",$message))
		{
			$content_type="text/html";
			$message=nl2br($message);
		}
		
		// From array cleaned	
		$headers  = "MIME-Version: 1.0".$eol;
		$headers .= "Content-type: $content_type; charset=UTF-8".$eol;
		$headers .=  "Content-Transfer-Encoding: 8bit".$eol;
		
		$headers .= "From: $from".$eol;
		$headers .= "Reply-To: $from".$eol;
		if($cc!="")
		{
			$headers .= "Cc: $cc".$eol;
	
		}
		if($bcc!="")
		{
			$headers .= "Bcc: $bcc".$eol;

		} 
		$headers .= "Return-Path: $from".$eol; 
		$headers .= "X-Mailer: PHP v".phpversion().$eol;   

		
		if(trim($to)=="" || $this->is_address_skip(trim($to))) // To address missing
		{
			return;
		}	
		
		$bool=  @mail($to, $subject, $message, $headers);
		return $bool;
	}

	/*This subroutine checks whether the uploaded or downloaded attachment is within the set size limit*/	
	function is_valid_size($filename,$file_vars)
	{
		$size=$file_vars[$filename]['size'];
		$config=$this->prefix_table("configuration");
		$sql="select attachment_size from $config ";
		$a_config=$this->get_a_line($sql);
		$max_size=$a_config['attachment_size']*1024;
		if($size > $max_size)		// file size more than max allowed file size
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	/*This routine moves the file from the client's machine to the server directory */
	function upload_file($filename,$file_vars,$new_name,$new_dir='',$file_path='')
	{
		$tmp_name=$file_vars[$filename]['tmp_name'];
		$name=$file_vars[$filename]['name'];
		list($n,$ext)=explode("\.",$name);
		if($new_dir=="")
		{
			$upload_dir=$file_path;
			$upload_path=$upload_dir."/".$new_name.".".$ext;
		}
		else
		{	
			$upload_dir="../images";
			$upload_path=$upload_dir."/".$new_name;
			$new_name=$n;			
		}
		$bool=move_uploaded_file($tmp_name,$upload_path);
		if($bool==true)
		{
			return $new_name.".".$ext;
		}
		else
		{
			return false;
		}
	}

	/* Given some input text and a filename , this function would write the text to the file */
	function write_to_file($filename,$content,$mode="w")
	{
		$fp=fopen($filename,$mode);
		fwrite($fp,$content);
		fclose($fp);
	}

	/*This function calculates the difference between server timezone and gmt . If server timezone is earlier ,the value returned is +ve. */
	function server_timezone_diff()
	{
		$gmt_22=gmmktime(22,00,00,01,01,1970);
		$server_22=mktime(22,00,00,01,01,1970);
		$diff=$server_22-$gmt_22;
		return $diff;
	}

	// return unix timestamp in seconds since 1970 01 01 00 00 00 corrected to timezone
	// zone is in munutes
	function get_corrected_timestamp($zone,$yy,$mm,$dd,$hh,$ii,$ss,$in_gmt=1)
	{
		if($in_gmt!=1)
		{
			$diff=$this->server_timezone_diff();
			$gmt_stamp=@gmmktime($hh,$ii,$ss,$mm,$dd,$yy);
		}
		else
		{	
			$gmt_stamp=@gmmktime($hh,$ii,$ss,$mm,$dd,$yy);
		}	
		$corrected_stamp=$gmt_stamp+($zone*60);
		return $corrected_stamp;
	}

	/* function that gets in unix datetime and the zone and corrects it to M d format*/
	function return_formatted_date($last_activity,$zone)
	{
		list($lastday,$lasttime)=preg_split("/[ ]+/",$last_activity,-1,PREG_SPLIT_NO_EMPTY);
		list($yy,$mm,$dd)=explode("-",$lastday);
		list($hh,$ii,$ss)=explode(":",$lasttime);
		$formatted_stamp=$this->get_corrected_timestamp($zone,$yy,$mm,$dd,$hh,$ii,$ss);
		$current_stamp=$this->get_corrected_timestamp($zone,gmdate("Y"),gmdate("m"),gmdate("d"),gmdate("H"),gmdate("i"),gmdate("s"),2);
		
		if(($current_stamp-$formatted_stamp) > 86400)	// difference is nore than 1 day
		{
			$formatted_date=@gmdate("M d",$formatted_stamp);
			if(($current_stamp-$formatted_stamp) <= 86400*10)
			{
			$days="(".(round(($current_stamp-$formatted_stamp)/86400));
			$period="days ago)";
			}
		}
		else
		{
			$formatted_date=@gmdate("H:i ",$formatted_stamp);
			$current_date=@gmdate("H:i ",$current_stamp);
			$days="(".(round(($current_stamp-$formatted_stamp)/3600));
			$period="hours ago)";
			if((round(($current_stamp-$formatted_stamp)/60))<=60)
			{
				$days="(".(round(abs($current_stamp-$formatted_stamp)/60));
				$period="minutes ago)";
			}
			if((round(($current_stamp-$formatted_stamp)))<=60 and (round(($current_stamp-$formatted_stamp))) > 0)
			{
				$days=abs($current_stamp-$formatted_stamp);	
				$days="(".$days;
				$period="secs ago)";
			}
		}
		$return_array=array();
		$return_array['formatted_date']=$formatted_date;
		$return_array['diff']=$days;
		$return_array['period']=$period;
		return $return_array;
	}


	/* very much like now() , the only difference is this function would return now() in GMT */
	function get_current_date($zone=0,$format="dt")
	{
		//$diff=$this->server_timezone_diff();
		if($this->date_format=="mssql")
		{
			if($format=="dt")
			{
				$f="d-M-Y H:i:s";
			}
			elseif($format=="d")
			{
				$f="d-M-Y";
			}
			else
			{
				$f=$format;
			}
		$sent_date=gmdate($f,mktime(date("H"),date("i"),date("s")+($zone*60),date("m"),date("d"),date("y")));
		}
		else
		{
			if($format=="dt")
			{
				$f="Y-m-d H:i:s";
			}
			elseif($format=="d")
			{
				$f="Y-m-d";
			}
			else
			{
				$f=$format;
			}

		$sent_date=gmdate($f,mktime(date("H"),date("i"),date("s")+($zone*60),date("m"),date("d"),date("y")));
		}
		return $sent_date;				
	}
	
	//----------------------------------------------
	function get_db_date($zone,$offset)
	{
		if($this->date_format=="mssql")
		{
			$sent_date=gmdate('d-M-Y',mktime(date("H"),date("i"),date("s")+($zone*60),date("m"),date("d")+$offset,date("y")));
		}
		else
		{
			$sent_date=gmdate('Y-m-d',mktime(date("H"),date("i"),date("s")+($zone*60),date("m"),date("d")+$offset,date("y")));
		}
		return $sent_date;		
	}

	//--------------------------------------------------
	function phpstamp_to_dbstamp($stamp)
	{
		if($this->date_format=="mssql")
		{
			$sent_date=gmdate('d-M-Y',$stamp);
		}
		else
		{
			$sent_date=gmdate('Y-m-d',$stamp);
		}

	return $sent_date;		
	}
	
	//--------------------------------------------------
	function get_current_stamp($zone)
	{
		if($this->date_format=="mssql")
		{
			$current_stamp=gmmktime(date("H"),date("i"),date("s")+($zone*60),date("m"),date("d")+$offset,date("y"));
		}
		else
		{
			$current_stamp=gmmktime(date("H"),date("i"),date("s")+($zone*60),date("m"),date("d")+$offset,date("y"));
		}
		return $current_stamp;	
	}

	/*  GET TICKET STATUS */
	function get_status_name($status_key)
	{
		$ticket_status=$this->prefix_table("ticket_status");
		$sql="select statusname from $ticket_status where status_key='$status_key' ";
		$a_status=$this->get_a_line($sql);

		return $a_status['statusname'];	
	}

	/* GET PRIORITY NAME */
	function get_priority_name($priority_id)
	{
		$ticket_priorities=$this->prefix_table("ticket_priorities");
		$sql="select priorityname from $ticket_priorities where priority_id='$priority_id' ";
		$a_priority=$this->get_a_line($sql);

		return $a_priority['priorityname'];	
	}

	/* GET PRIORITY NAME */
	function get_assigned_person($assigned_to)
	{
		
		$staff=$this->prefix_table("staff");
		$sql="select staff_name from $staff where staff_id='$assigned_to' ";
		$a_staff=$this->get_a_line($sql);

		return $a_staff['staff_name'];	
	}

	function get_assigned_details($assigned_to) {
		$staff = $this->prefix_table("staff");
		$sql = "select * from $staff where staff_id='$assigned_to' ";
		$a_staff = $this->get_a_line($sql);
		return $a_staff;	
	}

	//-----------------------------------------------------------------------------------------------------------
	function update_replies($reply_mess,$ticket_id,$zone,$reply_id,$myvar,$ticket_replies_flag)
	{
		if($ticket_replies_flag!="1")
		{
			return $reply_mess;
		}	
	
		$ticket_replies=$this->prefix_table("ticket_replies");
		$clients=$this->prefix_table("clients");
		
		$sql="select reply,subject, reporter_id, 
		".$this->add_offsetNformat('replied_on',$zone,'minute','replied_on').", reporter , reply_id 
		  from $ticket_replies where ticket_id='$ticket_id' and  private='0'    order by reply_id asc  ";
		$a_replies=$this->return_db_handle($sql);

		$str="";
		while($row=$this->return_next_row($a_replies))
		{
			$reply=$row['reply_id'];
			if($reply==$reply_id)
			{
				continue;
			}
			$replied_date=$row['replied_on'];
			$reply_subject=$row['subject'];
			$reporter=$row['reporter'];
			$reply_message=$row['reply'];
			$reporter_id=$row['reporter_id'];	
			if($reporter=="STAFF")
			{
				$replied_by=$this->get_assigned_person($reporter_id);
			}	
			else
			{
				$sql="select client_name from $clients where client_id='$reporter_id'";
				$a_client=$this->get_a_line($sql);
				$replied_by=$a_client['client_name'];
			}
			//$str.=preg_replace("/{{(.*?)}}/e","$$1",$myvar);
			preg_match_all("/{{(.*?)}}/", $myvar, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$str .= preg_replace_callback("/{{(.*?)}}/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $myvar);	
		}		
	$reply_mess.="\n".$str."\n";
	return $reply_mess;
	}

	/* quick reply action in tickets_view and ticket_detail page of staff is handled here */	
	function submit_quick_reply($supp_obj,$a_predefined,$staff_id,$generic_msg)
	{
		$post_vars=$a_predefined['post'];
		$file_vars=$a_predefined['file'];
		$session_vars=$a_predefined['session'];		
		$zone=$session_vars['zone'];
		@extract($post_vars);

		$reply = trim ($this -> stripLargeTags ($reply));

		if ($reply == "")
			return $generic_msg['cEnter_Valid_Reply'];

		$subject = trim ($this -> stripLargeTags ($subject));

		$addresses=array();

		//Prefix and prepare tables 
		$tickets			=	$supp_obj->prefix_table("tickets");
		$staff_departments	=	$supp_obj->prefix_table("staff_departments");
		$staff				=	$supp_obj->prefix_table("staff");
		$clients			=	$supp_obj->prefix_table("clients");
		$mail_servers		=	$supp_obj->prefix_table("mail_servers");
		$dept_servers		=	$supp_obj->prefix_table("dept_servers");
		$config				=	$supp_obj->prefix_table("configuration");
		$departments		=	$supp_obj->prefix_table("departments");
		$emails				=	$supp_obj->prefix_table("emails");

		// Get the ticket details
		$sql="select *,
			".$supp_obj->add_offsetNformat('sent_date',$zone,'minute','sent_date')." 

		 from $tickets where ticket_id='$ticket_id' ";			
		$a_ticket=$supp_obj->get_a_line($sql);
		$dept_id=$a_ticket['dept_id'];
		$client_id=$a_ticket['client_id'];
		$priority_id=$a_ticket['priority_id'];

		$sql="select * from $config ";
		$a_config=$supp_obj->get_a_line($sql);
		@extract($a_config);

		$ticket_reply_message=$ticket_replies;
		// Get the reply subject
		if($subject == "")
		{
			$subject1=$a_config['reply_subject'];
			$subject=$a_ticket['subject'];
			$subject = addslashes ($subject);
			//$subject=preg_replace("/{{(.*?)}}/e","$$1",$subject1);
			preg_match_all("/{{(.*?)}}/", $subject1, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$subject = preg_replace_callback("/{{(.*?)}}/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $subject1);	
		}
		//Get the mail server's email address and the signature of the department
		$sql="select pop3_email,signature,$departments.dept_name as dept_name from $mail_servers ,
		$dept_servers,$departments where 
		$mail_servers.server_id=$dept_servers.server_id 
		and $departments.dept_id=$dept_servers.dept_id
		and $dept_servers.dept_id='$dept_id' ";
		$a_from=$supp_obj->get_a_line($sql);	
		$from=$a_from['pop3_email'];
		$dept_name=$a_from['dept_name'];
		$from=$dept_name. " <".$from.">";
		$signature=$a_from['signature'];
		//Get the customer's email address
		$sql="select * from $clients where client_id='$client_id' ";
		$a_client=$supp_obj->get_a_line($sql);
		$email=$a_client['email'];
		$client_name=$a_client['client_name'];
		$sql="select is_admin,staff_signature from $staff where staff_id='$staff_id' ";
		$a_sql=$supp_obj->get_a_line($sql);
		$staff_signature=$a_sql['staff_signature'];
		$is_admin=$a_sql['is_admin'];		
		$sql="select dept_id from $staff_departments where staff_id='$staff_id' ";
		$a_column=$supp_obj->get_single_column($sql);		
		//print_R($a_column);
		if(!$is_admin)	// Check for security only if not admin
		{
			if(!in_array($dept_id,$a_column))	// staff doesn't belong to dept
			{
				return ;
			}
		}
		if($ticket_id!="")
		{
			$ticket_replies=$supp_obj->prefix_table("ticket_replies");
			$replied_on=$supp_obj->get_current_date();	
			$tktstatus='O';
			$action_array=array("N","O","H","C","S");
			if($dotktaction!="" and in_array($dotktaction,$action_array))
			{
				$tktstatus=$dotktaction;
			}
		
			if($tktstatus=="C")	// Send notification to the staff of the department if the ticket is closed.
			{
				$supp_obj->notify_onticketclose($session_vars,$dept_id,$tktstatus,$ticket_id);
			}

			if($reply_minutes=="" or !is_numeric($reply_minutes))
			{
				$reply_minutes=0;
			}
			
			if($distance_reply=="" or !is_numeric($distance_reply))
			{
				$distance_reply=0;
			}
			if(isset($ctravelling)) {
				$remoteaccess = 1;
			} else {
				$remoteaccess = 0;
			}
			//$reply = strip_tags($reply);
			$insert_array=array("reply"=>$reply,"reporter_id"=>$staff_id,
			"ticket_id"=>$ticket_id,"reporter"=>"STAFF","replied_on"=>$replied_on,
			"subject"=>$subject,"change_status"=>$tktstatus,"reply_minutes"=>$reply_minutes,"reply_travel"=>$distance_reply,"responded_from"=>$dept_id,"source"=>$source,"destination"=>$destination,"remoteoption"=>$remoteaccess);
			$avoid_array=array("reply_id","reminder_on","last_update","last_updatedby","last_reporter","private");
			$sql=$supp_obj->construct_query($ticket_replies,"INSERT",$insert_array,$avoid_array);
			$reply_id=$supp_obj->execute_query($sql);
			$activity_array1['ticket_id']=$ticket_id;
			$activity_array1['reply_id']=$reply_id;
			$supp_obj->log_activity($activity_array1,$staff_id,'STAFF','Y');

			$last_activity=$this->get_current_date();	
			$sql="update $tickets set status='$tktstatus',
			staff_last_activity='$last_activity',
			updater_id='$staff_id',updater='STAFF'
			 where ticket_id='$ticket_id' "	;
			$supp_obj->execute_query($sql);		
			$activity_array2['ticket_id']=$ticket_id;
			$activity_array2['status']=$tktstatus;
			// Log status change only if the status is different from the previous status. Change done on version 3.0.0
			if($a_ticket['status']!=$tktstatus)
			{
				$supp_obj->log_activity($activity_array2,$staff_id,'STAFF');
			}
			$current_status=$supp_obj->get_status_name($tktstatus);
			$current_priority=$supp_obj->get_priority_name($priority_id);
		
			if($ticket_summary_flag=="1")
			{
				$reply_message.="\n#-#----- ".$ticket_summary_subject." -----#-#\n".$ticket_summary;
			}

			if($ticket_replies_flag=="1")
			{
				if($ticket_summary_flag=="1")
				{
					$reply_message.="\n".$ticket_reply_subject;
				}
				else
				{	
					$reply_message.="\n#-#----- ".$ticket_reply_subject." -----#-#";
				}
			}

			$reply_message=$supp_obj->update_replies($reply_message,$ticket_id,$zone,$reply_id,$ticket_reply_message,$ticket_replies_flag);
			$replace_array=array("reply"=>$reply,"http_url"=>$http_url,
			"ticket_id"=>$ticket_id,"client_name"=>$client_name,"dept_signature"=>$signature,
			"department"=>$dept_name,"status"=>$current_status,"priority"=>$current_priority,
			"received_date"=>$a_ticket['ticket_created'],"client_email"=>$email,"subject"=>$a_ticket['subject'],"message"=>$a_ticket['message'],"staff_signature"=>$staff_signature);

			$tag_array=$this->get_mail_tags($ticket_id);
			$replace_array=@array_merge($replace_array,$tag_array);
			$reply_message=$supp_obj->direct_replace($reply_message,$replace_array);
			$subject=$supp_obj->direct_replace($subject,$replace_array);

			// Send mail only if server mail and the respective mail template is enabled
			if($send_mail==1 and $send_tktreply==1)
			{
				//$supp_obj->send_mail($email,$subject,$reply_message,$from);
				//print_r($post_vars);
				if($ccaddress!="")
				{
					$addresses['cc']=$ccaddress;

					$addressdetails=@explode(",",$ccaddress);
					for($cc=0;$cc<count($addressdetails);$cc++)
					{
						$ccmail=$addressdetails[$cc];
						$sql="select email_id from $emails where email='$ccemail' and 
							ticket_id='$ticket_id' and reply_id='$reply_id' and  email_as='cc'";
						$ccrow=$supp_obj->get_a_line($sql);
						if($ccrow[0]=="")
						{
							$sql="insert into $emails (email, ticket_id, staff_id, 
								email_as , reply_id) values ('$ccmail','$ticket_id','$staff_id','cc',
								'$reply_id') ";
							$supp_obj->execute_query($sql);
						}
					}
				}
				if($bccaddress!="")
					{
						$addresses['bcc']=$bccaddress;
						
							$addressdetails=@explode(",",$bccaddress);
						for($cc=0;$cc<count($addressdetails);$cc++)
						{
								$ccmail=$addressdetails[$cc];
									$sql="select email_id from 	$emails where email='$ccemail' and ticket_id='$ticket_id' and reply_id='$reply_id' and email_as='bcc'";
								$ccrow=$supp_obj->get_a_line($sql);
								if($ccrow[0]=="")
								{

								$sql="insert into $emails (email, ticket_id, staff_id, email_as,reply_id ) values ('$ccmail','$ticket_id','$staff_id','bcc','$reply_id') ";
								$supp_obj->execute_query($sql);
								}
						}
					}

				if(count($file_vars)==0)
				{				
					$supp_obj->send_mail($email,$subject,$reply_message,$from,$addresses);
				}
				else
				{
					for($i=0;$i<count($file_vars);$i++)
					{
						$file_name=$file_vars['file_'.$i]['name'];
						$new_name=$ticket_id."_".$reply_id."_".$i;
						list($n,$ext)=explode("\.",$file_name);
						$attachment_name = $new_name.".".$ext;
						$array=array("ticket_id"=>$ticket_id,"attachment_name"=>$attachment_name,"file_name"=>$file_name,"reply_id"=>$reply_id);
						$ticket_attachments=$supp_obj->prefix_table("ticket_attachments");
						$avoid_array=array("att_id");
						$sql=$supp_obj->construct_query($ticket_attachments,"INSERT",$array,$avoid_array);	
						$supp_obj->execute_query($sql);
					}

					$supp_obj->send_attmail($email,$subject,$reply_message,$from,$file_vars,$ticket_id,$reply_id,$addresses);
				}
				
			}
		}
		return $generic_msg['cQuickreply_saved'];
	}

	/* This function would return no of records to display per page */
	function return_records_per_page()
	{	
			$config=$this->prefix_table("configuration");
			$sql="select records_per_page from $config ";
			$a_config=$this->get_a_line($sql);
			return $a_config['records_per_page'];
	}

	/* Paging functionality is implemented here.Input parameters are the template,
	* total number of records , link if any, current page number	*/	
	function print_pgbreak($template,$total,$lnk,$page_no,$pg_arg='page_no')
	{
		$records=$this->return_records_per_page();
		$pattern="/\<\{pagebreak_start\}\>(.*?)\<\{pagebreak_end\}\>/is";
		if($total==0)
		{
			$template=preg_replace($pattern,"",$template);
		}

		preg_match($pattern,$template,$out);
		$mat=$out[1];
		$pattern="/<{page_loopstart}>(.*?)<{page_loopend}>/is";
		preg_match($pattern,$mat,$out);
		$match=$out[1];
		$start=($page_no-1)*$records;
		$start+=1;
		$rec=$start+$records-1;
		$str="";
		if($start >1)
			{
		$pg=$page_no-1;
		$plink=$lnk."&".$pg_arg."=$pg";
		$mat=preg_replace("/\<\{previous_(.*?)\}\>/is","",$mat);
			}
		else
			{
		$mat=preg_replace("/\<\{previous_start\}\>(.*?)\<\{previous_end\}\>/is","",$mat);		
			}	
		$selected="";
		for($l=1;$l<=$total;$l+=$records)			
			{
				$v=$l+$records-1;
				if($records>1)
				{
					$pg=(int)($l/$records)+1;
				}
				else
				{
					$pg=(int)($l/$records);

				}
				if($v>$total)
				{
					$v=$total;
				}
				if($page_no==$pg)
				{
					$selected="selected";	
				}
				else
				{
					$selected="";
				}
			//	$str.="<option value=$pg $selected> $l - $v</option>";
			//$str.=preg_replace("/\<\{(.*?)\}\>/e","$$1",$match);
			
			preg_match_all('/\<\{(.*?)\}\>/', $match, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
				   $tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$str .= preg_replace_callback("/\<\{(.*?)\}\>/",
								 function($m) use ($tmp_array) { return $tmp_array[$m[1]]; },
								 $match);
		}
		//$str.="Showing $start-$rec of $total ";
		$mat=preg_replace($pattern,$str,$mat);
		$pg=$page_no+1;
		$nlink=$lnk."&".$pg_arg."=$pg";
		if($total > $rec)
		{
			$mat=preg_replace("/\<\{next_(.*?)\}\>/is","",$mat);
		}
		else
		{
			$mat=preg_replace("/\<\{next_start\}\>(.*?)\<\{next_end\}\>/is","",$mat);
		}
		
		//$mat=preg_replace("/\<\{(.*?)\}\>/e","$$1",$mat);
		
		preg_match_all('/\<\{(.*?)\}\>/', $mat, $matches);
		$tmp_array = array();
		foreach ($matches[0] as $index => $var_name) {
			$tmp_var_name = $matches[1][$index];
			if (isset($$tmp_var_name)) {
			   $tmp_array[$tmp_var_name] = $$tmp_var_name;
			} else {
				$tmp_array[$tmp_var_name] = '';
			}
		}
		
		$mat = preg_replace_callback("/\<\{(.*?)\}\>/",
							 function($m) use ($tmp_array) { return $tmp_array[$m[1]]; },
							 $mat);
							 
		$pattern="/\<\{pagebreak_start\}\>(.*?)\<\{pagebreak_end\}\>/is";
		$content=preg_replace($pattern,$mat,$template);
		return $content;		
	}

	/*Use this fn to find whether the guy is an administrator or not.*/
	function is_administrator($a_predefined) {
		$session_vars=$a_predefined['session'];
		$staff_id=$_SESSION['staff_id'];
		$staff=$this->prefix_table("staff");
		$sql="select is_admin from $staff where staff_id='$staff_id' ";
		$a_staff=$this->get_a_line($sql);
		if(isset($a_staff['is_admin']) && $a_staff['is_admin'] == 1)	 {
			return true;
		} else {
			return false;
		}
	}		

	/* THis function creates a new $dest directory and copies all the files from the source
	directory to the $dest directory */	
	function copyr($source, $dest)
	{
    // copies a single file
    	if (is_file($source)) 
		{
			return copy($source, $dest);
		}
 	  // Make destination directory
	    if (!is_dir($dest)) 
		{
			mkdir($dest);
			chmod($dest,0777);
		}
	    // Loop through the folder
	    $dir = dir($source);
    	while (false !== $entry = $dir->read()) 
		{
        	// Skip pointers
			if ($entry == '.' || $entry == '..') 
			{
			continue;
			}
			// Deep copy directories
			if ($dest !== "$source/$entry") 
			{
			$this->copyr("$source/$entry", "$dest/$entry");
			}
    	}
    // Clean up
    $dir->close();
    return true;
}

	/*This function deletes all the files in a directory and removes the directory too*/
	function delete_dir($source)
	{
    // delete a single file
    	if (is_file($source)) 
			{	
        		return @unlink($source);
    		}
	    // Loop through the folder
	    $dir = dir($source);
    	while (false !== $entry = $dir->read()) 
		{
        	// Skip pointers
       		if ($entry == '.' || $entry == '..') 
			{
	            continue;
	        }
 		$file_name=$source."/".$entry;
			unlink($file_name);
    	}
    // Clean up
    $dir->close();
	rmdir($source);	
    return true;
}

    /* deletes tickets from the system and all the references associated with it.*/
	function delete_tickets($a_predefined, $generic_msg, $a_tickets) {
		$ticket_custom_values = $this -> prefix_table ("ticket_custom_values");
		$ticket_custom_ids    = $this -> prefix_table ("ticket_custom_ids");

		$tickets=$this->prefix_table("tickets");		
		$ticket_replies=$this->prefix_table("ticket_replies");
		$tapeticket=$this->prefix_table("tapeticket");	
		$ticket_attachments=$this->prefix_table("ticket_attachments");
		$activity_log=$this->prefix_table("activity_log");
		$tickets_delete=$this->prefix_table("tickets_delete");
		
		$attachment_path="../attachments/";
		for($i = 0; $i < count($a_tickets); $i++) {	// scroll thro the list of tickets
			$ticket_id = $a_tickets[$i];
			
			$sql = "SELECT * FROM $tickets WHERE ticket_id = '".$ticket_id."'";
			$deleted = $this->get_a_line($sql);
			//$sql = "INSERT INTO $tickets_delete (ticket_id, staff_id, subject, message, ipaddress, created) VALUES ('".$ticket_id."', '".$_SESSION['staff_id']."', '".$deleted['subject']."', '".$deleted['message']."', '".$_SERVER['REMOTE_ADDR']."', NOW())";
			$deleted_arr['ticket_id'] = $ticket_id;
			$deleted_arr['staff_id'] = $_SESSION['staff_id'];
			$deleted_arr['subject'] = mysqli_real_escape_string($this->strip_html($deleted['subject']));
			$deleted_arr['message'] = mysqli_real_escape_string($this->strip_html($deleted['message']));
			$deleted_arr['ipaddress'] = $_SERVER['REMOTE_ADDR'];
			$deleted_arr['client_id'] = $deleted['client_id'];
			$deleted_arr['created'] = date('Y-m-d H:i:s');
			
			$avoid_array = array("id");
			$sql = $this->construct_query($tickets_delete, "INSERT", $deleted_arr, $avoid_array);
			
			if($this->execute_query($sql)) {
				$sql="select attachment_name from $ticket_attachments where ticket_id='$ticket_id' ";
				$a_attachments=$this->get_single_column($sql);
				for($j = 0; $j < count($a_attachments); $j++) {
					$attachment_name=$a_attachments[$j];
					$att_file=$attachment_path.$attachment_name;
					@unlink($att_file);	
				}
				
				// delete the attachment references also from the table
				$sql="delete from $ticket_attachments where ticket_id='$ticket_id' ";
				$this->execute_query($sql);
				
				// delete the replies made to this ticket
				$sql="delete from $ticket_replies where ticket_id='$ticket_id' ";
				$this->execute_query($sql);
				
				// Clear the log thats associated with this ticket
				$sql="delete from $activity_log where ticket_id='$ticket_id' ";
				$this->execute_query($sql);
				
				// delete the ticket finally
				$sql="delete from $tickets where ticket_id='$ticket_id' ";
				$this->execute_query($sql);
			
				$sql = "delete from $ticket_custom_values where ticket_id = '$ticket_id'";
				$this -> execute_query ($sql);
	
				$sql = "delete from $ticket_custom_ids where ticket_id = '$ticket_id'";
				$this -> execute_query ($sql);
				
				// delete the tape references
				$sql="delete from $tapeticket where ticketid = '$ticket_id' ";
				$this->execute_query($sql);
			}
		
		}
		return $generic_msg['cTickets_deleted'];
	}
	
//-----------------------------------------------------------------------------
// download attachment file from the server 	
	function download_file($fileDir,$fileName,$instance_name)
	{
		$fileString=$fileDir.'/'.$fileName; // combine the path and file
		// translate file name properly for Internet Explorer.
	if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE"))
	{
		  $instance_name = preg_replace('/\./', '%2e', $instance_name, substr_count($instance_name, '.') - 1);
	}
	// make sure the file exists before sending headers
	if(!$fdl=@fopen($fileString,'r'))
		{
		   die("Cannot Open File!");
		} 
	else 
		{
		  header("Cache-Control: ");// leave blank to avoid IE errors
		  header("Pragma: ");// leave blank to avoid IE errors
		  header("Content-type: application/octet-stream");
		  header("Content-Disposition: attachment; filename=\"".$instance_name."\"");
		  header("Content-length:".(string)(filesize($fileString)));
		  sleep(1);
		  fpassthru($fdl);
		}
	}
//------------------------------------------------------------------------------------------
/* THis function determines the current sort option and mode (whether ascending or descending) */
	function get_sort_option($supp_obj,$a_predefined,$who)
	{
		$get_vars=$a_predefined['get'];
		$orderby=$get_vars['orderby'];
		$tickets=$supp_obj->prefix_table("tickets");
		$clients=$supp_obj->prefix_table("clients");
		$ticket_status=$supp_obj->prefix_table("ticket_status");
		$ticket_priorities=$supp_obj->prefix_table("ticket_priorities");

		if($orderby!="")
		{
			$_SESSION['previousorderby']=$_SESSION['orderby'];
			$_SESSION['orderby']=$orderby;
		}
		if($_SESSION['orderby']=="")
		{
			$_SESSION['orderby']="sent_date";
		}
		
		$orderby=$_SESSION['orderby'];	
	//	print_r($_SESSION);

		switch($orderby)
		{
			case "ticket_id":
				$order_field=" $tickets.ticket_id ";
				break;
			case "subject":
				$order_field=" $tickets.subject ";
				break;
			case "status":
				$order_field=" $tickets.status ";
				break;
			case "priority_id":
				$order_field=" $tickets.priority_id ";
				break;
			case "sent_date":
				if($who=="STAFF")
					{


					$order_field=" $tickets.client_last_activity ";
					}
				else
					{
					$order_field=" $tickets.staff_last_activity ";	
					}	
				break;
			case "client_name":
				$order_field=" $clients.client_name ";
				break;
	
			default:
				if($who=="STAFF")
					{
					$order_field=" $tickets.client_last_activity ";
					}
				else
					{
					$order_field=" $tickets.staff_last_activity ";	
					}	
				break;			
						
		}
		$mode=$get_vars['mode'];

		if($mode!="")
		{
			$_SESSION['mode']=$mode;
		}
		if($_SESSION['mode']=="")
		{
			$_SESSION['mode']="desc";
		}
		
		$mode=$_SESSION['mode'];	

		switch($mode)
		{
			case "asc":
				$order_type="asc";
				break;
			case "desc":
				$order_type="desc";
				break;
			default:
				$order_type="desc";		
				break;
		}
		$return_array['order_field']=$order_field;	
		$return_array['order_type']=$order_type;
		return $return_array;
	}
//---------------------------------------------------------------------------------------
/*This function would filter the search text*/	
function filter_searchtxt($a_predefined,$search_array)	
{
	// Get all common words
	$ignored_words=$this->prefix_table("ignored_words");
	$sql="select word from $ignored_words ";
	$a_ignored=$this->get_single_column($sql);
	// first ignore all the one two letter words
	$new_array=array();
	// loop thro all the search words
	//print_R($a_ignored);
	for($i=0;$i<count($search_array);$i++)
	{
		// ignore common word
		if(in_array(trim($search_array[$i]),$a_ignored))
		{
			continue;
		}
		// check whether each word is greater than one , two digit
		if(strlen($search_array[$i])>2)
		{
			$new_array[]=$search_array[$i];
		}
		
		
	}

	
	
	return $new_array;
}

//------------------------------------------------------------------------------------------
/* This function gets in any record that match the search txt in tickets and clients table*/
	function get_search_clause($supp_obj,$a_predefined,$generic_msg)
	{
		$tickets=$supp_obj->prefix_table("tickets");
		$clients=$supp_obj->prefix_table("clients");
		$ticket_replies=$supp_obj->prefix_table("ticket_replies");
		$post_vars=$a_predefined['post'];
		$get_vars=$a_predefined['get'];
		$searchtxt=$get_vars['searchtxt'];
		@extract($post_vars);
			
		$searchtxt=$_SESSION['searchtext'];

		//print_R($post_vars);
		if($searchtxt!="") {
			if(preg_match("/^staff:/", $searchtxt)) {
					$staff=$this->prefix_table("staff");
					$tickets=$this->prefix_table("tickets");
					$sql="select is_admin, ticket_access from $staff where staff_id='".$_SESSION['staff_id']."'";
					$a_staff=$this->get_a_line($sql);
					if($a_staff['is_admin']=="1" or $a_staff['ticket_access']=="1") {
						list($ss,$username) = explode(":",$searchtxt);
						$username=trim($username);
						$sql="select staff_id from $staff where staff_username='$username'";
						$assigned=$this->get_a_line($sql);
						if($username!="none" and $assigned['staff_id']!="") {
							$search_clause= " and $tickets.assigned_to='".$assigned['staff_id']."'";
						} elseif($username=="all") {
							$search_clause= " and $tickets.assigned_to <> ''";
						} elseif($username=="none") {
							$search_clause= " and ( $tickets.assigned_to='0' or $tickets.assigned_to is null or $tickets.assigned_to='' ) ";
						} elseif($assigned['staff_id']=="") {
							$search_clause= " and $tickets.assigned_to='-1'";
						}
						$return_array['search_clause']=$search_clause;
						$return_array['search_txt']=$s_text;
						$return_array['ignored_txt']=$o_text;
						return $return_array;	
					} else {
						list($ss,$username) = explode(":",$searchtxt);
						$username=trim($username);
						$sql="select staff_id from $staff where staff_username='$username'";
						$assigned=$this->get_a_line($sql);
						if($assigned[0]=="" and $username!="all") {
							$search_clause= " and $tickets.assigned_to='-1'";
						}

						$return_array['search_clause']=$search_clause;
						$return_array['search_txt']=$s_text;
						$return_array['ignored_txt']=$o_text;
						return $return_array;	
					}
			} else {
				$search_clause=" and ( ";
				$search_arrayold=preg_split("/[ ,]/is",$searchtxt);
				$search_array=$this->filter_searchtxt($a_predefined,$search_arrayold);
				// check whether the search text is emphasized
				$filtered_text=stripslashes($searchtxt);
				if(preg_match("/[\"\'](.*?)[\"\']/",$filtered_text)) {
					$f_text=preg_replace("/[\'\"]/is","",$filtered_text);
					$search_array=array($f_text);
					$search_arrayold=$search_array;
				}

				$diff_array=array_diff($search_arrayold,$search_array);
				$s_text=join(" ",$search_array);
				$o_text=join(" ",$diff_array);
				if(count($search_array)==0) {
					$return_array['search_txt']=$s_text;
					$return_array['ignored_txt']=$o_text;
					return $return_array;
				}

			if($_SESSION['custom_field']=="") {
				$a_sql=$this->return_columns($tickets);
				for($j=0;$j<count($a_sql);$j++)	 {
					$column=$a_sql[$j];
					$search_clause.=" ( ";
					for($k=0;$k<count($search_array);$k++) {
						$key=$search_array[$k];
						$search_clause.=" $tickets.$column like '%$key%' and";
					}
					$search_clause=substr($search_clause,0,-3);		
					$search_clause.=" ) or";
					
				}
				$a_sql=array("subject","reply");
				
				for($j=0;$j<count($a_sql);$j++) {
					$column=$a_sql[$j];
					$search_clause.=" ( ";
					for($k=0;$k<count($search_array);$k++) {
						$key=$search_array[$k];
						$search_clause.=" $ticket_replies.$column like '%$key%' and";
					}
					$search_clause=substr($search_clause,0,-3);		
					$search_clause.=" ) or";
					
				}

				$a_sql=$this->return_columns($clients);
				for($j=0;$j<count($a_sql);$j++) {
					$column=$a_sql[$j];
					$search_clause.=" ( ";
					for($k=0;$k<count($search_array);$k++) {
						$key=$search_array[$k];
						$search_clause.=" $clients.$column like '%$key%' and";
					}
					$search_clause=substr($search_clause,0,-3);		
					$search_clause.=" ) or";
				}
				$search_clause=substr($search_clause,0,-2);	
			} else {
				$field_id = $_SESSION['custom_field'];
				$fields   = $this -> prefix_table ("fields");
				$sql="select * from $fields where field_id='$field_id'";
			
				$a_field=$this->get_a_line($sql);
				$column_name=$a_field['table_field'];
			
				$client_custom_values = $this -> prefix_table ("client_custom_values");
				$ticket_custom_values = $this -> prefix_table ("ticket_custom_values");

				if($a_field['orient_id']=="1") { // Customer custom field
					$column_name=" $client_custom_values.$column_name ";
				} else {
					$column_name=" $ticket_custom_values.$column_name ";
				}
				$search_clause.=" ( ";
				for($k=0;$k<count($search_array);$k++) {
					$key=$search_array[$k];
					$search_clause.=" $column_name like '%$key%' and";
				}
				$search_clause=substr($search_clause,0,-3);		
				$search_clause.=" ) ";
			}	
			$search_clause.=" ) ";

			$return_array['search_clause']=$search_clause;
			$return_array['search_txt']=$s_text;
			$return_array['ignored_txt']=$o_text;
			return $return_array;
			}
		}
	}

	/*This function is very much like submit_quick_reply , the difference being that , this is executed when client makes a reply*/
	function submit_client_reply($supp_obj,$a_predefined,$generic_msg) {
		$post_vars=$a_predefined['post'];
		$session_vars=$a_predefined['session'];
		$file_vars=$a_predefined['file'];
		@extract($post_vars);
		
		//Prefix and prepare tables 
		$tickets			=	$supp_obj->prefix_table("tickets");
		$staff_departments	=	$supp_obj->prefix_table("staff_departments");
		$staff				=	$supp_obj->prefix_table("staff");
		$clients			=	$supp_obj->prefix_table("clients");
		$mail_servers		=	$supp_obj->prefix_table("mail_servers");
		$dept_servers		=	$supp_obj->prefix_table("dept_servers");
		$departments		=	$supp_obj->prefix_table("departments");
		$ticket_priorities	=	$supp_obj->prefix_table("ticket_priorities");
		$config				=	$supp_obj->prefix_table("configuration");
		$client_id			=	$session_vars['client_id'];
		
		$sql="select * from $config ";
		$a_config=$supp_obj->get_a_line($sql);
		@extract($a_config);
		$ticket_replies=$supp_obj->prefix_table("ticket_replies");

		$tsub=$a_config['tktnotify_subject'];
		$tmess=$a_config['tktnotify_message'];
		$send_mail=$a_config['send_mail'];
		$tktnotify_action=$a_config['tktnotify_action'];
		// submit the reply
		$replied_on=$supp_obj->get_current_date();	
		//$dotktaction=$a_predefined['post']['tktstatus'];
		$action_array=array("N","O","H","C","S");
			if($dotktaction!="" and in_array($dotktaction,$action_array))
			{
				$tktstatus=$dotktaction;
				$adtclause="  status='$tktstatus' , ";
				$activity_array2['ticket_id']=$ticket_id;
				$activity_array2['status']=$tktstatus;
				//print_R($activity_array2);
				$supp_obj->log_activity($activity_array2,$client_id,'CLIENT');
			}
		$avoid_array=array("reply_id","reminder_on","last_update","last_updatedby","last_reporter","private");
		$insert_array=array("reply"=>$reply,"reporter_id"=>$client_id,
		"ticket_id"=>$ticket_id,"reporter"=>"CLIENT","replied_on"=>$replied_on,
		"subject"=>$subject,"change_status"=>$tktstatus);
		$sql=$supp_obj->construct_query($ticket_replies,"INSERT",$insert_array,$avoid_array);

		$reply_id=$supp_obj->execute_query($sql);
		$activity_array1['ticket_id']=$ticket_id;
		$activity_array1['reply_id']=$reply_id;
		$supp_obj->log_activity($activity_array1,$client_id,'CLIENT','Y');
		$last_activity=$supp_obj->get_current_date();	
		$sql="update $tickets set $adtclause 
		client_last_activity='$last_activity', updater='CLIENT' 
		 where ticket_id='$ticket_id' "	;
		$supp_obj->execute_query($sql);		
		$tag_array=$this->get_mail_tags($ticket_id);
		@extract($tag_array);
			
		if($send_mail=="1" and $tktnotify_action=="1")	// send mail notifications if enabled by admin
		{
		// send mail to all staff in the department who have opted to receive email notifications
		$sql="select distinct($ticket_replies.reporter_id), staff_name , staff_email from $staff , 
		$ticket_replies where $staff.staff_id=$ticket_replies.reporter_id
		and $ticket_replies.ticket_id='$ticket_id' and 
		$ticket_replies.reporter='STAFF' and $staff.notify_reply='1'
		 ";
		$a_staff=$supp_obj->get_rsltset($sql);
			for($s=0;$s<count($a_staff);$s++) // send notification to all selected staffs 		
			{
				$staff_name=$a_staff[$s]['staff_name'];
				$staff_email=$a_staff[$s]['staff_email'];
				
				//$tsub=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tsub);
				preg_match_all("/\{\{(.*?)\}\}/", $tsub, $matches);
				$tmp_array = array();
				foreach ($matches[0] as $index => $var_name) {
					$tmp_var_name = $matches[1][$index];
					if (isset($$tmp_var_name)) {
						$tmp_array[$tmp_var_name] = $$tmp_var_name;
					} else {
						$tmp_array[$tmp_var_name] = '';
					}
				}
				
				$tsub = preg_replace_callback("/\{\{(.*?)\}\}/",
									 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
									 $tsub);
									 
				//$tmess=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tmess);
				preg_match_all("/\{\{(.*?)\}\}/", $tmess, $matches);
				$tmp_array = array();
				foreach ($matches[0] as $index => $var_name) {
					$tmp_var_name = $matches[1][$index];
					if (isset($$tmp_var_name)) {
						$tmp_array[$tmp_var_name] = $$tmp_var_name;
					} else {
						$tmp_array[$tmp_var_name] = '';
					}
				}
				
				$tmess = preg_replace_callback("/\{\{(.*?)\}\}/",
									 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
									 $tmess);	
									 
				$supp_obj->send_mail($staff_email,$tsub,$tmess,$admin_email);
			}
		}

		if(count($file_vars) > 0)
		{
			for($i=0;$i<count($file_vars);$i++)
			{
				$file_name=$file_vars['file_'.$i]['name'];
				$new_name=$ticket_id."_".$reply_id."_".$i;
				list($n,$ext)=explode("\.",$file_name);
				$attachment_name = $new_name.".".$ext;
				$array=array("ticket_id"=>$ticket_id,"attachment_name"=>$attachment_name,"file_name"=>$file_name,"reply_id"=>$reply_id);

				$ticket_attachments=$supp_obj->prefix_table("ticket_attachments");
				$avoid_array=array("att_id");
				$sql=$supp_obj->construct_query($ticket_attachments,"INSERT",$array,$avoid_array);	
				$supp_obj->execute_query($sql);
				$this->upload_file("file_".$i,$file_vars,$new_name,'','attachments');

			}
		}
		$return_array['status_msg']=$generic_msg['cReply_sent'];	
	//print_R($return_array);
		return $return_array;			
	}
	
	//----------------------------------------------------------------------------------	
	/*This function prints the new ticket form .*/
	function open_a_ticketfrm($supp_obj,$session_vars,$generic_msg,$post_vars=array(),$template='',$a_predefined=array())
	{
		$field_answers = $supp_obj -> prefix_table ("field_answers");
		$config=$supp_obj->prefix_table("configuration");
		$clients=$supp_obj->prefix_table("clients");
		$client_columns=$supp_obj->return_columns($clients);

		$lang=$session_vars['supportlang'];
		if($template=="")
		{
			$template="templates/new_ticket.tpl";
		}
		else
		{
			$staffloggedin="yes";
		}

		$customer_script=" var client_array=new Array(); \n";
		foreach($client_columns as $key=>$value)
		{
			$customer_script.=" client_array[$key]='$value'; \n ";	
		}
		$sql="select attachment,attachment_size,registered_only  from $config ";
		$a_config=$supp_obj->get_a_line($sql);

		$get_vars=$a_predefined['get'];

		if(!is_array($post_vars))
		{
			$post_vars=array();
		}

		if(count($get_vars) > 0)
		{
			$post_vars=array_merge($post_vars,$get_vars);
		}

		$content=$supp_obj->return_file_content($template);

		if($staffloggedin!="yes")
		{
			if($a_config['registered_only']=="y")
			{
				$content=@preg_replace("/<{registeredonly_start}>(.*?)<{registeredonly_end}>/is","",$content);
				$post_vars['status_msg']=$generic_msg['cOnly_registeredallowed'];
			}
			else
			{
				$content=@preg_replace("/<{registeredonly_(.*?)}>/is","",$content);
			}		
		}
	
		$content=$supp_obj->screen_customer_password($content);
		if($supp_obj->is_plugin_active("noticemanager") and $staffloggedin!="yes")
		{
			include("plugins/noticemanager/functions.php");
			$content=get_notice($supp_obj,$content);
		}
		else
		{
			$content=$supp_obj->screen_plugin_content("noticemanager",$content);

		}

		$content=$supp_obj->screen_plugin_content("formspamprevention",$content);



		$departments=$supp_obj->prefix_table("departments");
		$fields=$supp_obj->prefix_table("fields");
		$staff=$supp_obj->prefix_table("staff");
		$staff_departments=$supp_obj->prefix_table("staff_departments");
		
		$sql = "SELECT * FROM $staff order by staff_id";
		$loop_sql['staff_'] = $sql;
		
		$supp_obj->return_table_desc($fields);
		if($staffloggedin=="yes") {
			$readonlyaccess=" and readonlyaccess <> '1' ";
			$mysql=$supp_obj->get_dept_list_query($a_predefined,$readonlyaccess);				
			$loop_sql['dept_']=$mysql; //  prepare sql for selecting departments 
		} else {
			$mysql="select * from $departments where private_dept <> '1'  or private_dept is null order by dept_name asc ";
			$loop_sql['dept_']=$mysql;
		}	
		$dept_list = $supp_obj->get_rsltset ($mysql);

		if(isset($post_vars['dept_id'])) {
			$sel_arr['dept_']['dept_id']=array($post_vars['dept_id']);
		} else if(count($dept_list) == 1) {
			$sel_arr['dept_']['dept_id']=array($dept_list[0]['dept_id']);
		}

		$sql="select * from $fields where orient_id='1' and field_level = 0 order by display_order";
		$a_fields=$supp_obj->get_rsltset($sql);
		$pattern="/<{customfields_loopstart}>(.*?)<{customfields_loopend}>/is";
		preg_match($pattern,$content,$out);
		$match=$out[1];
		$str="";
		$custom_javascript="";
		$notentered=$generic_msg['cCustomfield_notentered'];
		$incorrect=$generic_msg['cCustomfield_typeincorrect'];	

		$div_id = 0;
		for($f=0;$f<count($a_fields);$f++) {
			$field_name=$a_fields[$f]['field_name'];
			$table_field=$a_fields[$f]['table_field'];

			$div_id ++;
			$_SESSION ['div_id'] = $div_id;
			$custom_group_id = "'group_".$f."_level_" . "$f'";
			
			$field_level = $a_fields [$f]['field_level'];
			$parent_field_id = $a_fields[$f]['field_id'];

		
			$sql = "select field_answer, answer_id, field_type_id, field_display_id, compulsory from $field_answers 
				where field_id = $parent_field_id and submitform = 1 order by field_answer";


			$res = $supp_obj -> get_rsltset ($sql);

			$field_option_array = array();
			$field_option_id_array = array ();

			for ($m = 0; $m < count ($res); $m ++)
			{
				$field_option_array [$m] = $res [$m][0];
				$field_option_id_array [$m] = $res [$m][1];
			}
			
			if($res[0]['compulsory']=="1")
			{
				$mandatory="*";
				$notentered1 = addslashes ($notentered);
				$field_name1 = addslashes ($field_name);
$custom_javascript.=<<<EOD
	
	var	flag1=validate_field($table_field, '$notentered1 $field_name1');
			if(flag1==false)
			{
				return false;
			}
EOD;

	if($res[0]['field_type_id'] == "1")
	{
		$incorrect1 = addslashes ($incorrect);
		$custom_javascript.=<<<EOD

		if(!IsNumeric($table_field.value))
		{
			alert('$incorrect1 $field_name1');
			return false;
		}	
EOD;

	}
			}
			else
			{
				$mandatory="";
			}

			/*if ($res [0]['field_type_id'] == "3")
			{
				if($res[0]['field_display_id']=="1")
				{
					$id = $f . "_" . $f. "_0";
					$draw_field="<select name=\"$table_field\" id=\"$id\" class=\"singleline-field\" onChange=\"get_child_custom_fields(this);\">
								<option value=''>Choose</option>";
					for($o=0;$o<count($field_option_array);$o++)
					{
						$draw_field.="<option value=\"".$field_option_id_array[$o]."\">".$field_option_array[$o]."</option>";
					}	
					$draw_field.="</select>";
					if($res[0]['compulsory']=="1")
						$draw_field.=" <span class=\"mandatory-fld\">*</span>";	
				}
				elseif ($res [0]['field_display_id'] == "2")
				{
					$id = $f . "_" . $f. "_0";
					$draw_field="";
					for($o=0;$o<count($field_option_array);$o++)
					{
						$draw_field.="<input type='radio' name='$table_field' id=\"$id\" value='".
							$field_option_id_array[$o]."' onclick = 'get_child_custom_fields (this);'>".
							$field_option_array[$o]."";
						if($res[0]['compulsory']=="1" and $o==0)
							$draw_field.="  <span class=\"mandatory-fld\">*</span>";
						$draw_field.="<br/>";	

					}	
				}
				else
				{
					$draw_field="<input type=\"text\" name=\"$table_field\" id=\"$table_field\" value=\"{{".
					$table_field."}}\" class=\"singleline-field\"/>";
					if($a_fields[$f]['compulsory']=="1")
						$draw_field.=" <span class=\"mandatory-fld\">*</span>";	
	
				}
				
			}
			else if ($res [0]['field_type_id'] == "2" || $res [0]['field_type_id'] == "1")
			{
				$draw_field="<input type=\"text\" name=\"$table_field\" id=\"$table_field\" value=\"{{".
					$table_field."}}\" class=\"singleline-field\"/>";
				if($res[0]['compulsory']=="1")
					$draw_field.=" <span class=\"mandatory-fld\">*</span>";	
			
			}*/
			if ($res [0]['field_type_id'] == "3") {
				if($res[0]['field_display_id'] == "1")
				{
					$id = $f . "_" . $f. "_0";
					$draw_field="<select name=\"$table_field\" id=\"$id\" class=\"form-control select\" onChange=\"get_child_custom_fields(this);\">
								<option value=''>Choose</option>";
					for($o = 0; $o < count($field_option_array); $o++) {
						$draw_field.="<option value=\"".$field_option_id_array[$o]."\">".$field_option_array[$o]."</option>";
					}	
					$draw_field.="</select>";
					/*if($res[0]['compulsory'] == "1")
						$draw_field.=" <span class=\"mandatory-fld\">*</span>";	*/
				} elseif ($res [0]['field_display_id'] == "2") {
					$id = $f . "_" . $f. "_0";
					$draw_field="";
					for($o = 0; $o < count($field_option_array); $o++) {
						$draw_field.="<input type='radio' name='$table_field' id=\"$id\" value='".
							$field_option_id_array[$o]."' onclick = 'get_child_custom_fields (this);'>".
							$field_option_array[$o]."";
						/*if($res[0]['compulsory'] == "1" and $o == 0)
							$draw_field.="  <span class=\"mandatory-fld\">*</span>";*/
						$draw_field .= "<br/>";	
					}	
				} else {
					$draw_field="<input type=\"text\" name=\"$table_field\" id=\"$table_field\" value=\"{{".
					$table_field."}}\" class=\"form-control\"/>";
					/*if($a_fields[$f]['compulsory']=="1")
						$draw_field.=" <span class=\"mandatory-fld\">*</span>";	*/
				}
			} else if ($res [0]['field_type_id'] == "2" || $res [0]['field_type_id'] == "1") {
				$draw_field="<input type=\"text\" name=\"$table_field\" id=\"$table_field\" value=\"{{".
					$table_field."}}\" class=\"form-control\"/>";
				/*if($res[0]['compulsory']=="1")
					$draw_field.=" <span class=\"mandatory-fld\">*</span>";	*/
			
			}

			if ($res [0]['field_type_id'] == "1" || $res [0]['field_type_id'] == "2" || $res [0]['field_type_id'] == "3") {
				if ($post_vars['client_new_ticket'] != "true") {
					//$str.=preg_replace("/<{(.*?)}>/e","$$1",$match);	
					preg_match_all("/<{(.*?)}>/", $match, $matches);
					$tmp_array = array();
					foreach ($matches[0] as $index => $var_name) {
						$tmp_var_name = $matches[1][$index];
						if (isset($$tmp_var_name)) {
						   $tmp_array[$tmp_var_name] = $$tmp_var_name;
						} else {
							$tmp_array[$tmp_var_name] = '';
						}
					}
					
					$str .= preg_replace_callback("/<{(.*?)}>/",
										 function($m) use ($tmp_array) { return $tmp_array[$m[1]]; },
										 $match);
				}
			}
		}

		$content=preg_replace($pattern,$str,$content);
		$priorities=$supp_obj->prefix_table("ticket_priorities");
		$mysql="select *,priorityname as priority_name  from $priorities ";
		$loop_sql['priority_']=$mysql; //  prepare sql for selecting ticket priorities
		$sel_arr['priority_']['priority_id']=array($post_vars['priority_id']);
		$a_content=$supp_obj->replace_loop($loop_sql,$content,'',$sel_arr); // populate tpl file
		
		//subject line
		$ticket_subject=$supp_obj->prefix_table("ticket_subject");
		$mysql="select * from $ticket_subject ORDER BY subject";
		$loop_sql['subject_']=$mysql; //  prepare sql for selecting ticket priorities
		$a_content=$supp_obj->replace_loop($loop_sql,$content,'',$sel_arr); // populate tpl file
		
		$content = $a_content[0];
		// Check if attachment is allowed
	
		$content=$supp_obj->get_reply_attachments($supp_obj,$get_vars,$content);

		if($a_config['attachment']==1)	// attachment is allowed
		{
			$content=preg_replace("/\<\{attachment_(.*?)\}\>/is","",$content);
		}
		else							
		{
			$content=preg_replace("/\<\{attachment_start\}\>(.*?)\<\{attachment_end\}\>/is","",$content);
		}
		$post_vars['posted']="yes";	
		$post_vars=@array_merge($post_vars,$a_config);
		
		if($post_vars['status_msg']=="")
		{
			$content=preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);		
		}
		else
		{
			$content=preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		}
		$post_vars['custom_javascript']=$custom_javascript;

		if($get_vars['parent']!="")
		{
			$post_vars['parent']=$get_vars['parent'];
			$post_vars['reply_id']=$get_vars['reply_id'];
			$post_vars['client_id']=$get_vars['client_id'];
		}
		$post_vars['customer_script']=$customer_script;	
		$content=$supp_obj->direct_replace($content,$post_vars);		// replace simple variables

		echo $content;
		//setcookie("user_lang", trim($_SESSION ["supportlang"]), time() + (30 * 24 * 60 * 60 * 1000));		
	}

	//------------------------------------------------------------------------------------------------------
	/*Update Activity Log*/
	function log_activity($activity_array, $action_by, $user_type, $first = '') {
		$activity_log  = $this->prefix_table("activity_log");
		$departments   = $this->prefix_table("departments");
		$ticket_status = $this->prefix_table("ticket_status");
		//Get Current Date
		$action_on     = $this->get_current_date();
		
		//Is the ticket being moved to another department?
		if ($activity_array['fdept_id'] != "" and $activity_array['tdept_id'] != "") {
			$sql           = "select dept_name from $departments where dept_id='" . $activity_array['fdept_id'] . "'";
			$a_from        = $this->get_a_line($sql);
			$from          = $a_from['dept_name'];
			$sql           = "select dept_name from $departments where dept_id='" . $activity_array['tdept_id'] . "'";
			$a_to          = $this->get_a_line($sql);
			$to            = $a_to['dept_name'];
			$action_detail = $from . " => " . $to;
			$action_name   = "MOVE";
		}
		
		//Is status change happening
		if ($activity_array['status'] != "") {
			$sql           = "select statusname from $ticket_status where status_key='" . $activity_array['status'] . "'";
			$a_status      = $this->get_a_line($sql);
			$action_detail = "{{cStatus_changedto}} :" . $a_status['statusname'];
			$action_name   = "CHANGE";
		}
		if ($first == "Y") // If new ticket
			{
			$action_detail            = "{{cNew_ticket}}";
			$action_name              = "NEW";
			$activity_array['status'] = 'N';
		}
		if ($activity_array['reply_id'] != "") // reply edited
			{
			$action_detail = "{{cReply_edited}}";
			$action_name   = "EDIT";
		}
		if ($activity_array['reply_id'] != "" and $first == "Y") // reply added
			{
			$action_detail = "{{cReply_added}}";
			$action_name   = "ADD";
		}
		$ticket_id = $activity_array['ticket_id'];
		if ($activity_array['assignchange']) {
			$action_detail = $activity_array['assignchange'];
			$action_name   = "ASSIGN";
		}
		if ($activity_array['note']) {
			$action_detail = "{{cNote_added}}";
			$action_name   = "NOTE";
		}
		if ($activity_array['textnote']) {
			$action_detail = "{{cText_sentto}} :" . $activity_array['statusname'];
			$action_name   = "NOTE";
		}
		if ($activity_array['custom']) {
			$action_detail = "{{cCustom_saved}}";
			$action_name   = "CUSTOM";
		}
		if ($activity_array['split']) {
			$action_detail = "{{cSplit_from}}" . $activity_array['parent'];
			$action_name   = "SPLIT";
		}
		if ($activity_array['split']) {
			$action_detail = "{{cSplit_from}}" . $activity_array['parent'];
			$action_name   = "SPLIT";
		}
		if ($activity_array['splitted']) {
			$action_detail = "{{cSplit_to}}" . $activity_array['child'];
			$action_name   = "SPLIT";
		}
		if ($activity_array['schedule']) {
			$action_detail = $activity_array['action_detail'];
			$action_name   = "SCHEDULE";
		}
		
		if ($activity_array['resolution'] != "") {
			$action_name = "RESOLUTION";
			if ($activity_array['resolutiontype'] == "mark") {
				$action_detail = '{{cResolution_marked}}';
			} else {
				$action_detail = '{{cResolution_unmarked}}';
				
			}
		}
		
		$action_detail = $this->escape_string($action_detail);
		$reply_id      = $activity_array['reply_id'];
		if ($reply_id == '') {
			$reply_id = 0;
		}
		if ($activity_array['fdept_id'] != "") {
			$dept_id = $activity_array['fdept_id'];
		} else {
			$tickets = $this->prefix_table("tickets");
			$sql     = "select dept_id from $tickets where ticket_id='$ticket_id'";
			$a_dept  = $this->get_a_line($sql);
			$dept_id = $a_dept[0];
		}
		
		$sql = "insert into $activity_log (action_on,action_by,action_who,ticket_id,action_name,action_detail,adept_id,areply_id,astatus) values ('$action_on','$action_by','$user_type','$ticket_id','$action_name','$action_detail','$dept_id','$reply_id','" . $activity_array['status'] . "') ";
		
		$this->execute_query($sql);
	}


	/*This function submits a new ticket to the database*/
	function submit_ticket($supp_obj, $session_vars, $post_vars, $generic_msg, $file_vars, $template='', $multiple_submit = '') {
		$tick_array = array();
		$ticket_specific_custom_fields_name	= array ();
		$ticket_specific_custom_fields_value	= array ();	
		$ctr1 = 0;

		$customer_specific_custom_fields_name 	= array ();
		$customer_specific_custom_fields_value 	= array ();
		$ctr2 = 0;

		$fields 		= $supp_obj -> prefix_table ("fields");
		$field_answers  = $supp_obj -> prefix_table ("field_answers");		

		$post_vars ["message"] = $this -> stripLargeTags ($post_vars["message"]);
		$post_vars ["subject"] = $this -> stripLargeTags ($post_vars["subject"]);

		while(list($key,$value)=@each($post_vars)) {
			if (beginsWith($key, "tick_custom_")) {
				$temp = $key;
				$temp = str_replace ("tick_", "", $temp);
				$ticket_specific_custom_fields_name  [$ctr1] = $temp;
				$ticket_specific_custom_fields_value [$ctr1] = addslashes ($value);

				$sql_temp = "select field_id from $fields where table_field = '$temp' AND orient_id = 2";
				$sql_temp = $supp_obj -> get_rsltset ($sql_temp);
				$sql_temp = $sql_temp [0][0];

				$value = trim($value);

				$sql_temp = "select field_answer, field_type_id, answer_id from $field_answers where field_id = " . $sql_temp;
				$sql_temp .= " and answer_id =  '$value'";

				if (is_numeric ($value)) {
					$sql_temp = $supp_obj -> get_rsltset ($sql_temp);
					if ($sql_temp [0][1] == '3')
						$ticket_specific_custom_fields_value [$ctr1] = addslashes ($sql_temp [0][0]);		
					$ticket_specific_custom_fields_id [$ctr1] = ($sql_temp [0]['answer_id']);
				}
				$ctr1 ++;
			}

			if (beginsWith($key, "custom_")) {
				$customer_specific_custom_fields_name  [$ctr2] = $key;
				$customer_specific_custom_fields_value [$ctr2] = $value;

				$sql_temp = "select field_id from $fields where 
					table_field = '$key' and orient_id = 1";

				$sql_temp = $supp_obj -> get_rsltset ($sql_temp);
				$sql_temp = $sql_temp [0][0];
				$sql_temp = "select field_answer, field_type_id, answer_id from $field_answers where 
					field_id = " . $sql_temp;
				$sql_temp .= " and answer_id =  '$value'";
				
				if (is_numeric ($value))
				{
					$sql_temp = $supp_obj -> get_rsltset ($sql_temp);
					if ($sql_temp [0][1] == '3')
						$customer_specific_custom_fields_value [$ctr2] = addslashes ($sql_temp [0][0]);		
					$customer_specific_custom_fields_id [$ctr2] = $sql_temp [0]['answer_id'];
				}
				$ctr2 ++;
			}

			$$key=$value;
			if(preg_match("/^tick/",$key))
			{
				$key=str_replace("tick_","",$key);
				$tick_array[$key]=$value;
			}
		}
		// get all the table names
		$departments			= $supp_obj -> prefix_table ("departments");
		$ticket_priorities		= $supp_obj -> prefix_table ("ticket_priorities");
		$mail_servers			= $supp_obj -> prefix_table ("mail_servers");
		$dept_servers			= $supp_obj -> prefix_table ("dept_servers");
		$departments			= $supp_obj -> prefix_table ("departments");
		$staff					= $supp_obj -> prefix_table ("staff");
		$staff_departments		= $supp_obj -> prefix_table ("staff_departments");
		$clients				= $supp_obj -> prefix_table ("clients");
		$tickets				= $supp_obj -> prefix_table ("tickets");
		$client_custom_values 	= $supp_obj -> prefix_table ("client_custom_values");
		$ticket_custom_values 	= $supp_obj -> prefix_table ("ticket_custom_values");
		$client_custom_ids 		= $supp_obj -> prefix_table ("client_custom_ids");
		$ticket_custom_ids 		= $supp_obj -> prefix_table ("ticket_custom_ids");
		$schedule		 		= $supp_obj -> prefix_table ("schedule");

		// Check for security code if formspamprevention module is active	
		if($supp_obj->is_plugin_active("formspamprevention") and isset($post_vars['security_code']))
		{
			if($_SESSION['staff_id']=="" and $_SESSION['cust_code']!=$security_code)
			{
				$return_vars['status_msg']=$generic_msg['cInvalid_securitycode'];
				$return_vars['status']=false;
				return $return_vars;
			}
		}

		// Check for file attachments ..
		$sql="select priorityname from $ticket_priorities where priority_id='".$post_vars['priority_id']."'";
		$a_priority=$supp_obj->get_a_line($sql);
		$priorityname=$a_priority['priorityname'];
		$sql="select * from $departments where dept_id='$dept_id' ";
		$a_dep=$supp_obj->get_a_line($sql);
		$dept_name=$a_dep['dept_name'];
		// find out department from email address so that customer can be replied
		$sql="select pop3_email,signature, $departments.dept_name as dept_name from $mail_servers , $dept_servers, $departments 
			where $mail_servers.server_id=$dept_servers.server_id 
			and $departments.dept_id=$dept_servers.dept_id  and $dept_servers.dept_id='$dept_id' ";
		$a_popdetails=$supp_obj->get_a_line($sql);
		$pop3_email=$a_popdetails['pop3_email'];
		$dept_name=$a_popdetails['dept_name'];
		$pop3_email=$dept_name." <".$pop3_email.">";

		$ticket_prefix=$a_dep['ticket_prefix'];
		$ticket_id=$supp_obj->generate_unique_no($ticket_prefix);
		// Check for spam 
		$spam_message=$supp_obj->prefix_table("spam_message");
		$sql="select sp_word,spamaction from $spam_message ";
		$a_sql=$supp_obj->get_a_line($sql);
		$sp_word=$a_sql['sp_word'];
		$spamaction=$a_sql['spamaction'];
		$subject_filter=preg_split("/[\r\n]+/is",$sp_word,-1,PREG_SPLIT_NO_EMPTY);
		//Create customer if not exists
		$sql="select email,client_id,client_name,phone from $clients where email='$email'  ";
		$a_email=$supp_obj->get_a_line($sql);
		// Get configuration details
		$config=$supp_obj->prefix_table("configuration");
		$sql="select * from $config ";
		$a_config=$supp_obj->get_a_line($sql);
		@extract($a_config);
		$post_vars['status']='N';	

	if($supp_obj->mail_spam($subject_filter,$subject,$message) or $supp_obj->is_address_spammed($email))
	{
		if($spamaction=="move")
		{
			$post_vars['status']="S";				
		}
		else
		{
			$return_vars['status_msg']=$generic_msg['cBanned_words'];
			$return_vars['status']=false;
			return $return_vars;	
		}
	}

	if(!$supp_obj->is_attachment_size_valid($file_vars))	// Attachment size is more than the limit
	{
		$return_vars['status_msg']=$generic_msg['cInvattachmentsize'];
		$return_vars['status']=false;
		return $return_vars;		
	}

	if($a_email['email']=="") // customer doesn't exist
	{
		$registered_on=$supp_obj->get_current_date();		
		$post_vars['registered_on']=$registered_on;
		$avoid_array=array("client_id");
		if($post_vars['pass_word']=="")
		{
			$post_vars['pass_word']=$supp_obj->generate_password();	
		}	
		$pass=$post_vars['pass_word'];
		$post_vars['pass_word']=md5($post_vars['pass_word']);
		$post_vars['preferred_zone'] = $this->default_timezone();
		$post_vars['default_lang']=$default_lang;
		$post_vars['client_status']="a";
		$sql=$supp_obj->construct_query($clients,"INSERT",$post_vars,$avoid_array);
		$client_id=$supp_obj-> execute_query($sql);
	
		$sql_update_lang  = "update $clients set default_lang = '" . $_SESSION['supportlang'] . "' where client_id = ";
		$sql_update_lang .= $client_id;
		$supp_obj -> execute_query ($sql_update_lang);
	
		$replace_array=array("http_url"=>$http_url,"dept_name"=>$dept_name,
		"ticket_id"=>$ticket_id,"client_name"=>$post_vars['client_name'],
		"dept_signature"=>$a_popdetails['signature'],
		"email"=>$post_vars['email'],"pass_word"=>$pass,"subject"=>$post_vars['subject'],"message"=>$post_vars['message'],
		"priority"=>$priorityname,"phone"=>$post_vars['phone']);
		$newclient_message=$supp_obj->direct_replace($newclient_message,$replace_array);
		$newclient_subject=$supp_obj->direct_replace($newclient_subject,$replace_array);
	
		if($send_mail==1 and $newclient_action==1 )	// send mail only if overall mail is enabled and creation mail is enabled
		{		
			$supp_obj->send_mail($email,$newclient_subject,$newclient_message,$pop3_email);
		}
	} else {//customer exist
		if($_SESSION['staff_id']=="" and $multiple_submit!=1) {
			$return_vars['status_msg']=$generic_msg['cDup_email'];
			$return_vars['status']=false;
			return $return_vars;	
		}
		$client_id=$a_email['client_id'];
		// if the name is different , replace the old one with the current one
		$client_columns=$supp_obj->return_columns($clients);
		$fields=$supp_obj->prefix_table("fields");
		$sql="select table_field from $fields where orient_id='1' ";
		$a_fields=$supp_obj->get_single_column($sql);
		$query_clause="";
		for($q=0;$q<count($a_fields);$q++) {
			if(in_array($a_fields[$q],$client_columns)) {
				$var=$a_fields[$q];
				$query_clause.=" , $var='".$$var."'";
			}
		}	
		$sql="update $clients set client_name='$client_name',phone='$phone' $query_clause  where client_id='$client_id' ";
		$supp_obj->execute_query($sql);
		$sql="select * from $clients where client_id ='$client_id' ";
		$a_clnt=$supp_obj->get_a_line($sql);
		$post_vars+=$a_clnt;
	}
	
	if($a_config['attachment']==1)	// file attachment is allowed ...
	{
		if($template=="")		// from root
		{
			$path_name="attachments";	
		}
		else
		{
			$path_name="../attachments";

		}
		$supp_obj->upload_attachments($ticket_id,$file_vars,$session_vars,$path_name);	
	
	}		
	$post_vars['ticket_id']=$ticket_id;
	$post_vars['dept_name']=$dept_name;
	$post_vars['http_url']=$http_url;
	$post_vars['dept_signature']=$a_popdetails['signature'];
	$post_vars['priority']=$priorityname;
	$priority=$priorityname;
		
	$ticket_message=$supp_obj->direct_replace($ticket_message,$post_vars);
	$ticket_subject=$supp_obj->direct_replace($ticket_subject,$post_vars);
	
	
	if($post_vars['assign_to'] != '') {
		$schedule_arr['ticket_id'] = $post_vars['ticket_id'];
		$schedule_arr['staff_id'] = $post_vars['assign_to'];
		$schedule_arr['dueon'] = $post_vars['dueon'];
		$schedule_arr['duetime'] = $post_vars['duetime'];
		$schedule_arr['assigned'] = $session_vars['staff_id'];
		$schedule_arr['created'] = 'NOW()';
		$schedule_arr['message'] = $post_vars['message'];
		
		$avoid_array = array("id", "status", "modified");
		$sql = $supp_obj->construct_query($schedule, "INSERT", $schedule_arr, $avoid_array);
		$supp_obj->execute_query($sql);
		
		$assigned_detail = $supp_obj->get_assigned_details($post_vars['assign_to']);
		$activity_arr['action_detail'] = '{{cSchedule_assigned_to}} => '.$assigned_detail['staff_name'];
		$activity_arr['ticket_id'] = $schedule_arr['ticket_id'];
		$activity_arr['schedule'] = true;
		$supp_obj->log_activity($activity_arr, $schedule_arr['assigned'], 'STAFF');

		$staff_name = $assigned_detail['staff_name'];
		$staff_email = $assigned_detail['staff_email'];
		//$tmess = preg_replace("/\{\{(.*?)\}\}/e","$$1",$tktnotify_message);
		preg_match_all("/\{\{(.*?)\}\}/", $tktnotify_message, $matches);
		$tmp_array = array();
		foreach ($matches[0] as $index => $var_name) {
			$tmp_var_name = $matches[1][$index];
			if (isset($$tmp_var_name)) {
				$tmp_array[$tmp_var_name] = $$tmp_var_name;
			} else {
				$tmp_array[$tmp_var_name] = '';
			}
		}
		
		$tmess .= preg_replace_callback("/\{\{(.*?)\}\}/",
							 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
							 $tktnotify_message);	
		
		$icalarray = array("summary" => $tmess, "subject" => $ticket_subject, "location"=>"Office", "ticket_id" => $post_vars['ticket_id']);
		$ical = $supp_obj->formatIcal($assigned_detail['staff_email'], $pop3_email, $icalarray);
	}
	
	if($send_mail==1 and $send_tktconfirmation==1) {	// send mail only if overall mail is enabled and confirmation mail is enabled
		//$supp_obj->send_mail($email,$ticket_subject,$ticket_message,$pop3_email);
	}

	// send mail to all staff in the department who have opted to receive email notifications
	// should I send mail to staff ?
	
	if($send_mail==1 and $tktnotify_action=="1")
	{
	//if($_SESSION['staff_id']!="") // code commented by vijay
	{
	
		$sql="select distinct($staff_departments.staff_id),staff_name,staff_email from $staff,$staff_departments 
		where $staff.staff_id=$staff_departments.staff_id and 
		$staff_departments.dept_id='$dept_id' and $staff.notify_ticket='1' and ticket_access = 1 ";
		$a_staff=$supp_obj->get_rsltset($sql);
	
		for($s=0;$s<count($a_staff);$s++) // send notification to all selected staffs 		
		{
			$tsub=$tktnotify_subject;
			$tmess=$tktnotify_message;
	
			$staff_name=$a_staff[$s]['staff_name'];
			$staff_email=$a_staff[$s]['staff_email'];
			
			//$tsub=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tsub);
			preg_match_all("/\{\{(.*?)\}\}/", $tsub, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$tsub = preg_replace_callback("/\{\{(.*?)\}\}/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $tsub);
			
			//$tmess=preg_replace("/\{\{(.*?)\}\}/e","$$1",$tmess);
			preg_match_all("/\{\{(.*?)\}\}/", $tmess, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$tmess = preg_replace_callback("/\{\{(.*?)\}\}/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $tmess);

			$supp_obj->send_mail($staff_email,$tsub,$tmess,$admin_email);
		}
	
	}
	}
	
	$post_vars['client_id']=$client_id;
	$dept_servers=$supp_obj->prefix_table("dept_servers");
	$sql="select server_id from $dept_servers where default_server='1' and dept_id='$dept_id' ";
	$a_server=$supp_obj->get_a_line($sql);
	$server_id=$a_server['server_id'];
	$post_vars['server_id']=$server_id;
	
	$post_vars['updater_id']=$client_id;
	$post_vars['updater']="CLIENT";	
	$sent_date=$supp_obj->get_current_date();		
	$post_vars['client_last_activity']=$sent_date;
	$post_vars['ticket_created']=$sent_date;
	$post_vars['sent_date']=$sent_date;
	$post_vars['staff_last_activity']=$sent_date;
	if($post_vars['staff_id']=="")
	{
		$post_vars['staff_id']=0;
	}
	if($post_vars['staff_assignto'] != "") {
		$post_vars['assigned_to'] = $post_vars['staff_assignto'];
		$post_vars['staff_id'] = $post_vars['staff_assignto'];
	} else if($_SESSION['staff_id'] != "") {
		$post_vars['assigned_to']=$_SESSION['staff_id'];
		$post_vars['staff_id']=$_SESSION['staff_id'];
	}
	
	if($post_vars['cat_id']=="")
	{
		$post_vars['cat_id']=0;
	}
	if($post_vars['timezone']=="")
	{
		$post_vars['timezone']=0;
	}
	if($post_vars['assigned_to']=="")
	{
		$post_vars['assigned_to']=0;
	}
	//print_R($tick_array);
	//$post_vars+=$tick_array;
	if(count($tick_array) > 0)
	{
		$post_vars=array_merge($post_vars,$tick_array);	
	}
	
	$sql=$supp_obj->construct_query($tickets,"INSERT",$post_vars);
	$diff=$supp_obj->server_timezone_diff();
	$new_id=$supp_obj->execute_query($sql);
	
	$activity_array['ticket_id']=$ticket_id;
	$supp_obj->log_activity($activity_array,$client_id,'CLIENT','Y');
	
	$post_vars['ticket_id']=$ticket_id;
	
	// insert customer specific custom fields
	// insert ticket specific custom fields
	//commented due to custom fields data 23rd june 2015
	if (count($ticket_specific_custom_fields_name) > 0)
	{
		$this->addCustomFields ($supp_obj, $ticket_id, $ticket_specific_custom_fields_name, 
			$ticket_specific_custom_fields_value, $ticket_specific_custom_fields_id, "2");	
	}
	
	
	if (count ($customer_specific_custom_fields_name) > 0)
	{
		if ($post_vars['client_new_ticket'] != "true")
		{
			$this->addCustomFields ($supp_obj, $client_id, $customer_specific_custom_fields_name, 
			$customer_specific_custom_fields_value, $customer_specific_custom_fields_id, "1");	
		}
	}	
	
	
	if($template=="" and $multiple_submit!=1)		// if the post info is coming from root client page 
	{
		$template="templates/index.tpl";		// instead of submit ticket template show the index page itself
		$content=$supp_obj->return_file_content($template);
		$content=$supp_obj->screen_plugin_content("knowledgebase",$content);
		$content=$supp_obj->screen_customer_password($content);
	
		// code added by vijay for languages list begins here
		$chosen_lang_id = $_SESSION['supportlang'];
		$chosen_lang = "langname_" . $chosen_lang_id;
		$language = $supp_obj -> prefix_table ("language");	
		$sql_lang = "select * from $language";
		$res_lang = $supp_obj -> get_rsltset ($sql_lang);

		for ($i = 0; $i < count ($res_lang); $i ++)
		{
			$lang_id = $res_lang [$i]['lang_folder'];
			$lang_name = $res_lang [$i][$chosen_lang];

			if ($lang_id != $chosen_lang_id) 
			{
				$lang_content .= "<option value=\"" . $lang_id . "\">" . $lang_name . "</option>";
			}
			else
			{
				$lang_content .= "<option value=\"" . $lang_id . "\"selected>" . $lang_name . "</option>";
			}
		}
		$content = @preg_replace ("/<{languages_list}>/is", $lang_content, $content);
	
		// code added by vijay for languages list ends here
		$msg_content=$generic_msg['cTicket_submitinfo'];
		$post_vars['status_msg']=$supp_obj->direct_replace($msg_content,$post_vars);
		$content=preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		$plugins=$supp_obj->prefix_table("plugins");
		$sql="select plugin_status from $plugins where plugin_name='ldap' ";
		$line=$supp_obj->get_a_line($sql);
		$replace_content=array();
		if($line['plugin_status']=="1")  // Plugin status is active
		{
		$ldap_properties=$supp_obj->prefix_table("ldap_properties");
		$sql="select ldap_customer_authenticate from $ldap_properties ";
		$a_ldap_properties=$supp_obj->get_a_line($sql);
		if($a_ldap_properties['ldap_customer_authenticate']=="1")
		{
			$post_vars['logon']=$generic_msg['cUser_name'];										
		}
		else
		{
			$post_vars['logon']=$generic_msg['cEmail'];
		}
	
		}
		else
		{
			$post_vars['logon']=$generic_msg['cEmail'];
		}
	
	if($supp_obj->is_plugin_active("noticemanager"))
	{
		include("plugins/noticemanager/functions.php");
		$content=get_notice($supp_obj,$content);
	}
	else
	{
		$content=$supp_obj->screen_plugin_content("noticemanager",$content);
	
	}
	
	if($a_config['registered_only']=="y")
	{
		$content=@preg_replace("/<{registeredonly_start}>(.*?)<{registeredonly_end}>/is","",$content);
		$content=@preg_replace("/<{registrationrequired_(.*?)}>/is","",$content);
	}
	else
	{
		$content=@preg_replace("/<{registeredonly_(.*?)}>/is","",$content);
		$content=@preg_replace("/<{registrationrequired_start}>(.*?)<{registrationrequired_end}>/is","",$content);
	}			
		$content=$supp_obj->direct_replace($content,$post_vars);
		echo $content;
		$return_vars['status']=true;
		return $return_vars;	
	}
	elseif($multiple_submit==1)
	{
		$return_vars['status_msg']=$generic_msg['cTicket_created'];
		$return_vars['status']=false;
		return $return_vars;	
	
	}	
	else
	{
// Redirect to ticket detail page
$script=<<<EOD
<script language="JavaScript">
window.location.replace('ticket_detail.php?ticket_id=$ticket_id&status_msg=cTicket_submitted');
</script>
EOD;
echo $script;
exit;		
}
}
//--------------------------------------------------------------------------------------
/*This function checks for spam in a mail content*/
function mail_spam($subject_filter,$subject,$content)
{
	$sub_array=@array_keys($subject_filter);
	$spam_in_sub=0;
	for($ii=0;$ii<count($sub_array);$ii++)
	{
		$key=$sub_array[$ii];
		
		$key=$subject_filter[$key];
		if(trim($key)=="")
		{
			continue;
		}
		$key=preg_quote($key);
		$pattern="/".$key."/is";
		if(@preg_match($pattern,$subject) or @preg_match($pattern,$content))	// spam found .. what do i do now
		{
			return true;
		}
	}
return false;
}
//---------------------------------------------------------------------------------------
function is_valid_account($pop3host,$pop3user,$pop3pass)
{
// connect to host over port 110 with a 5 second timeout
$fp = @fsockopen ($pop3host, 110, $errno, $errstr, 5); 
if (!$fp)
{ 
	return false;
}
else
{ 
   fclose ($fp); 
} 
$mail_box1="{".$pop3host."/pop3:110}INBOX";
$mail_box2="{".$pop3host."/pop3/notls}INBOX";
// Connect to the mail server .
$ml_handle = @imap_open($mail_box1, $pop3user, $pop3pass);
if (!$ml_handle) 
{
$ml_handle = @imap_open($mail_box2, $pop3user, $pop3pass);
}
if(!$ml_handle)
{
	return false;
}

return true;
}

//---------------------------------------------------------------------------------------
function strip_off_html($content)
{
$search = array ("'<script[^>]*?>.*?</script>'si",
				"'<style[^>]*?>.*?</style>'si",
				 "'<[\/\!]*?[^<>]*?>'si",           // Strip out HTML tags
 "'([\r\n])[\s]+'"              // Strip out white space
 );                    // evaluate as php

$replace = array ("",
  "","",
  "\\1");
	
/*	
$search = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
 "'<[\/\!]*?[^<>]*?>'si",           // Strip out HTML tags
 "'([\r\n])[\s]+'",                 // Strip out white space
 "'&(quot|#34);'i",                 // Replace HTML entities
 "'&(amp|#38);'i",
 "'&(lt|#60);'i",
 "'&(gt|#62);'i",
 "'&(nbsp|#160);'i",
 "'&(iexcl|#161);'i",
 "'&(cent|#162);'i",
 "'&(pound|#163);'i",
 "'&(copy|#169);'i",
 "'&#(\d+);'e");                    // evaluate as php

$replace = array ("",
  "",
  "\\1",
  "\"",
  "&",
  "<",
  ">",
  " ",
  chr(161),
  chr(162),
  chr(163),
  chr(169),
  "chr(\\1)");
*/

$content = preg_replace($search, $replace, $content);
return $content;
}	
//------------------------------------------------------------------------------------------------------------------
function notify_onticketclose($session_vars,$dept_id,$tktstatus,$ticket_id)
{

if($tktstatus=="C") // act only if the ticket status is closed
{
	$staff_vars['logged_in_staff'] = $session_vars['staff_id'];
	$config=$this->prefix_table("configuration");
	$staff_departments=$this->prefix_table("staff_departments");
	$staff=$this->prefix_table("staff");
	$clients=$this->prefix_table("clients");
						
	$tag_array=$this->get_mail_tags($ticket_id);	


	$sql="select admin_email, closeticket_subject, closeticket_message, closeticket_action, send_mail from $config";
	$a_config=$this->get_a_line($sql);
	if($a_config['send_mail']==1 and $a_config['closeticket_action']==1)
	{
		// Get those staff who are in this department and who have opted to receive notifications except the logged in staff
		$sql="select distinct(staff_email), staff_name from $staff,$staff_departments 
		where $staff.staff_id=$staff_departments.staff_id and 
		$staff_departments.dept_id='$dept_id' and $staff.notify_closeticket='1' and $staff.staff_id  <>  '".$staff_vars['logged_in_staff']."'";
		$a_staff=$this->get_rsltset($sql);
		for($i=0;$i<count($a_staff);$i++)
		{

			$row=$a_staff[$i];
			$row['logged_in_staff']=$session_vars['staff_username'];
			$row['ticket_id']=$ticket_id;
			$row=@array_merge($row,$tag_array);
								
			$staff_email=$a_staff[$i]['staff_email'];
			$subject=$this->direct_replace($a_config['closeticket_subject'],$row);
			$message=$this->direct_replace($a_config['closeticket_message'],$row);										    
		    $this->send_mail($staff_email,$subject,$message,$a_config['admin_email']);
		}	
				
	}
	
}
				

}	
//----------------------------------------------------------------------------------------------------
function return_dates_between($date1,$date2)
{
list($startdate,$starttime)=@preg_split("/[ ]+/is",$date1,-1,PREG_SPLIT_NO_EMPTY);
list($enddate,$endtime)=@preg_split("/[ ]+/is",$date2,-1,PREG_SPLIT_NO_EMPTY);
list($syear,$smonth,$sday)=@explode("-",$startdate);
list($shour,$smin,$ssec)=@explode(":",$starttime);
list($eyear,$emonth,$eday)=@explode("-",$enddate);
list($ehour,$emin,$esec)=@explode(":",$endtime);
$startsec=@gmmktime($shour,$smin,$ssec,$smonth,$sday,$syear);
$endsec=@gmmktime($ehour,$emin,$esec,$emonth,$eday,$eyear);
$diff=$endsec-$startsec;
$diff=abs($diff);
$no_of_days=floor($diff/86400);
return $no_of_days;	

}
//-------------------------------------------------------------------------------------------------------------	

function autoclose_tickets($session_vars)
{
$tickets=$this->prefix_table("tickets");
$config=$this->prefix_table("configuration");
$sql="select auto_close from $config ";
$a_sql=$this->get_a_line($sql);
$auto_close=$a_sql['auto_close'];
$current_date=$this->get_current_date();
// Get those tickets where no activity has been performed either by the client
// or by the staff
$sql="select * from $tickets where ".
$this->date_diff($current_date,'client_last_activity')." >= '$auto_close' and  ".
$this->date_diff($current_date,'staff_last_activity')." >= '$auto_close' and status not in  ('C','H') ";
$a_tickets=$this->get_rsltset($sql);
for($i=0;$i<count($a_tickets);$i++)
{
	$ticket_id=$a_tickets[$i]['ticket_id'];
	$dept_id=$a_tickets[$i]['dept_id'];
	$sql="update $tickets set status='C' where ticket_id='$ticket_id' ";
	$this->execute_query($sql);
	$activity_array1['ticket_id']=$ticket_id;
	$activity_array1['status']="C";
	$this->log_activity($activity_array1,$_SESSION['staff_id'],'SYSTEM');
	$this->notify_onticketclose($session_vars,$dept_id,'C',$ticket_id);
}	
}
//------------------------------------------------------------------------------------------------------------------------------

function default_timezone()
{
	$config=$this->prefix_table("configuration");
	$sql = "select time_zone from $config";
	$a_config = $this->get_a_line($sql);
	return $a_config['time_zone'];	
}

//--------------------------------------------------------------------------------------------------------------------------------------------
function send_attmail($to,$subject,$message,$from,$file_vars,$ticket_id,$reply_id,$addresses=array())
{


if($this->gen_smtp_mail=="1")
{
	$adt['file']=$file_vars;	
	$adt['ticket_id']=$ticket_id;
	$adt['reply_id']=$reply_id;	
	return $this->send_smtp_mail($to,$subject,$message,$from,$addresses,$adt);
}

if (strtoupper(substr(PHP_OS,0,3)=='WIN')) 
{ 
	  $eol="\r\n"; 
} 
elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) 
{ 
	 $eol="\r"; 
} 
else 
{ 
	$eol="\n"; 
} 
$cc="";
$bcc="";
if(isset($addresses['cc']) and $addresses['cc']!="")
{
	$cc=$addresses['cc'];
}	

if(isset($addresses['bcc']) and $addresses['bcc']!="")
{
	$bcc=$addresses['bcc'];
}	


$message=stripslashes($message);
$message1=nl2br($message);
$headers = "From: $from".$eol;
$headers .= "Reply-To: $from".$eol;
if($cc!="")
{
		$headers.= "Cc: $cc".$eol;

} 
	if($bcc!="")
{
		$headers.= "Bcc: $bcc".$eol;

} 

$headers .= "Return-Path: $from".$eol; 
$headers .= "X-Mailer: PHP v".phpversion().$eol;    

$semi_rand = md5(time());  
$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";  
$headers .= "MIME-Version: 1.0" .$eol.  
			"Content-Type: multipart/mixed;" .$eol.  
			" boundary=\"{$mime_boundary}\"";  

$message = "This is a multi-part message in MIME format." .$eol.$eol.  
				"--{$mime_boundary}" .$eol.  
				"Content-Type:text/html; charset=\"UTF-8\"" .$eol.  
			   "Content-Transfer-Encoding: 7bit" .$eol.$eol;
$message .= $message1.$eol.$eol;

for($i=0;$i<(count($file_vars));$i++)
{
	$tmp_name=$file_vars['file_'.$i]['tmp_name'];
	if($tmp_name!="none" and $tmp_name!="")		// if the user has uploaded an attachment
	{
		$size=$file_vars['file_'.$i]['size'];	
		
		$new_name=$ticket_id."_".$reply_id."_".$i;
		
		$attachment_name=$this->upload_file("file_".$i,$file_vars,$new_name,'','../attachments');
	}

	$fileatt_type = $file_vars['file_'.$i]['type'];
	$fileatt_name = $file_vars['file_'.$i]['name'];

	list($n,$ext)=explode("\.",$fileatt_name);

	$fileatt = "../attachments/".$attachment_name;
	$file = fopen($fileatt,'rb');  
	$data = fread($file,filesize($fileatt));  
	fclose($file);  
	$data = chunk_split(base64_encode($data));  
	$message .= "--{$mime_boundary}" .$eol.  
					  "Content-Type: {$fileatt_type};" .$eol.  
					  " name=\"{$fileatt_name}\"" .$eol.  
					  "Content-Transfer-Encoding: base64" .$eol.$eol.  
					 $data  .$eol.$eol.  
					  "--{$mime_boundary}".$eol;  
	unset($data);
	unset($file);
	unset($fileatt);
	unset($fileatt_type);
	unset($fileatt_name);
}

if(trim($to)=="") // To address missing
{
	return;
}	


$bool=@mail($to, $subject, $message, $headers);
return $bool;
}
//-------------------------------------------------------------------------------------------------------------------------------------
function block_email($supp_obj,$session_vars,$a_predefined,$generic_msg)
{
$get_vars=$a_predefined['get'];
$ticket_id=$get_vars['ticket_id'];
$client_id=$get_vars['fclient_id'];
$clients=$supp_obj->prefix_table("clients");
$sql="select email from $clients where client_id='$client_id' ";
$a_client=$supp_obj->get_a_line($sql);
$blemail=$a_client['email'];
$post_vars=$a_predefined['post'];
@extract($post_vars);	
$tickets=$supp_obj->prefix_table("tickets");
$spam_message=$supp_obj->prefix_table("spam_message");
$sql = "select * from $spam_message";
$a_spam = $supp_obj->get_a_line($sql);

$upd_spam = $a_spam['sp_addresses']."\r\n".$blemail;

$upd_spam=strtolower($upd_spam);
$upd_spam=preg_split("/[\r\n]+/",$upd_spam,-1,PREG_SPLIT_NO_EMPTY);
$upd_spam=array_unique($upd_spam);
$upd_spam=implode("\r\n",$upd_spam);

// update the spam_message table with new email address.
if($a_spam['spm_id']!="")
{
	$sql = "update $spam_message set sp_addresses='$upd_spam'";
	$supp_obj->execute_query($sql);
}
else
{
	$sql="insert into $spam_message (sp_addresses, sp_word, spamaction) values('$upd_spam', '', '') ";
	$supp_obj->execute_query($sql);
}

// Update the ticket status as spam
$sql = "update $tickets set status='S' where ticket_id='$ticket_id'";
$supp_obj->execute_query($sql);
$activity_array["ticket_id"]=$ticket_id;
$activity_array["status"]="S";
$action_by=$session_vars['staff_id'];
$user_type="STAFF";
$supp_obj->log_activity($activity_array,$action_by,$user_type,$first='');	
$return_array['status_msg']='cBlocked_successfully';
return $return_array;

}

//----------------------------------------------------------------------------------------------------------------------------------------

function unblock_email($supp_obj,$session_vars,$a_predefined,$generic_msg)
{
$get_vars=$a_predefined['get'];
$ticket_id=$get_vars['ticket_id'];
$client_id=$get_vars['fclient_id'];
$clients=$supp_obj->prefix_table("clients");
$sql="select email from $clients where client_id='$client_id' ";
$a_client=$supp_obj->get_a_line($sql);
$blemail=$a_client['email'];
$a_email=array($blemail);
$post_vars=$a_predefined['post'];
@extract($post_vars);	
$tickets=$supp_obj->prefix_table("tickets");
$spam_message=$supp_obj->prefix_table("spam_message");
$activity_log=$supp_obj->prefix_table("activity_log");

$sql = "select * from $spam_message";
$a_spam = $supp_obj->get_a_line($sql);

$upd_spam = $a_spam['sp_addresses'];

$upd_spam=strtolower($upd_spam);
$upd_spam=preg_split("/[\r\n]+/",$upd_spam,-1,PREG_SPLIT_NO_EMPTY);
$upd_spam=array_unique($upd_spam);
if(is_array($upd_spam) and $upd_spam[0]!="")
{
	$upd_spam=array_diff($upd_spam,$a_email);

}	
$upd_spam=implode("\r\n",$upd_spam);
// update the spam_message table with new email address.
if($a_spam['spm_id']!="")
{
	$sql = "update $spam_message set sp_addresses='$upd_spam'";
	$supp_obj->execute_query($sql);
}
else
{
	$sql="insert into $spam_message (sp_addresses) values('$upd_spam') ";
	$supp_obj->execute_query($sql);
}

// Have to update tickets too.. So get into the activity log now
$sql="select * from $tickets where client_id = $client_id and status='S' ";
$a_tickets=$supp_obj->get_rsltset($sql);
for($i=0;$i<count($a_tickets);$i++)
{
	$ticket_id=$a_tickets[$i]["ticket_id"];
	$sql="select action_detail from $activity_log where ticket_id='$ticket_id' and action_detail like '%{{cStatus_changedto}}%'
	and action_detail not like '%Spam%'  order by activity_id desc limit 0, 1";
	$a_log=$supp_obj->get_a_line($sql);
	if($a_log['action_detail']!="")
	{
		list($n,$status)=explode(":",$a_log['action_detail']);
		$status=trim($status);
		$status=$status[0];
	}
	else
	{
		$status="N";
	}	
}	
$sql = "update $tickets set status='$status' where ticket_id='$ticket_id'";
$supp_obj->execute_query($sql);
$activity_array["ticket_id"]=$ticket_id;
$activity_array["status"]=$status;
$action_by=$session_vars['staff_id'];
$user_type="STAFF";
$supp_obj->log_activity($activity_array,$action_by,$user_type,$first='');
$return_array['status_msg']='cUnblocked_successfully';
return $return_array;	
	

}

//----------------------------------------------------------------------------------------------------------------------------------------

function is_address_spammed($email)
{
# Feature Block email addresses,
$spam_message=$this->prefix_table("spam_message");
$sql = "select * from $spam_message";
$a_spam = $this->get_a_line($sql);
if($a_spam['sp_addresses']=="")
{
	return false;
}
if (preg_match("/".$email."/i", $a_spam['sp_addresses']))
{
	return true;
}
else
{
	return false;
}	
}	
//--------------------------------------------------------------------------------------------------------------------------------------------------			
function decode_text($text,$charset)
{


$return_string = "";

if($text!="")
{
	$elements=@imap_mime_header_decode($text);
	//print_R($elements);
	for($i=0; $i < count($elements); $i++) 
	{
		//print_R($elements[$i]);
		if ($charset == "default")
		{
		   $return_string .= $this->conv_to_utf8($elements[$i]->text, $charset);
		}   
		else
		{
			$return_string .= $this->conv_to_utf8($elements[$i]->text, $elements[$i]->charset);
		}
	}
}
return $return_string;
}
//------------------------------------------------------------------------------------------------------------------------------------------------


function conv_to_utf8($text, $charset)
{

if (function_exists('iconv')) 
{
	if ($charset=="")
	{
		$charset="US-ASCII";
	}	
	$charset = strtoupper($charset);
	$matched = iconv($charset, "UTF-8", $text);
	if ($matched)
	{
		return $matched;
	}	
}
return $text;
}

//----------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------

function add_quoted_text($content,$prefix,$reporter='CLIENT')
{


//	$content="hiBLOCKQUOTE type=\"cite\"Hi there</a>/BLOCKQUOTE original text BLOCKQUOTE type=\"cite\">second quote</a>/BLOCKQUOTE";

$string="";
$i=1;

$original_string=$content;

if($reporter=='STAFF')
{
$pattern="/\-\-\- Original Message \-\-\-/is";
preg_match($pattern,$original_string,$matched);
if($matched[0]!="")
{
		// Clip off original reply
		$id=$prefix."_".$i;
		$spanid=$prefix."span_".$i;
			$anchor="<span id=\"$spanid\" class=\"quotedflag\"><a onClick=\"showElement('$id','$spanid');\">show quoted text</a></span><div id=\"$id\" style=\"display:none\"class=\"quotedtext\">";
	$replacement=$anchor."--- Original Message ---";
	$content=preg_replace($pattern,$replacement,$content)."</div>";

	return $content;					
}

}	


$pattern="/#-#----- (.*?) -----#-#/is";
preg_match($pattern,$original_string,$matched);
if($matched[0]!="")
{
// Clip off original reply
		$id=$prefix."_".$i;
		$spanid=$prefix."span_".$i;
	$anchor="<span id=\"$spanid\" class=\"quotedflag\"><a onClick=\"showElement('$id','$spanid');\">show quoted text</a></span><div id=\"$id\" style=\"display:none\"class=\"quotedtext\">";

		$replacement=$anchor."#-#----- $1"." -----#-#";
		$content=preg_replace($pattern,$replacement,$content)."</div>";
		
	return $content;					
}

$pattern="/<BLOCKQUOTE (.*?)>(.*?)<\/BLOCKQUOTE>/is";


while($original_string!="")
{

$pattern="/<BLOCKQUOTE (.*?)>(.*?)<\/BLOCKQUOTE>/is";

preg_match($pattern,$original_string,$matched);

//	print_R($matched);

if($matched[0]=="")
{
$string.=$original_string;
$original_string="";

return $string;
}

$pos=strpos($original_string,$matched[0]);


$lenofmatched=strlen($matched[0]);

$id=$prefix."_".$i;

$spanid=$prefix."span_".$i;

$anchor="<span id=\"$spanid\" class=\"quotedflag\"><a onClick=\"showElement('$id','$spanid');\">show quoted text</a></span><div id=\"$id\" style=\"display:none\"class=\"quotedtext\">";

$lenofanchor=strlen($anchor);

$text=substr($original_string,0,$pos);
$len=strlen($text);

$cut=$len+$lenofmatched;

$string.=$text.$anchor.$matched[0]."</div>";


$original_string=substr($original_string,$cut);

$i++;


}


//print_r($matched);


return $string;

}

//---------------------------------------------------------------------------------------

function display_custom_fields($supp_obj,$a_predefined,$generic_msg,$content,$view=1)
{
	$get_vars=$a_predefined['get'];
	$post_vars=$a_predefined['post'];
	$client_id=$get_vars['fclient_id'];
	@extract($post_vars);	
	$clients=$supp_obj->prefix_table("clients");
	$fields=$supp_obj->prefix_table("fields");
	$field_answers = $supp_obj -> prefix_table ("field_answers");
	$sql="select * from $clients where  client_id='$client_id' ";
	$a_client=$supp_obj->get_a_line($sql);
	@extract($a_client);			

	$sql="select * from $fields where orient_id='1' and field_level = 0 order by display_order";

		$a_fields=$supp_obj->get_rsltset($sql);
		$pattern="/<{customfields_loopstart}>(.*?)<{customfields_loopend}>/is";
		preg_match($pattern,$content,$out);
		$match=$out[1];
		$str="";
		$custom_javascript="";
		$notentered=$generic_msg['cCustomfield_notentered'];
		$incorrect=$generic_msg['cCustomfield_typeincorrect'];	

		$div_id = 0;
		for($f=0;$f<count($a_fields);$f++)
		{
			$field_name=$a_fields[$f]['field_name'];
			$table_field=$a_fields[$f]['table_field'];

			$div_id ++;
			$_SESSION ['div_id'] = $div_id;
			$custom_group_id = "'group_".$f."_level_" . "$f'";
			
			$field_level = $a_fields [$f]['field_level'];
			$parent_field_id = $a_fields[$f]['field_id'];

		
			$sql = "select field_answer, answer_id, field_type_id, field_display_id, compulsory from $field_answers 
				where field_id = $parent_field_id and submitform = 1 order by field_answer";


			$res = $supp_obj -> get_rsltset ($sql);

			$field_option_array = array();
			$field_option_id_array = array ();

			for ($m = 0; $m < count ($res); $m ++)
			{
				$field_option_array [$m] = $res [$m][0];
				$field_option_id_array [$m] = $res [$m][1];
			}
			
			if($res[0]['compulsory']=="1")
			{
				$mandatory="*";
				$notentered1 = addslashes ($notentered);
				$field_name1 = addslashes ($field_name);
$custom_javascript.=<<<EOD
	
	var	flag1=validate_field($table_field, '$notentered1 $field_name1');
			if(flag1==false)
			{
				return false;
			}

EOD;

	if($res[0]['field_type_id'] == "1")
	{
		$incorrect1 = addslashes ($incorrect);
		
		
		$custom_javascript.=<<<EOD

		if(!IsNumeric($table_field.value))
		{
			alert('$incorrect1 $field_name1');
			return false;
		}	
EOD;

	}


			}
			else
			{
				$mandatory="";
			}

			if ($res [0]['field_type_id'] == "3")
			{
				if($res[0]['field_display_id']=="1")
				{
					$id = $f . "_" . $f. "_0";
					$draw_field="<select name=\"$table_field\" id=\"$id\" class='singleline-field' 
						onChange = 'get_child_custom_fields (this);'><option value=''>Choose</option>";
					for($o=0;$o<count($field_option_array);$o++)
					{
						$draw_field.="<option value=\"".$field_option_id_array[$o]."\">".$field_option_array[$o]."</option>";
					}	
					$draw_field.="</select>";
					if($res[0]['compulsory']=="1")
						$draw_field.=" <span class=\"mandatory-fld\">*</span>";	
				}
				elseif ($res [0]['field_display_id'] == "2")
				{
					$id = $f . "_" . $f. "_0";
					$draw_field="";
					for($o=0;$o<count($field_option_array);$o++)
					{
						$draw_field.="<input type='radio' name='$table_field' id=\"$id\" value='".
							$field_option_id_array[$o]."' onclick = 'get_child_custom_fields (this);'>".
							$field_option_array[$o]."";
						if($res[0]['compulsory']=="1" and $o==0)
							$draw_field.="  <span class=\"mandatory-fld\">*</span>";
						$draw_field.="<br/>";	

					}	
				}
				else
				{
					$draw_field="<input type=\"text\" name=\"$table_field\" id=\"$table_field\" value=\"{{".
					$table_field."}}\" class=\"singleline-field\"/>";
					if($a_fields[$f]['compulsory']=="1")
						$draw_field.=" <span class=\"mandatory-fld\">*</span>";	
	
				}
				
			}
			else if ($res [0]['field_type_id'] == "2" || $res [0]['field_type_id'] == "1")
			{
				$draw_field="<input type=\"text\" name=\"$table_field\" id=\"$table_field\" value=\"{{".
					$table_field."}}\" class=\"singleline-field\"/>";
				if($res[0]['compulsory']=="1")
					$draw_field.=" <span class=\"mandatory-fld\">*</span>";	
			
			}

			if ($res [0]['field_type_id'] == "1" || $res [0]['field_type_id'] == "2" || $res [0]['field_type_id'] == "3")
			{
				if ($post_vars['client_new_ticket'] != "true")
				{
					//$str.=preg_replace("/<{(.*?)}>/e","$$1",$match);
                    preg_match_all("/<{(.*?)}>/", $match, $matches);
                    $tmp_array = array();
                    foreach ($matches[0] as $index => $var_name) {
                        $tmp_var_name = $matches[1][$index];
                        if (isset($$tmp_var_name)) {
                            $tmp_array[$tmp_var_name] = $$tmp_var_name;
                        } else {
                            $tmp_array[$tmp_var_name] = '';
                        }
                    }
                    
                    $str .= preg_replace_callback("/<{(.*?)}>/",
                                         function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
                                         $match);
                                         
                    preg_match_all("/<{(.*?)}>/", $match, $matches);
                    $tmp_array = array();
                    foreach ($matches[0] as $index => $var_name) {
                        $tmp_var_name = $matches[1][$index];
                        if (isset($$tmp_var_name)) {
                            $tmp_array[$tmp_var_name] = $$tmp_var_name;
                        } else {
                            $tmp_array[$tmp_var_name] = '';
                        }
                    }
                    
                    $str .= preg_replace_callback("/<{(.*?)}>/",
                                         function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
                                         $match);	
				}
			}
		}
		$content=@preg_replace($pattern,$str,$content);
		return $content;
		
	}
//---------------------------------------------------------------------------------------

	function ticket_access($staff_id)
	{
		$staff=$this->prefix_table("staff");
		$tickets=$this->prefix_table("tickets");
		$sql="select * from $staff where staff_id='".$staff_id."' ";
		$a_staff=$this->get_a_line($sql);	
		
		$where_clause="";

		if(($a_staff['is_admin']!="1") and $a_staff['ticket_access']!="1")
			{
					$where_clause=" and $tickets.assigned_to = '".$staff_id."' ";	
			}

		return $where_clause;	

	}

//---------------------------------------------------------------------------------------------------

	function screen_customer_password($content)
	{
					$config=$this->prefix_table("configuration");
			$sql="select password_flag from $config ";
			$line=$this->get_a_line($sql);
			if($line['password_flag']=="1")
			{
				$content=preg_replace("/\<\{passwordflag_start\}\>(.*?)\<\{passwordflag_end\}\>/is","",$content);
			}
			else
			{
				$content=preg_replace("/<{passwordflag_(.*?)}>/is","",$content);
			}		

		return $content;	

	}

//---------------------------------------------------------------------------------------------------

	function screen_timespent($content,$dept_id)
	{

			$departments=$this->prefix_table("departments");
			$sql="select show_time_spent from $departments where dept_id='$dept_id'";
			$line=$this->get_a_line($sql);	
			$show_time_spent=$line['show_time_spent'];
			
			if($show_time_spent!="1")
			{
				$content=preg_replace("/\<\{showtimespent_start\}\>(.*?)\<\{showtimespent_end\}\>/is","",$content);
			}
			else
			{
				$content=preg_replace("/<{showtimespent_(.*?)}>/is","",$content);
			}		

		return $content;	

	}

//---------------------------------------------------------------------------------------------------

  function display_filter_text($generic_msg,$a_predefined,$filter)
  {


		$s_text=$filter['search_txt'];
		$o_text=$filter['ignored_txt'];
		
		if($_SESSION['searchtext']!="")
		{
			$searchtxt=$_SESSION['searchtext'];
			$searchtxt=stripslashes(preg_replace("/[\'\"]/is","",$searchtxt));

				if(preg_match("/^staff:/",$searchtxt)) {
					$staff=$this->prefix_table("staff");
					$tickets=$this->prefix_table("tickets");
					$sql="select is_admin, ticket_access,staff_id  from $staff where staff_id='".$_SESSION['staff_id']."'";
					$a_staff=$this->get_a_line($sql);
					list($ss,$username)=explode(":",$searchtxt);
					$username=trim($username);
						$sql="select staff_id from $staff where staff_username='$username'";
						$assigned=$this->get_a_line($sql);
					if($a_staff['is_admin']=="1" or $a_staff['ticket_access']=="1" or ($username=="all" or $_SESSION['staff_id']==$assigned['staff_id']) ) {
						if($assigned['staff_id']=="" and $username!="none" and $username!="all")
						{
							$return_status=$generic_msg['cNo_staff']. " <span class=searchedword>".$username."</span>";
							$_SESSION['searchtext']="";
							return $return_status;	
						}
						elseif($username=="none")
						{
							$return_status=$generic_msg['cUnassigned_tickets'];	
						}
						else
						{
							$return_status=$generic_msg['cShow_assigned']."<span class=searchedword>".$username."</span> ";	
						}		
					}
					else
					{
							$return_status=$generic_msg['cCannot_seeassigned'];
							$_SESSION['searchtext']="";
							return $return_status;	
					}
				}
	
			else
			{

			if($_SESSION['custom_field']!="")
			{
					$fields=$this->prefix_table("fields");
					$sql="select *  from $fields where field_id='".$_SESSION['custom_field']."'";
					$a_field=$this->get_a_line($sql);
					//print_R($a_field);	
					$return_status=$generic_msg['cShowing_tickets']." ".$generic_msg['cWhere']." ".$a_field['field_name'];
					if($a_field['field_type_id']=="1")
					{
						$return_status.=" ".$generic_msg['cIs'];
					}
					else
					{
						$return_status.=" ".$generic_msg['cContains'];

					}
					$return_status.="<span class=searchedword> '".$searchtxt."</span>'";
			}
			else
			{

			$return_status=$generic_msg['cSearch_results']."<span class=searchedword> '".$searchtxt."</span>'";
			if(trim($s_text)=="")	// Show all results if the user searches for common or 1 2 letter words and make it a point to tell the user also
			{
				$return_status=$generic_msg['cShowing_all_results'];
			}
			if($o_text!="")	// there are some ignored words	
			{
				if(substr_count($o_text," ")==0)
					{
						$return_status.="<span class=ignoredwordstxt>'$o_text'".$generic_msg['cOne_ignoredword']."</span>";						
					}
				else
					{
						$return_status.="<span class=ignoredwordstxt>".$generic_msg['cNotincluded'].": $o_text.</span>";
					}	

			}
			}


			}		
		}

		// Determine whether custom date range is to be used or stats date range is to be used.
		if($_SESSION['fstatus']=="custom")
		{
			if($_SESSION['adv_from_date']!="")
			{
				$from_date=$_SESSION['adv_from_date'];
				$to_date=$_SESSION['adv_to_date'];
			}
		}
		else
		{
			if($_SESSION['Ffrom_date']!="")
			{
				$from_date=$_SESSION['Ffrom_date'];
				$to_date=$_SESSION['Fto_date'];
			}
		}

		if($from_date!="")
		{
			if($return_status=="")
			{
				$return_status.=$generic_msg['cShowing_tickets']." ";
			}
			$zone=$_SESSION['zone'];
			list($from_date,$time1)=@preg_split("/[ ]/is",$from_date,-1,PREG_SPLIT_NO_EMPTY);
			list($to_date,$time2)=@preg_split("/[ ]/is",$to_date,-1,PREG_SPLIT_NO_EMPTY);
			list($y,$m,$d)=@explode("-",$from_date);
			list($h,$i,$s)=@explode(":",$time1);
			$time1=@gmmktime($h,$i,$s+($zone*60),$m,$d,$y);
			list($y,$m,$d)=@explode("-",$to_date);
			list($h,$i,$s)=@explode(":",$time2);
			$time2=@gmmktime($h,$i,$s+($zone*60),$m,$d,$y);	
			if($from_date==$to_date)
			{
					$return_status.=$generic_msg['cShowing']." ".$generic_msg['cFor']." ".@gmdate("d-M-y",$time1);
			}
			else
			{
				$return_status.=$generic_msg['cBetween']." ".@gmdate("d-M-y",$time1)." ".$generic_msg['cToc']." ".@gmdate("d-M-y",$time2)." ";
			}

		}



		if($_SESSION['priority_type']!="")
		{
			$ticket_priorities=$this->prefix_table("ticket_priorities");
			$sql="select priorityname from $ticket_priorities where priority_id='".$_SESSION['priority_type']."'";
			$a_ar=$this->get_a_line($sql);
			$return_status.=" ".$generic_msg['cOf']." ".$a_ar['priorityname']." ".$generic_msg['cPrioritymessage']." ";
		}
	
		if($searchtxt!="" or $_SESSION['Ffrom_date']!="" or $_SESSION['priority_type']!="" or $_SESSION['fstatus']=="custom")
		{
			$return_status.= ". <a href='tickets_view.php?enableall=yes' >".$generic_msg['cClear_search']."</a>";
		}

	return $return_status;	
	
  }

		
	//---------------------------------------------------------------------------------------------------


	function default_function($buffer) {
//	return $buffer;
    $buffer = htmlspecialchars($buffer);
    $buffer = str_replace("\011", ' &nbsp;&nbsp;&nbsp;',
        str_replace('  ', ' &nbsp;', $buffer));
    $buffer = preg_replace("@((\015\012)|(\015)|(\012))@", '', $buffer);

    return $buffer;
}

	
	//----------------------------------------------------------------------------------------------------------
	function is_plugin_active($pluginname)
	{
		
		$plugins=$this->prefix_table("plugins");
		$sql="select plugin_status from $plugins where plugin_name='$pluginname'";
		$row=$this->get_a_line($sql);
		if(isset($row['plugin_status']) && $row['plugin_status']=="1")
		{
			return true;
		}
		else
		{
			return false;
		}		
	}	

	//----------------------------------------------------------------------------------------------------------
	
	function screen_plugin_content($pluginname,$content)
	{

		
		if($this->is_plugin_active($pluginname))
		{
			if($pluginname=="knowledgebase" and $_SESSION['staff_id']!="")
			{
				$staff=$this->prefix_table("staff");
				$sql="select staff_kb,is_admin from $staff where staff_id='".$_SESSION['staff_id']."'";
				$row=$this->get_a_line($sql);
				if($row['is_admin']!="1" and $row['staff_kb']!="1")
				{
						$pattern="/<{".$pluginname."active_start}>(.*?)<{".$pluginname."active_end}>/is";	
						$content=@preg_replace($pattern,"",$content);	

				}
			}
			if($pluginname=="noticemanager")
			{	
				$prop=$this->prefix_table("nm_properties");
				$sql="select notice_message from $prop ";
				$a_sql=$this->get_a_line($sql);
				if(trim($a_sql['notice_message'])=="")
				{
						$pattern="/<{".$pluginname."active_start}>(.*?)<{".$pluginname."active_end}>/is";	
						$content=@preg_replace($pattern,"",$content);	
				}	
			}
			

			$pattern="/<{".$pluginname."active_(.*?)}>/is";	
			$content=@preg_replace($pattern,"",$content);	
		}
		else
		{
			$pattern="/<{".$pluginname."active_start}>(.*?)<{".$pluginname."active_end}>/is";	
			$content=@preg_replace($pattern,"",$content);	

		}
		
		return $content;	
	}

	//--------------------------------------------------------------------------------------------------------------------------------------------
		function is_in_array($str, $array) { 
  return preg_grep('/^' . preg_quote($str, '/') . '$/i', $array); 
}


	//-------------------------------------------------------------------------------------------------------------------------------------------

	function time_clause()
	{

		$zone=$_SESSION['zone'];
		
		$where_clause="";

		if($_SESSION['fstatus']=="custom")			// Custom date range is used
		{
			$from_date=$_SESSION['adv_from_date'];
			$to_date=$_SESSION['adv_to_date'];	
			$preset=$_SESSION['adv_preset'];
			$filter=$_SESSION['adv_filter'];		
		}
		elseif($_SESSION['Ffrom_date']!="") 	// Date range is passed from the stats module
		{
			$from_date=$_SESSION['Ffrom_date'];
			$to_date=$_SESSION['Fto_date'];
			$preset=$_SESSION['stats_preset'];
			$filter=$_SESSION['stats_filter'];

		}
		
		if($from_date!="")				// build the time clause. Column names used are staff_last_activity and client_last_activity 
		{
			if($_SESSION['filter_column']=="")
			{
			
			$where_clause=" and ( (".$this->date_add_sql('staff_last_activity',$zone,'minute')." between '$from_date' and '$to_date') or (".$this->date_add_sql('client_last_activity',$zone,'minute')." between '$from_date' and '$to_date') ) ";
		
			}
			elseif($_SESSION['filter_column']=="ticket_created")
			{
					$where_clause=" and ( (".$this->date_add_sql('ticket_created',$zone,'minute')." between '$from_date' and '$to_date') ) ";
					$where_clause.=" and status not in ('S','C') ";

			}

		}
				

		return $where_clause;
		
	}	

	//--------------------------------------------------------------------------------------------------------------------------------------------
	function priority_clause($a_predefined)
	{

		$search_clause="";
		$get_vars=$a_predefined['get'];
		$tickets=$this->prefix_table("tickets");
		if(isset($get_vars['priority_type']))
			{
				$_SESSION['priority_type']=$get_vars['priority_type'];
			}

			
			if($_SESSION['adv_priorityfilter']!="" and $_SESSION['fstatus']=="custom")
			{
				$priority_array=$_SESSION['adv_priorityfilter'];
				if(is_array($priority_array) and count($priority_array) >= 1)
				{
					$priority_string=implode("','",$priority_array);
					$search_clause.=" and $tickets.priority_id in ('".$priority_string."')";

				}
				
			}
			elseif($_SESSION['priority_type']!="")
				{
					$search_clause.=" and $tickets.priority_id='".$_SESSION['priority_type']."'";
				}
			

			//print_r($_SESSION);
		return $search_clause;
	}


	function get_readonly_dept()
	{
		$staff_departments=$this->prefix_table("staff_departments");
		$staff_id=$_SESSION['staff_id'];
		$sql="select dept_id from $staff_departments where staff_id='$staff_id' and readonlyaccess='1' ";
		$a_dept=$this->get_single_column($sql);	
		return $a_dept;	

	}

	function filter_read_only_dept($dept_list,$dept_id,$content,$removeaccess=0)
	{

	
		if(@in_array($dept_id,$dept_list) or $removeaccess==1)
		{
			$content=@preg_replace("/<{readonlyaccess_start}>(.*?)<{readonlyaccess_end}>/is","",$content);
			$content=@preg_replace("/<{readshow_(.*?)}>/is","",$content);	
		}
		else
		{
			$content=@preg_replace("/<{readonlyaccess_(.*?)}>/is","",$content);	
			$content=@preg_replace("/<{readshow_start}>(.*?)<{readshow_end}>/is","",$content);
	
		}

		return $content;
	}

	//-----------------------------------------------------------------------------------------------------------------------------------

	function prefix_keys($array,$pr)
	{
		$array1=array();	
		while(list($key,$value)=@each($array))
		{
			$array1[$pr.$key]=$value;
		}
		return $array1;
	}


	function get_mail_tags($ticket_id)
	{

		$tag_array=array();
		$tickets=$this->prefix_table("tickets");
		$clients=$this->prefix_table("clients");
		$departments=$this->prefix_table("departments");
		$config=$this->prefix_table("configuration");
		$mail_servers=$this->prefix_table("mail_servers");
		$dept_servers=$this->prefix_table("dept_servers");
		$ticket_status=$this->prefix_table("ticket_status");
		$sql="select http_url from $config ";
		$a_config=$this->get_a_line($sql);
		$ticket_priorities=$this->prefix_table("ticket_priorities");
		$sql="select * from $tickets where ticket_id='$ticket_id'";
		$a_ticket=$this->get_a_line($sql);
		$sql="select statusname from $ticket_status where status_key='".$a_ticket['status']."'";
		$a_status=$this->get_a_line($sql);
		$sql="select * from $clients where client_id='".$a_ticket['client_id']."'";
		$a_client=$this->get_a_line($sql);
		$sql="select priorityname from $ticket_priorities where priority_id='".$a_ticket['priority_id']."'";
		$a_prior=$this->get_a_line($sql);
		$sql="select dept_name, signature from $departments,$mail_servers,$dept_servers where $departments.dept_id=$dept_servers.dept_id
		and $dept_servers.server_id=$mail_servers.server_id and 

		 $departments.dept_id='".$a_ticket['dept_id']."'";
		$a_dept=$this->get_a_line($sql);
		$tag_array['subject']=$a_ticket['subject'];
		$tag_array['message']=$a_ticket['message'];
		$tag_array['client_name']=$a_client['client_name'];
		$tag_array['client_email']=$a_client['email'];
		$tag_array['phone']=$a_client['phone'];
		$tag_array['priority']=$a_prior['priorityname'];
		$tag_array['http_url']=$a_config['http_url'];	
		$tag_array['dept_name']=$a_dept['dept_name'];
		$tag_array['dept_signature']=$a_dept['signature'];
		$tag_array['status']=$a_status['statusname'];
	
		
		return $tag_array;
	}

	//--------------------------------------------------------------------------------------------------------------------
	
	function get_reply_attachments($supp_obj,$get_vars,$content)
	{
		if($get_vars['reply_id']!="")
		{
			$ticket_attachments=$supp_obj->prefix_table("ticket_attachments");
			$content=@preg_replace("/<{replyattachments_(.*?)}>/is","",$content);
			$sql="select * from $ticket_attachments where reply_id='".$get_vars['reply_id']."' and ticket_id='".$get_vars['parent']."'";
			$a_attach=$supp_obj->get_rsltset($sql);
			preg_match("/<{currentattachments_loopstart}>(.*?)<{currentattachments_loopend}>/is",$content,$out);
			$match=$out[1];$str="";
			$ticket_id=$get_vars['parent'];
			$reply_id=$get_vars['reply_id'];	
			for($i=0;$i<count($a_attach);$i++)
			{
				$att_id=$a_attach[$i]['att_id'];
				$file_name=$a_attach[$i]['file_name'];
                
				//$str.=preg_replace("/<{(.*?)}>/e","$$1",$match);
                preg_match_all("/<{(.*?)}>/", $match, $matches);
                $tmp_array = array();
                foreach ($matches[0] as $index => $var_name) {
                    $tmp_var_name = $matches[1][$index];
                    if (isset($$tmp_var_name)) {
                        $tmp_array[$tmp_var_name] = $$tmp_var_name;
                    } else {
                        $tmp_array[$tmp_var_name] = '';
                    }
                }
                
                $str .= preg_replace_callback("/<{(.*?)}>/",
                                     function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
                                     $match);		
			}
			$content=@preg_replace("/<{currentattachments_loopstart}>(.*?)<{currentattachments_loopend}>/is",$str,$content);

		}
		else
		{
		
			$content=@preg_replace("/<{replyattachments_start}>(.*?)<{replyattachments_end}>/is","",$content);
		
		}

		return $content;
	}	
	
	//--------------------------------------------------------------------------------------------------------------------

	function get_status_clause($a_predefined)
	{
		$post_vars=$a_predefined['post'];
		$tickets=$this->prefix_table("tickets");
		$where_clause="";
		if($_SESSION['adv_statusfilter']!="" and is_array($_SESSION['adv_statusfilter']) and count($_SESSION['adv_statusfilter']) >=1)
		{
			$status_array=$_SESSION['adv_statusfilter'];
			$status_string=implode("','",$status_array);
			$where_clause.=" and $tickets.status in ('".$status_string."') ";

		}

		
		if($_SESSION['fstatus']=="custom")
		{		
			if($_SESSION['adv_assigned']!="" and $_SESSION['adv_unassigned']=="")
			{
				$where_clause.=" and $tickets.assigned_to <> '0' ";
			}		
			if($_SESSION['adv_assigned']=="" and $_SESSION['adv_unassigned']!="")
			{
				$where_clause.=" and $tickets.assigned_to = '0' ";

			}
	}
			
		return $where_clause;	

	}

	//-------------------------------------------------------------------------------------------------------------------------
	function is_attachment_size_valid($file_vars)
	{
		$config=$this->prefix_table("configuration");
		$sql="select attachment_size from $config ";
		$a_config=$this->get_a_line($sql);
		$max_size=$a_config['attachment_size']*1024;

		$size=0;
		//print_r($file_vars);
		for($i=0;$i<count($file_vars);$i++)
		{
			$file_name='file_'.$i;
			$size+=$file_vars[$file_name]['size'];
			
		}
		if($size > $max_size )
		{
			return false;
		}
		else
		{
			return true;
		}	
		

	}
	
	//---------------------------------------------------------------------------------------------------------------------------

	function upload_attachments($ticket_id,$file_vars,$session_vars,$folder)
	{
		$ticket_attachments=$this->prefix_table('ticket_attachments');	
		for($i=0;$i<count($file_vars);$i++)
		{
			$file_name='file_'.$i;
			$file_display_name=$file_vars[$file_name]['name'];
			$new_name=$ticket_id."_".($i+1);
			$tmp_name=$file_vars[$file_name]['tmp_name'];
			if($tmp_name!="none" and $tmp_name!="")		// if the user has uploaded an attachment
			{
	
			$attachment_name=$this->upload_file($file_name,$file_vars,$new_name,'',$folder);

			$sql=" insert into $ticket_attachments (ticket_id, attachment_name, file_name, reply_id )
			values ('$ticket_id','$attachment_name','$file_display_name',0) ";
			$this->execute_query($sql); 
			}
	
		}


	}

	//---------------------------------------------------------------------------------------------------------------------------
	
	function get_dept_list_query($a_predefined,$whereclause='',$listview='notall')
	{
	
		$departments=$this->prefix_table("departments");
		$staff_departments=$this->prefix_table("staff_departments");

		if($_SESSION['staff_id']!="" and $listview=="notall")
		{
	
		$sql="select * from $departments , $staff_departments where $departments.dept_id=$staff_departments.dept_id
		and $staff_departments.staff_id = '".$_SESSION['staff_id']."'

		$whereclause  order by $departments.dept_name asc ";
		}
		elseif($_SESSION['staff_id']!="" and $listview=="all")
		{
		
			$sql="select * from $departments order by dept_name asc ";
	
		}
		else
		{
			$sql="select * from $departments order by dept_name asc ";
		}
			
		return $sql;
		

	}

	//---------------------------------------------------------------------------------------------------------------------------------
	function get_other_recipients($mail_box, $message_id,$header,$department_email)
	{
		$other_recipients="";
		$to=$header->to;
		for($i=0;$i<count($to);$i++)
		{
			$object=$to[$i];
			$fromaddress = $object->mailbox . "@" . $object->host;
			if($fromaddress!=$department_email)
			{
				$other_recipients.=$fromaddress.", ";
			}
		}	
		$to=$header->cc;
		for($i=0;$i<count($to);$i++)
		{
			$object=$to[$i];
			$fromaddress = $object->mailbox . "@" . $object->host;
			if($fromaddress!=$department_email)
			{
				$other_recipients.=$fromaddress.", ";
			}
		}
		$other_recipients=@substr($other_recipients,0,-2);	

		return $other_recipients;	
	}

	//------------------------------------------------------------------------------------------------------------------------------------

function makeClickableLinks($text)
    {

	    $text = preg_replace('#(script|about|applet|activex|chrome):#is', "\\1:", $text);

	    // pad it with a space so we can match things at the start of the 1st line.
	    $ret = ' ' . $text;

	    // matches an "xxxx://yyyy" URL at the start of a line, or after a space.
	    // xxxx can only be alpha characters.
	    // yyyy is anything up to the first space, newline, comma, double quote or <
	    $ret = preg_replace("#(^|[\n ])([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "\\1<a href=\"\\2\" target=\"_blank\">\\2</a>", $ret);

	    // matches a "www|ftp.xxxx.yyyy[/zzzz]" kinda lazy URL thing
	    // Must contain at least 2 dots. xxxx contains either alphanum, or "-"
	    // zzzz is optional.. will contain everything up to the first space, newline,
	    // comma, double quote or <.
	    $ret = preg_replace("#(^|[\n ])((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "\\1<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $ret);

	    // matches an email@domain type address at the start of a line, or after a space.
	    // Note: Only the followed chars are valid; alphanums, "-", "_" and or ".".
	    $ret = preg_replace("#(^|[\n ])([a-z0-9&\-_.]+?)@([\w\-]+\.([\w\-\.]+\.)*[\w]+)#i", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>", $ret);

	    // Remove our padding..
	    $ret = substr($ret, 1);
	    return $ret;
    }

	
	
//}
// End of Generic class


	function addCustomFields ($supp_obj, $id, $custom_fields_name, 
		$custom_fields_value, $custom_field_id, $custom_field_type)
	{
		if ($custom_field_type == "1")
		{
			$custom_values = $supp_obj -> prefix_table ("client_custom_values");
			$custom_ids = $supp_obj -> prefix_table ("client_custom_ids");
		}
		else
		{
			$custom_values = $supp_obj -> prefix_table ("ticket_custom_values");
			$custom_ids = $supp_obj -> prefix_table ("ticket_custom_ids");
		}

		if ($custom_field_type == "1")
		{
			$sql = "delete from $custom_values where client_id = \"" . $id . "\"";
			$supp_obj -> execute_query ($sql);

			$sql = "delete from $custom_ids where client_id = \"" . $id . "\"";
			$supp_obj -> execute_query ($sql);
	
			$sql_custom_fields  = "insert into $custom_values (client_id";
			$sql_custom_fields1 = "insert into $custom_ids    (client_id";
		}
		else
		{
			$sql = "delete from $custom_values where ticket_id = \"" . $id . "\"";
			$supp_obj -> execute_query ($sql);

			$sql = "delete from $custom_ids where ticket_id = \"" . $id . "\"";
			$supp_obj -> execute_query ($sql);			
		
			$sql_custom_fields  = "insert into $custom_values (ticket_id";
			$sql_custom_fields1 = "insert into $custom_ids    (ticket_id";		
		}

		for ($m = 0; $m < count ($custom_fields_name); $m ++)
		{
			$sql_custom_fields .= ", " . $custom_fields_name [$m];
			$sql_custom_fields1 .= ", " . $custom_fields_name [$m];
		}
		
		$sql_custom_fields .= ") values (\"" . $id . "\"";
		$sql_custom_fields1 .= ") values (\"" . $id . "\"";

		for ($m = 0; $m < count ($custom_fields_value); $m ++)
		{
			$temp_value = $custom_fields_value [$m];
			$sql_custom_fields .= ", '" . ($temp_value) . "'";
			
			$temp_value = $custom_field_id [$m];
			$sql_custom_fields1 .= "," . "'" . ($temp_value) . "'";
		}

		$sql_custom_fields .= ")";
		$sql_custom_fields1 .= ")";

		$supp_obj -> execute_query ($sql_custom_fields);
		$supp_obj -> execute_query ($sql_custom_fields1);


	}




// -------------------------------------------------------------------------------------------
	function stripLargeTags($html)
	{
	    $search = array (
        	'@<script[^>]*?>.*?</script>@si', // Strip out javascript
	        '@<style[^>]*?>.*?</style>@si', // Strip out styles
        	'@<script[^>]@si', // Strip out javascript
	        '@<![\s\S]*?--[ \t\n\r]*>@', // Strip comments including CDATA
	    );
	    $replace = array ('', '', '');
	    $text = preg_replace($search, $replace, $html);
	    return $text;
	}
// -------------------------------------------------------------------------------------------







}

	function beginsWith( $str, $sub ) {
   		return ( substr( $str, 0, strlen( $sub ) ) == $sub );
	}	

?>
