<?php
include_once("../includes/configure.php");
include("../lang/en/admin_generic.php");	
include_once("../includes/class.phpmailer.php");	
include_once("../includes/class.smtp.php");

class fixedTemplate {
	public function get_tickets($supp_obj, $session_vars, $generic_msg) {
		$weekly_tickets = $supp_obj->prefix_table("weekly_tickets");
		$clients = $supp_obj->prefix_table("clients");
		$tickets = $supp_obj->prefix_table("tickets");
		
		$sql = "SELECT * FROM $weekly_tickets WHERE STR_TO_DATE(start_date,'%m-%d-%Y') <= '".date('Y-m-d')."'";
		$result = $supp_obj->return_db_handle($sql);
		$post_vars['updater'] = "STAFF";
		$post_vars['multiple_submit'] = 1;
		while($row = $supp_obj->return_next_row($result)) {
			$sql = "SELECT * FROM $clients WHERE client_id = '".$row['client_id']."'";
			$clsch = $supp_obj->get_a_line($sql);
			$post_vars['updater_id'] = $row['assign_to'];
			$post_vars['assigned_to'] = $row['assign_to'];
			$post_vars['message'] = addslashes($row['message']);
			$post_vars['subject'] = addslashes($row['subject']);
			$post_vars['server_id'] = $row['servicetype'];
			$post_vars['dept_id'] = $row['servicetype'];
			$post_vars['status'] = $row['status'];
			$post_vars['priority'] = $row['priority_id'];
			$post_vars['priority_id'] = $row['priority_id'];
			$post_vars['staff_assignto'] = $row['assign_to'];
			$post_vars['email'] = $clsch['email'];
			$post_vars['client_name'] = $clsch['client_name'];
			$post_vars['registered_on'] = $clsch['registered_on'];
			$post_vars['preferred_zone'] = $clsch['preferred_zone'];
			$post_vars['client_status'] = $clsch['client_status'];
			$post_vars['client_id'] = $row['client_id'];
			$post_vars['id'] = $row['id'];
			
			if($row['monday'] == 1) {
				$days[] = 'monday';
			}
			if($row['tuesday'] == 1) {
				$days[] = 'tuesday';
			}
			if($row['wednesday'] == 1) {
				$days[] = 'wednesday';
			}
			if($row['thursday'] == 1) {
				$days[] = 'thursday';
			}
			if($row['friday'] == 1) {
				$days[] = 'friday';
			}
			if($row['saturday'] == 1) {
				$days[] = 'saturday';
			}
			if($row['sunday'] == 1) {
				$days[] = 'sunday';
			}
			$start_date = $this->formatdate($row['start_date'], 'm-d-Y', 'Y-m-d');
			
			foreach($days as $dow) {
				$tmp = $this->calRecurrence($dow, $row['week_interval'], 'W', $start_date);
				if($tmp) {
					$this->submit_new_ticket($supp_obj, $post_vars, $session_vars, $generic_msg);
				}
			}
		}
	}
	function formatdate($dateString, $format, $return_format) {
		$date = DateTime::createFromFormat($format, $dateString);
		$newDateString = $date->format($return_format);
		
		return $newDateString;
	}
	function calRecurrence($dow, $step, $unit, $start_date) {
		//echo $dow.' = '.$step.' = '.$unit.' = '.$start_date.'<br>';
		$date_array = array();
		$start = new DateTime($start_date);
		$end   = new DateTime();
		$today = date('Y-m-d');
		
		$start->modify($dow);
		$interval = new DateInterval("P{$step}{$unit}");
		$period   = new DatePeriod($start, $interval, $end);
		
		foreach ($period as $date) {
		   $date_array[] = $date->format('Y-m-d');
		}
		//echo $dow;echo '<pre>';print_r( $date_array);echo '</pre>';
		if(in_array($today, $date_array))  {
			return true;
		} else {
			return false;
		}
	}
	public function update_checked($supp_obj, $id) {
		$tickets = $supp_obj->prefix_table("tickets");
		$weekly_tickets = $supp_obj->prefix_table("weekly_tickets");
		$sql = "UPDATE $weekly_tickets SET lastchecked = '".date("Y-m-d H:i:s")."' WHERE id = '".$id."'";
		$supp_obj->execute_query($sql);
	}
	public function submit_new_ticket($supp_obj, $post_vars = array(), $session_vars, $generic_msg) {
		$tickets = $supp_obj->prefix_table("tickets");
		$supp_obj->submit_ticket($supp_obj, $session_vars, $post_vars, $generic_msg, array());
		$this->update_checked($supp_obj, $post_vars['id']);
	}
	public function srttodate($day = array(), $interval, $lastchecked = '') {
		$interval--;
		if($lastchecked != '') {
			for($i = 0; $i < count($day); $i++) {
				$new_timestamp[$i] = date("m-d-Y", strtotime($day[$i].', +'.$interval.' week', strtotime($lastchecked)));
			}
		} else {
			for($i = 0; $i < count($day); $i++) {
				$new_timestamp[$i] = date("m-d-Y", strtotime($day[$i].', +'.$interval.' week', time()));
			}
		}
		
		return $new_timestamp;
	}
}

class monthlytemplate {
	public function convert_into_date($month, $year, $last_string, $interval = '1', $day = 1) {
		if(!checkdate($month, $day, $year)) {
			return false;
		}
		$fun_date = $year.'-'.$month.'-'.$day;
		if($interval == 1)
			return date('Y-m-d', strtotime($last_string, strtotime($fun_date))); 
		else
			return date('Y-m-d', strtotime($last_string, strtotime('+'.$interval.' Month', strtotime($fun_date)))); 
	}
	public function get_tickets($supp_obj, $session_vars, $generic_msg) {
		$monthly_tickets = $supp_obj->prefix_table("monthly_tickets");
		$clients = $supp_obj->prefix_table("clients");
		$tickets = $supp_obj->prefix_table("tickets");
		
		$sql = "SELECT * FROM $monthly_tickets WHERE STR_TO_DATE(start_date,'%m-%d-%Y') <= '".date('Y-m-d')."'";
		$result = $supp_obj->return_db_handle($sql);
		$post_vars['updater'] = "STAFF";
		$post_vars['multiple_submit'] = 1;
		while($row = $supp_obj->return_next_row($result)) {
			$sql = "SELECT * FROM $clients WHERE client_id = '".$row['client_id']."'";
			$clsch = $supp_obj->get_a_line($sql);
			$post_vars['updater_id'] = $row['assign_to'];
			$post_vars['assigned_to'] = $row['assign_to'];
			$post_vars['message'] = addslashes($row['message']);
			$post_vars['subject'] = addslashes($row['subject']);
			$post_vars['server_id'] = $row['servicetype'];
			$post_vars['dept_id'] = $row['servicetype'];
			$post_vars['status'] = $row['status'];
			$post_vars['priority'] = $row['priority_id'];
			$post_vars['priority_id'] = $row['priority_id'];
			$post_vars['staff_assignto'] = $row['assign_to'];
			$post_vars['email'] = $clsch['email'];
			$post_vars['client_name'] = $clsch['client_name'];
			$post_vars['registered_on'] = $clsch['registered_on'];
			$post_vars['preferred_zone'] = $clsch['preferred_zone'];
			$post_vars['client_status'] = $clsch['client_status'];
			$post_vars['client_id'] = $row['client_id'];
			$post_vars['id'] = $row['id'];

			if($row['sch_type'] == 2) {
				$last_string = $row['month_week']." ".$row['month_weekday'];
				$fun_date = $this->convert_into_date(date("m"), date('Y'), $last_string, $row['month_interval']);
				
				if($fun_date == date("Y-m-d") && date("Y-m-d", strtotime($row['lastchecked'])) != $fun_date) {
					$this->submit_new_ticket($supp_obj, $post_vars, $session_vars, $generic_msg);
				}
			} else if($row['sch_type'] == 1) {
				$date_call = date('Y')."-".date('m')."-".$row['month_day'];
				if($row['lastchecked'] == "0000-00-00 00:00:00") {
					if($date_call == date("Y-m-d")) {
						$this->submit_new_ticket($supp_obj, $post_vars);
					}
				} else {
					$date_call = date('Y-m-'.$row['month_day'], strtotime('+'.$row['month_interval'].' Month', strtotime(str_replace('-', '/', $row['lastchecked'])))); 
					if($date_call == date("Y-m-d")) {
						$this->submit_new_ticket($supp_obj, $post_vars);
					}
				}
			}
		}
	}
	public function update_checked($supp_obj, $id) {
		$tickets = $supp_obj->prefix_table("tickets");
		$monthly_tickets = $supp_obj->prefix_table("monthly_tickets");
		$sql = "UPDATE $monthly_tickets SET lastchecked = '".date("Y-m-d H:i:s")."' WHERE id = '".$id."'";
		$supp_obj->execute_query($sql);
	}
	public function submit_new_ticket($supp_obj, $post_vars = array(), $session_vars, $generic_msg) {
		$tickets = $supp_obj->prefix_table("tickets");
		$supp_obj->submit_ticket($supp_obj, $session_vars, $post_vars, $generic_msg, array());
		$this->update_checked($supp_obj, $post_vars['id']);
	}
}

class one_tickets {
	public function get_tickets($supp_obj, $session_vars, $generic_msg) {
		$one_tickets = $supp_obj->prefix_table("one_tickets");
		$clients = $supp_obj->prefix_table("clients");
		$tickets = $supp_obj->prefix_table("tickets");
		
		$sql = "SELECT * FROM $one_tickets WHERE STR_TO_DATE(start_date,'%m-%d-%Y') = '".date('Y-m-d')."'";
		$result = $supp_obj->return_db_handle($sql);
		$post_vars['updater'] = "STAFF";
		$post_vars['multiple_submit'] = 1;
		while($row = $supp_obj->return_next_row($result)) {
			$sql = "SELECT * FROM $clients WHERE client_id = '".$row['client_id']."'";
			$clsch = $supp_obj->get_a_line($sql);
			$post_vars['updater_id'] = $row['assign_to'];
			$post_vars['assigned_to'] = $row['assign_to'];
			$post_vars['message'] = addslashes($row['message']);
			$post_vars['subject'] = addslashes($row['subject']);
			$post_vars['server_id'] = $row['servicetype'];
			$post_vars['dept_id'] = $row['servicetype'];
			$post_vars['status'] = $row['status'];
			$post_vars['priority'] = $row['priority_id'];
			$post_vars['priority_id'] = $row['priority_id'];
			$post_vars['staff_assignto'] = $row['assign_to'];
			$post_vars['email'] = $clsch['email'];
			$post_vars['client_name'] = $clsch['client_name'];
			$post_vars['registered_on'] = $clsch['registered_on'];
			$post_vars['preferred_zone'] = $clsch['preferred_zone'];
			$post_vars['client_status'] = $clsch['client_status'];
			$post_vars['client_id'] = $row['client_id'];
			$post_vars['id'] = $row['id'];
			
			if($row['lastchecked'] == '0000-00-00 00:00:00') {
				$this->submit_new_ticket($supp_obj, $post_vars, $session_vars, $generic_msg);
			}
		}
	}
	public function update_checked($supp_obj, $id) {
		$tickets = $supp_obj->prefix_table("tickets");
		$one_tickets = $supp_obj->prefix_table("one_tickets");
		$sql = "UPDATE $one_tickets SET lastchecked = '".date("Y-m-d H:i:s")."' WHERE id = '".$id."'";
		$supp_obj->execute_query($sql);
	}
	public function submit_new_ticket($supp_obj, $post_vars = array(), $session_vars, $generic_msg) {
		$tickets = $supp_obj->prefix_table("tickets");
		$supp_obj->submit_ticket($supp_obj, $session_vars, $post_vars, $generic_msg, array());
		$this->update_checked($supp_obj, $post_vars['id']);
	}
}

set_time_limit(0);

$cron_log = $supp_obj->prefix_table('cron_log');
$sql = "SELECT * FROM $cron_log";
$row = $supp_obj->get_a_line($sql);

if($row['weekly_tickets'] != date('Y-m-d')) {
	$sql = "UPDATE $cron_log SET weekly_tickets = '".date('Y-m-d')."'";
	$supp_obj->execute_query($sql);
	$obj = new fixedTemplate;
	$obj->get_tickets($supp_obj, $session_vars, $generic_msg);
}

if($row['monthly_tickets'] != date('Y-m-d')) {
	$sql = "UPDATE $cron_log SET monthly_tickets = '".date('Y-m-d')."'";
	$supp_obj->execute_query($sql);
	$obj1 = new monthlytemplate;
	$obj1->get_tickets($supp_obj, $session_vars, $generic_msg);
}

if($row['one_tickets'] != date('Y-m-d')) {
	$sql = "UPDATE $cron_log SET one_tickets = '".date('Y-m-d')."'";
	$supp_obj->execute_query($sql);
	$obj2 = new one_tickets;
	$obj2->get_tickets($supp_obj, $session_vars, $generic_msg);
}
?>