<?php
include_once("session.php");
include_once("header.php");
include_once("nav.php");

class ticketTemplate {
	function viewform($supp_obj, $a_predefined, $generic_msg, $status_msg) {
		$departments = $supp_obj->prefix_table("departments");
		$staff = $supp_obj->prefix_table("staff");
		$fields = $supp_obj->prefix_table("fields");
		$staff_departments = $supp_obj->prefix_table("staff_departments");
		$ticket_subject = $supp_obj->prefix_table("ticket_subject");
		$priorities = $supp_obj->prefix_table("ticket_priorities");
		$schedule_tickets = $supp_obj->prefix_table("schedule_tickets");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		
		$template = "../templates/admin/manage_weekly_ticket_template.tpl";
		$content = $supp_obj->return_file_content($template);
		
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		$sql = "SELECT * FROM $schedule_tickets WHERE type = '2' LIMIT 0, 1";
		$row = $supp_obj->get_a_line($sql);
		
		//department line
		$sql = "SELECT * FROM $staff order by staff_id";
		$loop_sql['staff_'] = $sql;
		$supp_obj->return_table_desc($fields);
		if($staffloggedin == "yes") {
			$readonlyaccess = " AND readonlyaccess <> '1' ";
			$mysql = $supp_obj->get_dept_list_query($a_predefined, $readonlyaccess);				
			$loop_sql['dept_'] = $mysql; //prepare sql for selecting departments 
		} else {
			$mysql = "SELECT * FROM $departments WHERE private_dept <> '1'  OR private_dept IS NULL ORDER BY dept_name ASC";
			$loop_sql['dept_'] = $mysql;
		}
			
		$sel_arr['dept_']['dept_id'] = array($row['department']);
		
		$a_content = $supp_obj->replace_loop($loop_sql, $content, '', $sel_arr); // populate tpl file
		$content = $a_content[0];
		
		//priority line
		$mysql = "SELECT *, priorityname AS priority_name FROM $priorities ";
		$loop_sql['priority_'] = $mysql; //  prepare sql for selecting ticket priorities
		$sel_arr['priority_']['priority_id'] = array($row['priority']);
		$a_content = $supp_obj->replace_loop($loop_sql, $content, '', $sel_arr); // populate tpl file
		$content = $a_content[0];
		
		//subject line
		$mysql = "SELECT * FROM $ticket_subject ORDER BY subject";
		$loop_sql['subject_'] = $mysql; //  prepare sql for selecting ticket priorities
		$sel_arr['priority_']['subject'] = array($row['subject']);
		$a_content = $supp_obj->replace_loop($loop_sql, $content, '', $sel_arr); // populate tpl file
		$content = $a_content[0];
		
		$replace_array['weekly_id'] = $row['id'];
		$replace_array['message'] = $row['message'];
		$replace_array['defaulttime'] = $row['defaulttime'];
		$replace_array['status_msg'] = $a_predefined['status_msg'];
		
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		
		echo $content;
	}
	
	function updatetemplate($supp_obj, $a_predefined, $generic_msg) {
		$schedule_tickets = $supp_obj->prefix_table("schedule_tickets");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		
		$sql = "UPDATE $schedule_tickets SET department = '".$department."', priority = '".$priority."', subject = '".$subject."', message = '".$message."', defaulttime = '".$defaulttime."' WHERE id = '".$id."'";
		$supp_obj->execute_query($sql);
		return $generic_msg['cTicketTemplateMsg'];	
	}
}

$cr = new ticketTemplate;
$act = $post_vars['act'];
switch($act) {
	case NULL:
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
	case 'updatetemplate':
		$a_predefined['status_msg'] = $cr->updatetemplate($supp_obj, $a_predefined, $generic_msg);
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
}

include_once("footer.php");
?>