<?php
include_once("session.php");
class CannedReplies {
    function show_all_canned_replies($supp_obj, $a_predefined, $generic_msg) {
        
        $session_vars = $a_predefined['session'];
        $post_vars    = $a_predefined['post'];
        $get_vars     = $a_predefined['get'];
        $staff_id     = $session_vars['staff_id'];
        
        
        $template = "../templates/admin/manage_replies.tpl";
        $content  = $supp_obj->return_file_content($template);
        
        
        // Check if any canned reply exist
        $cannedreplies  = $supp_obj->prefix_table("cannedreplies");
        $canneddept     = $supp_obj->prefix_table("canneddept");
        $departments    = $supp_obj->prefix_table("departments");
        $tickets        = $supp_obj->prefix_table("tickets");
        $ticket_replies = $supp_obj->prefix_table("ticket_replies");
        
        $staff = $supp_obj->prefix_table("staff");
        
        $sql      = "select all_dept from $staff where staff_id='$staff_id' ";
        $row      = $supp_obj->get_a_line($sql);
        $all_dept = $row[0];
        
        $staff_departments = $supp_obj->prefix_table("staff_departments");
        $sql               = "select dept_id from $staff_departments where staff_id='$staff_id' ";
        $dept_ids          = $supp_obj->get_single_column($sql);
        
        if ($get_vars['ticket_id'] != "") {
            $sql = "select dept_id from $tickets where ticket_id='" . $get_vars['ticket_id'] . "'";
            $row = $supp_obj->get_a_line($sql);
            if (@in_array($row['dept_id'], $dept_ids)) {
                $sql                      = "select reply from $ticket_replies where reply_id='" . $get_vars['reply_id'] . "'";
                $row                      = $supp_obj->get_a_line($sql);
                $replace_content['reply'] = $row['reply'];
            }
        }
        
        $sql         = "select * from $cannedreplies  where staff_id='$staff_id' or canned_type='Public' ORDER BY canned_subject";
        $canned_data = $supp_obj->get_rsltset($sql);
        $cnt         = count($canned_data);

        if ($cnt <= 0) {
            $content = preg_replace("/<{cannedreplies_start}>(.*?)<{cannedreplies_end}>/is", "", $content);
        } else {
            $content = preg_replace("/<{cannedreplies_(.*?)}>/is", "", $content);
            $pattern = "/<{reply_loopstart}>(.*?)<{reply_loopend}>/is";
            preg_match($pattern, $content, $out);
            $match = $out[1];
            $str   = "";
            $class = "";
            for ($i = 0; $i < count($canned_data); $i++) {
                $no = $i + 1;
                
                $canned_subject = $canned_data[$i]['canned_subject'];
                $canned_id      = $canned_data[$i]['canned_id'];
                $depttype       = $canned_data[$i]['depttype'];
                
                if ($depttype == "specific" and $all_dept != "1" and $_SESSION['staff_id'] != $canned_data[$i]['staff_id']) {
                    $sql     = "select dept_id from $canneddept where canned_id='$canned_id' ";
                    $columns = $supp_obj->get_single_column($sql);
                    $valid   = 0;
                    for ($j = 0; $j < count($dept_ids); $j++) {
                        $dept_id = $dept_ids[$j];
                        if (in_array($dept_id, $columns)) {
                            $valid = 1;
                            break;
                        }
                    }
                    if ($valid == 0) {
                        continue;
                    }
                    $valid = 0;
                }
                //$str.=preg_replace("/<{(.*?)}>/e","$$1",$match);
                preg_match_all("/<{(.*?)}>/", $match, $matches);
                $tmp_array = array();
                foreach ($matches[0] as $index => $var_name) {
                    $tmp_var_name = $matches[1][$index];
                    if (isset($$tmp_var_name)) {
                        $tmp_array[$tmp_var_name] = $$tmp_var_name;
                    } else {
                        $tmp_array[$tmp_var_name] = '';
                    }
                }
                
                $str .= preg_replace_callback("/<{(.*?)}>/", function($m) use ($tmp_array) {
                    return $tmp_array[$m[1]];
                }, $match);
            }
            $content = preg_replace($pattern, $str, $content);
        }
        //print_R($session_vars);
        $staff_id = $session_vars['staff_id'];
        $sql      = $supp_obj->get_dept_list_query($a_predefined);
        $depts    = $supp_obj->get_rsltset($sql);
        //print_r($depts);
        
        $pattern = "/<{dept_loopstart}>(.*?)<{dept_loopend}>/is";
        preg_match($pattern, $content, $out);
        $match = $out[1];
        $str   = "";
        if (count($post_vars['fdept']) <= 0 or @in_array("0", $post_vars['fdept'])) {
            
            $replace_content['deptselected'] = "selected";
        } else {
            $dept_selected = $post_vars['fdept'];
        }
        $selected = "";
        for ($i = 0; $i < count($depts); $i++) {
            $dept_row = $depts[$i];
            $dept_id  = $dept_row['dept_id'];
            if (@in_array($dept_id, $dept_selected)) {
                $selected = "selected";
            } else {
                $selected = "";
            }
            $dept_name = $dept_row['dept_name'];
            //$str.=preg_replace("/<{(.*?)}>/e","$$1",$match);	
            preg_match_all("/<{(.*?)}>/", $match, $matches);
            $tmp_array = array();
            foreach ($matches[0] as $index => $var_name) {
                $tmp_var_name = $matches[1][$index];
                if (isset($$tmp_var_name)) {
                    $tmp_array[$tmp_var_name] = $$tmp_var_name;
                } else {
                    $tmp_array[$tmp_var_name] = '';
                }
            }
            
            $str .= preg_replace_callback("/<{(.*?)}>/", function($m) use ($tmp_array) {
                return $tmp_array[$m[1]];
            }, $match);
        }
        
        $content = preg_replace($pattern, $str, $content);
        
		if (isset($post_vars['replytype']) && $post_vars['replytype'] == "Private") {
            $replace_content['privatechecked'] = "checked";
        } else {
            $replace_content['publicchecked'] = "checked";
        }
		
        if (isset($get_vars['error_message']) && $get_vars['error_message'] != "") {
            $content                          = preg_replace("/<{errormsg_(.*?)}>/s", "", $content);
            $replace_content['status_msg'] = $generic_msg[$get_vars['error_message']];
        } else {
            $content = preg_replace("/<{errormsg_start}>(.*?)<{errormsg_end}>/s", "", $content);
        }
        
        $content = $supp_obj->direct_replace($content, $replace_content);
        
		echo $content;
    }
    
    function add_reply($supp_obj, $a_predefined) {
        $post_vars    = $a_predefined['post'];
        $session_vars = $a_predefined['session'];
        @extract($post_vars);
        $staff_id    = $session_vars['staff_id'];
        $canned_date = $supp_obj->get_current_date();
        
        $cannedreplies = $supp_obj->prefix_table("cannedreplies");
        
        if (@in_array("0", $post_vars['fdept'])) {
            $depttype = "All";
        } else {
            $depttype = "specific";
        }
        
        $label = trim($supp_obj->stripLargeTags($label));
        $reply = trim($supp_obj->stripLargeTags($reply));
        
        
        if ($label == "") {
            return "no_label";
        }
        
        if ($reply == "") {
            return "no_reply";
        }
        
        
        
        $sql       = " insert into $cannedreplies (canned_subject, canned_message,canned_type,staff_id,canned_date,depttype)
			values ('$label','$reply','$replytype','$staff_id','$canned_date','$depttype') ";
        $insert_id = $supp_obj->execute_query($sql);
        
        if ($depttype == "specific") {
            $fdept      = $post_vars['fdept'];
            $canneddept = $supp_obj->prefix_table("canneddept");
            for ($i = 0; $i < count($fdept); $i++) {
                $dept_id = $fdept[$i];
                $sql     = "insert into $canneddept (dept_id,canned_id) values ('$dept_id','$insert_id') ";
                $supp_obj->execute_query($sql);
            }
        }
        
        
    }
    
    function check_permission($supp_obj, $staff_id, $canned_id) {
        $valid = 0;
        
        $staff_departments = $supp_obj->prefix_table("staff_departments");
        $staff             = $supp_obj->prefix_table("staff");
        $canneddept        = $supp_obj->prefix_table('canneddept');
        
        $sql      = "select all_dept from $staff where staff_id='$staff_id' ";
        $row      = $supp_obj->get_a_line($sql);
        $all_dept = $row[0];
        
        $sql           = "select dept_id from $staff_departments  where staff_id='$staff_id' ";
        $columns       = $supp_obj->get_single_column($sql);
        $cannedreplies = $supp_obj->prefix_table("cannedreplies");
        $sql           = "select * from $cannedreplies where canned_id='$canned_id' ";
        
        $row = $supp_obj->get_a_line($sql);
        if (($row['depttype'] == "All" and $row['canned_type'] == "Public") or $row['staff_id'] == $staff_id) {
            return true;
        }
        
        if ($row['canned_type'] == "Public" and $all_dept == "1") {
            return true;
        }
        
        if ($row['canned_type'] == "Public") {
            $sql   = "select dept_id from $canneddept where canned_id='$canned_id' ";
            //echo $sql;
            $depts = $supp_obj->get_single_column($sql);
            //print_R($depts);
            //print_r($columns);
            for ($i = 0; $i < count($columns); $i++) {
                $dept_id = $columns[$i];
                if (@in_array($dept_id, $depts)) {
                    return true;
                }
            }
        }
        
        return false;
        
    }
    
    
    function delete_canned($supp_obj, $a_predefined) {
        
        $get_vars     = $a_predefined['get'];
        $canned_id    = $get_vars['canned_id'];
        $session_vars = $a_predefined['session'];
        $staff_id     = $session_vars['staff_id'];
        
        $canneddept    = $supp_obj->prefix_table("canneddept");
        $cannedreplies = $supp_obj->prefix_table("cannedreplies");
        
        if ($this->check_permission($supp_obj, $staff_id, $canned_id)) {
            $sql = "delete from $canneddept where canned_id='$canned_id' ";
            $supp_obj->execute_query($sql);
            $sql = " delete from $cannedreplies where canned_id='$canned_id'";
            $supp_obj->execute_query($sql);
        }
        
        
        
    }
    //------------------------------------------------------------------------------------------------
    function canned_edit($supp_obj, $a_predefined, $generic_msg) {
        $session_vars = $a_predefined['session'];
        $post_vars    = $a_predefined['post'];
        $get_vars     = $a_predefined['get'];
        $staff_id     = $session_vars['staff_id'];
        $canned_id    = $get_vars['canned_id'];
        if (!$this->check_permission($supp_obj, $staff_id, $canned_id)) {
            echo "<div class=errormsg>" . $generic_msg['cNotAuthorized'] . "</div>";
            return;
        }
        
        $departments = $supp_obj->prefix_table("departments");
        
        $staff_departments = $supp_obj->prefix_table("staff_departments");
        $cannedreplies     = $supp_obj->prefix_table("cannedreplies");
        $canneddept        = $supp_obj->prefix_table("canneddept");
        
        $sql             = "select * from $cannedreplies where canned_id='$canned_id' ";
        $replace_content = $supp_obj->get_a_line($sql);
        
        
        $sql     = "select dept_id from $canneddept where canned_id='$canned_id' ";
        $depts_c = $supp_obj->get_single_column($sql);
        
        $template = "../templates/admin/manage_reply_edit.tpl";
        $content  = $supp_obj->return_file_content($template);
        $staff_id = $session_vars['staff_id'];
        $sql      = $supp_obj->get_dept_list_query($a_predefined);
        $depts    = $supp_obj->get_rsltset($sql);
        
        $pattern = "/<{dept_loopstart}>(.*?)<{dept_loopend}>/is";
        preg_match($pattern, $content, $out);
        $match = $out[1];
        $str   = "";
        //print_r($replace_content);
        if ($replace_content['depttype'] != "specific") {
            $replace_content['deptselected'] = "selected";
        } else {
            $dept_selected = $depts_c;
        }
        $selected = "";
        for ($i = 0; $i < count($depts); $i++) {
            $dept_row = $depts[$i];
            $dept_id  = $dept_row['dept_id'];
            if (@in_array($dept_id, $dept_selected)) {
                $selected = "selected";
            } else {
                $selected = "";
            }
            $dept_name = $dept_row['dept_name'];
            //$str.=preg_replace("/<{(.*?)}>/e","$$1",$match);	
            preg_match_all("/<{(.*?)}>/", $match, $matches);
            $tmp_array = array();
            foreach ($matches[0] as $index => $var_name) {
                $tmp_var_name = $matches[1][$index];
                if (isset($$tmp_var_name)) {
                    $tmp_array[$tmp_var_name] = $$tmp_var_name;
                } else {
                    $tmp_array[$tmp_var_name] = '';
                }
            }
            
            $str .= preg_replace_callback("/<{(.*?)}>/", function($m) use ($tmp_array) {
                return $tmp_array[$m[1]];
            }, $match);
        }
        //echo "str=$str";
        
        $content = preg_replace($pattern, $str, $content);
        if ($replace_content['canned_type'] == "Private") {
            $replace_content['privatechecked'] = "checked";
        } else {
            $replace_content['publicchecked'] = "checked";
        }
        if ($get_vars['error_message'] != "") {
            $content                          = preg_replace("/<{errormsg_(.*?)}>/s", "", $content);
            $replace_content['error_message'] = $generic_msg[$get_vars['error_message']];
        } else {
            $content = preg_replace("/<{errormsg_start}>(.*?)<{errormsg_end}>/s", "", $content);
        }
        
        
        $replace_content["canned_subject"] = $supp_obj->clean_textbox_data($replace_content["canned_subject"]);
        $content                           = $supp_obj->direct_replace($content, $replace_content);
        echo $content;
        
        
    }
    
    function edit_canned($supp_obj, $a_predefined) {
        
        $post_vars    = $a_predefined['post'];
        $session_vars = $a_predefined['session'];
        @extract($post_vars);
        $staff_id    = $session_vars['staff_id'];
        $canned_date = $supp_obj->get_current_date();
        
        
        if (!$this->check_permission($supp_obj, $staff_id, $canned_id)) {
            echo "<div class=errormsg>" . $generic_msg['cNotAuthorized'] . "</div>";
            return;
        }
        
        
        $cannedreplies = $supp_obj->prefix_table("cannedreplies");
        
        if (@in_array("0", $post_vars['fdept'])) {
            $depttype = "All";
        } else {
            $depttype = "specific";
        }
        
        $sql = " update $cannedreplies set canned_subject='$label', canned_message='$reply',canned_type='$replytype',
			canned_date='$canned_date',depttype='$depttype' where  canned_id='$canned_id' ";
        //	echo $sql;
        
        $supp_obj->execute_query($sql);
        
        if ($depttype == "specific") {
            $fdept      = $post_vars['fdept'];
            $canneddept = $supp_obj->prefix_table("canneddept");
            $sql        = "delete from $canneddept where canned_id='$canned_id' ";
            $supp_obj->execute_query($sql);
            for ($i = 0; $i < count($fdept); $i++) {
                $dept_id = $fdept[$i];
                $sql     = "insert into $canneddept (dept_id,canned_id) values ('$dept_id','$canned_id') ";
                $supp_obj->execute_query($sql);
            }
        }
        
        
        
    }
    
    //--------------------------------------------------------------
    
    
}
$cr = new CannedReplies;
switch ($act) {
    case NULL:
        include_once("header.php");
        include_once("nav.php");
        
        $cr->show_all_canned_replies($supp_obj, $a_predefined, $generic_msg);
        break;
    case "addcanned":
        $result = $cr->add_reply($supp_obj, $a_predefined);
        
        if ($result == "no_label") {
            $script = <<<EOD
<script language="JavaScript">
	window.location='manage_replies.php?error_message=cNolabel';
</script>
EOD;
            echo $script;
        }
        
        else if ($result == "no_reply") {
            $script = <<<EOD
<script language="JavaScript">
	window.location='manage_replies.php?error_message=cNocannedreply';
</script>
EOD;
            echo $script;
        }
        
        else {
            $script = <<<EOD
<script language="JavaScript">
	window.location='manage_replies.php?error_message=cCanned_added';
</script>
EOD;
            echo $script;
        }
        exit;
        
        
        break;
    
    case "delete":
        $cr->delete_canned($supp_obj, $a_predefined);
        $script = <<<EOD
<script language="JavaScript">
	window.location='manage_replies.php?error_message=cCanned_deleted';
</script>
EOD;
        echo $script;
        exit;
        
        
        break;
    case "edit":
        include_once("header.php");
        include_once("nav.php");
        $cr->canned_edit($supp_obj, $a_predefined, $generic_msg);
        break;
    case "editcanned":
        $cr->edit_canned($supp_obj, $a_predefined);
        $script = <<<EOD
<script language="JavaScript">
	window.location='manage_replies.php?error_message=cCanned_edited';
</script>
EOD;
        echo $script;
        exit;
        
        break;
}
include_once("footer.php");
?>
