<?php
include_once("session.php");
class Plugins
{
    public function view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg)
    {
        $session_vars   = $a_predefined['session'];
        $template       = "../templates/admin/manage_plugins.tpl";
        $content        = $supp_obj->return_file_content($template);
        $plugins        = $supp_obj->prefix_table("plugins");
        $a_plugin       = array();
        $sql            = "select * from $plugins ";
        $cur            = $supp_obj->return_db_handle($sql);
        $status_array   = array();
        $plugin_details = array();
        while ($row = $supp_obj->return_next_row($cur)) {
            $a_plugin[]                          = $row['plugin_name'];
            $plugin_details[$row['plugin_name']] = $row;
            $status_array[$row['plugin_name']]   = $row['plugin_status'];
        }

        $replace_array = array();
        if ($status_msg != "") {
            $content                     = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
            $replace_array['status_msg'] = $generic_msg[$status_msg];
        } else {
            $content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
        }

        $plugin_dir = "../plugins";
        $pattern    = "/<{plugins_loopstart}>(.*?)<{plugins_loopend}>/is";
        preg_match($pattern, $content, $out);
        $match       = $out[1];
        $str         = "";
        $supportlang = $session_vars['supportlang'];
        if ($handle = opendir($plugin_dir)) {
            $rowno = 1;
            while (false !== ($file = readdir($handle))) {
                if ($file != "." && $file != "..") {
                    $file_path = $plugin_dir . "/" . $file;
                    if (is_dir($file_path)) {
                        @include($file_path . "/lang/" . $supportlang . "/" . $file . ".php");
                        $plugin_name = $plugin_msg['cPlugin_short'];
                        $version     = $plugin_msg['cPlugin_version'];

                        $plugin_version = $plugin_details[$file]['plugin_version'];
                        $plugin_version = $plugin_version == "" ? $version : $plugin_version;


                        $plugin_desc = $plugin_msg['cPlugin_desc'];

                        $plugin_links = "";
                        if (in_array($file, $a_plugin)) {
                            $scripttext  = $generic_msg['cManage'];
                            $script_name = "manage_plugins.php?act=manage&plugin_name=" . $file;
                            $plugin_links .= "<a href=\"$script_name\">$scripttext</a>";
                            if ($status_array[$file] == "1") { // plugin activated
                                $scripttext  = $generic_msg['cDeactivate'];
                                $script_name = "manage_plugins.php?act=deactivate&plugin_name=" . $file;
                                $plugin_links .= " | <a href=\"$script_name\">$scripttext</a>";
                            } else { // not activated
                                $scripttext  = $generic_msg['cActivate'];
                                $script_name = "manage_plugins.php?act=activate&plugin_name=" . $file;
                                $plugin_links .= " | <a href=\"$script_name\">$scripttext</a>";
                            }
                            $scripttext  = $generic_msg['cRemove'];
                            $script_name = "manage_plugins.php?act=remove&plugin_name=" . $file;
                            $plugin_links .= " | <a onClick=\"confirm_remove('$file');\" class=\"pseudolink\">$scripttext</a>";
                        } else {
                            $scripttext  = $generic_msg['cInstall'];
                            $script_name = "manage_plugins.php?act=install&plugin_name=" . $file;
                            $plugin_links .= "<a href=\"$script_name\">$scripttext</a>";
                        }

                        //$str .= preg_replace("/<{(.*?)}>/e", "$$1", $match);
                        preg_match_all("/<{(.*?)}>/", $match, $matches);
                        $tmp_array = array();
                        foreach ($matches[0] as $index => $var_name) {
                            $tmp_var_name = $matches[1][$index];
                            if (isset($$tmp_var_name)) {
                                $tmp_array[$tmp_var_name] = $$tmp_var_name;
                            } else {
                                $tmp_array[$tmp_var_name] = '';
                            }
                        }

                        $str .= preg_replace_callback(
                            "/<{(.*?)}>/",
                            function ($m) use ($tmp_array) {
                                return $tmp_array[$m[1]];
                            },
                            $match
                        );
                        $rowno++;
                    }
                }
            }
            closedir($handle);
        }
        $content = preg_replace($pattern, $str, $content);

        $content = $supp_obj->direct_replace($content, $replace_array);
        echo $content;
    }

    //------------------------------------------------------------------------------------------------------------------------------------
    public function install_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];
        $plugin_dir  = "../plugins/" . $plugin_name . "/install.php";
        $plugins     = $supp_obj->prefix_table("plugins");

        $db_server = $a_predefined['db'];

        if (file_exists($plugin_dir)) {
            $sql      = "select plugin_name from $plugins where plugin_name='$plugin_name'";
            $a_plugin = $supp_obj->get_a_line($sql);
            if (isset($a_plugin['plugin_name']) && $a_plugin['plugin_name'] != "") {
                return 'cPlugin_duplicate';
            }

            include_once($plugin_dir);
            return 'cPlugin_installed';
        }
    }

    //------------------------------------------------------------------------------------------------------------------------------------
    public function edit_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];

        $plugin_dir  = "../plugins/" . $plugin_name . "/manage.php";

        if (file_exists($plugin_dir)) {
            include_once($plugin_dir);
            view_plugin_properties($supp_obj, $a_predefined, $generic_msg, $status_msg);
        }
    }

    //------------------------------------------------------------------------------------------------------------------------------------
    public function blank_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];

        $plugin_dir  = "../plugins/" . $plugin_name . "/manage.php";

        if (file_exists($plugin_dir)) {
            include_once($plugin_dir);
        }
    }

    //------------------------------------------------------------------------------------------------------------------------------------
    public function update_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $post_vars   = $a_predefined['post'];
        $plugin_name = $post_vars['plugin_name'];
        $plugin_dir  = "../plugins/" . $plugin_name . "/manage.php";
        //echo $plugin_dir;

        if (file_exists($plugin_dir)) {
            include_once($plugin_dir);
            $status_msg = update_plugin_properties($supp_obj, $a_predefined, $generic_msg, $status_msg);
            view_plugin_properties($supp_obj, $a_predefined, $generic_msg, $status_msg);
        }
    }

    //------------------------------------------------------------------------------------------------------------------------------------
    public function activate_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];
        $plugins     = $supp_obj->prefix_table("plugins");
        $sql         = "update $plugins set plugin_status='1' where plugin_name='$plugin_name'";
        $supp_obj->execute_query($sql);
        return "cPlugin_activated";
    }
    //------------------------------------------------------------------------------------------------------------------------------------

    public function deactivate_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];
        $plugins     = $supp_obj->prefix_table("plugins");
        $sql         = "update $plugins set plugin_status='0' where plugin_name='$plugin_name'";
        $supp_obj->execute_query($sql);
        return "cPlugin_deactivated";
    }

    //------------------------------------------------------------------------------------------------------------------------------------

    public function remove_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];
        $plugins     = $supp_obj->prefix_table("plugins");
        $plugin_dir  = "../plugins/" . $plugin_name . "/uninstall.php";
        $plugins     = $supp_obj->prefix_table("plugins");

        $db_server = $a_predefined['db'];

        if (file_exists($plugin_dir)) {
            include_once($plugin_dir);
            return 'cPlugin_removed';
        }
    }

    //------------------------------------------------------------------------------------------------------------------------------------
    public function upgrade_plugin($supp_obj, $a_predefined, $generic_msg)
    {
        $get_vars    = $a_predefined['get'];
        $plugin_name = $get_vars['plugin_name'];
        $plugin_dir  = "../plugins/" . $plugin_name . "/lang/en/" . $plugin_name . ".php";

        if (file_exists($plugin_dir)) {
            include_once($plugin_dir);
        }
        $plugin_dir = "../plugins/" . $plugin_name . "/upgrade.php";

        if (file_exists($plugin_dir)) {
            include_once($plugin_dir);
            return 'cPlugin_upgraded';
        }
    }
}
$plug               = new Plugins;
$a_predefined['db'] = $db_server;
switch ($act) {
    case null:
        include_once("header.php");
        include_once("nav.php");

        $plug->view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg);
        break;

    case "install":
        $status_msg = $plug->install_plugin($supp_obj, $a_predefined, $generic_msg);
        include_once("header.php");
        include_once("nav.php");

        $plug->view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg);
        break;

    case "manage":
        include_once("header.php");
        include_once("nav.php");

        $plug->edit_plugin($supp_obj, $a_predefined, $generic_msg);
        break;

    case "blank":
        $plug->blank_plugin($supp_obj, $a_predefined, $generic_msg);
        break;

    case "activate":
        $status_msg = $plug->activate_plugin($supp_obj, $a_predefined, $generic_msg);
        include_once("header.php");
        include_once("nav.php");

        $plug->view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg);
        break;

    case "deactivate":
        $status_msg = $plug->deactivate_plugin($supp_obj, $a_predefined, $generic_msg);
        include_once("header.php");
        include_once("nav.php");

        $plug->view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg);
        break;

    case "remove":
        $status_msg = $plug->remove_plugin($supp_obj, $a_predefined, $generic_msg);
        include_once("header.php");
        include_once("nav.php");

        $plug->view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg);
        break;

    case "editplugin":
        include_once("header.php");
        include_once("nav.php");

        $plug->update_plugin($supp_obj, $a_predefined, $generic_msg);
        break;

    case "upgrade":
        $status_msg = $plug->upgrade_plugin($supp_obj, $a_predefined, $generic_msg);
        include_once("header.php");
        include_once("nav.php");

        $plug->view_plugins($supp_obj, $a_predefined, $generic_msg, $status_msg);
        break;

}

if ($act !== 'blank') {
    include_once("footer.php");
}
