<?php
include_once("session.php");
include_once("header.php");
include_once("nav.php");

class dailyTicketTemplate {
	function viewform($supp_obj, $a_predefined, $generic_msg, $status_msg) {
		$client_custom_values = $supp_obj->prefix_table("client_custom_values");
		$monthly_tickets = $supp_obj->prefix_table("monthly_tickets");
		$customers = $supp_obj->prefix_table("clients");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		
		$template = "../templates/admin/manage_monthly_ticket.tpl";
		$content = $supp_obj->return_file_content($template);
		
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		$sql = "SELECT * FROM $customers c, $client_custom_values cc, $monthly_tickets s WHERE c.client_id = cc.client_id AND s.client_id = c.client_id";
		if($get_vars['orderby'] != "") {
			$sql .= " ORDER BY ".$get_vars['orderby']." ".$get_vars['mode'];	
		}
		
		$res = $supp_obj->return_db_handle($sql);
		$data_set = "";$rowno = 0;
		while($row = $supp_obj->return_next_row($res)) {$rowno++;
			$sch_sting = "";
			if($row['sch_type'] == 1) {
				$sch_sting = "Occurs day ".$row['month_day']." of every ".$row['month_interval']." month.";
			} else {
				$sch_sting = "Occurs the ".$row['month_week']." ".$row['month_weekday']." of every ".$row['month_interval']." month.";
			}
			if($rowno % 2 == 0) {
				$class_name = "tabledata";
			} else {
				$class_name = "tabledataalt";
			}
			$data_set .= '<tr class="'.$class_name.'">
                  <td>'.$row['client_name'].'</td>
                  <td>'.$row['email'].'</td>
				  <td>'.$row['subject'].'</td>';
			$data_set .= '<td>'.$sch_sting.'</td>';
			$data_set .= '<td>'.$row['start_date'].'</td>';
			$data_set .= '<td>'.$row['custom_1'].'</td>
                  <td>'.$row['custom_3'].'</td>
                  <td><a href="edit_monthly_ticket.php?id='.$row['id'].'">Edit</a></td>
                  <td align="right"><input type="checkbox" name="chk_ticket[]" id="chk_ticket_id[]" value="'.$row['id'].'" />
                    <input type="hidden" name="id[]" id="id" value="'.$row['id'].'" /></td>
                </tr>';
		}
		
		$replace_array['monthly_ticket_data'] = $data_set;

		$replace_array['status_msg'] = $a_predefined['status_msg'];
		if($get_vars['mode'] == "asc") {
			$replace_array['sort_mode'] = "desc";
		} else {
			$replace_array['sort_mode'] = "asc";
		}
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		echo $content;
	}
	
	function deleteClient($supp_obj, $a_predefined, $generic_msg) {
		$monthly_tickets = $supp_obj->prefix_table("monthly_tickets");
		//searchcust
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		@extract($post_vars);
		for($i = 0; $i < count($chk_ticket); $i++) {
			$client_id = $chk_ticket[$i];
			$sql = "DELETE FROM $monthly_tickets WHERE id = '".$client_id."'";
			$supp_obj->execute_query($sql);
		}
		return $generic_msg['cClientDeletedSuccessfully'];
	}
}

$cr = new dailyTicketTemplate;
$act = $post_vars['act'];
switch($act) {
	case NULL:
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
	case 'deleteCl':
		$a_predefined['status_msg'] = $cr->deleteClient($supp_obj, $a_predefined, $generic_msg);
		$cr->viewform($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
}

include_once("footer.php");
?>