<?php
include_once("session.php");

class KB {
	function show_kb($supp_obj, $return_array = '', $a_predefined) {
		$kb = $supp_obj->prefix_table("kb");
		$staff = $supp_obj->prefix_table("staff");
		
		$template .= "../templates/admin/manage_kb.tpl";
		$content = $supp_obj->return_file_content($template);
		$replace_content = array();
		

		if($return_array != "") {
			$status_msg = $return_array['status_msg'];
			$post_vars['status_msg'] = $status_msg;
		}
		
		$post_vars['add_edit_kb'] = "Knowledgebase";
		
		if($return_array['status_msg'] != "") {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		} else {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);
		}
		
		$content = $supp_obj->direct_replace($content, $post_vars);
			
		$sql = "SELECT kb.*, s.staff_name FROM $kb AS kb LEFT JOIN $staff AS s ON kb.author = s.staff_id";
		$loop_sql['kb_'] = $sql;
		$evalcode['kb_'] = '';

		$a_content = $supp_obj->replace_loop($loop_sql, $content, $evalcode);
		$content = $a_content[0];

		echo $content;
	}
	
	function add_kb($supp_obj, $return_array = '', $a_predefined) {
		$kb = $supp_obj->prefix_table("kb");
		
		$template .= "../templates/admin/knowledgebase.tpl";
		$content = $supp_obj->return_file_content($template);
		$replace_content = array();
		

		if($return_array != "") {
			$status_msg = $return_array['status_msg'];
			$post_vars['status_msg'] = $status_msg;
		}
		
		$post_vars['add_edit_kb'] = "Add Knowledgebase";
		
		if($return_array['status_msg'] != "") {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is","",$content);
		} else {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is","",$content);
		}
		
		$content = $supp_obj->direct_replace($content, $post_vars);
		
		echo $content;
	}
	
	function process_kb($supp_obj, $return_array = '', $a_predefined) {
		$kb = $supp_obj->prefix_table("kb");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		$session_vars = $a_predefined['session'];
		
		$staff_id = $session_vars['staff_id'];
		
		if(isset($post_vars['kb_id']) && !empty($post_vars['kb_id'])) {
			$sql = "UPDATE $kb SET title = '".$post_vars['title']."', contents = '".$post_vars['contents']."', meta_title = '".$post_vars['meta_title']."', meta_description = '".$post_vars['meta_description']."', tags = '".$post_vars['tags']."', author = '".$staff_id."' WHERE id = '".$post_vars['kb_id']."'";
			$message = "Knowledgebase updated successfully!";
		} else {
			$sql = "INSERT INTO $kb (title, contents, meta_title, meta_description, tags, author, created) VALUES ('".$post_vars['title']."', '".$post_vars['contents']."', '".$post_vars['meta_title']."', '".$post_vars['meta_description']."', '".$post_vars['tags']."', '".$staff_id."', NOW())";
			$message = "Knowledgebase entry added successfully!";
		}

		$supp_obj->execute_query($sql);
		
		return $message;	
	}
	
	function edit_kb($supp_obj, $return_array = '', $a_predefined) {
		$kb = $supp_obj->prefix_table("kb");
		
		$template .= "../templates/admin/knowledgebase.tpl";
		$content = $supp_obj->return_file_content($template);
		$replace_content = array();
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		$session_vars = $a_predefined['session'];
		
		$kb_id = $get_vars['kb_id'];
		
		$sql = "SELECT * FROM $kb WHERE id = '$kb_id'";
		$replace_vars = $supp_obj->get_a_line($sql);

		if($return_array != "") {
			$status_msg = $return_array['status_msg'];
			$replace_vars['status_msg'] = $status_msg;
		}
		
		$replace_vars['get_vars'] = "?act=edit_kb&kb_id=".$kb_id;
		$replace_vars['add_edit_kb'] = "Edit Knowledgebase";
		
		if($return_array['status_msg'] != "") {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		} else {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
		}
		
		$content = $supp_obj->direct_replace($content, $replace_vars);
		
		echo $content;
	}
	
	function view_kb($supp_obj, $return_array = '', $a_predefined) {
		$kb = $supp_obj->prefix_table("kb");
		$staff = $supp_obj->prefix_table("staff");
		
		$template .= "../templates/admin/knowledgebase_view.tpl";
		$content = $supp_obj->return_file_content($template);
		$replace_content = array();
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		$session_vars = $a_predefined['session'];
		
		if($return_array != "") {
			$status_msg = $return_array['status_msg'];
			$replace_vars['status_msg'] = $status_msg;
		}
		
		$replace_vars['add_edit_kb'] = $replace_vars['add_edit_kb_s'] = "Knowledgebase";
		
		if($return_array['status_msg'] != "") {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		} else {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
		}
		
		$sql = "SELECT kb.*, DATE_FORMAT(kb.created,'%m/%d/%Y') AS created_date, s.staff_name FROM $kb AS kb LEFT JOIN $staff AS s ON kb.author = s.staff_id ";
		
		if(isset($get_vars['q']) && !empty($get_vars['q'])) {
			$query = $supp_obj->strip_html($get_vars['q']);
			$replace_vars['add_edit_kb_s'] .= " Search results for (".$query.")";
			$sql .= " WHERE MATCH (contents, title) AGAINST ('".$query."') OR s.staff_name LIKE '%".$query."%' ";
		} else {
			$sql .= " ORDER BY created DESC";
		}
		$content = $supp_obj->direct_replace($content, $replace_vars);
		
		$loop_sql['kb_'] = $sql;
		$evalcode['kb_'] = '';

		$a_content = $supp_obj->replace_loop($loop_sql, $content, $evalcode);
		$content = $a_content[0];
		
		echo $content;
	}
	
	function post_view($supp_obj, $return_array = '', $a_predefined) {
		$kb = $supp_obj->prefix_table("kb");
		$staff = $supp_obj->prefix_table("staff");
		
		$template .= "../templates/admin/knowledgebase_post.tpl";
		$content = $supp_obj->return_file_content($template);
		$replace_content = array();
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		$session_vars = $a_predefined['session'];
		
		$kb_id = $get_vars['id'];
		
		if($return_array != "") {
			$status_msg = $return_array['status_msg'];
			$replace_vars['status_msg'] = $status_msg;
		}
		
		$sql = "SELECT kb.*, DATE_FORMAT(kb.created,'%m/%d/%Y') AS created_date, s.staff_name FROM $kb AS kb LEFT JOIN $staff AS s ON kb.author = s.staff_id WHERE kb.id = '$kb_id'";
		$replace_vars = $supp_obj->get_a_line($sql);
		
		if($return_array['status_msg'] != "") {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		} else {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);
		}
		
		$content = $supp_obj->direct_replace($content, $replace_vars);
				
		echo $content;
	}
}

include_once("header.php");
include_once("nav.php");

$kb = new KB;

switch($act) {	
	case NULL:
		$kb->show_kb($supp_obj, $return_array, $a_predefined);
	break;
	
	case 'add':
		$kb->add_kb($supp_obj, $return_array, $a_predefined);
	break;
	
	case 'kb':
		$return_array['status_msg'] = $kb->process_kb($supp_obj, $return_array, $a_predefined);
		$kb->edit_kb($supp_obj, $return_array, $a_predefined);
	break;
	
	case 'edit_kb':
		$kb->edit_kb($supp_obj, $return_array, $a_predefined);
	break;
	
	case 'view':
		$kb->view_kb($supp_obj, $return_array, $a_predefined);
	break;
	
	case 'view_post':
		$kb->post_view($supp_obj, $return_array, $a_predefined);
	break;
}

include_once("footer.php");